/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.prehistoric;

import fossilsarcheology.Revival;
import fossilsarcheology.client.sound.FASoundRegistry;
import fossilsarcheology.server.entity.ai.DinoAIEatFeedersAndBlocks;
import fossilsarcheology.server.entity.ai.DinoAIEatItems;
import fossilsarcheology.server.entity.ai.DinoAIFollowOwner;
import fossilsarcheology.server.entity.ai.DinoAIHunt;
import fossilsarcheology.server.entity.ai.DinoAIHurtByTarget;
import fossilsarcheology.server.entity.ai.DinoAILeapAtTarget;
import fossilsarcheology.server.entity.ai.DinoAILookIdle;
import fossilsarcheology.server.entity.ai.DinoAIOwnerHurtByTarget;
import fossilsarcheology.server.entity.ai.DinoAIOwnerHurtTarget;
import fossilsarcheology.server.entity.ai.DinoAIRiding;
import fossilsarcheology.server.entity.ai.DinoAIWander;
import fossilsarcheology.server.entity.ai.DinoAIWatchClosest;
import fossilsarcheology.server.entity.ai.DinoMeleeAttackAI;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.entity.prehistoric.EntityVelociraptor;
import fossilsarcheology.server.entity.prehistoric.IScaryDinosaur;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityTypeAI;
import fossilsarcheology.server.entity.utility.EntityToyBase;
import java.util.function.Predicate;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityDeinonychus
extends EntityPrehistoric
implements IScaryDinosaur {
    public static Animation ANIMATION_JUMPAT = Animation.create((int)35);
    private boolean attackDecision = true;

    public EntityDeinonychus(World world) {
        super(world, PrehistoricEntityType.DEINONYCHUS, 2.0, 6.0, 10.0, 32.0, 0.23, 0.35, 0.0, 2.0);
        this.nearByMobsAllowed = 9;
        this.hasFeatherToggle = true;
        this.featherToggle = Revival.CONFIG_OPTIONS.featheredDeinonychus;
        this.setActualSize(1.8f, 1.25f);
        this.minSize = 0.2f;
        this.maxSize = 0.85f;
        this.teenAge = 4;
        this.ridingY = 2.0f;
        this.developsResistance = false;
        this.breaksBlocks = false;
        this.pediaScale = 34.0f;
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinoMeleeAttackAI(this, 1.0, false));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinoAILeapAtTarget(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIEatFeedersAndBlocks(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new DinoAIEatItems(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DinoAIRiding(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DinoAILeapAtTarget(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new DinoAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new DinoAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new DinoAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new DinoAIOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new DinoAIHurtByTarget(this));
        this.field_70715_bh.func_75776_a(4, new DinoAIHunt<EntityLivingBase>(this, EntityLivingBase.class, true, (Predicate<EntityLivingBase>)((com.google.common.base.Predicate)entity -> entity instanceof EntityLivingBase)));
    }

    @Override
    public int getAttackLength() {
        return 20;
    }

    @Override
    public void setSpawnValues() {
    }

    @Override
    public PrehistoricEntityTypeAI.Activity aiActivityType() {
        return PrehistoricEntityTypeAI.Activity.NOCTURNAL;
    }

    @Override
    public PrehistoricEntityTypeAI.Attacking aiAttackType() {
        return PrehistoricEntityTypeAI.Attacking.JUMP;
    }

    @Override
    public PrehistoricEntityTypeAI.Climbing aiClimbType() {
        return PrehistoricEntityTypeAI.Climbing.ARTHROPOD;
    }

    @Override
    public PrehistoricEntityTypeAI.Following aiFollowType() {
        return PrehistoricEntityTypeAI.Following.AGRESSIVE;
    }

    @Override
    public PrehistoricEntityTypeAI.Jumping aiJumpType() {
        return PrehistoricEntityTypeAI.Jumping.TWOBLOCKS;
    }

    @Override
    public PrehistoricEntityTypeAI.Response aiResponseType() {
        return PrehistoricEntityTypeAI.Response.TERITORIAL;
    }

    @Override
    public PrehistoricEntityTypeAI.Stalking aiStalkType() {
        return PrehistoricEntityTypeAI.Stalking.STEALTH;
    }

    @Override
    public PrehistoricEntityTypeAI.Taming aiTameType() {
        return PrehistoricEntityTypeAI.Taming.IMPRINTING;
    }

    @Override
    public PrehistoricEntityTypeAI.Untaming aiUntameType() {
        return PrehistoricEntityTypeAI.Untaming.ATTACK;
    }

    @Override
    public PrehistoricEntityTypeAI.Moving aiMovingType() {
        return PrehistoricEntityTypeAI.Moving.WALK;
    }

    @Override
    public PrehistoricEntityTypeAI.WaterAbility aiWaterAbilityType() {
        return PrehistoricEntityTypeAI.WaterAbility.NONE;
    }

    @Override
    public boolean doesFlock() {
        return false;
    }

    @Override
    public Item getOrderItem() {
        return Items.field_151103_aS;
    }

    @Override
    public int getAdultAge() {
        return 10;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackDecision) {
            if (this.getAnimation() == this.ATTACK_ANIMATION && this.getAnimationTick() == 12 && this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) < 6.0f) {
                this.doAttack();
                this.attackDecision = this.field_70146_Z.nextBoolean();
                this.func_70638_az().func_70653_a((Entity)this, 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            }
        } else {
            double d0;
            if (this.func_70638_az() != null) {
                if (this.func_184187_bx() != null && this.func_184187_bx() == this.func_70638_az() && this.field_70173_aa % 20 == 0) {
                    IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
                    this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)iattributeinstance.func_111126_e());
                }
                if ((d0 = this.func_70068_e((Entity)this.func_70638_az())) < 20.0 && this.getAnimation() != this.getExtraAnimation(0)) {
                    this.setAnimation(this.getExtraAnimation(0));
                }
            }
            if (this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.getAnimation() == ANIMATION_JUMPAT && this.getAnimationTick() >= 17 && this.getAnimationTick() <= 20 && this.field_70122_E) {
                d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
                double d2 = this.func_70638_az().field_70163_u - this.field_70163_u + (double)this.func_70638_az().field_70131_O;
                float f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                this.field_70159_w += d0 / (double)f * (double)0.8f + this.field_70159_w * (double)0.2f;
                this.field_70179_y += d1 / (double)f * (double)0.8f + this.field_70179_y * (double)0.2f;
                this.field_70181_x += d2 / (double)f * (double)0.8f + this.field_70181_x * (double)0.2f;
            }
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (this.attackDecision && this.getAnimation() != this.ATTACK_ANIMATION) {
            this.setAnimation(this.ATTACK_ANIMATION);
        }
        return false;
    }

    public void func_70108_f(Entity entity) {
        super.func_70108_f(entity);
        if (this.func_70638_az() != null) {
            if (this.func_70638_az() == entity && this.getAnimation() == this.ATTACK_ANIMATION && !this.field_70122_E && this.func_184187_bx() != entity && entity instanceof EntityToyBase) {
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f);
            } else if (this.func_70638_az() == entity && this.getAnimation() == ANIMATION_JUMPAT && !this.field_70122_E && this.func_184187_bx() != entity) {
                this.attackDecision = this.field_70146_Z.nextBoolean();
                this.func_184220_m(entity);
            }
        }
    }

    @Override
    public boolean func_70686_a(Class clazz) {
        return clazz != EntityVelociraptor.class && super.func_70686_a(clazz);
    }

    @Override
    public boolean func_70097_a(DamageSource dmg, float i) {
        if (this.func_184187_bx() != null && this.func_110144_aD() != null && this.func_110144_aD() == this.func_184187_bx() && this.func_70681_au().nextInt(2) == 0) {
            this.func_184210_p();
        }
        return super.func_70097_a(dmg, i);
    }

    @Override
    public Animation getExtraAnimation(int i) {
        return ANIMATION_JUMPAT;
    }

    @Override
    public boolean useSpecialAttack() {
        return !this.attackDecision;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{this.SPEAK_ANIMATION, this.ATTACK_ANIMATION, ANIMATION_JUMPAT};
    }

    @Override
    public int getMaxHunger() {
        return 100;
    }

    @Override
    public boolean canBeRidden() {
        return false;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return FASoundRegistry.DEINONYCHUS_LIVNIG;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return FASoundRegistry.DEINONYCHUS_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return FASoundRegistry.DEINONYCHUS_DEATH;
    }

    @Override
    public float getTargetScale() {
        return 2.0f;
    }
}

