/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.settings;

import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import xaero.map.gui.CursorBox;
import xaero.map.mods.SupportMods;
import xaero.map.settings.ModSettings;

public enum ModOptions {
    DEBUG("gui.xaero_debug", false, true, false, false),
    COLOURS("gui.xaero_block_colours", false, true, false, false),
    LIGHTING("gui.xaero_lighting", false, true, false, false),
    UPDATE("gui.xaero_update_chunks", false, true, false, false),
    LOAD("gui.xaero_load_chunks", false, true, false, false),
    DEPTH("gui.xaero_terrain_depth", false, true, false, false),
    SLOPES("gui.xaero_terrain_slopes", false, true, false, false),
    STEPS("gui.xaero_footsteps", false, true, false, false),
    FLOWERS("gui.xaero_flowers", false, true, false, false),
    COORDINATES("gui.xaero_wm_coordinates", false, true, false, false),
    BIOMES("gui.xaero_biome_colors", false, true, false, false),
    WAYPOINTS("gui.xaero_worldmap_waypoints", false, true, false, true),
    ARROW("gui.xaero_render_arrow", false, true, false, false),
    DISPLAY_ZOOM("gui.xaero_display_zoom", false, true, false, false),
    IGNORE_HEIGHTMAPS("gui.xaero_wm_ignore_heightmaps", false, true, new CursorBox("gui.xaero_wm_box_ignore_heightmaps"), true, false),
    WAYPOINT_SCALE("gui.xaero_wm_waypoint_scale", true, false, 0.5f, 5.0f, 0.5f, false, true),
    OPEN_ANIMATION("gui.xaero_open_map_animation", false, true, false, false),
    RELOAD("gui.xaero_reload_everything", false, true, false, false),
    ZOOM_BUTTONS("gui.xaero_zoom_buttons", false, true, false, false),
    WAYPOINT_BACKGROUNDS("gui.xaero_waypoint_backgrounds", false, true, false, true),
    PAUSE_REQUESTS("pause_requests", false, true, false, false),
    EXTRA_DEBUG("extra_debug", false, true, false, false),
    DETECT_AMBIGUOUS_Y("gui.xaero_wm_detect_ambiguous_y", false, true, new CursorBox("gui.xaero_wm_box_detect_ambiguous_y"), false, false),
    UPDATE_NOTIFICATION("gui.xaero_wm_update_notification", false, true, false, false),
    ADJUST_HEIGHT_FOR_SHORT_BLOCKS("gui.xaero_wm_adjust_height_for_carpetlike_blocks", false, true, new CursorBox("gui.xaero_wm_box_adjust_height_for_carpetlike_blocks"), false, false),
    MIN_ZOOM_LOCAL_WAYPOINTS("gui.xaero_wm_min_zoom_local_waypoints", true, false, 0.0f, 3.0f, 0.01f, false, true),
    ARROW_COLOUR("gui.xaero_wm_arrow_colour", false, true, new CursorBox("gui.xaero_wm_box_arrow_color"), false, false),
    MAP_TELEPORT_ALLOWED("gui.xaero_wm_teleport_allowed", false, true, new CursorBox("gui.xaero_wm_teleport_allowed_tooltip"), true, false),
    PARTIAL_Y_TELEPORTATION("gui.xaero_wm_partial_y_teleportation", false, true, new CursorBox("gui.xaero_wm_box_partial_y_teleportation"), false, false),
    DISPLAY_STAINED_GLASS("gui.xaero_wm_display_stained_glass", false, true, false, false);

    private final boolean enumFloat;
    private final boolean enumBoolean;
    private final String enumString;
    private double valueMin;
    private double valueMax;
    private double valueStep;
    private CursorBox tooltip;
    private boolean ingameOnly;
    private boolean requiresMinimap;
    private boolean switchScreen;
    public static final CursorBox REQUIRES_MINIMAP;
    public static final CursorBox REQUIRES_INGAME;

    public static ModOptions getModOptions(int par0) {
        for (ModOptions enumoptions : ModOptions.values()) {
            if (enumoptions.returnEnumOrdinal() != par0) continue;
            return enumoptions;
        }
        return null;
    }

    private ModOptions(String par3Str, boolean par4, boolean par5, boolean ingameOnly, boolean requiresMinimap) {
        this(par3Str, par4, par5, null, ingameOnly, requiresMinimap);
    }

    private ModOptions(String p_i45004_3_, boolean p_i45004_4_, boolean p_i45004_5_, float p_i45004_6_, float p_i45004_7_, float p_i45004_8_, boolean ingameOnly, boolean requiresMinimap) {
        this(p_i45004_3_, p_i45004_4_, p_i45004_5_, p_i45004_6_, p_i45004_7_, p_i45004_8_, null, ingameOnly, requiresMinimap);
    }

    private ModOptions(String par3Str, boolean par4, boolean par5, CursorBox tooltip, boolean ingameOnly, boolean requiresMinimap) {
        this.tooltip = tooltip;
        this.enumString = par3Str;
        this.enumFloat = par4;
        this.enumBoolean = par5;
        this.ingameOnly = ingameOnly;
        this.requiresMinimap = requiresMinimap;
    }

    private ModOptions(String p_i45004_3_, boolean p_i45004_4_, boolean p_i45004_5_, float p_i45004_6_, float p_i45004_7_, float p_i45004_8_, CursorBox tooltip, boolean ingameOnly, boolean requiresMinimap) {
        this.tooltip = tooltip;
        this.enumString = p_i45004_3_;
        this.enumFloat = p_i45004_4_;
        this.enumBoolean = p_i45004_5_;
        this.valueMin = p_i45004_6_;
        this.valueMax = p_i45004_7_;
        this.valueStep = p_i45004_8_;
        this.ingameOnly = ingameOnly;
        this.requiresMinimap = requiresMinimap;
    }

    public boolean getEnumFloat() {
        return this.enumFloat;
    }

    public boolean getEnumBoolean() {
        return this.enumBoolean;
    }

    public int returnEnumOrdinal() {
        return this.ordinal();
    }

    public double getValueMax() {
        return this.valueMax;
    }

    public void setValueMax(double p_148263_1_) {
        this.valueMax = p_148263_1_;
    }

    public double normalizeValue(double p_148266_1_) {
        return MathHelper.func_151237_a((double)((this.snapToStepClamp(p_148266_1_) - this.valueMin) / (this.valueMax - this.valueMin)), (double)0.0, (double)1.0);
    }

    public double denormalizeValue(double p_148262_1_) {
        return this.snapToStepClamp(this.valueMin + (this.valueMax - this.valueMin) * MathHelper.func_151237_a((double)p_148262_1_, (double)0.0, (double)1.0));
    }

    public double snapToStepClamp(double p_148268_1_) {
        p_148268_1_ = this.snapToStep(p_148268_1_);
        return MathHelper.func_151237_a((double)p_148268_1_, (double)this.valueMin, (double)this.valueMax);
    }

    protected double snapToStep(double p_148264_1_) {
        if (this.valueStep > 0.0) {
            p_148264_1_ = this.valueStep * (double)Math.round(p_148264_1_ / this.valueStep);
        }
        return p_148264_1_;
    }

    public String getEnumString() {
        return I18n.func_135052_a((String)this.enumString, (Object[])new Object[0]);
    }

    public String getEnumStringRaw() {
        return this.enumString;
    }

    public CursorBox getTooltip() {
        if (this.isDisabledBecauseNotIngame()) {
            return REQUIRES_INGAME;
        }
        if (this.isDisabledBecauseMinimap()) {
            return REQUIRES_MINIMAP;
        }
        return this.tooltip;
    }

    public boolean isIngameOnly() {
        return this.ingameOnly;
    }

    public boolean requiresMinimap() {
        return this.requiresMinimap;
    }

    public boolean isSwitchScreen() {
        return this.switchScreen;
    }

    public boolean isDisabledBecauseNotIngame() {
        return this.isIngameOnly() && !ModSettings.canEditIngameSettings();
    }

    public boolean isDisabledBecauseMinimap() {
        return this.requiresMinimap() && !SupportMods.minimap();
    }

    static {
        REQUIRES_MINIMAP = new CursorBox("gui.xaero_wm_option_requires_minimap");
        REQUIRES_INGAME = new CursorBox("gui.xaero_wm_option_requires_ingame");
    }
}

