/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xaero.map.MapProcessor;
import xaero.map.MapWriter;
import xaero.map.biome.BiomeColorCalculator;
import xaero.map.region.MapBlock;
import xaero.map.region.MapPixel;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayManager;

public class Overlay
extends MapPixel {
    private short opacity;
    private float transparency;

    public Overlay(int state, int colourType, int customColour, float transparency, byte light, boolean glowing) {
        this.write(state, colourType, customColour, transparency, light, glowing);
    }

    public void write(int state, int colourType, int customColour, float transparency, byte light, boolean glowing) {
        this.opacity = 0;
        this.state = state;
        this.colourType = (byte)colourType;
        this.customColour = customColour;
        this.transparency = transparency;
        this.light = light;
        this.glowing = glowing;
    }

    public boolean isWater() {
        int id = this.state & 0xFFF;
        return (this.state & 0xFFFF0000) == 0 && (id == 9 || id == 8);
    }

    public int getParametres() {
        int parametres = 0;
        parametres |= !this.isWater() ? 1 : 0;
        parametres |= this.opacity > 1 ? 8 : 0;
        parametres |= this.light << 4;
        int compatibleColourType = this.colourType >= 2 ? this.colourType - 1 : this.colourType;
        int colourTypeToWrite = compatibleColourType < 0 ? 0 : compatibleColourType & 3;
        return parametres |= colourTypeToWrite << 8;
    }

    public void getPixelColour(MapBlock block, int[] result_dest, MapWriter mapWriter, World world, MapTileChunk tileChunk, MapTileChunk prevChunk, MapTileChunk prevChunkDiagonal, MapTileChunk prevChunkHorisontal, MapTile mapTile, int x, int z, BlockPos.MutableBlockPos mutableGlobalPos, float shadowR, float shadowG, float shadowB, BiomeColorCalculator biomeColorCalculator, MapProcessor mapProcessor, OverlayManager overlayManager) {
        super.getPixelColours(result_dest, mapWriter, world, tileChunk, prevChunk, prevChunkDiagonal, prevChunkHorisontal, mapTile, x, z, block, -1, null, mutableGlobalPos, shadowR, shadowG, shadowB, biomeColorCalculator, mapProcessor, overlayManager, null);
    }

    public String toString() {
        return "(S: " + this.getState() + ", CT: " + this.colourType + ", CC: " + this.getCustomColour() + ", A: " + this.transparency + ", O: " + this.opacity + ", L: " + this.light + ")";
    }

    public boolean equals(Overlay p) {
        return p != null && this.opacity == p.opacity && this.transparency == p.transparency && this.light == p.light && this.getState() == p.getState();
    }

    void fillManagerKeyHolder(Object[] keyHolder, int colourType, int customColour) {
        keyHolder[0] = this.state;
        keyHolder[1] = colourType;
        keyHolder[2] = customColour;
        keyHolder[3] = this.light;
        keyHolder[4] = this.opacity;
    }

    public void increaseOpacity(int toAdd) {
        this.opacity = (short)(this.opacity + toAdd);
    }

    public int getOpacity() {
        return this.opacity;
    }

    public float getTransparency() {
        return this.transparency;
    }
}

