/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.patreon;

import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiYesNo;
import org.apache.commons.codec.binary.Hex;
import xaero.map.WorldMap;
import xaero.map.patreon.Patreon;
import xaero.map.patreon.PatreonMod;

public class GuiUpdateAll
extends GuiYesNo {
    public GuiUpdateAll() {
        super(null, "These mods are out-of-date: " + GuiUpdateAll.modListToNames(Patreon.getOutdatedMods()), Patreon.getPatronPledge() >= 5 ? "Would you like to automatically update them?" : "Would you like to update them (open the mod pages)?", 0);
        Patreon.setNotificationDisplayed(true);
    }

    private static String modListToNames(List<Object> list) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(((PatreonMod)list.get((int)i)).modName);
        }
        return builder.toString();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (Patreon.getPatronPledge() >= 5) {
            this.field_146292_n.add(new GuiButton(201, this.field_146294_l / 2 - 100, this.field_146295_m / 6 + 120, "Changelogs"));
        }
        this.field_146292_n.add(new GuiButton(202, this.field_146294_l / 2 - 100, this.field_146295_m / 6 + 144, "Don't show again for these updates"));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 0: {
                boolean shouldExit = false;
                if (Patreon.getPatronPledge() >= 5) {
                    for (GuiButton b : this.field_146292_n) {
                        b.field_146124_l = false;
                    }
                    shouldExit = this.autoUpdate();
                } else {
                    shouldExit = true;
                    for (int i = 0; i < Patreon.getOutdatedMods().size(); ++i) {
                        PatreonMod m = (PatreonMod)Patreon.getOutdatedMods().get(i);
                        try {
                            Desktop d = Desktop.getDesktop();
                            d.browse(new URI(m.changelogLink));
                            if (m.modJar == null) continue;
                            d.open(m.modJar.getParentFile());
                            continue;
                        }
                        catch (Exception e) {
                            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
                            shouldExit = false;
                        }
                    }
                }
                if (shouldExit) {
                    Minecraft.func_71410_x().func_71400_g();
                    break;
                }
                Minecraft.func_71410_x().func_147108_a(null);
                break;
            }
            case 1: {
                this.field_146297_k.func_147108_a(null);
                break;
            }
            case 201: {
                for (int i = 0; i < Patreon.getOutdatedMods().size(); ++i) {
                    PatreonMod mod = (PatreonMod)Patreon.getOutdatedMods().get(i);
                    try {
                        Desktop d = Desktop.getDesktop();
                        d.browse(new URI(mod.changelogLink));
                        continue;
                    }
                    catch (URISyntaxException e) {
                        WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
                    }
                }
                break;
            }
            case 202: {
                for (int i = 0; i < Patreon.getOutdatedMods().size(); ++i) {
                    PatreonMod mod = (PatreonMod)Patreon.getOutdatedMods().get(i);
                    if (mod.onVersionIgnore == null) continue;
                    mod.onVersionIgnore.run();
                }
                this.field_146297_k.func_147108_a(null);
            }
        }
    }

    private static void download(BufferedOutputStream output, InputStream input, boolean closeInput) throws IOException {
        int read;
        byte[] buffer = new byte[256];
        while ((read = input.read(buffer, 0, buffer.length)) >= 0) {
            output.write(buffer, 0, read);
        }
        output.flush();
        if (closeInput) {
            input.close();
        }
        output.close();
    }

    public boolean autoUpdate() {
        try {
            MessageDigest digestMD5;
            try {
                digestMD5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e1) {
                WorldMap.LOGGER.info("No algorithm for MD5.");
                return false;
            }
            PatreonMod autoupdater = (PatreonMod)Patreon.getMods().get("autoupdater30");
            String jarLink = autoupdater.changelogLink;
            String jarMD5 = autoupdater.latestVersionLayout;
            URL url = new URL(jarLink);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(900);
            conn.setConnectTimeout(900);
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11");
            if (conn.getContentLengthLong() > 0x200000L) {
                throw new IOException("Input too long to trust!");
            }
            InputStream input = conn.getInputStream();
            input = new BufferedInputStream(input);
            DigestInputStream digestInput = new DigestInputStream(input, digestMD5);
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(new File("./xaero_autoupdater.jar")));
            GuiUpdateAll.download(output, digestInput, true);
            byte[] digest = digestMD5.digest();
            String fileMD5 = Hex.encodeHexString((byte[])digest);
            if (!jarMD5.equals(fileMD5)) {
                WorldMap.LOGGER.info("Invalid autoupdater MD5: " + fileMD5);
                return false;
            }
            ArrayList<String> command = new ArrayList<String>();
            Path javaPath = new File(System.getProperty("java.home")).toPath().resolve("bin").resolve("java");
            command.add(javaPath.toString());
            command.add("-jar");
            command.add("./xaero_autoupdater.jar");
            command.add("6");
            command.add(Patreon.getUpdateLocation());
            for (int i = 0; i < Patreon.getOutdatedMods().size(); ++i) {
                PatreonMod m = (PatreonMod)Patreon.getOutdatedMods().get(i);
                if (m.modJar == null) continue;
                int canonicalPathAttempts = 10;
                String jarPath = null;
                while (canonicalPathAttempts-- > 0) {
                    try {
                        jarPath = m.modJar.getCanonicalPath();
                        break;
                    }
                    catch (IOException ioe) {
                        WorldMap.LOGGER.info("IO exception fetching the canonical path to the mod jar!");
                        if (canonicalPathAttempts == 0) {
                            throw ioe;
                        }
                        WorldMap.LOGGER.error("suppressed exception", (Throwable)ioe);
                        WorldMap.LOGGER.info("Retrying... (" + canonicalPathAttempts + ")");
                        try {
                            Thread.sleep(25L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                command.add(jarPath);
                command.add(m.latestVersionLayout);
                command.add(m.currentVersion.split("_")[1]);
                command.add(m.latestVersion);
                command.add(m.currentVersion.split("_")[0]);
                command.add(m.md5 == null ? "null" : m.md5);
            }
            WorldMap.LOGGER.info(String.join((CharSequence)", ", command));
            Runtime.getRuntime().exec(command.toArray(new String[0]));
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            return false;
        }
        return true;
    }
}

