/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.minimap.element;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import xaero.common.IXaeroMinimap;
import xaero.common.minimap.element.render.MinimapElementRenderLocation;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.map.element.MapElementRenderer;
import xaero.map.mods.SupportMods;
import xaero.map.mods.minimap.element.MinimapElementReaderWrapper;
import xaero.map.mods.minimap.element.MinimapElementRenderProviderWrapper;

public final class MinimapElementRendererWrapper<E, C>
extends MapElementRenderer<E, C, MinimapElementRendererWrapper<E, C>> {
    private final int order;
    private final IXaeroMinimap modMain;
    private final MinimapElementRenderer<E, C> renderer;
    private final Supplier<Boolean> shouldRenderSupplier;

    private MinimapElementRendererWrapper(IXaeroMinimap modMain, C context, MinimapElementRenderProviderWrapper<E, C> provider, MinimapElementReaderWrapper<E, C> reader, MinimapElementRenderer<E, C> renderer, Supplier<Boolean> shouldRenderSupplier, int order) {
        super(context, provider, reader);
        this.order = order;
        this.renderer = renderer;
        this.modMain = modMain;
        this.shouldRenderSupplier = shouldRenderSupplier;
    }

    @Override
    public void beforeRender(int location, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, FontRenderer fontRenderer, ScaledResolution scaledRes, boolean pre) {
        this.renderer.preRender(MinimapElementRenderLocation.fromWorldMap((int)location), mc.func_175606_aa(), (EntityPlayer)mc.field_71439_g, cameraX, -1.0, cameraZ, scaledRes, this.modMain);
    }

    @Override
    public void afterRender(int location, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, FontRenderer fontRenderer, ScaledResolution scaledRes, boolean pre) {
        this.renderer.postRender(MinimapElementRenderLocation.fromWorldMap((int)location), mc.func_175606_aa(), (EntityPlayer)mc.field_71439_g, cameraX, -1.0, cameraZ, scaledRes, this.modMain);
    }

    @Override
    public void renderElementPre(int location, E element, boolean hovered, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, FontRenderer fontRenderer, float optionalScale, double partialX, double partialY, boolean cave, float partialTicks, ScaledResolution scaledRes) {
    }

    @Override
    public boolean renderElement(int location, E element, boolean hovered, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, FontRenderer fontRenderer, int elementIndex, double optionalDepth, float optionalScale, double partialX, double partialY, boolean cave, float partialTicks, ScaledResolution scaledRes) {
        MinimapRendererHelper helper = this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().getHelper();
        if (SupportMods.xaeroMinimap.compatibilityVersion >= 12) {
            return this.renderer.renderElement(MinimapElementRenderLocation.fromWorldMap((int)location), hovered, false, fontRenderer, null, helper, mc.func_175606_aa(), (EntityPlayer)mc.field_71439_g, cameraX, -1.0, cameraZ, elementIndex, optionalDepth, optionalScale, element, partialX, partialY, cave, partialTicks, scaledRes);
        }
        return this.renderer.renderElement(MinimapElementRenderLocation.fromWorldMap((int)location), hovered, fontRenderer, null, helper, mc.func_175606_aa(), (EntityPlayer)mc.field_71439_g, cameraX, -1.0, cameraZ, elementIndex, optionalDepth, optionalScale, element, partialX, partialY, cave, partialTicks, scaledRes);
    }

    @Override
    public boolean shouldRender(int location, boolean pre) {
        return !pre && this.shouldRenderSupplier.get() != false && this.renderer.shouldRender(location);
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public static final class Builder<E, C> {
        private final MinimapElementRenderer<E, C> renderer;
        private Supplier<Boolean> shouldRenderSupplier;
        private IXaeroMinimap modMain;
        private int order;

        private Builder(MinimapElementRenderer<E, C> renderer) {
            this.renderer = renderer;
        }

        private Builder<E, C> setDefault() {
            this.setModMain(null);
            this.setShouldRenderSupplier(new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return true;
                }
            });
            this.setOrder(0);
            return this;
        }

        public Builder<E, C> setModMain(IXaeroMinimap modMain) {
            this.modMain = modMain;
            return this;
        }

        public Builder<E, C> setShouldRenderSupplier(Supplier<Boolean> shouldRenderSupplier) {
            this.shouldRenderSupplier = shouldRenderSupplier;
            return this;
        }

        public Builder<E, C> setOrder(int order) {
            this.order = order;
            return this;
        }

        public MinimapElementRendererWrapper<E, C> build() {
            if (this.modMain == null || this.shouldRenderSupplier == null) {
                throw new IllegalStateException();
            }
            MinimapElementRenderProviderWrapper providerWrapper = new MinimapElementRenderProviderWrapper(this.renderer.getProvider());
            MinimapElementReaderWrapper readerWrapper = new MinimapElementReaderWrapper(this.renderer.getElementReader());
            Object context = this.renderer.getContext();
            return new MinimapElementRendererWrapper(this.modMain, context, providerWrapper, readerWrapper, this.renderer, this.shouldRenderSupplier, this.order);
        }

        public static <E, C> Builder<E, C> begin(MinimapElementRenderer<E, C> renderer) {
            return super.setDefault();
        }
    }
}

