/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import xaero.map.WorldMap;
import xaero.map.animation.SlowingAnimation;
import xaero.map.element.MapElementRenderer;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.gui.GuiMap;
import xaero.map.icon.XaeroIcon;
import xaero.map.mods.SupportXaeroMinimap;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointReader;
import xaero.map.mods.gui.WaypointRenderContext;
import xaero.map.mods.gui.WaypointRenderProvider;
import xaero.map.mods.gui.WaypointSymbolCreator;

public final class WaypointRenderer
extends MapElementRenderer<Waypoint, WaypointRenderContext, WaypointRenderer> {
    private final SupportXaeroMinimap minimap;
    private final WaypointSymbolCreator symbolCreator;

    private WaypointRenderer(WaypointRenderContext context, WaypointRenderProvider provider, WaypointReader reader, SupportXaeroMinimap minimap, WaypointSymbolCreator symbolCreator) {
        super(context, provider, reader);
        this.minimap = minimap;
        this.symbolCreator = symbolCreator;
    }

    public WaypointSymbolCreator getSymbolCreator() {
        return this.symbolCreator;
    }

    @Override
    public void renderElementPre(int location, Waypoint w, boolean hovered, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, FontRenderer fontRenderer, float optionalScale, double partialX, double partialY, boolean cave, float partialTicks, ScaledResolution scaledRes) {
        GlStateManager.func_179137_b((double)partialX, (double)partialY, (double)0.0);
        GlStateManager.func_179152_a((float)(optionalScale * ((WaypointRenderContext)this.context).worldmapWaypointsScale), (float)(optionalScale * ((WaypointRenderContext)this.context).worldmapWaypointsScale), (float)1.0f);
        float visibilityAlpha = w.isDisabled() ? 0.3f : 1.0f;
        GlStateManager.func_179109_b((float)-14.0f, (float)-41.0f, (float)0.0f);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)(brightness * visibilityAlpha / ((WaypointRenderContext)this.context).worldmapWaypointsScale));
        Minecraft.func_71410_x().field_71462_r.func_73729_b(0, 19, 0, 117, 41, 22);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public boolean shouldRender(int location, boolean pre) {
        return WorldMap.settings.renderWaypoints && (!pre || WorldMap.settings.waypointBackgrounds);
    }

    @Override
    public boolean renderElement(int location, Waypoint w, boolean hovered, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, FontRenderer fontRenderer, int elementIndex, double optionalDepth, float optionalScale, double partialX, double partialY, boolean cave, float partialTicks, ScaledResolution scaledRes) {
        int symbolFrameWidth;
        boolean renderBackground = hovered || WorldMap.settings.waypointBackgrounds;
        GlStateManager.func_179137_b((double)partialX, (double)partialY, (double)0.0);
        GlStateManager.func_179152_a((float)(optionalScale * ((WaypointRenderContext)this.context).worldmapWaypointsScale), (float)(optionalScale * ((WaypointRenderContext)this.context).worldmapWaypointsScale), (float)1.0f);
        GlStateManager.func_179094_E();
        float visibilityAlpha = w.isDisabled() ? 0.3f : 1.0f;
        int color = w.getColor();
        String symbol = w.getSymbol();
        int type = w.getType();
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        int flagU = 35;
        int flagV = 34;
        int flagW = 30;
        int flagH = 43;
        if (symbol.length() > 1) {
            flagU += 35;
            flagW += 13;
        }
        if (w.isTemporary()) {
            flagU += 83;
        }
        GlStateManager.func_179109_b((float)((float)(-flagW) / 2.0f), (float)(-flagH + 1), (float)0.0f);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        if (renderBackground) {
            textureManager.func_110577_a(WorldMap.guiTextures);
            GlStateManager.func_179131_c((float)(red * visibilityAlpha), (float)(green * visibilityAlpha), (float)(blue * visibilityAlpha), (float)visibilityAlpha);
            Gui.func_146110_a((int)0, (int)0, (float)flagU, (float)flagV, (int)flagW, (int)flagH, (float)256.0f, (float)256.0f);
        }
        GlStateManager.func_179121_F();
        float oldDestAlpha = w.getDestAlpha();
        if (hovered) {
            w.setDestAlpha(255.0f);
        } else {
            w.setDestAlpha(0.0f);
        }
        if (oldDestAlpha != w.getDestAlpha()) {
            w.setAlphaAnim(new SlowingAnimation(w.getAlpha(), w.getDestAlpha(), 0.8, 1.0));
        }
        if (w.getAlphaAnim() != null) {
            w.setAlpha((float)w.getAlphaAnim().getCurrent());
        }
        float alpha = w.getAlpha();
        XaeroIcon symbolIcon = null;
        int symbolVerticalOffset = 0;
        int symbolWidth = 0;
        int stringWidth = fontRenderer.func_78256_a(symbol);
        int n = symbolFrameWidth = stringWidth / 2 > 4 ? 62 : 32;
        if (type != 1 && alpha < 200.0f) {
            symbolVerticalOffset = 5;
            symbolWidth = (stringWidth - 1) * 3;
            symbolIcon = this.symbolCreator.getSymbolTexture(symbol, scaledRes);
        } else if (type == 1) {
            symbolVerticalOffset = 3;
            symbolWidth = 27;
            symbolIcon = this.symbolCreator.getDeathSymbolTexture(scaledRes);
        }
        if (symbolIcon != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-1.0f - (float)symbolWidth / 2.0f), (float)(62 + (renderBackground ? -43 + symbolVerticalOffset - 1 : -12)), (float)0.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
            GlStateManager.func_179144_i((int)symbolIcon.getTextureAtlas().getTextureId());
            GlStateManager.func_179131_c((float)visibilityAlpha, (float)visibilityAlpha, (float)visibilityAlpha, (float)visibilityAlpha);
            Gui.func_146110_a((int)0, (int)0, (float)(symbolIcon.getOffsetX() + 1), (float)(symbolIcon.getOffsetY() + 1), (int)symbolFrameWidth, (int)62, (float)symbolIcon.getTextureAtlas().getWidth(), (float)symbolIcon.getTextureAtlas().getWidth());
            GlStateManager.func_179121_F();
        }
        if ((int)alpha > 0) {
            int tc = (int)alpha << 24 | 0xFFFFFF;
            String name = w.getName();
            int len = fontRenderer.func_78256_a(name);
            GlStateManager.func_179109_b((float)0.0f, (float)(renderBackground ? -38 : -11), (float)0.0f);
            GlStateManager.func_179152_a((float)3.0f, (float)3.0f, (float)1.0f);
            int bgLen = Math.max(len + 2, 10);
            Gui.func_73734_a((int)(-bgLen / 2), (int)-1, (int)(bgLen / 2), (int)9, (int)MapRenderHelper.getColorInt(red, green, blue, alpha / 255.0f));
            Gui.func_73734_a((int)(-bgLen / 2), (int)-1, (int)(bgLen / 2), (int)8, (int)MapRenderHelper.getColorInt(0.0f, 0.0f, 0.0f, alpha / 255.0f * 200.0f / 255.0f));
            if ((int)alpha > 3) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179147_l();
                fontRenderer.func_78276_b(name, -(len - 1) / 2, 0, tc);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        return false;
    }

    @Override
    public void beforeRender(int location, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, FontRenderer fontRenderer, ScaledResolution scaledRes, boolean pre) {
        ((WaypointRenderContext)this.context).deathpoints = this.minimap.getDeathpoints();
        ((WaypointRenderContext)this.context).userScale = mc.field_71462_r != null && mc.field_71462_r instanceof GuiMap ? ((GuiMap)mc.field_71462_r).getUserScale() : 1.0;
    }

    @Override
    public void afterRender(int location, Minecraft mc, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, FontRenderer fontRenderer, ScaledResolution scaledRes, boolean pre) {
    }

    @Override
    public int getOrder() {
        return 200;
    }

    public static final class Builder {
        private SupportXaeroMinimap minimap;
        private WaypointSymbolCreator symbolCreator;

        private Builder() {
        }

        private Builder setDefault() {
            this.setMinimap(null);
            this.setSymbolCreator(null);
            return this;
        }

        public Builder setMinimap(SupportXaeroMinimap minimap) {
            this.minimap = minimap;
            return this;
        }

        public Builder setSymbolCreator(WaypointSymbolCreator symbolCreator) {
            this.symbolCreator = symbolCreator;
            return this;
        }

        public WaypointRenderer build() {
            if (this.minimap == null || this.symbolCreator == null) {
                throw new IllegalStateException();
            }
            return new WaypointRenderer(new WaypointRenderContext(), new WaypointRenderProvider(this.minimap), new WaypointReader(), this.minimap, this.symbolCreator);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

