/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Keyboard;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.gui.MySmallButton;
import xaero.map.gui.ScreenBase;
import xaero.map.world.MapDimension;

public class GuiMapName
extends ScreenBase {
    protected String screenTitle;
    private GuiTextField nameTextField;
    private MapDimension mapDimension;
    private String editingMWId;
    private String currentNameFieldContent;
    private MapProcessor mapProcessor;

    public GuiMapName(MapProcessor mapProcessor, GuiScreen par1GuiScreen, GuiScreen escape, MapDimension mapDimension, String editingMWId) {
        super(par1GuiScreen, escape);
        this.mapDimension = mapDimension;
        this.editingMWId = editingMWId;
        this.currentNameFieldContent = editingMWId == null ? "" : mapDimension.getMultiworldName(editingMWId);
        this.mapProcessor = mapProcessor;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.screenTitle = I18n.func_135052_a((String)"gui.xaero_map_name", (Object[])new Object[0]);
        if (this.nameTextField != null) {
            this.currentNameFieldContent = this.nameTextField.func_146179_b();
        }
        this.nameTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 100, 60, 200, 20);
        this.nameTextField.func_146180_a(this.currentNameFieldContent);
        this.nameTextField.func_146195_b(true);
        this.func_189646_b(new MySmallButton(200, this.field_146294_l / 2 - 155, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0])));
        this.func_189646_b(new MySmallButton(201, this.field_146294_l / 2 + 5, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0])));
        Keyboard.enableRepeatEvents((boolean)true);
        this.updateConfirmButton();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            if (button.field_146127_k == 200) {
                if (this.canConfirm()) {
                    Object object = this.mapProcessor.uiSync;
                    synchronized (object) {
                        if (this.mapProcessor.getMapWorld() == this.mapDimension.getMapWorld()) {
                            String mwIdFixed;
                            String unfilteredName = this.nameTextField.func_146179_b();
                            if (this.editingMWId == null) {
                                String mwId = unfilteredName.toLowerCase().replaceAll("[^a-z0-9]+", "");
                                if (mwId.isEmpty()) {
                                    mwId = "map";
                                }
                                mwId = "cm$" + mwId;
                                boolean mwAdded = false;
                                mwIdFixed = mwId;
                                int fix = 1;
                                while (!mwAdded) {
                                    mwAdded = this.mapDimension.addMultiworldChecked(mwIdFixed);
                                    if (mwAdded) continue;
                                    mwIdFixed = mwId + ++fix;
                                }
                                Path dimensionFolderPath = this.mapDimension.getMainFolderPath();
                                Path multiworldFolderPath = dimensionFolderPath.resolve(mwIdFixed);
                                try {
                                    Files.createDirectories(multiworldFolderPath, new FileAttribute[0]);
                                }
                                catch (IOException e) {
                                    WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
                                }
                                this.mapDimension.setMultiworldUnsynced(mwIdFixed);
                            } else {
                                mwIdFixed = this.editingMWId;
                            }
                            this.mapDimension.setMultiworldName(mwIdFixed, unfilteredName);
                            this.mapDimension.saveConfigUnsynced();
                            this.goBack();
                        }
                    }
                }
            } else if (button.field_146127_k == 201) {
                this.goBack();
            }
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private boolean canConfirm() {
        return this.nameTextField.func_146179_b().length() > 0;
    }

    private void updateConfirmButton() {
        ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = this.canConfirm();
    }

    @Override
    protected void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        if (this.nameTextField.func_146206_l()) {
            this.nameTextField.func_146201_a(par1, par2);
            this.updateConfirmButton();
        }
        if ((par2 == 28 || par2 == 156) && this.canConfirm()) {
            this.func_146284_a((GuiButton)this.field_146292_n.get(0));
        }
    }

    public void func_73876_c() {
        this.updateConfirmButton();
        this.nameTextField.func_146178_a();
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.renderEscapeScreen(par1, par2, par3);
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.screenTitle, this.field_146294_l / 2, 20, 0xFFFFFF);
        this.nameTextField.func_146194_f();
        super.func_73863_a(par1, par2, par3);
    }

    protected void func_73864_a(int par1, int par2, int par3) throws IOException {
        super.func_73864_a(par1, par2, par3);
        this.nameTextField.func_146192_a(par1, par2, par3);
    }
}

