/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.chunk.storage.RegionFileCache;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeInfoSupplier;
import xaero.map.cache.BlockStateColorTypeCache;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.misc.CachedFunction;
import xaero.map.misc.Misc;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;

public class WorldDataReader {
    private MapProcessor mapProcessor;
    private boolean[] underair;
    private boolean[] blockFound;
    private byte[] lightLevels;
    private int[] biomeBuffer;
    private int[] topH;
    private MapBlock buildingObject;
    private OverlayBuilder[] overlayBuilders;
    private BlockPos.MutableBlockPos mutableBlockPos;
    private BlockStateColorTypeCache colorTypeCache;
    private BiomeInfoSupplier biomeKeySupplier;
    private BlockStateShortShapeCache blockStateShortShapeCache;
    private final CachedFunction<IBlockState, Boolean> transparentCache;
    private int firstTransparentStateY;
    private boolean[] shouldExtendTillTheBottom;

    public WorldDataReader(OverlayManager overlayManager, BlockStateColorTypeCache colorTypeCache, BlockStateShortShapeCache blockStateShortShapeCache) {
        this.colorTypeCache = colorTypeCache;
        this.buildingObject = new MapBlock();
        this.underair = new boolean[256];
        this.blockFound = new boolean[256];
        this.lightLevels = new byte[256];
        this.biomeBuffer = new int[3];
        this.overlayBuilders = new OverlayBuilder[256];
        this.mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < this.overlayBuilders.length; ++i) {
            this.overlayBuilders[i] = new OverlayBuilder(overlayManager);
        }
        this.biomeKeySupplier = new BiomeInfoSupplier(){

            @Override
            public void getBiomeInfo(BlockStateColorTypeCache colorTypeCache, World world, IBlockState state, BlockPos pos, int[] dest, int biomeId) {
                colorTypeCache.getBlockBiomeColour(world, state, pos, dest, biomeId);
            }
        };
        this.topH = new int[256];
        this.blockStateShortShapeCache = blockStateShortShapeCache;
        this.transparentCache = new CachedFunction<IBlockState, Boolean>(new Function<IBlockState, Boolean>(){

            @Override
            public Boolean apply(IBlockState state) {
                return WorldDataReader.this.mapProcessor.getMapWriter().shouldOverlay(state);
            }
        });
        this.shouldExtendTillTheBottom = new boolean[256];
    }

    public void setMapProcessor(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildRegion(MapRegion region, File worldDir, World world, boolean loading, int[] chunkCountDest) {
        boolean regionIsResting;
        if (!loading) {
            region.pushWriterPause();
        }
        boolean result = true;
        int prevRegX = region.getRegionX();
        int prevRegZ = region.getRegionZ() - 1;
        MapRegion prevRegion = this.mapProcessor.getMapRegion(prevRegX, prevRegZ, false);
        MapRegion mapRegion = region;
        synchronized (mapRegion) {
            regionIsResting = region.isResting();
            if (!loading && regionIsResting) {
                region.setBeingWritten(true);
                region.setShouldCache(false, "world save");
                region.setReloadHasBeenRequested(false, "world save");
                region.setVersion(this.mapProcessor.getGlobalVersion());
                region.setCacheHashCode(WorldMap.settings.getRegionCacheHashCode());
                if (region.getLoadState() != 2) {
                    if (region.getLoadState() == 4) {
                        region.restoreBufferUpdateObjects();
                    }
                    region.setLoadState((byte)2);
                    region.setLastSaveTime(System.currentTimeMillis() + 100000L);
                    this.mapProcessor.addToProcess(region);
                } else {
                    this.mapProcessor.removeToRefresh(region);
                    region.setRefreshing(false);
                }
            }
        }
        int caveStart = this.mapProcessor.getCaveStart();
        boolean ignoreHeightmaps = this.mapProcessor.getMapWorld().isIgnoreHeightmaps();
        boolean flowers = WorldMap.settings.flowers;
        if (loading || region.getLoadState() == 2 && regionIsResting) {
            RegionFile regionFile = RegionFileCache.func_76550_a((File)worldDir, (int)(region.getRegionX() * 32), (int)(region.getRegionZ() * 32));
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    MapTileChunk tileChunk = region.getChunk(i, j);
                    if (tileChunk == null) {
                        tileChunk = new MapTileChunk(region, (region.getRegionX() << 3) + i, (region.getRegionZ() << 3) + j);
                        region.setChunk(i, j, tileChunk);
                        MapRegion mapRegion2 = region;
                        synchronized (mapRegion2) {
                            region.setAllCachePrepared(false);
                        }
                    }
                    if (region.isMetaLoaded()) {
                        tileChunk.getLeafTexture().setBufferedTextureVersion(region.getAndResetCachedTextureVersion(i, j));
                    }
                    this.buildTileChunk(tileChunk, caveStart, ignoreHeightmaps, prevRegion, regionFile, world, flowers);
                    tileChunk.setLoadState((byte)2);
                    if (!tileChunk.includeInSave() && !tileChunk.hasHighlightsIfUndiscovered()) {
                        region.setChunk(i, j, null);
                        tileChunk.getLeafTexture().deleteTexturesAndBuffers();
                        tileChunk = null;
                        continue;
                    }
                    chunkCountDest[0] = chunkCountDest[0] + 1;
                }
            }
            if (region.isMultiplayer()) {
                region.setLastSaveTime(System.currentTimeMillis() - 60000L + 1500L);
            }
        } else {
            result = false;
        }
        if (!loading) {
            region.popWriterPause();
        }
        return result;
    }

    private void buildTileChunk(MapTileChunk tileChunk, int caveStart, boolean ignoreHeightmaps, MapRegion prevRegion, RegionFile regionFile, World world, boolean flowers) {
        tileChunk.unincludeInSave();
        tileChunk.resetHeights();
        for (int insideX = 0; insideX < 4; ++insideX) {
            for (int insideZ = 0; insideZ < 4; ++insideZ) {
                NBTTagCompound nbttagcompound;
                int chunkZ;
                MapTile tile = tileChunk.getTile(insideX, insideZ);
                int chunkX = (tileChunk.getX() << 2) + insideX;
                DataInputStream datainputstream = regionFile.func_76704_a(chunkX & 0x1F, (chunkZ = (tileChunk.getZ() << 2) + insideZ) & 0x1F);
                if (datainputstream == null) {
                    if (tile == null) continue;
                    tileChunk.setChanged(true);
                    tileChunk.setTile(insideX, insideZ, null, this.blockStateShortShapeCache);
                    this.mapProcessor.getTilePool().addToPool(tile);
                    continue;
                }
                boolean createdTile = false;
                if (tile == null) {
                    tile = this.mapProcessor.getTilePool().get(this.mapProcessor.getCurrentDimension(), chunkX, chunkZ);
                    createdTile = true;
                }
                try {
                    nbttagcompound = CompressedStreamTools.func_74794_a((DataInputStream)datainputstream);
                    datainputstream.close();
                }
                catch (IOException e) {
                    try {
                        datainputstream.close();
                    }
                    catch (IOException e1) {
                        WorldMap.LOGGER.error("suppressed exception", (Throwable)e1);
                    }
                    WorldMap.LOGGER.error(String.format("Error loading chunk nbt for chunk %d %d!", chunkX, chunkZ), (Throwable)e);
                    if (tile == null) continue;
                    tileChunk.setTile(insideX, insideZ, null, this.blockStateShortShapeCache);
                    this.mapProcessor.getTilePool().addToPool(tile);
                    continue;
                }
                nbttagcompound = Minecraft.func_71410_x().func_184126_aj().func_188257_a((IFixType)FixTypes.CHUNK, nbttagcompound);
                if (this.buildTile(nbttagcompound, tile, tileChunk, chunkX, chunkZ, caveStart, ignoreHeightmaps, world, flowers)) {
                    tileChunk.setTile(insideX, insideZ, tile, this.blockStateShortShapeCache);
                    if (!createdTile) continue;
                    tileChunk.setChanged(true);
                    continue;
                }
                tileChunk.setTile(insideX, insideZ, null, this.blockStateShortShapeCache);
                this.mapProcessor.getTilePool().addToPool(tile);
            }
        }
        if (tileChunk.wasChanged()) {
            tileChunk.setToUpdateBuffers(true);
            tileChunk.setChanged(false);
        }
    }

    private boolean buildTile(NBTTagCompound nbttagcompound, MapTile tile, MapTileChunk tileChunk, int chunkX, int chunkZ, int caveStart, boolean ignoreHeightmaps, World world, boolean flowers) {
        boolean cave;
        NBTTagCompound levelCompound = nbttagcompound.func_74775_l("Level");
        if (levelCompound.func_74771_c("TerrainPopulated") == 0) {
            return false;
        }
        NBTTagList sectionsList = levelCompound.func_150295_c("Sections", 10);
        int fillCounter = 256;
        int[] topH = this.topH;
        boolean[] shouldExtendTillTheBottom = this.shouldExtendTillTheBottom;
        for (int i = 0; i < this.blockFound.length; ++i) {
            this.overlayBuilders[i].startBuilding();
            this.blockFound[i] = false;
            this.underair[i] = false;
            this.lightLevels[i] = 0;
            topH[i] = 0;
            shouldExtendTillTheBottom[i] = false;
        }
        int[] heightMap = levelCompound.func_74759_k("HeightMap");
        boolean heightMapExists = heightMap.length == 256;
        byte[] biomes = null;
        int[] biomesInt = null;
        boolean biomesDataExists = false;
        if (levelCompound.func_150297_b("Biomes", 7)) {
            biomes = levelCompound.func_74770_j("Biomes");
            biomesDataExists = biomes.length == 256;
        } else if (levelCompound.func_150297_b("Biomes", 11)) {
            biomesInt = levelCompound.func_74759_k("Biomes");
            biomesDataExists = biomesInt.length == 256;
        }
        boolean bl = cave = caveStart != -1;
        if (sectionsList.func_74745_c() == 0) {
            this.biomeBuffer[2] = 0;
            this.biomeBuffer[0] = 0;
            this.biomeBuffer[1] = -1;
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    MapBlock currentPixel = tile.getBlock(i, j);
                    this.buildingObject.prepareForWriting();
                    this.buildingObject.write(0, 0, 0, this.biomeBuffer, (byte)0, false, cave);
                    tile.setBlock(i, j, this.buildingObject);
                    this.buildingObject = currentPixel != null ? currentPixel : new MapBlock();
                }
            }
        } else {
            for (int i = sectionsList.func_74745_c() - 1; i >= 0 && fillCounter > 0; --i) {
                NBTTagCompound sectionCompound = sectionsList.func_150305_b(i);
                boolean hasBlocks = sectionCompound.func_150297_b("Blocks", 7);
                boolean hasPalette = sectionCompound.func_150297_b("Palette", 11);
                byte[] blockIds_a = null;
                byte[] dataArray = null;
                byte[] addArray = null;
                byte[] add2Array = null;
                int[] palette = null;
                boolean preparedSectionData = false;
                byte[] lightMap = null;
                int sectionHeight = sectionCompound.func_74771_c("Y") * 16;
                int sectionBasedHeight = sectionHeight + 15;
                for (int z = 0; z < 16; ++z) {
                    block5: for (int x = 0; x < 16; ++x) {
                        int startHeight;
                        int pos_2d = (z << 4) + x;
                        if (this.blockFound[pos_2d]) continue;
                        if (cave) {
                            startHeight = caveStart;
                        } else {
                            int height = heightMapExists ? heightMap[pos_2d] : 255;
                            startHeight = ignoreHeightmaps || height == -1 ? sectionBasedHeight : height + 3;
                        }
                        if (i > 0 && startHeight < sectionHeight) continue;
                        int biome = biomesDataExists ? (biomesInt != null ? biomesInt[pos_2d] : biomes[pos_2d] & 0xFF) : 0;
                        int localStartHeight = 15;
                        if (startHeight >> 4 << 4 == sectionHeight) {
                            localStartHeight = startHeight & 0xF;
                        }
                        if (!preparedSectionData) {
                            if (hasBlocks) {
                                blockIds_a = sectionCompound.func_74770_j("Blocks");
                                addArray = sectionCompound.func_150297_b("Add", 7) ? sectionCompound.func_74770_j("Add") : null;
                                add2Array = sectionCompound.func_150297_b("Add2", 7) ? sectionCompound.func_74770_j("Add2") : null;
                                dataArray = sectionCompound.func_74770_j("Data");
                            }
                            if (hasPalette) {
                                palette = sectionCompound.func_74759_k("Palette");
                            }
                            if (sectionCompound.func_150297_b("BlockLight", 7) && (lightMap = sectionCompound.func_74770_j("BlockLight")).length != 2048) {
                                lightMap = null;
                            }
                            preparedSectionData = true;
                        }
                        for (int y = localStartHeight; y >= 0; --y) {
                            boolean buildResult;
                            int h = sectionHeight + y;
                            int pos = y << 8 | pos_2d;
                            int blockId = 0;
                            int blockMeta = 0;
                            if (hasPalette) {
                                int leftIndexPart = hasBlocks ? (blockIds_a[pos] & 0xFF) << 4 : 0;
                                int paletteIndex = leftIndexPart | this.nibbleValue(dataArray, pos);
                                int blockStateOtherId = palette[paletteIndex];
                                blockId = blockStateOtherId >> 4;
                                blockMeta = blockStateOtherId & 0xF;
                            } else if (hasBlocks) {
                                blockId = blockIds_a[pos] & 0xFF | (addArray == null ? 0 : this.nibbleValue(addArray, pos) << 8);
                                if (add2Array != null) {
                                    blockId |= this.nibbleValue(add2Array, pos) << 12;
                                }
                                blockMeta = this.nibbleValue(dataArray, pos);
                            }
                            int stateId = Block.func_176210_f((IBlockState)Block.func_149729_e((int)blockId).func_176203_a(blockMeta));
                            this.mutableBlockPos.func_181079_c(chunkX << 4 | x, sectionHeight | y, chunkZ << 4 | z);
                            OverlayBuilder overlayBuilder = this.overlayBuilders[pos_2d];
                            byte light = this.lightLevels[pos_2d];
                            IBlockState state = Misc.getStateById(stateId);
                            if (!shouldExtendTillTheBottom[pos_2d] && !overlayBuilder.isEmpty() && this.firstTransparentStateY - h >= 5) {
                                shouldExtendTillTheBottom[pos_2d] = true;
                            }
                            if (!(buildResult = this.buildPixel(this.buildingObject, state, stateId, x, h, z, pos_2d, this.biomeBuffer, light, biome, cave, overlayBuilder, world, this.mutableBlockPos, topH, shouldExtendTillTheBottom[pos_2d], flowers)) && y == 0 && i == 0) {
                                h = 0;
                                stateId = 0;
                                state = Blocks.field_150350_a.func_176223_P();
                                buildResult = true;
                            }
                            if (buildResult) {
                                this.buildingObject.prepareForWriting();
                                overlayBuilder.finishBuilding(this.buildingObject);
                                this.colorTypeCache.getBlockBiomeColour(world, state, (BlockPos)this.mutableBlockPos, this.biomeBuffer, biome);
                                if (overlayBuilder.getOverlayBiome() != -1) {
                                    this.biomeBuffer[1] = overlayBuilder.getOverlayBiome();
                                }
                                boolean glowing = this.mapProcessor.getMapWriter().isGlowing(state);
                                this.buildingObject.write(stateId, h, topH[pos_2d], this.biomeBuffer, light, glowing, cave);
                                MapBlock currentPixel = tile.getBlock(x, z);
                                boolean equalsSlopesExcluded = this.buildingObject.equalsSlopesExcluded(currentPixel);
                                boolean fullyEqual = this.buildingObject.equals(currentPixel, equalsSlopesExcluded);
                                if (!fullyEqual) {
                                    tile.setBlock(x, z, this.buildingObject);
                                    this.buildingObject = currentPixel != null ? currentPixel : new MapBlock();
                                    if (!equalsSlopesExcluded) {
                                        tileChunk.setChanged(true);
                                    }
                                }
                                this.blockFound[pos_2d] = true;
                                --fillCounter;
                                continue block5;
                            }
                            this.lightLevels[pos_2d] = lightMap == null ? (byte)0 : this.nibbleValue(lightMap, pos);
                        }
                    }
                }
            }
        }
        tile.setWrittenOnce(true);
        tile.setLoaded(true);
        tile.setWorldInterpretationVersion(1);
        return true;
    }

    private boolean buildPixel(MapBlock pixel, IBlockState state, int stateId, int x, int h, int z, int pos_2d, int[] biomeBuffer, byte light, int dataBiome, boolean cave, OverlayBuilder overlayBuilder, World world, BlockPos.MutableBlockPos mutableBlockPos, int[] topH, boolean shouldExtendTillTheBottom, boolean flowers) {
        Block b = state.func_177230_c();
        if (b instanceof BlockAir) {
            this.underair[pos_2d] = true;
            return false;
        }
        if (!this.underair[pos_2d] && cave) {
            return false;
        }
        if (this.mapProcessor.getMapWriter().isInvisible(world, state, b, flowers)) {
            return false;
        }
        int lightOpacity = state.getLightOpacity((IBlockAccess)world, (BlockPos)mutableBlockPos);
        if (this.shouldOverlayCached(state)) {
            if (h > topH[pos_2d]) {
                topH[pos_2d] = h;
            }
            if (overlayBuilder.isEmpty()) {
                this.firstTransparentStateY = h;
            }
            if (shouldExtendTillTheBottom) {
                overlayBuilder.getCurrentOverlay().increaseOpacity(Misc.getStateById(overlayBuilder.getCurrentOverlay().getState()).getLightOpacity((IBlockAccess)world, (BlockPos)mutableBlockPos));
            } else {
                overlayBuilder.build(stateId, biomeBuffer, lightOpacity, light, world, this.mapProcessor, (BlockPos)mutableBlockPos, dataBiome, this.colorTypeCache, this.biomeKeySupplier);
            }
            return false;
        }
        if (!this.mapProcessor.getMapWriter().hasVanillaColor(state, world, (BlockPos)mutableBlockPos)) {
            return false;
        }
        if (h > topH[pos_2d]) {
            topH[pos_2d] = h;
        }
        return true;
    }

    private boolean shouldOverlayCached(IBlockState state) {
        return this.transparentCache.apply(state);
    }

    private byte nibbleValue(byte[] array, int index) {
        byte b = array[index >> 1];
        if ((index & 1) == 0) {
            return (byte)(b & 0xF);
        }
        return (byte)(b >> 4 & 0xF);
    }
}

