/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.cache;

import java.lang.reflect.Field;
import java.util.Hashtable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColorHelper;
import xaero.map.WorldMap;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.misc.Misc;

public class BlockStateColorTypeCache {
    private Hashtable<IBlockState, Integer> colorTypes = new Hashtable();
    private Hashtable<IBlockState, Object> defaultColorResolversCache = new Hashtable();
    private int grassColor;
    private int foliageColor;
    private IBlockState grassState = Blocks.field_150349_c.func_176223_P();
    private IBlockState oakLeavesState = Blocks.field_150362_t.func_176223_P();
    private IBlockState waterState = Blocks.field_150355_j.func_176223_P();
    private Field defaultGrassResolverField = Misc.getFieldReflection(BiomeColorHelper.class, "field_180291_a", "GRASS_COLOR");
    private Field defaultFoliageResolverField = Misc.getFieldReflection(BiomeColorHelper.class, "field_180289_b", "FOLIAGE_COLOR");
    private Field defaultWaterResolverField = Misc.getFieldReflection(BiomeColorHelper.class, "field_180290_c", "WATER_COLOR");
    private Object DEFAULT_GRASS_RESOLVER;
    private Object DEFAULT_FOLIAGE_RESOLVER;
    private Object DEFAULT_WATER_RESOLVER;
    private boolean detectionWorks = true;

    public void getBlockBiomeColour(World world, IBlockState state, BlockPos pos, int[] dest, int biomeId) {
        dest[2] = 0;
        dest[0] = 0;
        dest[1] = -1;
        Integer cachedColorType = this.colorTypes.get(state);
        int colorType = cachedColorType != null ? cachedColorType : -1;
        int customColour = -1;
        boolean gotFullCC = false;
        boolean isRenderThread = Minecraft.func_71410_x().func_152345_ab();
        if (colorType == -1 && isRenderThread) {
            boolean detected;
            Object detectedColorResolver = this.detectionWorks ? XaeroWorldMapCore.detectColorResolver(state, world, pos, this.DEFAULT_GRASS_RESOLVER, this.DEFAULT_FOLIAGE_RESOLVER, this.DEFAULT_WATER_RESOLVER) : null;
            boolean bl = detected = detectedColorResolver != null;
            if (!detected) {
                if (state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i) {
                    detectedColorResolver = this.DEFAULT_WATER_RESOLVER;
                } else {
                    try {
                        customColour = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, null, null, 0);
                    }
                    catch (Throwable t) {
                        customColour = 0;
                    }
                    if (customColour != -1 && customColour != this.grassColor && customColour != this.foliageColor) {
                        Material material = state.func_185904_a();
                        if (material != null && (material.func_151565_r() == MapColor.field_151661_c || material.func_151565_r() == MapColor.field_151669_i || material.func_151565_r() == MapColor.field_151662_n)) {
                            customColour = this.tryGettingColor(state, world, pos, 0);
                            gotFullCC = true;
                            if (material.func_151565_r() == MapColor.field_151661_c && customColour == this.tryGettingColor(this.grassState, world, pos, 0)) {
                                detectedColorResolver = this.DEFAULT_GRASS_RESOLVER;
                            } else if (material.func_151565_r() == MapColor.field_151669_i && customColour == this.tryGettingColor(this.oakLeavesState, world, pos, 0)) {
                                detectedColorResolver = this.DEFAULT_FOLIAGE_RESOLVER;
                            } else if (material.func_151565_r() == MapColor.field_151662_n && customColour == this.tryGettingColor(this.waterState, world, pos, 0)) {
                                detectedColorResolver = this.DEFAULT_WATER_RESOLVER;
                            }
                        }
                    } else if (customColour == this.grassColor) {
                        detectedColorResolver = this.DEFAULT_GRASS_RESOLVER;
                    } else if (customColour == this.foliageColor) {
                        detectedColorResolver = this.DEFAULT_FOLIAGE_RESOLVER;
                    }
                }
            }
            if (detectedColorResolver != null) {
                colorType = 1;
                if (detectedColorResolver == this.DEFAULT_FOLIAGE_RESOLVER) {
                    colorType = 2;
                }
                if (!detected) {
                    this.defaultColorResolversCache.put(state, detectedColorResolver);
                }
            } else {
                if (!gotFullCC) {
                    customColour = this.tryGettingColor(state, world, pos, 0);
                    gotFullCC = true;
                }
                colorType = customColour != 0xFFFFFF && customColour != -1 ? 3 : 0;
            }
            this.colorTypes.put(state, colorType);
        } else if (colorType == 3 && !isRenderThread) {
            colorType = -1;
        }
        if ((colorType == 1 || colorType == 2) && biomeId == -1) {
            if (isRenderThread) {
                biomeId = Biome.func_185362_a((Biome)world.func_180494_b(pos));
            } else {
                colorType = -1;
            }
        }
        dest[0] = colorType;
        if (colorType == -1) {
            dest[1] = biomeId;
        } else if (colorType == 1 || colorType == 2) {
            dest[1] = biomeId;
        } else if (colorType == 3) {
            if (!gotFullCC) {
                customColour = this.tryGettingColor(state, world, pos, 0);
            }
            dest[2] = customColour;
        }
    }

    public void updateGrassColor() {
        this.grassColor = this.tryGettingColor(this.grassState, null, null, 0);
        this.foliageColor = this.tryGettingColor(this.oakLeavesState, null, null, 0);
        if (WorldMap.settings.debug) {
            WorldMap.LOGGER.info("Default grass colour: " + this.grassColor);
        }
    }

    public void updateDefaultResolvers(World world) {
        if (world == null) {
            return;
        }
        this.DEFAULT_GRASS_RESOLVER = XaeroWorldMapCore.detectColorResolver(Blocks.field_150349_c.func_176223_P(), world, new BlockPos(0, 0, 0), null, null, null);
        if (this.DEFAULT_GRASS_RESOLVER == null) {
            this.DEFAULT_GRASS_RESOLVER = this.getDefaultGrassResolver();
            this.detectionWorks = false;
        }
        this.DEFAULT_FOLIAGE_RESOLVER = XaeroWorldMapCore.detectColorResolver(Blocks.field_150362_t.func_176223_P(), world, new BlockPos(0, 0, 0), null, null, null);
        if (this.DEFAULT_FOLIAGE_RESOLVER == null) {
            this.DEFAULT_FOLIAGE_RESOLVER = this.getDefaultFoliageResolver();
            this.detectionWorks = false;
        }
        this.DEFAULT_WATER_RESOLVER = XaeroWorldMapCore.detectColorResolver(Blocks.field_150355_j.func_176223_P(), world, new BlockPos(0, 0, 0), null, null, null);
        if (this.DEFAULT_WATER_RESOLVER == null) {
            this.DEFAULT_WATER_RESOLVER = this.getDefaultWaterResolver();
            this.detectionWorks = false;
        }
    }

    private int tryGettingColor(IBlockState state, World world, BlockPos pos, int tint) {
        try {
            return Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)world, pos, tint);
        }
        catch (Throwable t) {
            WorldMap.LOGGER.error("suppressed exception", t);
            return 0;
        }
    }

    public Object getColorResolver(IBlockState state, World world, BlockPos pos) {
        Object detection;
        Object object = detection = this.detectionWorks ? XaeroWorldMapCore.detectColorResolver(state, world, pos, this.DEFAULT_GRASS_RESOLVER, this.DEFAULT_FOLIAGE_RESOLVER, this.DEFAULT_WATER_RESOLVER) : null;
        if (detection != null) {
            return detection;
        }
        return this.defaultColorResolversCache.get(state);
    }

    private Object getDefaultGrassResolver() {
        return Misc.getReflectFieldValue(null, this.defaultGrassResolverField);
    }

    private Object getDefaultFoliageResolver() {
        return Misc.getReflectFieldValue(null, this.defaultFoliageResolverField);
    }

    private Object getDefaultWaterResolver() {
        return Misc.getReflectFieldValue(null, this.defaultWaterResolverField);
    }
}

