/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.util;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTItemStackUtil {
    private static void initNBTTagCompound(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
    }

    public static boolean hasTag(ItemStack itemStack, String tagName) {
        return itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b(tagName);
    }

    public static void removeTag(ItemStack itemStack, String tagName) {
        if (itemStack.func_77978_p() != null) {
            itemStack.func_77978_p().func_82580_o(tagName);
        }
    }

    public static String getString(ItemStack itemStack, String tagName) {
        if (NBTItemStackUtil.hasTag(itemStack, tagName)) {
            return itemStack.func_77978_p().func_74779_i(tagName);
        }
        return "";
    }

    public static void setString(ItemStack itemStack, String tagName, String tagValue) {
        NBTItemStackUtil.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74778_a(tagName, tagValue);
    }

    public static Boolean getBoolean(ItemStack itemStack, String tagName) {
        if (NBTItemStackUtil.hasTag(itemStack, tagName)) {
            return itemStack.func_77978_p().func_74767_n(tagName);
        }
        return false;
    }

    public static void setBoolean(ItemStack itemStack, String tagName, boolean tagValue) {
        NBTItemStackUtil.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74757_a(tagName, tagValue);
    }

    public static Byte getByte(ItemStack itemStack, String tagName) {
        if (NBTItemStackUtil.hasTag(itemStack, tagName)) {
            return itemStack.func_77978_p().func_74771_c(tagName);
        }
        return (byte)0;
    }

    public static void setByte(ItemStack itemStack, String tagName, byte tagValue) {
        NBTItemStackUtil.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74774_a(tagName, tagValue);
    }

    public static Short getShort(ItemStack itemStack, String tagName) {
        if (NBTItemStackUtil.hasTag(itemStack, tagName)) {
            return itemStack.func_77978_p().func_74765_d(tagName);
        }
        return (short)0;
    }

    public static void setShort(ItemStack itemStack, String tagName, short tagValue) {
        NBTItemStackUtil.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74777_a(tagName, tagValue);
    }

    public static Integer getInteger(ItemStack itemStack, String tagName) {
        if (NBTItemStackUtil.hasTag(itemStack, tagName)) {
            return itemStack.func_77978_p().func_74762_e(tagName);
        }
        return 0;
    }

    public static void setInteger(ItemStack itemStack, String tagName, int tagValue) {
        NBTItemStackUtil.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74768_a(tagName, tagValue);
    }

    public static Long getLong(ItemStack itemStack, String tagName) {
        if (NBTItemStackUtil.hasTag(itemStack, tagName)) {
            return itemStack.func_77978_p().func_74763_f(tagName);
        }
        return 0L;
    }

    public static void setLong(ItemStack itemStack, String tagName, long tagValue) {
        NBTItemStackUtil.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74772_a(tagName, tagValue);
    }

    public static Float getFloat(ItemStack itemStack, String tagName) {
        if (NBTItemStackUtil.hasTag(itemStack, tagName)) {
            return Float.valueOf(itemStack.func_77978_p().func_74760_g(tagName));
        }
        return Float.valueOf(0.0f);
    }

    public static void setFloat(ItemStack itemStack, String tagName, float tagValue) {
        NBTItemStackUtil.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74776_a(tagName, tagValue);
    }

    public static Double getDouble(ItemStack itemStack, String tagName) {
        if (NBTItemStackUtil.hasTag(itemStack, tagName)) {
            return itemStack.func_77978_p().func_74769_h(tagName);
        }
        return 0.0;
    }

    public static void setDouble(ItemStack itemStack, String tagName, double tagValue) {
        NBTItemStackUtil.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74780_a(tagName, tagValue);
    }

    public static NBTTagCompound getCompoundTag(ItemStack itemStack, String tagName) {
        if (NBTItemStackUtil.hasTag(itemStack, tagName)) {
            return itemStack.func_77978_p().func_74775_l(tagName);
        }
        return new NBTTagCompound();
    }

    public static void setCompoundTag(ItemStack itemStack, String tagName, NBTTagCompound tagValue) {
        NBTItemStackUtil.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74782_a(tagName, (NBTBase)tagValue);
    }

    public static NBTTagList getTagList(ItemStack itemStack, String tagName, int tagType) {
        if (NBTItemStackUtil.hasTag(itemStack, tagName)) {
            return itemStack.func_77978_p().func_150295_c(tagName, tagType);
        }
        return new NBTTagList();
    }

    public static void setTagList(ItemStack itemStack, String tagName, NBTTagList tagValue) {
        NBTItemStackUtil.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74782_a(tagName, (NBTBase)tagValue);
    }
}

