/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util.helpers;

import com.pg85.otg.configuration.ConfigFunction;
import com.pg85.otg.configuration.customobjects.CustomObjectConfigFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InheritanceHelper {
    public static final <T, C extends CustomObjectConfigFunction<T>> List<C> mergeListsCustomObject(Collection<? extends C> childList, Collection<? extends C> parentList) {
        ArrayList<C> returnList = new ArrayList<C>(childList);
        for (CustomObjectConfigFunction parentFunction : parentList) {
            if (InheritanceHelper.hasAnalogousFunction(parentFunction, childList)) continue;
            returnList.add(parentFunction);
        }
        return returnList;
    }

    private static final <T, C extends CustomObjectConfigFunction<T>> boolean hasAnalogousFunction(C function, Collection<? extends C> list) {
        for (CustomObjectConfigFunction toCheck : list) {
            if (!function.isAnalogousTo(toCheck)) continue;
            return true;
        }
        return false;
    }

    private InheritanceHelper() {
    }

    public static final <T, C extends ConfigFunction<T>> List<C> mergeLists(Collection<? extends C> childList, Collection<? extends C> parentList) {
        ArrayList<C> returnList = new ArrayList<C>(childList);
        for (ConfigFunction parentFunction : parentList) {
            if (InheritanceHelper.hasAnalogousFunction(parentFunction, childList)) continue;
            returnList.add(parentFunction);
        }
        return returnList;
    }

    private static final <T, C extends ConfigFunction<T>> boolean hasAnalogousFunction(C function, Collection<? extends C> list) {
        for (ConfigFunction toCheck : list) {
            if (!function.isAnalogousTo(toCheck)) continue;
            return true;
        }
        return false;
    }
}

