/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.surface;

import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.ChunkBuffer;
import com.pg85.otg.generator.GeneratingChunk;
import com.pg85.otg.generator.surface.LayerChoice;
import com.pg85.otg.generator.surface.SimpleSurfaceGenerator;
import com.pg85.otg.util.helpers.StringHelper;
import com.pg85.otg.util.materials.MaterialHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MultipleLayersSurfaceGenerator
extends SimpleSurfaceGenerator {
    private List<LayerChoice> layerChoices;

    public MultipleLayersSurfaceGenerator(String[] args) throws InvalidConfigException {
        if (args.length < 2) {
            throw new InvalidConfigException("Needs at least two arguments");
        }
        this.layerChoices = new ArrayList<LayerChoice>();
        for (int i = 0; i < args.length - 2; i += 3) {
            LocalMaterialData surfaceBlock = MaterialHelper.readMaterial(args[i]);
            LocalMaterialData groundBlock = MaterialHelper.readMaterial(args[i + 1]);
            float maxNoise = (float)StringHelper.readDouble(args[i + 2], -20.0, 20.0);
            this.layerChoices.add(new LayerChoice(surfaceBlock, groundBlock, maxNoise));
        }
        Collections.sort(this.layerChoices);
    }

    @Override
    public LocalMaterialData getSurfaceBlockAtHeight(LocalWorld world, BiomeConfig biomeConfig, int xInWorld, int yInWorld, int zInWorld) {
        double noise = world.getBiomeBlocksNoiseValue(xInWorld, zInWorld);
        for (LayerChoice layer : this.layerChoices) {
            if (!(noise <= (double)layer.maxNoise)) continue;
            return layer.getSurfaceBlockReplaced(world, biomeConfig, yInWorld);
        }
        return biomeConfig.getSurfaceBlockReplaced(world, yInWorld);
    }

    @Override
    public LocalMaterialData getGroundBlockAtHeight(LocalWorld world, BiomeConfig biomeConfig, int xInWorld, int yInWorld, int zInWorld) {
        double noise = world.getBiomeBlocksNoiseValue(xInWorld, zInWorld);
        for (LayerChoice layer : this.layerChoices) {
            if (!(noise <= (double)layer.maxNoise)) continue;
            return layer.getGroundBlockReplaced(world, biomeConfig, yInWorld);
        }
        return biomeConfig.getGroundBlockReplaced(world, yInWorld);
    }

    @Override
    public void spawn(LocalWorld world, GeneratingChunk generatingChunkInfo, ChunkBuffer chunkBuffer, BiomeConfig config, int xInWorld, int zInWorld) {
        int x = xInWorld & 0xF;
        int z = zInWorld & 0xF;
        double noise = generatingChunkInfo.getNoise(x, z);
        for (LayerChoice layer : this.layerChoices) {
            if (!(noise <= (double)layer.maxNoise)) continue;
            this.spawnColumn(world, layer, generatingChunkInfo, chunkBuffer, config, x, z);
            return;
        }
        this.spawnColumn(world, null, generatingChunkInfo, chunkBuffer, config, x, z);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (LayerChoice groundLayer : this.layerChoices) {
            stringBuilder.append(groundLayer.surfaceBlock);
            stringBuilder.append(',').append(' ');
            stringBuilder.append(groundLayer.groundBlock);
            stringBuilder.append(',').append(' ');
            stringBuilder.append(groundLayer.maxNoise);
            stringBuilder.append(',').append(' ');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 2);
        return stringBuilder.toString();
    }
}

