/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.surface;

import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.biome.settings.ReplacedBlocksMatrix;
import com.pg85.otg.generator.ChunkBuffer;
import com.pg85.otg.generator.GeneratingChunk;
import com.pg85.otg.generator.noise.NoiseGeneratorPerlinMesaBlocks;
import com.pg85.otg.generator.surface.SurfaceGenerator;
import com.pg85.otg.util.materials.MaterialHelper;
import java.util.Arrays;
import java.util.Random;

public class MesaSurfaceGenerator
implements SurfaceGenerator {
    public static final String NAME_NORMAL = "Mesa";
    public static final String NAME_FOREST = "MesaForest";
    public static final String NAME_BRYCE = "MesaBryce";
    private LocalMaterialData[] clayBands;
    private long worldSeed;
    private boolean hasForest;
    private boolean brycePillars;
    private NoiseGeneratorPerlinMesaBlocks pillarNoise;
    private NoiseGeneratorPerlinMesaBlocks pillarRoofNoise;
    private NoiseGeneratorPerlinMesaBlocks clayBandsOffsetNoise;
    private LocalMaterialData hardClay = MaterialHelper.HARDENED_CLAY;
    private LocalMaterialData orangeClay = MaterialHelper.ORANGE_STAINED_CLAY;
    private LocalMaterialData yellowClay = MaterialHelper.YELLOW_STAINED_CLAY;
    private LocalMaterialData brownClay = MaterialHelper.BROWN_STAINED_CLAY;
    private LocalMaterialData redClay = MaterialHelper.RED_STAINED_CLAY;
    private LocalMaterialData whiteClay = MaterialHelper.WHITE_STAINED_CLAY;
    private LocalMaterialData silverClay = MaterialHelper.SILVER_STAINED_CLAY;
    private LocalMaterialData redSand = MaterialHelper.RED_SAND;
    boolean initialized;
    private boolean hardClayIsReplaced;
    private boolean orangeClayIsReplaced;
    private boolean yellowClayIsReplaced;
    private boolean brownClayIsReplaced;
    private boolean redClayIsReplaced;
    private boolean whiteClayIsReplaced;
    private boolean silverClayIsReplaced;
    private boolean redSandIsReplaced;
    private int lastX = Integer.MAX_VALUE;
    private int lastZ = Integer.MAX_VALUE;
    private int lastNoise = 0;
    boolean clayBandsGenerated = false;

    private MesaSurfaceGenerator(boolean mountainMesa, boolean forestMesa) {
        this.brycePillars = mountainMesa;
        this.hasForest = forestMesa;
    }

    public static MesaSurfaceGenerator getFor(String settingValue) {
        if (NAME_NORMAL.equalsIgnoreCase(settingValue)) {
            return new MesaSurfaceGenerator(false, false);
        }
        if (NAME_FOREST.equalsIgnoreCase(settingValue)) {
            return new MesaSurfaceGenerator(false, true);
        }
        if (NAME_BRYCE.equalsIgnoreCase(settingValue)) {
            return new MesaSurfaceGenerator(true, false);
        }
        return null;
    }

    public void Init(ReplacedBlocksMatrix replacedBlocks) {
        if (!this.initialized) {
            this.initialized = true;
            this.hardClayIsReplaced = replacedBlocks.replacesBlock(this.hardClay);
            this.orangeClayIsReplaced = replacedBlocks.replacesBlock(this.orangeClay);
            this.yellowClayIsReplaced = replacedBlocks.replacesBlock(this.yellowClay);
            this.brownClayIsReplaced = replacedBlocks.replacesBlock(this.brownClay);
            this.redClayIsReplaced = replacedBlocks.replacesBlock(this.redClay);
            this.whiteClayIsReplaced = replacedBlocks.replacesBlock(this.whiteClay);
            this.silverClayIsReplaced = replacedBlocks.replacesBlock(this.silverClay);
            this.redSandIsReplaced = replacedBlocks.replacesBlock(this.redSand);
        }
    }

    private LocalMaterialData getBand(LocalWorld world, BiomeConfig biomeConfig, int xInWorld, int yInWorld, int zInWorld) {
        LocalMaterialData material;
        int noise = this.lastNoise;
        if (this.lastX != xInWorld || this.lastZ != zInWorld) {
            noise = (int)Math.round(this.clayBandsOffsetNoise.getValue((double)xInWorld / 512.0, (double)zInWorld / 512.0) * 2.0);
            this.lastX = xInWorld;
            this.lastZ = zInWorld;
            this.lastNoise = noise;
        }
        if ((material = this.clayBands[(yInWorld + noise + 64) % 64]) == this.hardClay) {
            return !this.hardClayIsReplaced ? this.hardClay : this.hardClay.parseWithBiomeAndHeight(world, biomeConfig, yInWorld);
        }
        if (material == this.orangeClay) {
            return !this.orangeClayIsReplaced ? this.orangeClay : this.orangeClay.parseWithBiomeAndHeight(world, biomeConfig, yInWorld);
        }
        if (material == this.yellowClay) {
            return !this.yellowClayIsReplaced ? this.yellowClay : this.yellowClay.parseWithBiomeAndHeight(world, biomeConfig, yInWorld);
        }
        if (material == this.brownClay) {
            return !this.brownClayIsReplaced ? this.brownClay : this.brownClay.parseWithBiomeAndHeight(world, biomeConfig, yInWorld);
        }
        if (material == this.redClay) {
            return !this.redClayIsReplaced ? this.redClay : this.redClay.parseWithBiomeAndHeight(world, biomeConfig, yInWorld);
        }
        if (material == this.whiteClay) {
            return !this.whiteClayIsReplaced ? this.whiteClay : this.whiteClay.parseWithBiomeAndHeight(world, biomeConfig, yInWorld);
        }
        if (material == this.silverClay) {
            return !this.silverClayIsReplaced ? this.silverClay : this.silverClay.parseWithBiomeAndHeight(world, biomeConfig, yInWorld);
        }
        if (material == this.redSand) {
            return !this.redSandIsReplaced ? this.redSand : this.redSand.parseWithBiomeAndHeight(world, biomeConfig, yInWorld);
        }
        return null;
    }

    @Override
    public LocalMaterialData getSurfaceBlockAtHeight(LocalWorld world, BiomeConfig biomeConfig, int xInWorld, int yInWorld, int zInWorld) {
        return this.getBand(world, biomeConfig, xInWorld, yInWorld, zInWorld);
    }

    @Override
    public LocalMaterialData getGroundBlockAtHeight(LocalWorld world, BiomeConfig biomeConfig, int xInWorld, int yInWorld, int zInWorld) {
        return this.getBand(world, biomeConfig, xInWorld, yInWorld, zInWorld);
    }

    private void generateBands(long p_150619_1_) {
        this.clayBands = new LocalMaterialData[64];
        Arrays.fill(this.clayBands, this.hardClay);
        Random random = new Random(p_150619_1_);
        this.clayBandsOffsetNoise = new NoiseGeneratorPerlinMesaBlocks(random, 1);
        for (int l1 = 0; l1 < 64; ++l1) {
            if ((l1 += random.nextInt(5) + 1) >= 64) continue;
            this.clayBands[l1] = this.orangeClay;
        }
        int i2 = random.nextInt(4) + 2;
        for (int i = 0; i < i2; ++i) {
            int j = random.nextInt(3) + 1;
            int k = random.nextInt(64);
            for (int l = 0; k + l < 64 && l < j; ++l) {
                this.clayBands[k + l] = this.yellowClay;
            }
        }
        int j2 = random.nextInt(4) + 2;
        for (int k2 = 0; k2 < j2; ++k2) {
            int i3 = random.nextInt(3) + 2;
            int l3 = random.nextInt(64);
            for (int i1 = 0; l3 + i1 < 64 && i1 < i3; ++i1) {
                this.clayBands[l3 + i1] = this.brownClay;
            }
        }
        int l2 = random.nextInt(4) + 2;
        for (int j3 = 0; j3 < l2; ++j3) {
            int i4 = random.nextInt(3) + 1;
            int k4 = random.nextInt(64);
            for (int j1 = 0; k4 + j1 < 64 && j1 < i4; ++j1) {
                this.clayBands[k4 + j1] = this.redClay;
            }
        }
        int k3 = random.nextInt(3) + 3;
        int j4 = 0;
        for (int l4 = 0; l4 < k3; ++l4) {
            j4 += random.nextInt(16) + 4;
            for (int k1 = 0; j4 + k1 < 64 && k1 < 1; ++k1) {
                this.clayBands[j4 + k1] = this.whiteClay;
                if (j4 + k1 > 1 && random.nextBoolean()) {
                    this.clayBands[j4 + k1 - 1] = this.silverClay;
                }
                if (j4 + k1 >= 63 || !random.nextBoolean()) continue;
                this.clayBands[j4 + k1 + 1] = this.silverClay;
            }
        }
    }

    @Override
    public void spawn(LocalWorld world, GeneratingChunk generatingChunk, ChunkBuffer chunkBuffer, BiomeConfig biomeConfig, int xInWorld, int zInWorld) {
        int highestBlockInColumn;
        int maxHeight;
        long worldSeed = world.getSeed();
        if (this.clayBands == null || !this.clayBandsGenerated) {
            this.generateBands(worldSeed);
        }
        this.Init(biomeConfig.replacedBlocks);
        if (this.pillarNoise == null || this.pillarRoofNoise == null || !this.clayBandsGenerated) {
            Random random = new Random(this.worldSeed);
            this.pillarNoise = new NoiseGeneratorPerlinMesaBlocks(random, 4);
            this.pillarRoofNoise = new NoiseGeneratorPerlinMesaBlocks(random, 1);
        }
        this.clayBandsGenerated = true;
        int x = xInWorld & 0xF;
        int z = zInWorld & 0xF;
        double noise = generatingChunk.getNoise(x, z);
        this.worldSeed = worldSeed;
        double bryceHeight = 0.0;
        if (this.brycePillars) {
            int k = (xInWorld & 0xFFFFFFF0) + (zInWorld & 0xF);
            int l = (zInWorld & 0xFFFFFFF0) + (xInWorld & 0xF);
            double bryceNoiseValue = Math.min(Math.abs(noise), this.pillarNoise.getValue((double)k * 0.25, (double)l * 0.25));
            if (bryceNoiseValue > 0.0) {
                bryceHeight = bryceNoiseValue * bryceNoiseValue * 2.5;
                double d3 = 0.001953125;
                double d4 = Math.abs(this.pillarRoofNoise.getValue((double)k * d3, (double)l * d3));
                double d5 = Math.ceil(d4 * 50.0) + 14.0;
                if (bryceHeight > d5) {
                    bryceHeight = d5;
                }
                bryceHeight += 64.0;
            }
        }
        int waterLevel = generatingChunk.getWaterLevel(x, z);
        boolean useDefaultGroundBlock = true;
        LocalMaterialData currentGroundBlock = null;
        boolean groundIsStainedClay = true;
        int noisePlusRandomFactor = (int)(noise / 3.0 + 3.0 + generatingChunk.random.nextDouble() * 0.25);
        int k1 = -1;
        boolean belowSand = false;
        boolean useGroundBlockGround = false;
        boolean useGroundBlockStone = false;
        int i1 = 0;
        if (biomeConfig.worldConfig.ceilingBedrock) {
            chunkBuffer.setBlock(x, generatingChunk.heightCap - 2, z, biomeConfig.worldConfig.getBedrockBlockReplaced(world, biomeConfig, generatingChunk.heightCap - 2));
        }
        int n = maxHeight = (highestBlockInColumn = chunkBuffer.getHighestBlockForColumn(x, z)) < (int)bryceHeight ? (int)bryceHeight : highestBlockInColumn;
        if ((double)maxHeight < bryceHeight) {
            maxHeight = (int)bryceHeight;
        }
        int minHeight = 0;
        LocalMaterialData worldMaterial = null;
        for (int y = maxHeight; y >= minHeight; --y) {
            if (y < (int)bryceHeight || i1 < 15 || this.brycePillars) {
                worldMaterial = chunkBuffer.getBlock(x, y, z);
            }
            if (y < (int)bryceHeight && worldMaterial.isAir()) {
                chunkBuffer.setBlock(x, y, z, this.getBand(world, biomeConfig, x, y, z));
            }
            if (generatingChunk.mustCreateBedrockAt(biomeConfig.worldConfig, y)) {
                chunkBuffer.setBlock(x, y, z, biomeConfig.worldConfig.getBedrockBlockReplaced(world, biomeConfig, y));
                continue;
            }
            if (i1 >= 15 && !this.brycePillars) continue;
            if (worldMaterial.isEmptyOrAir()) {
                k1 = -1;
                continue;
            }
            if (worldMaterial.equals(biomeConfig.getWaterBlockReplaced(world, y))) continue;
            if (k1 == -1) {
                belowSand = false;
                if (noisePlusRandomFactor <= 0) {
                    useDefaultGroundBlock = false;
                    useGroundBlockGround = false;
                    useGroundBlockStone = true;
                } else if (y >= waterLevel - 4 && y <= waterLevel + 1) {
                    useDefaultGroundBlock = false;
                    useGroundBlockGround = true;
                    useGroundBlockStone = false;
                }
                k1 = noisePlusRandomFactor + Math.max(0, y - waterLevel);
                if (y >= waterLevel - 1) {
                    if (this.hasForest && y > 86 + noisePlusRandomFactor * 2) {
                        chunkBuffer.setBlock(x, y, z, biomeConfig.getSurfaceBlockReplaced(world, y));
                    } else if (y > waterLevel + 3 + noisePlusRandomFactor) {
                        worldMaterial = y >= 64 && y <= 127 ? this.getBand(world, biomeConfig, xInWorld, y, zInWorld) : (!this.orangeClayIsReplaced ? this.orangeClay : this.orangeClay.parseWithBiomeAndHeight(world, biomeConfig, y));
                        chunkBuffer.setBlock(x, y, z, worldMaterial);
                    } else {
                        chunkBuffer.setBlock(x, y, z, !this.redSandIsReplaced ? this.redSand : this.redSand.parseWithBiomeAndHeight(world, biomeConfig, y));
                        belowSand = true;
                    }
                } else {
                    if (useGroundBlockGround) {
                        ++i1;
                        continue;
                    }
                    if (useGroundBlockStone) {
                        currentGroundBlock = biomeConfig.getGroundBlockReplaced(world, y);
                    } else if (useDefaultGroundBlock) {
                        LocalMaterialData localMaterialData = currentGroundBlock = !this.whiteClayIsReplaced ? this.whiteClay : this.whiteClay.parseWithBiomeAndHeight(world, biomeConfig, y);
                    }
                    if (groundIsStainedClay) {
                        chunkBuffer.setBlock(x, y, z, !this.orangeClayIsReplaced ? this.orangeClay : this.orangeClay.parseWithBiomeAndHeight(world, biomeConfig, y));
                    } else {
                        chunkBuffer.setBlock(x, y, z, currentGroundBlock);
                    }
                }
            } else if (k1 > 0) {
                --k1;
                if (belowSand) {
                    chunkBuffer.setBlock(x, y, z, !this.orangeClayIsReplaced ? this.orangeClay : this.orangeClay.parseWithBiomeAndHeight(world, biomeConfig, y));
                } else {
                    worldMaterial = this.getBand(world, biomeConfig, xInWorld, y, zInWorld);
                    chunkBuffer.setBlock(x, y, z, worldMaterial);
                }
            }
            ++i1;
        }
    }

    @Override
    public String toString() {
        if (this.hasForest) {
            return NAME_FOREST;
        }
        if (this.brycePillars) {
            return NAME_BRYCE;
        }
        return NAME_NORMAL;
    }
}

