/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.surface;

import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.biome.settings.ReplacedBlocksMatrix;

public class LayerChoice
implements Comparable<LayerChoice> {
    protected final LocalMaterialData surfaceBlock;
    protected final LocalMaterialData groundBlock;
    final float maxNoise;
    private boolean initialized = false;
    private boolean surfaceBlockIsReplaced;
    private boolean groundBlockIsReplaced;

    LayerChoice(LocalMaterialData surfaceBlock, LocalMaterialData groundBlock, float maxNoise) {
        this.surfaceBlock = surfaceBlock;
        this.groundBlock = groundBlock;
        this.maxNoise = maxNoise;
    }

    public LocalMaterialData getSurfaceBlockReplaced(LocalWorld world, BiomeConfig biomeConfig, int y) {
        this.Init(biomeConfig.replacedBlocks);
        if (this.surfaceBlockIsReplaced) {
            return this.surfaceBlock.parseWithBiomeAndHeight(world, biomeConfig, y);
        }
        return this.surfaceBlock;
    }

    public LocalMaterialData getGroundBlockReplaced(LocalWorld world, BiomeConfig biomeConfig, int y) {
        this.Init(biomeConfig.replacedBlocks);
        if (this.groundBlockIsReplaced) {
            return this.groundBlock.parseWithBiomeAndHeight(world, biomeConfig, y);
        }
        return this.groundBlock;
    }

    public void Init(ReplacedBlocksMatrix replacedBlocks) {
        if (!this.initialized) {
            this.initialized = true;
            this.surfaceBlockIsReplaced = replacedBlocks.replacesBlock(this.surfaceBlock);
            this.groundBlockIsReplaced = replacedBlocks.replacesBlock(this.groundBlock);
        }
    }

    @Override
    public int compareTo(LayerChoice that) {
        float delta = this.maxNoise - that.maxNoise;
        return (int)(delta * 65565.0f);
    }
}

