/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.biome.layers;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.biome.BiomeGroup;
import com.pg85.otg.configuration.biome.BiomeGroupManager;
import com.pg85.otg.configuration.standard.WorldStandardValues;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.generator.biome.layers.Layer;
import com.pg85.otg.generator.biome.layers.LayerBiome;
import com.pg85.otg.generator.biome.layers.LayerBiomeBeforeGroups;
import com.pg85.otg.generator.biome.layers.LayerBiomeBorder;
import com.pg85.otg.generator.biome.layers.LayerBiomeGroups;
import com.pg85.otg.generator.biome.layers.LayerBiomeInBiome;
import com.pg85.otg.generator.biome.layers.LayerEmpty;
import com.pg85.otg.generator.biome.layers.LayerFromImage;
import com.pg85.otg.generator.biome.layers.LayerIce;
import com.pg85.otg.generator.biome.layers.LayerLand;
import com.pg85.otg.generator.biome.layers.LayerLandRandom;
import com.pg85.otg.generator.biome.layers.LayerMix;
import com.pg85.otg.generator.biome.layers.LayerMixWithRiver;
import com.pg85.otg.generator.biome.layers.LayerRiver;
import com.pg85.otg.generator.biome.layers.LayerRiverInit;
import com.pg85.otg.generator.biome.layers.LayerSmooth;
import com.pg85.otg.generator.biome.layers.LayerZoom;
import com.pg85.otg.generator.biome.layers.LayerZoomFuzzy;
import com.pg85.otg.generator.biome.layers.LayerZoomVoronoi;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.network.ConfigProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class LayerFactory {
    private LayerFactory() {
    }

    private static int getDefaultOceanBiomeId(LocalWorld world) {
        LocalBiome defaultOceanBiome = world.getBiomeByNameOrNull(world.getConfigs().getWorldConfig().defaultOceanBiome);
        if (defaultOceanBiome == null) {
            defaultOceanBiome = world.getFirstBiomeOrNull();
            if (defaultOceanBiome == null) {
                throw new RuntimeException("Could not find DefaultOceanBiome \"" + world.getConfigs().getWorldConfig().defaultOceanBiome + "\", aborting.");
            }
            OTG.log(LogMarker.WARN, "Could not find DefaultOceanBiome \"" + world.getConfigs().getWorldConfig().defaultOceanBiome + "\", substituting \"" + defaultOceanBiome.getName() + "\".", new Object[0]);
        }
        return defaultOceanBiome.getIds().getOTGBiomeId();
    }

    public static Layer[] createNormal(LocalWorld world) {
        Layer mainLayer = LayerFactory.initMainLayer(world);
        LayerZoomVoronoi zoomedLayer = new LayerZoomVoronoi(10L, LayerFactory.getDefaultOceanBiomeId(world), mainLayer);
        zoomedLayer.initWorldGenSeed(world.getSeed());
        return new Layer[]{mainLayer, zoomedLayer};
    }

    public static Layer[] createFromImage(LocalWorld world) {
        WorldConfig worldConfig = world.getConfigs().getWorldConfig();
        Layer mainLayer = LayerFactory.initMainLayer(world);
        mainLayer = worldConfig.imageMode == WorldConfig.ImageMode.ContinueNormal ? new LayerFromImage(1L, LayerFactory.getDefaultOceanBiomeId(world), mainLayer, worldConfig, world) : new LayerFromImage(1L, LayerFactory.getDefaultOceanBiomeId(world), null, worldConfig, world);
        LayerZoomVoronoi zoomedLayer = new LayerZoomVoronoi(10L, LayerFactory.getDefaultOceanBiomeId(world), mainLayer);
        zoomedLayer.initWorldGenSeed(world.getSeed());
        return new Layer[]{mainLayer, zoomedLayer};
    }

    public static Layer[] createBeforeGroups(LocalWorld world) {
        BiomeConfig biomeConfig;
        List<LocalBiome> biomes;
        LocalBiome defaultFrozenOceanBiome;
        ConfigProvider configs = world.getConfigs();
        WorldConfig worldConfig = configs.getWorldConfig();
        LocalBiome defaultOceanBiome = world.getBiomeByNameOrNull(worldConfig.defaultOceanBiome);
        if (defaultOceanBiome == null) {
            defaultOceanBiome = world.getFirstBiomeOrNull();
            if (defaultOceanBiome == null) {
                throw new RuntimeException("Could not find DefaultOceanBiome \"" + worldConfig.defaultOceanBiome + "\", aborting.");
            }
            OTG.log(LogMarker.WARN, "Could not find DefaultOceanBiome \"" + worldConfig.defaultOceanBiome + "\", substituting \"" + defaultOceanBiome.getName() + "\".", new Object[0]);
        }
        if ((defaultFrozenOceanBiome = world.getBiomeByNameOrNull(worldConfig.defaultFrozenOceanBiome)) == null) {
            defaultFrozenOceanBiome = world.getFirstBiomeOrNull();
            if (defaultFrozenOceanBiome == null) {
                throw new RuntimeException("Could not find DefaultFrozenOceanBiome \"" + worldConfig.defaultFrozenOceanBiome + "\", aborting.");
            }
            OTG.log(LogMarker.WARN, "Could not find DefaultFrozenOceanBiome \"" + worldConfig.defaultFrozenOceanBiome + "\", substituting \"" + defaultOceanBiome.getName() + "\".", new Object[0]);
        }
        int defaultOceanId = defaultOceanBiome.getIds().getOTGBiomeId();
        int defaultFrozenOceanId = defaultFrozenOceanBiome.getIds().getOTGBiomeId();
        BiomeGroupManager worldGroupManager = worldConfig.biomeGroupManager;
        BiomeGroup normalGroup = worldGroupManager.getGroupByName(WorldStandardValues.NORMAL_BIOMES.getName());
        BiomeGroup iceGroup = worldGroupManager.getGroupByName(WorldStandardValues.ICE_BIOMES.getName());
        if (normalGroup == null) {
            normalGroup = new BiomeGroup(worldConfig, "", 0, 0, Collections.emptyList());
            normalGroup.processBiomeData(world);
        }
        if (iceGroup == null) {
            iceGroup = new BiomeGroup(worldConfig, "", 0, 0, Collections.emptyList());
            iceGroup.processBiomeData(world);
        }
        LocalBiome[][] normalBiomeMap = new LocalBiome[worldConfig.generationDepth + 1][];
        LocalBiome[][] iceBiomeMap = new LocalBiome[worldConfig.generationDepth + 1][];
        for (int i = 0; i < worldConfig.generationDepth + 1; ++i) {
            ArrayList<LocalBiome> normalBiomes = new ArrayList<LocalBiome>();
            ArrayList<LocalBiome> iceBiomes = new ArrayList<LocalBiome>();
            biomes = configs.getBiomeArrayLegacy();
            for (LocalBiome biome : biomes) {
                int t;
                if (biome == null) continue;
                biomeConfig = biome.getBiomeConfig();
                if (biomeConfig.biomeSize != i) continue;
                if (normalGroup.containsBiome(biomeConfig.getName())) {
                    for (t = 0; t < biomeConfig.biomeRarity; ++t) {
                        normalBiomes.add(biome);
                    }
                    normalGroup.totalGroupRarity -= biomeConfig.biomeRarity;
                }
                if (!iceGroup.containsBiome(biomeConfig.getName())) continue;
                for (t = 0; t < biomeConfig.biomeRarity; ++t) {
                    iceBiomes.add(biome);
                }
                iceGroup.totalGroupRarity -= biomeConfig.biomeRarity;
            }
            normalBiomeMap[i] = !normalBiomes.isEmpty() ? normalBiomes.toArray(new LocalBiome[normalBiomes.size() + normalGroup.totalGroupRarity]) : new LocalBiome[0];
            iceBiomeMap[i] = !iceBiomes.isEmpty() ? iceBiomes.toArray(new LocalBiome[iceBiomes.size() + iceGroup.totalGroupRarity]) : new LocalBiome[0];
        }
        Layer mainLayer = new LayerEmpty(1L, defaultOceanId);
        Layer RiverLayer = new LayerEmpty(1L, defaultOceanId);
        boolean riversStarted = false;
        for (int depth = 0; depth <= worldConfig.generationDepth; ++depth) {
            mainLayer = new LayerZoom(2001 + depth, defaultOceanId, mainLayer);
            if (worldConfig.randomRivers && riversStarted) {
                RiverLayer = new LayerZoom(2001 + depth, defaultOceanId, RiverLayer);
            }
            if (worldConfig.landSize == depth) {
                mainLayer = new LayerLand(1L, defaultOceanId, mainLayer, worldConfig.landRarity);
                mainLayer = new LayerZoomFuzzy(2000L, defaultOceanId, mainLayer);
            }
            if (depth < worldConfig.landSize + worldConfig.landFuzzy) {
                mainLayer = new LayerLandRandom(depth, defaultOceanId, mainLayer);
            }
            if (normalBiomeMap[depth].length != 0 || iceBiomeMap[depth].length != 0) {
                mainLayer = new LayerBiomeBeforeGroups(200L, defaultOceanId, mainLayer, normalBiomeMap[depth], iceBiomeMap[depth]);
            }
            if (iceGroup.getGenerationDepth() == depth) {
                mainLayer = new LayerIce(depth, defaultOceanId, mainLayer, iceGroup.getGroupRarity());
            }
            if (worldConfig.riverRarity == depth) {
                if (worldConfig.randomRivers) {
                    RiverLayer = new LayerRiverInit(155L, defaultOceanId, RiverLayer);
                    riversStarted = true;
                } else {
                    mainLayer = new LayerRiverInit(155L, defaultOceanId, mainLayer);
                }
            }
            if (worldConfig.generationDepth - worldConfig.riverSize == depth) {
                if (worldConfig.randomRivers) {
                    RiverLayer = new LayerRiver(5 + depth, defaultOceanId, RiverLayer);
                } else {
                    mainLayer = new LayerRiver(5 + depth, defaultOceanId, mainLayer);
                }
            }
            LayerBiomeBorder layerBiomeBorder = new LayerBiomeBorder(3000 + depth, world, defaultOceanId);
            LayerBiomeInBiome layerBiomeIsle = new LayerBiomeInBiome(mainLayer, world.getSeed(), defaultOceanId);
            boolean haveBorder = false;
            boolean haveIsle = false;
            biomes = configs.getBiomeArrayLegacy();
            for (LocalBiome biome : biomes) {
                if (biome == null) continue;
                biomeConfig = biome.getBiomeConfig();
                if (biomeConfig.biomeSize == depth && worldConfig.isleBiomes.contains(biomeConfig.getName()) && biomeConfig.isleInBiome != null) {
                    haveIsle = true;
                    boolean[] biomeCanSpawnIn = new boolean[1024];
                    boolean inOcean = false;
                    for (String islandInName : biomeConfig.isleInBiome) {
                        LocalBiome islandInBiome = world.getBiomeByNameOrNull(islandInName);
                        if (islandInBiome.getName().equals(worldConfig.defaultOceanBiome)) {
                            inOcean = true;
                            continue;
                        }
                        biomeCanSpawnIn[islandInBiome.getIds().getOTGBiomeId()] = true;
                    }
                    int chance = worldConfig.biomeRarityScale + 1 - biomeConfig.biomeRarity;
                    layerBiomeIsle.addIsle(biome, chance, biomeCanSpawnIn, inOcean);
                }
                if (biomeConfig.biomeSize != depth || !worldConfig.borderBiomes.contains(biomeConfig.getName()) || biomeConfig.biomeIsBorder == null) continue;
                haveBorder = true;
                for (String replaceFromName : biomeConfig.biomeIsBorder) {
                    int replaceFrom = 0;
                    LocalBiome replaceFromBiome = world.getBiomeByNameOrNull(replaceFromName);
                    replaceFrom = replaceFromBiome.getIds().getOTGBiomeId();
                    layerBiomeBorder.addBiome(biome, replaceFrom, world);
                }
            }
            if (haveIsle) {
                layerBiomeIsle.child = mainLayer;
                mainLayer = layerBiomeIsle;
            }
            if (!haveBorder) continue;
            layerBiomeBorder.child = mainLayer;
            mainLayer = layerBiomeBorder;
        }
        mainLayer = worldConfig.randomRivers ? new LayerMixWithRiver(1L, mainLayer, RiverLayer, configs, world, defaultOceanId, defaultFrozenOceanId) : new LayerMix(1L, mainLayer, configs, world, defaultOceanId, defaultFrozenOceanId);
        mainLayer = new LayerSmooth(400L, defaultOceanId, mainLayer);
        if (worldConfig.biomeMode == OTG.getBiomeModeManager().FROM_IMAGE) {
            mainLayer = worldConfig.imageMode == WorldConfig.ImageMode.ContinueNormal ? new LayerFromImage(1L, defaultOceanId, mainLayer, worldConfig, world) : new LayerFromImage(1L, defaultOceanId, null, worldConfig, world);
        }
        LayerZoomVoronoi zoomedLayer = new LayerZoomVoronoi(10L, defaultOceanId, mainLayer);
        zoomedLayer.initWorldGenSeed(world.getSeed());
        return new Layer[]{mainLayer, zoomedLayer};
    }

    private static Layer initMainLayer(LocalWorld world) {
        LocalBiome defaultFrozenOceanBiome;
        ConfigProvider configs = world.getConfigs();
        WorldConfig worldConfig = configs.getWorldConfig();
        LocalBiome defaultOceanBiome = world.getBiomeByNameOrNull(worldConfig.defaultOceanBiome);
        if (defaultOceanBiome == null) {
            defaultOceanBiome = world.getFirstBiomeOrNull();
            if (defaultOceanBiome == null) {
                OTG.log(LogMarker.FATAL, "Could not find DefaultOceanBiome \"" + worldConfig.defaultOceanBiome + "\", aborting.", new Object[0]);
                throw new RuntimeException("Could not find DefaultOceanBiome \"" + worldConfig.defaultOceanBiome + "\", aborting.");
            }
            OTG.log(LogMarker.WARN, "Could not find DefaultOceanBiome \"" + worldConfig.defaultOceanBiome + "\", substituting \"" + defaultOceanBiome.getName() + "\".", new Object[0]);
        }
        if ((defaultFrozenOceanBiome = world.getBiomeByNameOrNull(worldConfig.defaultFrozenOceanBiome)) == null) {
            defaultFrozenOceanBiome = world.getFirstBiomeOrNull();
            if (defaultFrozenOceanBiome == null) {
                OTG.log(LogMarker.FATAL, "Could not find DefaultFrozenOceanBiome \"" + worldConfig.defaultFrozenOceanBiome + "\", aborting.", new Object[0]);
                throw new RuntimeException("Could not find DefaultFrozenOceanBiome \"" + worldConfig.defaultFrozenOceanBiome + "\", aborting.");
            }
            OTG.log(LogMarker.WARN, "Could not find DefaultFrozenOceanBiome \"" + worldConfig.defaultFrozenOceanBiome + "\", substituting \"" + defaultOceanBiome.getName() + "\".", new Object[0]);
        }
        int defaultOceanId = defaultOceanBiome.getIds().getOTGBiomeId();
        int defaultFrozenOceanId = defaultFrozenOceanBiome.getIds().getOTGBiomeId();
        BiomeGroupManager groupManager = worldConfig.biomeGroupManager;
        Layer mainLayer = new LayerEmpty(1L, defaultOceanId);
        Layer RiverLayer = new LayerEmpty(1L, defaultOceanId);
        boolean riversStarted = false;
        List<LocalBiome> biomes = configs.getBiomeArrayLegacy();
        for (int depth = 0; depth <= worldConfig.generationDepth; ++depth) {
            mainLayer = new LayerZoom(2001 + depth, defaultOceanId, mainLayer);
            if (worldConfig.randomRivers && riversStarted) {
                RiverLayer = new LayerZoom(2001 + depth, defaultOceanId, RiverLayer);
            }
            if (worldConfig.landSize == depth) {
                mainLayer = new LayerLand(1L, defaultOceanId, mainLayer, worldConfig.landRarity);
                mainLayer = new LayerZoomFuzzy(2000L, defaultOceanId, mainLayer);
            }
            if (depth < worldConfig.landSize + worldConfig.landFuzzy) {
                mainLayer = new LayerLandRandom(depth, defaultOceanId, mainLayer);
            }
            if (!groupManager.isGroupDepthMapEmpty(depth)) {
                mainLayer = new LayerBiomeGroups(mainLayer, groupManager, depth, worldConfig.freezeAllColdGroupBiomes);
            }
            if (!groupManager.isBiomeDepthMapEmpty(depth)) {
                mainLayer = new LayerBiome(200L, defaultOceanId, mainLayer, groupManager, depth, worldConfig.frozenOceanTemperature);
            }
            if (depth == 3) {
                mainLayer = new LayerIce(depth, defaultOceanId, mainLayer);
            }
            if (worldConfig.riverRarity == depth) {
                if (worldConfig.randomRivers) {
                    RiverLayer = new LayerRiverInit(155L, defaultOceanId, RiverLayer);
                    riversStarted = true;
                } else {
                    mainLayer = new LayerRiverInit(155L, defaultOceanId, mainLayer);
                }
            }
            if (worldConfig.generationDepth - worldConfig.riverSize == depth) {
                if (worldConfig.randomRivers) {
                    RiverLayer = new LayerRiver(5 + depth, defaultOceanId, RiverLayer);
                } else {
                    mainLayer = new LayerRiver(5 + depth, defaultOceanId, mainLayer);
                }
            }
            LayerBiomeBorder layerBiomeBorder = new LayerBiomeBorder(3000 + depth, world, defaultOceanId);
            LayerBiomeInBiome layerBiomeIsle = new LayerBiomeInBiome(mainLayer, world.getSeed(), defaultOceanId);
            boolean haveBorder = false;
            boolean haveIsle = false;
            biomes = configs.getBiomeArrayLegacy();
            for (LocalBiome biome : biomes) {
                if (biome == null) continue;
                BiomeConfig biomeConfig = biome.getBiomeConfig();
                if (biomeConfig.biomeSizeWhenIsle == depth && worldConfig.isleBiomes.contains(biomeConfig.getName()) && biomeConfig.isleInBiome != null) {
                    haveIsle = true;
                    boolean[] biomeCanSpawnIn = new boolean[1024];
                    boolean inOcean = false;
                    for (String islandInName : biomeConfig.isleInBiome) {
                        LocalBiome islandInBiome = world.getBiomeByNameOrNull(islandInName);
                        if (islandInBiome.getName().equals(worldConfig.defaultOceanBiome)) {
                            inOcean = true;
                            continue;
                        }
                        biomeCanSpawnIn[islandInBiome.getIds().getOTGBiomeId()] = true;
                    }
                    int chance = worldConfig.biomeRarityScale + 1 - biomeConfig.biomeRarityWhenIsle;
                    layerBiomeIsle.addIsle(biome, chance, biomeCanSpawnIn, inOcean);
                }
                if (biomeConfig.biomeSizeWhenBorder != depth || !worldConfig.borderBiomes.contains(biomeConfig.getName()) || biomeConfig.biomeIsBorder == null) continue;
                haveBorder = true;
                for (String replaceFromName : biomeConfig.biomeIsBorder) {
                    int replaceFrom = 0;
                    LocalBiome replaceFromBiome = world.getBiomeByNameOrNull(replaceFromName);
                    if (replaceFromBiome == null) {
                        replaceFromBiome = world.getBiomeByNameOrNull(replaceFromName);
                    }
                    if (replaceFromBiome == null) {
                        OTG.log(LogMarker.WARN, "Could not find BorderBiome \"" + replaceFromName + "\" for biome \"" + biomeConfig.getName() + "\", ignoring.", new Object[0]);
                        continue;
                    }
                    replaceFrom = replaceFromBiome.getIds().getOTGBiomeId();
                    layerBiomeBorder.addBiome(biome, replaceFrom, world);
                }
            }
            if (haveIsle) {
                layerBiomeIsle.child = mainLayer;
                mainLayer = layerBiomeIsle;
            }
            if (!haveBorder) continue;
            layerBiomeBorder.child = mainLayer;
            mainLayer = layerBiomeBorder;
        }
        mainLayer = worldConfig.randomRivers ? new LayerMixWithRiver(1L, mainLayer, RiverLayer, configs, world, defaultOceanId, defaultFrozenOceanId) : new LayerMix(1L, mainLayer, configs, world, defaultOceanId, defaultFrozenOceanId);
        mainLayer = new LayerSmooth(400L, defaultOceanId, mainLayer);
        return mainLayer;
    }
}

