/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.biome.layers;

import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.generator.biome.ArraysCache;
import com.pg85.otg.generator.biome.layers.Layer;

public class LayerBiomeBorder
extends Layer {
    private boolean[][] bordersFrom;
    private int[] bordersTo;

    LayerBiomeBorder(long seed, LocalWorld world, int defaultOceanId) {
        super(seed, defaultOceanId);
        this.bordersFrom = new boolean[world.getMaxBiomesCount()][];
        this.bordersTo = new int[world.getMaxBiomesCount()];
    }

    void addBiome(LocalBiome replaceTo, int replaceFrom, LocalWorld world) {
        this.bordersFrom[replaceFrom] = new boolean[world.getMaxBiomesCount()];
        for (int i = 0; i < this.bordersFrom[replaceFrom].length; ++i) {
            LocalBiome biome = world.getBiomeByOTGIdOrNull(i);
            this.bordersFrom[replaceFrom][i] = biome == null || !replaceTo.getBiomeConfig().notBorderNear.contains(biome.getName());
        }
        this.bordersTo[replaceFrom] = replaceTo.getIds().getOTGBiomeId();
    }

    @Override
    public int[] getInts(LocalWorld world, ArraysCache cache, int x, int z, int xSize, int zSize) {
        int[] childInts = this.child.getInts(world, cache, x - 1, z - 1, xSize + 2, zSize + 2);
        int[] thisInts = cache.getArray(xSize * zSize);
        boolean improvedBiomeBorders = world.getConfigs().getWorldConfig().improvedBiomeBorders;
        for (int zi = 0; zi < zSize; ++zi) {
            for (int xi = 0; xi < xSize; ++xi) {
                this.initChunkSeed(xi + x, zi + z);
                int selection = childInts[xi + 1 + (zi + 1) * (xSize + 2)];
                int biomeId = this.getBiomeFromLayer(selection);
                if (this.bordersFrom[biomeId] != null) {
                    int northCheck = this.getBiomeFromLayer(childInts[xi + 1 + zi * (xSize + 2)]);
                    int southCheck = this.getBiomeFromLayer(childInts[xi + 1 + (zi + 2) * (xSize + 2)]);
                    int eastCheck = this.getBiomeFromLayer(childInts[xi + 2 + (zi + 1) * (xSize + 2)]);
                    int westCheck = this.getBiomeFromLayer(childInts[xi + (zi + 1) * (xSize + 2)]);
                    boolean[] biomeFrom = this.bordersFrom[biomeId];
                    if (biomeFrom[northCheck] && biomeFrom[eastCheck] && biomeFrom[westCheck] && biomeFrom[southCheck]) {
                        if (northCheck != biomeId || eastCheck != biomeId || westCheck != biomeId || southCheck != biomeId) {
                            selection = selection & 0x301800 | 0x400 | this.bordersTo[biomeId] | 0x400000;
                        } else if (improvedBiomeBorders) {
                            int nwCheck = this.getBiomeFromLayer(childInts[xi + 0 + zi * (xSize + 2)]);
                            int neCheck = this.getBiomeFromLayer(childInts[xi + 2 + zi * (xSize + 2)]);
                            int swCheck = this.getBiomeFromLayer(childInts[xi + 0 + (zi + 2) * (xSize + 2)]);
                            int seCheck = this.getBiomeFromLayer(childInts[xi + 2 + (zi + 2) * (xSize + 2)]);
                            if (biomeFrom[nwCheck] && biomeFrom[neCheck] && biomeFrom[swCheck] && biomeFrom[seCheck] && (nwCheck != biomeId || neCheck != biomeId || swCheck != biomeId || seCheck != biomeId)) {
                                selection = selection & 0x301800 | 0x400 | this.bordersTo[biomeId] | 0x400000;
                            }
                        }
                    }
                }
                thisInts[xi + zi * xSize] = selection;
            }
        }
        return thisInts;
    }
}

