/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.ConfigFunction;
import com.pg85.otg.configuration.ErroredFunction;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.bo3.BO3;
import com.pg85.otg.customobjects.bo3.BO3Settings;
import com.pg85.otg.generator.resource.AboveWaterGen;
import com.pg85.otg.generator.resource.BoulderGen;
import com.pg85.otg.generator.resource.CactusGen;
import com.pg85.otg.generator.resource.CustomObjectGen;
import com.pg85.otg.generator.resource.CustomStructureGen;
import com.pg85.otg.generator.resource.DungeonGen;
import com.pg85.otg.generator.resource.FossilGen;
import com.pg85.otg.generator.resource.GrassGen;
import com.pg85.otg.generator.resource.IceSpikeGen;
import com.pg85.otg.generator.resource.LiquidGen;
import com.pg85.otg.generator.resource.OreGen;
import com.pg85.otg.generator.resource.PlantGen;
import com.pg85.otg.generator.resource.ReedGen;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.generator.resource.SmallLakeGen;
import com.pg85.otg.generator.resource.SurfacePatchGen;
import com.pg85.otg.generator.resource.TreeGen;
import com.pg85.otg.generator.resource.UnderWaterOreGen;
import com.pg85.otg.generator.resource.UnderWaterPlantGen;
import com.pg85.otg.generator.resource.UndergroundLakeGen;
import com.pg85.otg.generator.resource.VeinGen;
import com.pg85.otg.generator.resource.VinesGen;
import com.pg85.otg.generator.resource.WellGen;
import com.pg85.otg.generator.surface.FrozenSurfaceHelper;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.network.ConfigProvider;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.Rotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class ObjectSpawner {
    public Object lockingObject = new Object();
    public boolean populating;
    public boolean processing = false;
    public boolean saving;
    public boolean saveRequired;
    private final LocalWorld world;
    private final Random rand;
    private final WorldConfig worldConfig;

    public ObjectSpawner(ConfigProvider configProvider, LocalWorld localWorld) {
        this.worldConfig = configProvider.getWorldConfig();
        this.rand = new Random();
        this.world = localWorld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populate(ChunkCoordinate chunkCoord) {
        Object object;
        boolean unlockWhenDone = false;
        boolean firstLog = false;
        while (true) {
            object = this.lockingObject;
            synchronized (object) {
                if (!this.saving) {
                    if (!this.populating) {
                        this.populating = true;
                        unlockWhenDone = true;
                    }
                    break;
                }
                if (firstLog) {
                    OTG.log(LogMarker.WARN, "Populate waiting on SaveToDisk. Although other mods could be causing this and there may not be any problem, this can potentially cause an endless loop!", new Object[0]);
                    firstLog = false;
                }
            }
        }
        object = this.lockingObject;
        synchronized (object) {
            this.saveRequired = true;
        }
        if (!this.processing) {
            this.processing = true;
            this.world.cacheBiomesForPopulation(chunkCoord);
            this.doPopulate(chunkCoord);
            this.processing = false;
        } else {
            this.world.invalidatePopulationBiomeCache();
            this.doPopulate(chunkCoord);
            OTG.log(LogMarker.INFO, "Cascading chunk generation detected.", new Object[0]);
            if (OTG.getPluginConfig().developerMode) {
                OTG.log(LogMarker.INFO, Arrays.toString(Thread.currentThread().getStackTrace()), new Object[0]);
            }
        }
        object = this.lockingObject;
        synchronized (object) {
            if (unlockWhenDone) {
                this.populating = false;
            }
        }
        if (chunkCoord.equals(this.world.getSpawnChunk())) {
            this.world.updateSpawnPointY();
        }
    }

    private void doPopulate(ChunkCoordinate chunkCoord) {
        int z;
        int x = chunkCoord.getChunkX() * 16;
        LocalBiome biome = this.world.getBiomeForPopulation(x + 8, (z = chunkCoord.getChunkZ() * 16) + 8, chunkCoord);
        if (biome == null) {
            OTG.log(LogMarker.WARN, "Unknown biome at {},{}  (chunk {}). Could not populate chunk.", x + 8, z + 8, chunkCoord);
            return;
        }
        BiomeConfig biomeConfig = biome.getBiomeConfig();
        if (this.world.isBo4Enabled()) {
            this.world.getStructureCache().plotBo4Structures(this.rand, ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + 1, chunkCoord.getChunkZ()));
            this.world.getStructureCache().plotBo4Structures(this.rand, ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX(), chunkCoord.getChunkZ() + 1));
            this.world.getStructureCache().plotBo4Structures(this.rand, ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + 1, chunkCoord.getChunkZ() + 1));
            this.world.getStructureCache().plotBo4Structures(this.rand, chunkCoord);
            ChunkCoordinate spawnChunk = this.world.getSpawnChunk();
            boolean hasVillage = false;
            if (spawnChunk.equals(chunkCoord) && this.world.getConfigs().getWorldConfig().bo3AtSpawn != null && this.world.getConfigs().getWorldConfig().bo3AtSpawn.trim().length() > 0) {
                CustomObject customObject = OTG.getCustomObjectManager().getGlobalObjects().getObjectByName(this.world.getConfigs().getWorldConfig().bo3AtSpawn, this.world.getConfigs().getWorldConfig().getName());
                if (customObject != null && customObject instanceof BO3) {
                    int y = 1;
                    if (((BO3)customObject).getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.highestBlock) {
                        y = this.world.getHighestBlockAboveYAt(spawnChunk.getBlockXCenter(), spawnChunk.getBlockZCenter(), chunkCoord) - 1;
                    } else if (((BO3)customObject).getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.highestSolidBlock) {
                        y = this.world.getBlockAboveSolidHeight(spawnChunk.getBlockXCenter(), spawnChunk.getBlockZCenter(), chunkCoord) - 1;
                    } else if (((BO3)customObject).getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.randomY) {
                        y = this.worldConfig.spawnPointSet ? this.worldConfig.spawnPointY : (int)((double)((BO3)customObject).getSettings().minHeight + Math.random() * (double)(((BO3)customObject).getSettings().maxHeight - ((BO3)customObject).getSettings().minHeight));
                    }
                    ((BO3)customObject).spawnForced(this.world, this.rand, Rotation.NORTH, spawnChunk.getBlockX() + 15, y += ((BO3)customObject).getSettings().spawnHeightOffset, spawnChunk.getBlockZ() + 15);
                }
            } else {
                hasVillage = this.world.placeDefaultStructures(this.rand, chunkCoord);
            }
            long resourcesSeed = this.worldConfig.resourcesSeed != 0L ? this.worldConfig.resourcesSeed : this.world.getSeed();
            this.rand.setSeed(resourcesSeed);
            long l1 = this.rand.nextLong() / 2L * 2L + 1L;
            long l2 = this.rand.nextLong() / 2L * 2L + 1L;
            this.rand.setSeed((long)chunkCoord.getChunkX() * l1 + (long)chunkCoord.getChunkZ() * l2 ^ resourcesSeed);
            OTG.firePopulationStartEvent(this.world, this.rand, hasVillage, chunkCoord);
            this.processResourcesBeforeBo4s(chunkCoord, biome, biomeConfig);
            this.spawnBO4s(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX(), chunkCoord.getChunkZ()), chunkCoord);
            this.processResourcesAfterBo4s(chunkCoord, hasVillage, biome, biomeConfig);
            OTG.firePopulationEndEvent(this.world, this.rand, hasVillage, chunkCoord);
        } else {
            long resourcesSeed = this.worldConfig.resourcesSeed != 0L ? this.worldConfig.resourcesSeed : this.world.getSeed();
            this.rand.setSeed(resourcesSeed);
            long l1 = this.rand.nextLong() / 2L * 2L + 1L;
            long l2 = this.rand.nextLong() / 2L * 2L + 1L;
            this.rand.setSeed((long)chunkCoord.getChunkX() * l1 + (long)chunkCoord.getChunkZ() * l2 ^ resourcesSeed);
            ChunkCoordinate spawnChunk = this.world.getSpawnChunk();
            boolean hasVillage = false;
            if (spawnChunk.equals(chunkCoord) && this.world.getConfigs().getWorldConfig().bo3AtSpawn != null && this.world.getConfigs().getWorldConfig().bo3AtSpawn.trim().length() > 0) {
                CustomObject customObject = OTG.getCustomObjectManager().getGlobalObjects().getObjectByName(this.world.getConfigs().getWorldConfig().bo3AtSpawn, this.world.getConfigs().getWorldConfig().getName());
                if (customObject != null && customObject instanceof BO3) {
                    int y = 1;
                    if (((BO3)customObject).getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.highestBlock) {
                        y = this.world.getHighestBlockAboveYAt(spawnChunk.getBlockXCenter(), spawnChunk.getBlockZCenter(), chunkCoord) - 1;
                    } else if (((BO3)customObject).getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.highestSolidBlock) {
                        y = this.world.getBlockAboveSolidHeight(spawnChunk.getBlockXCenter(), spawnChunk.getBlockZCenter(), chunkCoord) - 1;
                    } else if (((BO3)customObject).getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.randomY) {
                        y = this.worldConfig.spawnPointSet ? this.worldConfig.spawnPointY : (int)((double)((BO3)customObject).getSettings().minHeight + Math.random() * (double)(((BO3)customObject).getSettings().maxHeight - ((BO3)customObject).getSettings().minHeight));
                    }
                    boolean ret = ((BO3)customObject).spawnForced(this.world, this.rand, Rotation.NORTH, spawnChunk.getBlockX() + 15, y += ((BO3)customObject).getSettings().spawnHeightOffset, spawnChunk.getBlockZ() + 15);
                    if (!ret && OTG.getPluginConfig().spawnLog) {
                        OTG.log(LogMarker.WARN, "Failed to spawn bo3AtSpawn object", new Object[0]);
                    }
                }
            } else {
                hasVillage = this.world.placeDefaultStructures(this.rand, chunkCoord);
            }
            OTG.firePopulationStartEvent(this.world, this.rand, hasVillage, chunkCoord);
            for (ConfigFunction<BiomeConfig> res : biomeConfig.resourceSequence) {
                if (!(res instanceof Resource)) continue;
                ((Resource)res).process(this.world, this.rand, hasVillage, chunkCoord);
            }
            this.world.placePopulationMobs(biome, this.rand, chunkCoord);
            new FrozenSurfaceHelper(this.world).freezeChunk(chunkCoord);
            this.world.replaceBlocks(chunkCoord);
            OTG.firePopulationEndEvent(this.world, this.rand, hasVillage, chunkCoord);
        }
    }

    private void processResourcesBeforeBo4s(ChunkCoordinate chunkCoord, LocalBiome biome, BiomeConfig biomeConfig) {
        ArrayList<Resource> miscResources = new ArrayList<Resource>();
        for (ConfigFunction<BiomeConfig> configFunction : biomeConfig.resourceSequence) {
            if (configFunction instanceof CustomObjectGen || configFunction instanceof CustomStructureGen) continue;
            if (!(configFunction instanceof ErroredFunction)) {
                miscResources.add((Resource)configFunction);
                continue;
            }
            if (!OTG.getPluginConfig().spawnLog) continue;
            OTG.log(LogMarker.WARN, "Could not parse resource \"" + configFunction.toString() + "\" for biome " + biome.getName(), new Object[0]);
        }
        for (Resource resource : miscResources) {
            if (!(resource instanceof OreGen) && (!(resource instanceof SmallLakeGen) || this.world.getStructureCache().isBo4ChunkOccupied(chunkCoord)) && !(resource instanceof UndergroundLakeGen) && !(resource instanceof UnderWaterOreGen) && !(resource instanceof VeinGen) && !(resource instanceof SurfacePatchGen)) continue;
            resource.process(this.world, this.rand, false, chunkCoord);
        }
    }

    private void processResourcesAfterBo4s(ChunkCoordinate chunkCoord, boolean hasGeneratedAVillage, LocalBiome biome, BiomeConfig biomeConfig) {
        long resourcesSeed = this.worldConfig.resourcesSeed != 0L ? this.worldConfig.resourcesSeed : this.world.getSeed();
        this.rand.setSeed(resourcesSeed);
        long l1 = this.rand.nextLong() / 2L * 2L + 1L;
        long l2 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkCoord.getChunkX() * l1 + (long)chunkCoord.getChunkZ() * l2 ^ resourcesSeed);
        ArrayList<Resource> customObjects = new ArrayList<Resource>();
        ArrayList<Resource> miscResources = new ArrayList<Resource>();
        for (ConfigFunction<BiomeConfig> configFunction : biomeConfig.resourceSequence) {
            if (!(configFunction instanceof ErroredFunction)) {
                if (configFunction instanceof CustomObjectGen) {
                    customObjects.add((Resource)configFunction);
                    continue;
                }
                if (configFunction instanceof CustomStructureGen) continue;
                miscResources.add((Resource)configFunction);
                continue;
            }
            if (!OTG.getPluginConfig().spawnLog) continue;
            OTG.log(LogMarker.WARN, "Could not parse resource \"" + configFunction.toString() + "\" for biome " + biome.getName(), new Object[0]);
        }
        for (Resource resource : customObjects) {
            resource.process(this.world, this.rand, hasGeneratedAVillage, chunkCoord);
        }
        for (Resource resource : miscResources) {
            if (!(resource instanceof DungeonGen) && !(resource instanceof AboveWaterGen) && !(resource instanceof PlantGen) && !(resource instanceof UnderWaterPlantGen) && !(resource instanceof GrassGen) && !(resource instanceof TreeGen) && !(resource instanceof ReedGen) && !(resource instanceof LiquidGen) && !(resource instanceof BoulderGen) && !(resource instanceof CactusGen) && !(resource instanceof IceSpikeGen) && !(resource instanceof WellGen) && !(resource instanceof VinesGen) && !(resource instanceof FossilGen)) continue;
            resource.process(this.world, this.rand, hasGeneratedAVillage, chunkCoord);
        }
        this.world.placePopulationMobs(biome, this.rand, chunkCoord);
        new FrozenSurfaceHelper(this.world).freezeChunk(chunkCoord);
        this.world.replaceBlocks(chunkCoord);
    }

    private void spawnBO4(ChunkCoordinate chunkCoord, ChunkCoordinate chunkBeingPopulated) {
        this.world.getStructureCache().spawnBo4Chunk(chunkCoord, chunkBeingPopulated);
    }

    private void spawnBO4s(ChunkCoordinate chunkCoord, ChunkCoordinate chunkBeingPopulated) {
        this.spawnBO4(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + 1, chunkCoord.getChunkZ()), chunkCoord);
        this.spawnBO4(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX(), chunkCoord.getChunkZ() + 1), chunkCoord);
        this.spawnBO4(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + 1, chunkCoord.getChunkZ() + 1), chunkCoord);
        this.spawnBO4(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX(), chunkCoord.getChunkZ()), chunkCoord);
    }
}

