/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.util;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.biome.settings.WeightedMobSpawnGroup;
import com.pg85.otg.configuration.standard.MojangSettings;
import com.pg85.otg.logging.LogMarker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class MobSpawnGroupHelper {
    private static HashMap<String, Class<? extends Entity>> FoundEntitiesByClassName = new HashMap();
    private static HashMap<String, Class<? extends Entity>> FoundEntitiesByName = new HashMap();

    private static EnumCreatureType toEnumCreatureType(MojangSettings.EntityCategory type) {
        switch (type) {
            case MONSTER: {
                return EnumCreatureType.MONSTER;
            }
            case CREATURE: {
                return EnumCreatureType.CREATURE;
            }
            case AMBIENT_CREATURE: {
                return EnumCreatureType.AMBIENT;
            }
            case WATER_CREATURE: {
                return EnumCreatureType.WATER_CREATURE;
            }
        }
        throw new AssertionError((Object)("Unknown mob type: " + (Object)((Object)type)));
    }

    private static WeightedMobSpawnGroup fromMinecraftGroup(Biome.SpawnListEntry biomeMeta) {
        String mobName = MobSpawnGroupHelper.stringFromMinecraftClass(biomeMeta.field_76300_b);
        if (mobName == null) {
            return null;
        }
        return new WeightedMobSpawnGroup(mobName, biomeMeta.field_76292_a, biomeMeta.field_76301_c, biomeMeta.field_76299_d);
    }

    public static List<WeightedMobSpawnGroup> getListFromMinecraftBiome(Biome biome, MojangSettings.EntityCategory type) {
        List mobList = biome.func_76747_a(MobSpawnGroupHelper.toEnumCreatureType(type));
        return MobSpawnGroupHelper.fromMinecraftList(mobList);
    }

    private static List<WeightedMobSpawnGroup> fromMinecraftList(Collection<Biome.SpawnListEntry> biomeMetas) {
        ArrayList<WeightedMobSpawnGroup> result = new ArrayList<WeightedMobSpawnGroup>();
        for (Biome.SpawnListEntry meta : biomeMetas) {
            WeightedMobSpawnGroup wMSG = MobSpawnGroupHelper.fromMinecraftGroup(meta);
            if (wMSG == null) continue;
            result.add(wMSG);
        }
        return result;
    }

    public static List<Biome.SpawnListEntry> toMinecraftlist(Collection<WeightedMobSpawnGroup> weightedMobSpawnGroups) {
        ArrayList<Biome.SpawnListEntry> biomeList = new ArrayList<Biome.SpawnListEntry>();
        for (WeightedMobSpawnGroup mobGroup : weightedMobSpawnGroups) {
            Class<? extends Entity> entityClass = MobSpawnGroupHelper.toMinecraftClass(mobGroup.getInternalName());
            if (entityClass != null && EntityLiving.class.isAssignableFrom(entityClass)) {
                biomeList.add(new Biome.SpawnListEntry(entityClass, mobGroup.getWeight(), mobGroup.getMin(), mobGroup.getMax()));
                continue;
            }
            if (!OTG.getPluginConfig().spawnLog || (entityClass = MobSpawnGroupHelper.getEntityByClassName(mobGroup.getInternalName())) != null) continue;
            OTG.log(LogMarker.WARN, "Mob type {} not found", mobGroup.getInternalName());
        }
        return biomeList;
    }

    private static Class<? extends Entity> getEntityByClassName(String mobClassName) {
        Class entity = FoundEntitiesByClassName.get(mobClassName = mobClassName.toLowerCase().trim().replace("entity", "").replace("_", "").replace(" ", ""));
        if (entity == null) {
            List entityClasses = ForgeRegistries.ENTITIES.getValues();
            for (EntityEntry entityClass : entityClasses) {
                String entityName = entityClass.getEntityClass().getSimpleName();
                if (!entityName.toLowerCase().trim().replace("entity", "").replace("_", "").replace(" ", "").equals(mobClassName)) continue;
                entity = entityClass.getEntityClass();
                FoundEntitiesByClassName.put(mobClassName, entity);
                break;
            }
        }
        return entity;
    }

    public static Class<? extends Entity> toMinecraftClass(String entityName) {
        ResourceLocation resourceLocation = new ResourceLocation(entityName);
        Class entity = FoundEntitiesByName.get(entityName = entityName.toLowerCase().trim().replace("entity", "").replace("_", "").replace(" ", ""));
        if (entity == null) {
            Set mobNames = EntityList.func_180124_b();
            for (ResourceLocation mobName1 : mobNames) {
                if (!mobName1.equals((Object)resourceLocation)) continue;
                entity = EntityList.getClass((ResourceLocation)mobName1);
                FoundEntitiesByName.put(entityName, entity);
                break;
            }
            if (entity == null) {
                for (ResourceLocation mobName1 : mobNames) {
                    if (!mobName1.func_110623_a().toLowerCase().trim().replace("entity", "").replace("_", "").replace(" ", "").equals(entityName)) continue;
                    entity = EntityList.getClass((ResourceLocation)mobName1);
                    FoundEntitiesByName.put(entityName, entity);
                    break;
                }
            }
        }
        if (entity == null && (entity = MobSpawnGroupHelper.getEntityByClassName(entityName)) != null) {
            FoundEntitiesByName.put(entityName, entity);
        }
        return entity;
    }

    private static String stringFromMinecraftClass(Class<? extends Entity> entityClass) {
        ResourceLocation mobName = EntityList.func_191306_a(entityClass);
        if (mobName != null) {
            return mobName.toString();
        }
        if (OTG.getPluginConfig().spawnLog) {
            OTG.log(LogMarker.DEBUG, "No EntityRegistry entry found for class: " + entityClass, new Object[0]);
        }
        return null;
    }

    public static ResourceLocation resourceLocationFromMinecraftClass(Class<? extends Entity> entityClass) {
        ResourceLocation mobName = EntityList.func_191306_a(entityClass);
        if (mobName != null) {
            return mobName;
        }
        if (OTG.getPluginConfig().spawnLog) {
            OTG.log(LogMarker.WARN, "No EntityRegistry entry found for class: " + entityClass, new Object[0]);
        }
        return null;
    }
}

