/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.network.client;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.configuration.dimensions.DimensionConfigGui;
import com.pg85.otg.configuration.dimensions.DimensionsConfig;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import com.pg85.otg.forge.dimensions.OTGWorldProvider;
import com.pg85.otg.forge.gui.GuiHandler;
import com.pg85.otg.forge.gui.dimensions.OTGGuiDimensionList;
import com.pg85.otg.forge.gui.presets.OTGGuiPresetList;
import com.pg85.otg.forge.network.PacketDispatcher;
import com.pg85.otg.forge.network.client.packets.CreateDeleteDimensionPacket;
import com.pg85.otg.forge.network.client.packets.TeleportPlayerPacket;
import com.pg85.otg.forge.network.client.packets.UpdateDimensionSettingsPacket;
import com.pg85.otg.forge.world.ForgeWorld;
import com.pg85.otg.forge.world.WorldLoader;
import com.pg85.otg.network.ClientConfigProvider;
import com.pg85.otg.util.helpers.StreamHelper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;

public class ClientPacketManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendCreateDimensionPacket(DimensionConfig dimensionConfig) {
        ByteBuf nettyBuffer = Unpooled.buffer();
        ByteBufOutputStream stream = new ByteBufOutputStream(nettyBuffer);
        try {
            CreateDeleteDimensionPacket.writeCreatePacketToStream(dimensionConfig, (DataOutput)stream);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (nettyBuffer != null) {
            PacketDispatcher.sendToServer(new CreateDeleteDimensionPacket(nettyBuffer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendUpdateDimensionSettingsPacket(ArrayList<DimensionConfig> dimConfigs, boolean isOverWorldIncluded) {
        ByteBuf nettyBuffer = Unpooled.buffer();
        ByteBufOutputStream stream = new ByteBufOutputStream(nettyBuffer);
        try {
            UpdateDimensionSettingsPacket.writeToStream((DataOutput)stream, dimConfigs, isOverWorldIncluded);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (nettyBuffer != null) {
            PacketDispatcher.sendToServer(new UpdateDimensionSettingsPacket(nettyBuffer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendDeleteDimensionPacket(String dimensionName) {
        ByteBuf nettyBuffer = Unpooled.buffer();
        ByteBufOutputStream stream = new ByteBufOutputStream(nettyBuffer);
        try {
            CreateDeleteDimensionPacket.writeDeletePacketToStream(dimensionName, (DataOutput)stream);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (nettyBuffer != null) {
            PacketDispatcher.sendToServer(new CreateDeleteDimensionPacket(nettyBuffer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendTeleportPlayerPacket(String dimensionName) {
        ByteBuf nettyBuffer = Unpooled.buffer();
        ByteBufOutputStream stream = new ByteBufOutputStream(nettyBuffer);
        try {
            TeleportPlayerPacket.writeToStream(dimensionName, (DataOutput)stream);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (nettyBuffer != null) {
            PacketDispatcher.sendToServer(new TeleportPlayerPacket(nettyBuffer));
        }
    }

    public static void registerClientWorlds(DataInputStream wrappedStream, WorldLoader worldLoader) throws IOException {
        DimensionsConfig dimsConfig = DimensionsConfig.fromYamlString(StreamHelper.readStringFromStream(wrappedStream));
        OTG.setDimensionsConfig(dimsConfig);
        GuiHandler.GuiPresets.clear();
        int presetCount = wrappedStream.readInt();
        for (int i = 0; i < presetCount; ++i) {
            DimensionConfigGui dimConfig = DimensionConfigGui.fromYamlString(StreamHelper.readStringFromStream(wrappedStream));
            GuiHandler.GuiPresets.put(dimConfig.PresetName, dimConfig);
        }
        int worldCount = wrappedStream.readInt();
        HashMap<Integer, String> dimsToRemove = OTGDimensionManager.getAllOTGDimensions();
        for (int i = 0; i < worldCount; ++i) {
            boolean worldIsLoaded = wrappedStream.readBoolean();
            int dimensionId = wrappedStream.readInt();
            Integer integerToRemove = 0;
            boolean bFound = false;
            for (Map.Entry<Integer, String> dimToRemove : dimsToRemove.entrySet()) {
                if (dimToRemove.getKey() != dimensionId) continue;
                bFound = true;
                integerToRemove = dimToRemove.getKey();
            }
            if (bFound) {
                dimsToRemove.remove(integerToRemove);
            }
            String worldName = StreamHelper.readStringFromStream(wrappedStream);
            if (!DimensionManager.isDimensionRegistered((int)dimensionId) || dimensionId == 0 && ((ForgeEngine)OTG.getEngine()).getOverWorld() == null) {
                if (dimensionId != 0) {
                    OTGDimensionManager.registerDimension(dimensionId, DimensionType.register((String)worldName, (String)"OTG", (int)dimensionId, OTGWorldProvider.class, (boolean)false));
                }
                ForgeWorld world = new ForgeWorld(worldName);
                world.isLoadedOnServer = worldIsLoaded;
                world.clientDimensionId = dimensionId;
                ClientConfigProvider configs = new ClientConfigProvider(wrappedStream, world);
                world.provideClientConfigs(configs);
                worldLoader.LoadClientWorldFromPacket(world);
                continue;
            }
            new ClientConfigProvider(wrappedStream, new ForgeWorld(worldName));
        }
        for (Map.Entry<Integer, String> removedDim : dimsToRemove.entrySet()) {
            if (removedDim.getKey() == 0) continue;
            ForgeWorld forgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getUnloadedWorld(removedDim.getValue());
            if (forgeWorld == null) {
                forgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(removedDim.getValue());
            }
            OTGDimensionManager.DeleteDimension(removedDim.getKey(), forgeWorld, Minecraft.func_71410_x().field_71439_g.func_184102_h(), false);
        }
        int modPackConfigsCount = wrappedStream.readInt();
        ArrayList<DimensionsConfig> modPackConfigs = new ArrayList<DimensionsConfig>();
        for (int i = 0; i < modPackConfigsCount; ++i) {
            modPackConfigs.add(DimensionsConfig.fromYamlString(StreamHelper.readStringFromStream(wrappedStream)));
        }
        OTG.getEngine().getModPackConfigManager().setAllModPackConfigs(modPackConfigs);
        if (Minecraft.func_71410_x().field_71462_r != null && (Minecraft.func_71410_x().field_71462_r instanceof OTGGuiDimensionList || Minecraft.func_71410_x().field_71462_r instanceof OTGGuiPresetList)) {
            if (Minecraft.func_71410_x().field_71462_r instanceof OTGGuiDimensionList) {
                int previouslySelectedIndex = ((OTGGuiDimensionList)Minecraft.func_71410_x().field_71462_r).selectedDimensionIndex;
                boolean isMainMenu = ((OTGGuiDimensionList)Minecraft.func_71410_x().field_71462_r).dimensionSettingsList.mainMenu;
                boolean isGameRulesMenu = ((OTGGuiDimensionList)Minecraft.func_71410_x().field_71462_r).dimensionSettingsList.gameRulesMenu;
                boolean isAdvancedSettingsMenu = ((OTGGuiDimensionList)Minecraft.func_71410_x().field_71462_r).dimensionSettingsList.advancedSettingsMenu;
                float lastScrollPos = ((OTGGuiDimensionList)Minecraft.func_71410_x().field_71462_r).dimensionSettingsList.getAmountScrolledFloat();
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new OTGGuiDimensionList(previouslySelectedIndex, isMainMenu, isGameRulesMenu, isAdvancedSettingsMenu, lastScrollPos));
            } else {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new OTGGuiDimensionList(null));
            }
        }
    }
}

