/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.gui;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.configuration.dimensions.DimensionConfigGui;
import com.pg85.otg.configuration.dimensions.DimensionsConfig;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.forge.gui.mainmenu.OTGGuiWorldSelection;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiHandler
implements IGuiHandler {
    public static LinkedHashMap<String, DimensionConfigGui> GuiPresets = new LinkedHashMap();
    public static boolean IsInMainMenu = false;

    public static void loadGuiPresets() {
        GuiPresets.clear();
        ArrayList<DimensionsConfig> modPackConfigs = OTG.getEngine().getModPackConfigManager().getAllModPackConfigs();
        ArrayList<String> worldNames = new ArrayList<String>();
        File OTGWorldsDirectory = new File(OTG.getEngine().getOTGRootFolder().getAbsolutePath() + File.separator + "worlds");
        if (OTGWorldsDirectory.exists() && OTGWorldsDirectory.isDirectory()) {
            block0: for (File worldDir : OTGWorldsDirectory.listFiles()) {
                if (!worldDir.isDirectory()) continue;
                for (File file : worldDir.listFiles()) {
                    if (!file.getName().equals("WorldConfig.ini")) continue;
                    worldNames.add(worldDir.getName());
                    boolean shouldShow = true;
                    for (DimensionsConfig modPackConfig : modPackConfigs) {
                        if (modPackConfig.Overworld.PresetName != null && modPackConfig.Overworld.PresetName.equals(worldDir.getName())) {
                            shouldShow = true;
                            break;
                        }
                        if (!shouldShow || modPackConfig.Dimensions == null) continue;
                        for (DimensionConfig dimConfig : modPackConfig.Dimensions) {
                            if (!dimConfig.PresetName.equals(worldDir.getName()) || dimConfig.ShowInWorldCreationGUI) continue;
                            shouldShow = false;
                        }
                    }
                    WorldConfig worldConfig = WorldConfig.fromDisk(worldDir);
                    GuiPresets.put(worldDir.getName(), new DimensionConfigGui(worldDir.getName(), 0, shouldShow, worldConfig));
                    continue block0;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void openGui(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiWorldSelection) {
            IsInMainMenu = true;
            if (this.modPackConfigAllowsOTGWorldCreationMenu()) {
                event.setGui((GuiScreen)new OTGGuiWorldSelection());
            }
        }
    }

    public boolean modPackConfigAllowsOTGWorldCreationMenu() {
        ArrayList<DimensionsConfig> defaultConfigs = OTG.getEngine().getModPackConfigManager().getAllModPackConfigs();
        for (DimensionsConfig dimConfig : defaultConfigs) {
            if (dimConfig.ShowOTGWorldCreationMenu || dimConfig.Overworld.PresetName != null) continue;
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void closeGui(GuiOpenEvent event) {
    }

    public void registerKeybindings() {
    }

    public Object getServerGuiElement(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public Object getClientGuiElement(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }
}

