/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.generator.structure;

import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.forge.biomes.ForgeBiome;
import com.pg85.otg.forge.generator.structure.OTGMapGenStructure;
import com.pg85.otg.forge.generator.structure.OTGWoodLandMansionStart;
import com.pg85.otg.forge.world.ForgeWorld;
import com.pg85.otg.network.ConfigProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureStart;

public class OTGWoodLandMansionGen
extends OTGMapGenStructure {
    private int spacing = 80;
    private int separation = 20;
    private final List<Biome> woodLandMansionSpawnBiomes = new ArrayList<Biome>();

    public OTGWoodLandMansionGen(ConfigProvider settings, ForgeWorld world) {
        super(world);
        for (LocalBiome biome : settings.getBiomeArrayByOTGId()) {
            if (biome == null || !biome.getBiomeConfig().woodLandMansionsEnabled) continue;
            this.woodLandMansionSpawnBiomes.add(((ForgeBiome)biome).getHandle());
        }
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        boolean flag;
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            i = chunkX - 79;
        }
        if (chunkZ < 0) {
            j = chunkZ - 79;
        }
        int k = i / 80;
        int l = j / 80;
        Random random = this.field_75039_c.func_72843_D(k, l, 10387319);
        k *= 80;
        l *= 80;
        return chunkX == (k += (random.nextInt(60) + random.nextInt(60)) / 2) && chunkZ == (l += (random.nextInt(60) + random.nextInt(60)) / 2) && (flag = this.field_75039_c.func_72959_q().func_76940_a(chunkX * 16 + 8, chunkZ * 16 + 8, 32, this.woodLandMansionSpawnBiomes));
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        BiomeProvider biomeprovider = worldIn.func_72959_q();
        return biomeprovider.func_190944_c() && !this.woodLandMansionSpawnBiomes.contains(biomeprovider.func_190943_d()) ? null : OTGWoodLandMansionGen.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)this.spacing, (int)this.separation, (int)10387319, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    public String func_143025_a() {
        return "Mansion";
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new OTGWoodLandMansionStart(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    static {
        MapGenStructureIO.func_143034_b(OTGWoodLandMansionStart.class, (String)"MansionOTG");
    }
}

