/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.generator.structure;

import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.forge.biomes.ForgeBiome;
import com.pg85.otg.forge.generator.structure.OTGMapGenStructure;
import com.pg85.otg.forge.world.ForgeWorld;
import com.pg85.otg.network.ConfigProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraft.world.gen.structure.StructureStart;

public class OTGOceanMonumentGen
extends OTGMapGenStructure {
    private int spacing = 32;
    private int separation = 5;
    private int gridSize;
    private int randomOffset;
    private final List<Biome> monumentSpawnBiomes;
    private final List<Biome.SpawnListEntry> mobList;

    public OTGOceanMonumentGen(ConfigProvider settings, ForgeWorld world) {
        super(world);
        this.gridSize = settings.getWorldConfig().oceanMonumentGridSize;
        this.randomOffset = settings.getWorldConfig().oceanMonumentRandomOffset;
        this.monumentSpawnBiomes = new ArrayList<Biome>();
        this.mobList = Arrays.asList(new Biome.SpawnListEntry(EntityGuardian.class, 1, 2, 4));
        for (LocalBiome biome : settings.getBiomeArrayByOTGId()) {
            if (biome == null || !biome.getBiomeConfig().oceanMonumentsEnabled) continue;
            this.monumentSpawnBiomes.add(((ForgeBiome)biome).getHandle());
        }
    }

    protected boolean func_75047_a(int p_75047_1_, int p_75047_2_) {
        boolean flag;
        int k = p_75047_1_;
        int l = p_75047_2_;
        if (p_75047_1_ < 0) {
            p_75047_1_ -= this.gridSize - 1;
        }
        if (p_75047_2_ < 0) {
            p_75047_2_ -= this.gridSize - 1;
        }
        int i1 = p_75047_1_ / this.gridSize;
        int j1 = p_75047_2_ / this.gridSize;
        Random random = this.field_75039_c.func_72843_D(i1, j1, 10387313);
        i1 *= this.gridSize;
        j1 *= this.gridSize;
        return k == (i1 += (random.nextInt(this.randomOffset + 1) + random.nextInt(this.randomOffset + 1)) / 2) && l == (j1 += (random.nextInt(this.randomOffset + 1) + random.nextInt(this.randomOffset + 1)) / 2) && (flag = this.field_75039_c.func_72959_q().func_76940_a(k * 16 + 8, l * 16 + 8, 16, this.monumentSpawnBiomes));
    }

    public String func_143025_a() {
        return "Monument";
    }

    protected StructureStart func_75049_b(int p_75049_1_, int p_75049_2_) {
        return new StructureOceanMonument.StartMonument(this.field_75039_c, this.field_75038_b, p_75049_1_, p_75049_2_);
    }

    public List<Biome.SpawnListEntry> getMonsterSpawnList() {
        return this.mobList;
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        return OTGOceanMonumentGen.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)this.spacing, (int)this.separation, (int)10387313, (boolean)true, (int)100, (boolean)findUnexplored);
    }
}

