/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.generator;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.customobjects.bofunctions.ModDataFunction;
import com.pg85.otg.forge.OTGPlugin;
import com.pg85.otg.forge.generator.ForgeChunkBuffer;
import com.pg85.otg.forge.materials.ForgeMaterialData;
import com.pg85.otg.forge.util.NBTHelper;
import com.pg85.otg.forge.world.ForgeWorld;
import com.pg85.otg.generator.ChunkProviderOTG;
import com.pg85.otg.generator.ObjectSpawner;
import com.pg85.otg.generator.biome.OutputType;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.network.ConfigProvider;
import com.pg85.otg.util.BlockPos2D;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.FifoMap;
import com.pg85.otg.util.bo3.NamedBinaryTag;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockSand;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class OTGChunkGenerator
implements IChunkGenerator {
    private boolean testMode = false;
    private ForgeWorld world;
    private ChunkProviderOTG chunkProviderOTG;
    public ObjectSpawner spawner;
    private FifoMap<BlockPos2D, LocalMaterialData[]> unloadedBlockColumnsCache;
    private FifoMap<ChunkCoordinate, Chunk> unloadedChunksCache;
    private Map.Entry<ChunkCoordinate, Chunk> lastUsedChunk1;
    private Map.Entry<ChunkCoordinate, Chunk> lastUsedChunk2;
    private Map.Entry<ChunkCoordinate, Chunk> lastUsedChunk3;
    private Map.Entry<ChunkCoordinate, Chunk> lastUsedChunk4;
    ForgeChunkBuffer chunkBuffer;
    Object chunkBufferLock = new Object();
    Object chunkCacheLock = new Object();
    private DataFixer dataFixer = DataFixesManager.func_188279_a();

    public OTGChunkGenerator(ForgeWorld _world) {
        this.world = _world;
        this.testMode = this.world.getConfigs().getWorldConfig().modeTerrain == WorldConfig.TerrainMode.TerrainTest;
        this.chunkProviderOTG = new ChunkProviderOTG(this.world.getConfigs(), this.world);
        this.spawner = new ObjectSpawner(this.world.getConfigs(), this.world);
        this.unloadedBlockColumnsCache = new FifoMap(1024);
        this.unloadedChunksCache = new FifoMap(128);
        this.lastUsedChunk1 = null;
        this.lastUsedChunk2 = null;
        this.lastUsedChunk3 = null;
        this.lastUsedChunk4 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChunkCache() {
        Object object = this.chunkCacheLock;
        synchronized (object) {
            this.lastUsedChunk1 = null;
            this.lastUsedChunk2 = null;
            this.lastUsedChunk3 = null;
            this.lastUsedChunk4 = null;
            this.unloadedBlockColumnsCache.clear();
            this.unloadedChunksCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChunkFromCache(ChunkCoordinate chunkCoordinate) {
        Object object = this.chunkCacheLock;
        synchronized (object) {
            if (this.lastUsedChunk1 != null && this.lastUsedChunk1.getKey().equals(chunkCoordinate)) {
                this.lastUsedChunk1 = null;
            } else if (this.lastUsedChunk2 != null && this.lastUsedChunk2.getKey().equals(chunkCoordinate)) {
                this.lastUsedChunk2 = null;
            } else if (this.lastUsedChunk3 != null && this.lastUsedChunk3.getKey().equals(chunkCoordinate)) {
                this.lastUsedChunk3 = null;
            } else if (this.lastUsedChunk4 != null && this.lastUsedChunk4.getKey().equals(chunkCoordinate)) {
                this.lastUsedChunk4 = null;
            }
        }
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        return this.getBlocks(chunkX, chunkZ, true);
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
        this.unloadedChunksCache.remove(chunkCoord);
        if (this.testMode) {
            return;
        }
        BlockSand.field_149832_M = true;
        BlockGravel.field_149832_M = true;
        this.spawner.populate(chunkCoord);
        BlockSand.field_149832_M = false;
        BlockGravel.field_149832_M = false;
        HashMap<String, ArrayList<ModDataFunction<?>>> MessagesPerMod = this.world.getWorldSession().getModDataForChunk(chunkCoord);
        if (MessagesPerMod != null && MessagesPerMod.entrySet().size() > 0) {
            for (Map.Entry<String, ArrayList<ModDataFunction<?>>> modNameAndData : MessagesPerMod.entrySet()) {
                String messageString = "";
                if (modNameAndData.getKey().equals("OTG")) {
                    for (ModDataFunction<?> modData : modNameAndData.getValue()) {
                        boolean autoSpawn;
                        String[] paramString2 = modData.modData.split("\\/");
                        if (paramString2.length <= 1 || !paramString2[0].equals("mob") || !(autoSpawn = paramString2.length > 4 ? Boolean.parseBoolean(paramString2[4]) : false)) continue;
                        messageString = messageString + "[" + modData.x + "," + modData.y + "," + modData.z + "," + modData.modData + "]";
                    }
                } else {
                    for (ModDataFunction<?> modData : modNameAndData.getValue()) {
                        messageString = messageString + "[" + modData.x + "," + modData.y + "," + modData.z + "," + modData.modData + "]";
                    }
                }
                if (messageString.length() <= 0) continue;
                FMLInterModComms.sendRuntimeMessage((Object)OTGPlugin.Instance, (String)modNameAndData.getKey(), (String)"ModData", (String)("[[" + this.world.getName() + "," + chunkX + "," + chunkZ + "]" + messageString + "]"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk getChunk(int x, int z) {
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        Chunk chunk = null;
        Object object = this.chunkCacheLock;
        synchronized (object) {
            if (this.lastUsedChunk1 != null && this.lastUsedChunk1.getKey().equals(chunkCoord)) {
                chunk = this.lastUsedChunk1.getValue();
            } else if (this.lastUsedChunk2 != null && this.lastUsedChunk2.getKey().equals(chunkCoord)) {
                chunk = this.lastUsedChunk2.getValue();
            } else if (this.lastUsedChunk3 != null && this.lastUsedChunk3.getKey().equals(chunkCoord)) {
                chunk = this.lastUsedChunk3.getValue();
            } else if (this.lastUsedChunk4 != null && this.lastUsedChunk4.getKey().equals(chunkCoord)) {
                chunk = this.lastUsedChunk4.getValue();
            }
        }
        if (chunk == null) {
            chunk = this.world.getWorld().func_72863_F().func_186026_b(chunkCoord.getChunkX(), chunkCoord.getChunkZ());
            if (chunk == null) {
                chunk = this.world.getWorld().func_72964_e(chunkCoord.getChunkX(), chunkCoord.getChunkZ());
            }
            if (chunk != null) {
                object = this.chunkCacheLock;
                synchronized (object) {
                    this.lastUsedChunk4 = this.lastUsedChunk3;
                    this.lastUsedChunk3 = this.lastUsedChunk2;
                    this.lastUsedChunk2 = this.lastUsedChunk1;
                    this.lastUsedChunk1 = new AbstractMap.SimpleEntry<ChunkCoordinate, Chunk>(chunkCoord, chunk);
                }
            }
        }
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Chunk getBlocks(int chunkX, int chunkZ, boolean provideChunk) {
        Chunk chunk = (Chunk)this.unloadedChunksCache.get(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ));
        if (chunk == null) {
            chunk = new Chunk(this.world.getWorld(), chunkX, chunkZ);
            ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
            Object object = this.chunkBufferLock;
            synchronized (object) {
                this.chunkBuffer = new ForgeChunkBuffer(chunkCoord);
                this.chunkProviderOTG.generate(this.chunkBuffer);
                chunk = this.chunkBuffer.toChunk(this.world.getWorld());
                this.chunkBuffer = null;
            }
            this.fillBiomeArray(chunk);
            chunk.func_76603_b();
        } else {
            this.fillBiomeArray(chunk);
            chunk.func_76603_b();
        }
        return chunk;
    }

    private void fillBiomeArray(Chunk chunk) {
        byte[] chunkBiomeArray = chunk.func_76605_m();
        ConfigProvider configProvider = this.world.getConfigs();
        int[] biomeShortArray = this.world.getBiomeGenerator().getBiomes(null, chunk.field_76635_g * 16, chunk.field_76647_h * 16, 16, 16, OutputType.DEFAULT_FOR_WORLD);
        for (int i = 0; i < chunkBiomeArray.length; ++i) {
            int generationId = biomeShortArray[i];
            LocalBiome biome = configProvider.getBiomeByOTGIdOrNull(generationId);
            chunkBiomeArray[i] = (byte)biome.getIds().getSavedId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalMaterialData[] getBlockColumnInUnloadedChunk(int x, int z) {
        IBlockState blockInChunk;
        BlockPos2D blockPos = new BlockPos2D(x, z);
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        int chunkX = chunkCoord.getChunkX();
        int chunkZ = chunkCoord.getChunkZ();
        byte blockX = (byte)(x &= 0xF);
        byte blockZ = (byte)(z &= 0xF);
        LocalMaterialData[] cachedColumn = (LocalMaterialData[])this.unloadedBlockColumnsCache.get(blockPos);
        if (cachedColumn != null) {
            return cachedColumn;
        }
        Chunk chunk = this.world.getWorld().func_72863_F().func_186026_b(chunkX, chunkZ);
        if (chunk == null) {
            chunk = (Chunk)this.unloadedChunksCache.get(chunkCoord);
        } else {
            this.unloadedChunksCache.remove(chunkCoord);
        }
        if (chunk == null) {
            chunk = new Chunk(this.world.getWorld(), chunkX, chunkZ);
            Object object = this.chunkBufferLock;
            synchronized (object) {
                this.chunkBuffer = new ForgeChunkBuffer(chunkCoord);
                this.chunkProviderOTG.generate(this.chunkBuffer);
                chunk = this.chunkBuffer.toChunk(this.world.getWorld());
                this.chunkBuffer = null;
            }
            this.unloadedChunksCache.put(chunkCoord, chunk);
        }
        cachedColumn = new LocalMaterialData[256];
        LocalMaterialData[] blocksInColumn = new LocalMaterialData[256];
        for (int y = 0; y < 256 && (blockInChunk = chunk.func_177435_g(new BlockPos((int)blockX, y, (int)blockZ))) != null; y = (int)((short)(y + 1))) {
            blocksInColumn[y] = ForgeMaterialData.ofMinecraftBlockState(blockInChunk);
        }
        this.unloadedBlockColumnsCache.put(blockPos, cachedColumn);
        return blocksInColumn;
    }

    public double getBiomeBlocksNoiseValue(int blockX, int blockZ) {
        return this.chunkProviderOTG.getBiomeBlocksNoiseValue(blockX, blockZ);
    }

    public LocalMaterialData getMaterialInUnloadedChunk(int x, int y, int z) {
        LocalMaterialData[] blockColumn = this.getBlockColumnInUnloadedChunk(x, z);
        return blockColumn[y];
    }

    public int getHighestBlockYInUnloadedChunk(int x, int z, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow) {
        int height = -1;
        LocalMaterialData[] blockColumn = this.getBlockColumnInUnloadedChunk(x, z);
        for (int y = 255; y > -1; --y) {
            boolean isSolid;
            ForgeMaterialData material = (ForgeMaterialData)blockColumn[y];
            boolean isLiquid = material.isLiquid();
            boolean bl = isSolid = material.isSolid() || !ignoreSnow && material.isMaterial(DefaultMaterial.SNOW);
            if (isLiquid && ignoreLiquid) continue;
            if (findSolid && isSolid || findLiquid && isLiquid) {
                return y;
            }
            if ((!findSolid || !isLiquid) && (!findLiquid || !isSolid)) continue;
            return -1;
        }
        return height;
    }

    public void setBlock(int x, int y, int z, LocalMaterialData material, NamedBinaryTag metaDataTag) {
        if (y < 0 || y >= 256) {
            return;
        }
        IBlockState newState = ((ForgeMaterialData)material).internalBlock();
        BlockPos pos = new BlockPos(x, y, z);
        Chunk chunk = this.getChunk(x, z);
        if (chunk == null) {
            throw new RuntimeException("Could not provide chunk.");
        }
        boolean oldCaptureBlockStates = this.world.getWorld().captureBlockSnapshots;
        this.world.getWorld().captureBlockSnapshots = !newState.func_177230_c().hasTileEntity(newState);
        IBlockState iblockstate = chunk.func_177436_a(pos, newState);
        this.world.getWorld().captureBlockSnapshots = oldCaptureBlockStates;
        if (iblockstate == null) {
            return;
        }
        if (metaDataTag != null) {
            this.attachMetadata(x, y, z, metaDataTag);
        }
        this.world.getWorld().markAndNotifyBlock(pos, chunk, iblockstate, newState, 18);
    }

    private void attachMetadata(int x, int y, int z, NamedBinaryTag tag) {
        NBTTagCompound nmsTag = NBTHelper.getNMSFromNBTTagCompound(tag);
        nmsTag.func_74768_a("x", x);
        nmsTag.func_74768_a("y", y);
        nmsTag.func_74768_a("z", z);
        nmsTag = this.dataFixer.func_188257_a((IFixType)FixTypes.BLOCK_ENTITY, nmsTag);
        TileEntity tileEntity = this.world.getWorld().func_175625_s(new BlockPos(x, y, z));
        if (tileEntity != null) {
            tileEntity.func_145839_a(nmsTag);
        } else if (OTG.getPluginConfig().spawnLog) {
            OTG.log(LogMarker.WARN, "Skipping tile entity with id {}, cannot be placed at {},{},{}", nmsTag.func_74779_i("id"), x, y, z);
        }
    }

    public void func_180514_a(Chunk chunkIn, int chunkX, int chunkZ) {
        this.world.recreateStructures(chunkIn, chunkX, chunkZ);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return this.world.isInsideStructure(structureName, pos);
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos blockPos, boolean p_180513_4_) {
        return this.world.getNearestStructurePos(structureName, blockPos, p_180513_4_);
    }

    public int getHighestBlockInCurrentlyPopulatingChunk(int x, int z) {
        for (int i = 255; i > 0; --i) {
            LocalMaterialData material = this.chunkBuffer.getBlock(x, i, z);
            if (material == null || material.isEmptyOrAir()) continue;
            return i;
        }
        return 0;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType paramaca, BlockPos blockPos) {
        return this.world.getPossibleCreatures(paramaca, blockPos);
    }
}

