/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.events.client;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.dimensions.OTGWorldProvider;
import com.pg85.otg.forge.world.ForgeWorld;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ClientFogHandler {
    private final int MAX_BLEND_DISTANCE = 34;
    private short[][] biomeCache = new short[69][69];
    private double lastX;
    private double lastZ;
    boolean otgDidLastFogRender = false;
    String lastWorldName = "";

    public ClientFogHandler() {
        for (short[] row : this.biomeCache) {
            Arrays.fill(row, (short)-1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGetFogColor(EntityViewRenderEvent.FogColors event) {
        Vec3d fogColor;
        boolean hasMoved;
        int blockZ;
        if (!(event.getEntity() instanceof EntityPlayer) || !(event.getEntity().func_130014_f_().field_73011_w instanceof OTGWorldProvider)) {
            return;
        }
        ForgeWorld forgeWorld = ((ForgeEngine)OTG.getEngine()).getWorld(event.getEntity().field_70170_p);
        if (forgeWorld == null) {
            return;
        }
        int blockX = (int)Math.floor(event.getEntity().field_70165_t);
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(blockX, 0, blockZ = (int)Math.floor(event.getEntity().field_70161_v));
        BiomeConfig biomeConfig = this.getBiomeConfig(forgeWorld, 0, 0, blockPos, hasMoved = event.getEntity().field_70165_t != this.lastX || event.getEntity().field_70161_v != this.lastZ);
        if (biomeConfig != null && (fogColor = this.blendFogColors(forgeWorld, biomeConfig, (EntityLivingBase)event.getEntity(), event.getRed(), event.getGreen(), event.getBlue(), event.getRenderPartialTicks())) != null) {
            event.setRed((float)fogColor.field_72450_a);
            event.setGreen((float)fogColor.field_72448_b);
            event.setBlue((float)fogColor.field_72449_c);
        }
        this.lastX = event.getEntity().field_70165_t;
        this.lastZ = event.getEntity().field_70161_v;
    }

    @SideOnly(value=Side.CLIENT)
    private void resetFogDistance(Minecraft mc, int fogMode) {
        if (this.otgDidLastFogRender) {
            this.otgDidLastFogRender = false;
            float farPlaneDistance = mc.field_71474_y.field_151451_c * 16;
            if (fogMode < 0) {
                GL11.glFogf((int)2915, (float)0.0f);
                GL11.glFogf((int)2916, (float)farPlaneDistance);
            } else {
                GL11.glFogf((int)2915, (float)(farPlaneDistance * 0.75f));
                GL11.glFogf((int)2916, (float)farPlaneDistance);
            }
            for (short[] row : this.biomeCache) {
                Arrays.fill(row, (short)-1);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void clearBiomeCacheOnWorldChanged(Minecraft mc, int fogMode, ForgeWorld forgeWorld) {
        if (!this.lastWorldName.equals(forgeWorld.getName())) {
            this.lastWorldName = forgeWorld.getName();
            for (short[] row : this.biomeCache) {
                Arrays.fill(row, (short)-1);
            }
            this.resetFogDistance(mc, fogMode);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        if (!(event.getEntity().func_130014_f_().field_73011_w instanceof OTGWorldProvider)) {
            this.resetFogDistance(event.getRenderer().field_78531_r, event.getFogMode());
            return;
        }
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        int[] ranges = ForgeModContainer.blendRanges;
        int blendDistance = 6;
        if (settings.field_74347_j && settings.field_151451_c >= 0 && settings.field_151451_c < ranges.length) {
            blendDistance = ranges[settings.field_151451_c];
        }
        Entity entity = event.getEntity();
        int blockX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int blockZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        ForgeWorld forgeWorld = ((ForgeEngine)OTG.getEngine()).getWorld(entity.func_130014_f_());
        if (forgeWorld == null) {
            this.resetFogDistance(event.getRenderer().field_78531_r, event.getFogMode());
            return;
        }
        this.clearBiomeCacheOnWorldChanged(event.getRenderer().field_78531_r, event.getFogMode(), forgeWorld);
        float biomeFogDistance = 0.0f;
        float weightBiomeFog = 0.0f;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(0, 0, 0);
        boolean hasMoved = entity.field_70165_t != this.lastX || entity.field_70161_v != this.lastZ;
        boolean bFound = false;
        for (int x = -blendDistance; x <= blendDistance; ++x) {
            for (int z = -blendDistance; z <= blendDistance; ++z) {
                blockPos.func_181079_c(blockX + x, 0, blockZ + z);
                BiomeConfig config = this.getBiomeConfig(forgeWorld, x + blendDistance, z + blendDistance, blockPos, hasMoved);
                if (config == null) {
                    return;
                }
                if (config.fogColor == 0) continue;
                bFound = true;
                float fogDensity = 1.0f - config.fogDensity;
                float densityWeight = 1.0f;
                double differenceX = this.getDifference(entity.field_70165_t, blockX, x, blendDistance);
                double differenceZ = this.getDifference(entity.field_70161_v, blockZ, z, blendDistance);
                if (differenceX >= 0.0) {
                    fogDensity = (float)((double)fogDensity * differenceX);
                    densityWeight = (float)((double)densityWeight * differenceX);
                }
                if (differenceZ >= 0.0) {
                    fogDensity = (float)((double)fogDensity * differenceZ);
                    densityWeight = (float)((double)densityWeight * differenceZ);
                }
                biomeFogDistance += fogDensity;
                weightBiomeFog += densityWeight;
            }
        }
        if (!bFound) {
            this.resetFogDistance(event.getRenderer().field_78531_r, event.getFogMode());
            return;
        }
        float weightMixed = blendDistance * 2 * (blendDistance * 2);
        float weightDefault = weightMixed - weightBiomeFog;
        if (weightDefault < 0.0f) {
            weightDefault = 0.0f;
        }
        float fogDistanceAvg = weightBiomeFog == 0.0f ? 0.0f : biomeFogDistance / weightBiomeFog;
        float fogDistance = (biomeFogDistance * 240.0f + event.getFarPlaneDistance() * weightDefault) / weightMixed;
        float fogDistanceScaleBiome = 0.1f * (1.0f - fogDistanceAvg) + 0.75f * fogDistanceAvg;
        float fogDistanceScale = (fogDistanceScaleBiome * weightBiomeFog + 0.75f * weightDefault) / weightMixed;
        float finalFogDistance = Math.min(fogDistance, event.getFarPlaneDistance());
        this.lastX = entity.field_70165_t;
        this.lastZ = entity.field_70161_v;
        this.otgDidLastFogRender = true;
        if (event.getFogMode() < 0) {
            GL11.glFogf((int)2915, (float)0.0f);
            GL11.glFogf((int)2916, (float)finalFogDistance);
        } else {
            GL11.glFogf((int)2915, (float)(finalFogDistance * fogDistanceScale));
            GL11.glFogf((int)2916, (float)finalFogDistance);
        }
    }

    private double getDifference(double rawCoord, int blockCoord, int pos, int distance) {
        if (pos == -distance) {
            return 1.0 - (rawCoord - (double)blockCoord);
        }
        if (pos == distance) {
            return rawCoord - (double)blockCoord;
        }
        return -1.0;
    }

    @SideOnly(value=Side.CLIENT)
    private Vec3d blendFogColors(ForgeWorld forgeWorld, BiomeConfig biomeConfig, EntityLivingBase entity, float red, float green, float blue, double renderPartialTicks) {
        double fogBlue;
        double fogGreen;
        double fogRed;
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        int[] ranges = ForgeModContainer.blendRanges;
        int blendDistance = 6;
        if (settings.field_74347_j && settings.field_151451_c >= 0 && settings.field_151451_c < ranges.length) {
            blendDistance = ranges[settings.field_151451_c];
        }
        double biomeFogRed = 0.0;
        double biomeFogGreen = 0.0;
        double biomeFogBlue = 0.0;
        double biomeFogWeight = 0.0;
        int blockX = (int)Math.floor(entity.field_70165_t);
        int blockZ = (int)Math.floor(entity.field_70161_v);
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(blockX, 0, blockZ);
        boolean hasMoved = entity.field_70165_t != this.lastX || entity.field_70161_v != this.lastZ;
        for (int x = -blendDistance; x <= blendDistance; ++x) {
            for (int z = -blendDistance; z <= blendDistance; ++z) {
                blockPos.func_181079_c(blockX + x, 0, blockZ + z);
                BiomeConfig config = this.getBiomeConfig(forgeWorld, x + blendDistance, z + blendDistance, blockPos, hasMoved);
                if (config == null) {
                    return null;
                }
                if (config.fogColor == 0) continue;
                fogRed = (config.fogColor & 0xFF0000) >> 16;
                fogGreen = (config.fogColor & 0xFF00) >> 8;
                fogBlue = config.fogColor & 0xFF;
                float fogWeight = 1.0f;
                double differenceX = this.getDifference(entity.field_70165_t, blockX, x, blendDistance);
                double differenceZ = this.getDifference(entity.field_70161_v, blockZ, z, blendDistance);
                if (differenceX >= 0.0) {
                    fogRed *= differenceX;
                    fogGreen *= differenceX;
                    fogBlue *= differenceX;
                    fogWeight = (float)((double)fogWeight * differenceX);
                }
                if (differenceZ >= 0.0) {
                    fogRed *= differenceZ;
                    fogGreen *= differenceZ;
                    fogBlue *= differenceZ;
                    fogWeight = (float)((double)fogWeight * differenceZ);
                }
                biomeFogRed += fogRed;
                biomeFogGreen += fogGreen;
                biomeFogBlue += fogBlue;
                biomeFogWeight += (double)fogWeight;
            }
        }
        if (biomeFogWeight <= 0.0 || (float)blendDistance <= 0.0f) {
            return new Vec3d((double)red, (double)green, (double)blue);
        }
        biomeFogRed /= 255.0;
        biomeFogGreen /= 255.0;
        biomeFogBlue /= 255.0;
        float baseScale = 1.0f;
        float time = MathHelper.func_76131_a((float)(MathHelper.func_76134_b((float)(forgeWorld.getWorld().func_72826_c((float)renderPartialTicks) * (float)Math.PI * 2.0f)) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        baseScale *= 1.0f - (1.0f - time) * biomeConfig.fogTimeWeight;
        float rainStrength = forgeWorld.getWorld().func_72867_j((float)renderPartialTicks);
        float thunderStrength = forgeWorld.getWorld().func_72819_i((float)renderPartialTicks);
        if (thunderStrength >= 0.0f) {
            baseScale *= Math.min(1.0f - thunderStrength * biomeConfig.fogThunderWeight, 1.0f - rainStrength * biomeConfig.fogRainWeight);
        } else if (rainStrength >= 0.0f) {
            baseScale *= 1.0f - rainStrength * biomeConfig.fogRainWeight;
        }
        double weightMixed = blendDistance * 2 * (blendDistance * 2);
        double weightDefault = weightMixed - biomeFogWeight;
        fogRed = ((biomeFogRed *= (double)baseScale / biomeFogWeight) * biomeFogWeight + (double)red * weightDefault) / weightMixed;
        fogGreen = ((biomeFogGreen *= (double)baseScale / biomeFogWeight) * biomeFogWeight + (double)green * weightDefault) / weightMixed;
        fogBlue = ((biomeFogBlue *= (double)baseScale / biomeFogWeight) * biomeFogWeight + (double)blue * weightDefault) / weightMixed;
        return new Vec3d(fogRed, fogGreen, fogBlue);
    }

    private BiomeConfig getBiomeConfig(ForgeWorld world, int x, int z, BlockPos.MutableBlockPos blockPos, boolean hasMoved) {
        LocalBiome localBiome;
        short cachedId = this.biomeCache[x][z];
        if (cachedId != -1 && !hasMoved) {
            return OTG.getEngine().getOTGBiomeIds(world.getName())[cachedId];
        }
        Biome biome = world.getBiomeFromChunk(blockPos.func_177958_n(), blockPos.func_177952_p());
        LocalBiome localBiome2 = localBiome = biome != null ? world.getBiomeByNameOrNull(biome.func_185359_l()) : null;
        if (localBiome == null || localBiome.getBiomeConfig() == null) {
            this.biomeCache[x][z] = -1;
            return null;
        }
        this.biomeCache[x][z] = (short)localBiome.getIds().getOTGBiomeId();
        return localBiome.getBiomeConfig();
    }
}

