/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.events;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.OTGPlugin;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import com.pg85.otg.forge.dimensions.OTGWorldProvider;
import com.pg85.otg.forge.gui.GuiHandler;
import com.pg85.otg.forge.network.server.ServerPacketManager;
import com.pg85.otg.forge.world.ForgeWorld;
import com.pg85.otg.forge.world.ForgeWorldSession;
import com.pg85.otg.forge.world.OTGWorldType;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.feature.WorldGeneratorBonusChest;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldListener {
    private void initOnWorldLoad() {
        GuiHandler.IsInMainMenu = false;
        OTGPlugin.BiomeColorsListener.reload();
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void onWorldLoadServer(WorldEvent.Load event) {
        this.initOnWorldLoad();
        World world = event.getWorld();
        int dimension = world.field_73011_w.getDimension();
        ForgeWorld forgeWorld = ((ForgeEngine)OTG.getEngine()).getWorld(world);
        if (forgeWorld != null) {
            if (dimension == 0) {
                WorldListener.overrideWorldProvider(world);
            }
            DimensionConfig dimConfig = OTG.getDimensionsConfig().getDimensionConfig(forgeWorld.getName());
            WorldListener.createSpawnPosition(forgeWorld, dimConfig);
            if (dimConfig.BonusChest && !forgeWorld.getWorldSession().getPreGeneratorIsInitialised()) {
                WorldListener.createBonusChest(forgeWorld.getWorld());
            }
            forgeWorld.getWorldSession().setPreGeneratorCenterPoint(ChunkCoordinate.fromBlockCoords(world.func_72912_H().func_76079_c(), world.func_72912_H().func_76074_e()));
            world.field_175728_M = ((OTGWorldProvider)world.field_73011_w).createWorldBorderA(world.field_175728_M);
            ServerPacketManager.sendDimensionLoadUnloadPacketToAllPlayers(true, forgeWorld.getName(), event.getWorld().func_73046_m());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onWorldLoadClient(WorldEvent.Load event) {
        ForgeWorld forgeWorld;
        this.initOnWorldLoad();
        for (LocalWorld localWorld : ((ForgeEngine)OTG.getEngine()).getAllWorlds()) {
            forgeWorld = (ForgeWorld)localWorld;
            if (forgeWorld.getWorld() != null || forgeWorld.clientDimensionId != event.getWorld().field_73011_w.getDimension()) continue;
            forgeWorld.provideClientWorld(event.getWorld());
        }
        World world = event.getWorld();
        int dimension = world.field_73011_w.getDimension();
        forgeWorld = ((ForgeEngine)OTG.getEngine()).getWorld(world);
        if (forgeWorld != null) {
            if (dimension == 0) {
                WorldListener.overrideWorldProvider(world);
            }
            if (!world.field_72995_K) {
                DimensionConfig dimConfig = OTG.getDimensionsConfig().getDimensionConfig(forgeWorld.getName());
                WorldListener.createSpawnPosition(forgeWorld, dimConfig);
                if (dimConfig.BonusChest && !forgeWorld.getWorldSession().getPreGeneratorIsInitialised()) {
                    WorldListener.createBonusChest(forgeWorld.getWorld());
                }
                forgeWorld.getWorldSession().setPreGeneratorCenterPoint(ChunkCoordinate.fromBlockCoords(world.func_72912_H().func_76079_c(), world.func_72912_H().func_76074_e()));
                world.field_175728_M = ((OTGWorldProvider)world.field_73011_w).createWorldBorderA(world.field_175728_M);
            }
        }
    }

    private static void overrideWorldProvider(World world) {
        String newClassName = OTGWorldProvider.class.getName();
        Class<OTGWorldProvider> newProviderClass = OTGWorldProvider.class;
        if (newProviderClass != null && newProviderClass != world.field_73011_w.getClass()) {
            int dim = world.field_73011_w.getDimension();
            try {
                Constructor constructor = newProviderClass.getConstructor(new Class[0]);
                WorldProvider newProvider = (WorldProvider)constructor.newInstance(new Object[0]);
                try {
                    WorldProvider oldProvider = world.field_73011_w;
                    world.field_73011_w = newProvider;
                    ((OTGWorldProvider)world.field_73011_w).isSPServerOverworld = !world.field_72995_K;
                    world.field_73011_w.func_76558_a(world);
                    world.field_73011_w.setDimension(dim);
                    if (!world.field_72995_K) {
                        ((OTGWorldProvider)world.field_73011_w).init(oldProvider.func_177499_m());
                    }
                }
                catch (Exception e) {
                    OTG.log(LogMarker.ERROR, "WorldUtils.overrideWorldProvider: Failed to override the WorldProvider of dimension {}", dim);
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        OTG.log(LogMarker.WARN, "WorldUtils.overrideWorldProvider: Failed to create a WorldProvider from name '{}', or it was already that type", newClassName);
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        ForgeWorld world = ((ForgeEngine)OTG.getEngine()).getWorld(event.getWorld());
        if (world != null) {
            ((ForgeWorldSession)world.getWorldSession()).getPregenerator().savePregeneratorData();
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            boolean serverStopping;
            World mcWorld = event.getWorld();
            MinecraftServer mcServer = mcWorld.func_73046_m();
            if (mcServer == null) {
                mcServer = this.getClientServer();
            }
            boolean bl = serverStopping = !mcServer.func_71278_l();
            if (event.getWorld().func_175624_G() instanceof OTGWorldType) {
                int dimId = event.getWorld().field_73011_w.getDimension();
                ForgeWorld forgeWorld = ((ForgeEngine)OTG.getEngine()).getWorld(mcWorld);
                if (forgeWorld == null) {
                    return;
                }
                if (dimId != -1 && dimId != 1) {
                    if (((ForgeEngine)OTG.getEngine()).getWorld(event.getWorld()) != null) {
                        ((ForgeEngine)OTG.getEngine()).getWorldLoader().unloadWorld(event.getWorld(), false);
                    }
                    if (serverStopping) {
                        OTGDimensionManager.UnloadCustomDimensionData(mcWorld.field_73011_w.getDimension());
                        forgeWorld.unRegisterBiomes();
                        ((ForgeWorldSession)forgeWorld.getWorldSession()).getPregenerator().shutDown();
                    }
                }
            }
            if (serverStopping) {
                for (ForgeWorld unloadedWorld : ((ForgeEngine)OTG.getEngine()).getUnloadedWorlds()) {
                    if (unloadedWorld.getWorld() == mcWorld) continue;
                    OTGDimensionManager.UnloadCustomDimensionData(unloadedWorld.getWorld().field_73011_w.getDimension());
                    unloadedWorld.unRegisterBiomes();
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private MinecraftServer getClientServer() {
        return Minecraft.func_71410_x().func_71401_C();
    }

    @SubscribeEvent
    public void onCreateWorldSpawn(WorldEvent.CreateSpawnPosition event) {
        ForgeWorld world = ((ForgeEngine)OTG.getEngine()).getWorld(event.getWorld());
        if (world != null) {
            event.setCanceled(true);
        }
    }

    private static void createSpawnPosition(ForgeWorld forgeWorld, DimensionConfig dimConfig) {
        if (dimConfig.Settings.SpawnPointSet) {
            BlockPos spawnPosition = new BlockPos(dimConfig.Settings.SpawnPointX, dimConfig.Settings.SpawnPointY, dimConfig.Settings.SpawnPointZ);
            forgeWorld.getWorld().func_72912_H().func_176143_a(spawnPosition);
        } else {
            forgeWorld.getWorld().field_72987_B = true;
            BiomeProvider biomeprovider = forgeWorld.getWorld().field_73011_w.func_177499_m();
            List list = biomeprovider.func_76932_a();
            Random random = new Random(forgeWorld.getSeed());
            int range = 1024;
            BlockPos blockpos = biomeprovider.func_180630_a(0, 0, range, list, random);
            int i = 8;
            int j = forgeWorld.getWorld().field_73011_w.func_76557_i();
            int k = 8;
            if (blockpos != null) {
                i = blockpos.func_177958_n();
                k = blockpos.func_177952_p();
            } else {
                OTG.log(LogMarker.INFO, "Unable to find spawn biome", new Object[0]);
            }
            int l = 0;
            while (!forgeWorld.getWorld().field_73011_w.func_76566_a(i, k)) {
                i += random.nextInt(64) - random.nextInt(64);
                k += random.nextInt(64) - random.nextInt(64);
                if (++l != 1000) continue;
            }
            ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(i, k);
            if (forgeWorld.getConfigs().getWorldConfig().bo3AtSpawn != null && forgeWorld.getConfigs().getWorldConfig().bo3AtSpawn.trim().length() > 0) {
                i = chunkCoord.getBlockX() + 15;
                k = chunkCoord.getBlockZ() + 15;
            }
            forgeWorld.getWorld().func_72912_H().func_176143_a(new BlockPos(i, j, k));
            forgeWorld.getWorld().field_72987_B = false;
            dimConfig.Settings.SpawnPointX = i;
            dimConfig.Settings.SpawnPointY = j;
            dimConfig.Settings.SpawnPointZ = k;
            OTG.getDimensionsConfig().save();
        }
    }

    protected static void createBonusChest(World world) {
        int k;
        int j;
        BlockPos blockpos;
        WorldGeneratorBonusChest worldgeneratorbonuschest = new WorldGeneratorBonusChest();
        for (int i = 0; i < 10 && !worldgeneratorbonuschest.func_180709_b(world, world.field_73012_v, blockpos = world.func_175672_r(new BlockPos(j = world.func_72912_H().func_76079_c() + world.field_73012_v.nextInt(6) - world.field_73012_v.nextInt(6), 0, k = world.func_72912_H().func_76074_e() + world.field_73012_v.nextInt(6) - world.field_73012_v.nextInt(6))).func_177984_a()); ++i) {
        }
    }
}

