/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.events;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.exception.BiomeNotFoundException;
import com.pg85.otg.logging.LogMarker;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class BiomeColorsListener {
    private ResourceLocation lastBiome = null;
    private BiomeConfig lastBiomeConfig;

    @SubscribeEvent
    public void grassColor(BiomeEvent.GetGrassColor grassColorEvent) {
        if (!grassColorEvent.getBiome().getRegistryName().func_110624_b().equals("openterraingenerator")) {
            return;
        }
        BiomeConfig biomeConfig = this.lastBiomeConfig;
        if (this.lastBiome == null || this.lastBiomeConfig == null || !grassColorEvent.getBiome().getRegistryName().equals((Object)this.lastBiome)) {
            biomeConfig = this.getBiomeConfig(grassColorEvent.getBiome());
        }
        this.lastBiome = grassColorEvent.getBiome().getRegistryName();
        this.lastBiomeConfig = biomeConfig;
        if (biomeConfig == null) {
            return;
        }
        if (biomeConfig.grassColor == 0xFFFFFF) {
            return;
        }
        if (biomeConfig.grassColorIsMultiplier) {
            grassColorEvent.setNewColor((grassColorEvent.getOriginalColor() + biomeConfig.grassColor) / 2);
        }
    }

    @SubscribeEvent
    public void foliageColor(BiomeEvent.GetFoliageColor foliageColorEvent) {
        if (!foliageColorEvent.getBiome().getRegistryName().func_110624_b().equals("openterraingenerator")) {
            return;
        }
        BiomeConfig biomeConfig = this.lastBiomeConfig;
        if (this.lastBiome == null || this.lastBiomeConfig == null || !foliageColorEvent.getBiome().getRegistryName().equals((Object)this.lastBiome)) {
            biomeConfig = this.getBiomeConfig(foliageColorEvent.getBiome());
        }
        this.lastBiome = foliageColorEvent.getBiome().getRegistryName();
        this.lastBiomeConfig = biomeConfig;
        if (biomeConfig == null) {
            return;
        }
        if (biomeConfig.foliageColor == 0xFFFFFF) {
            return;
        }
        if (biomeConfig.foliageColorIsMultiplier) {
            foliageColorEvent.setNewColor((foliageColorEvent.getOriginalColor() + biomeConfig.foliageColor) / 2);
        }
    }

    @SubscribeEvent
    public void waterColor(BiomeEvent.GetWaterColor waterColorEvent) {
        if (!waterColorEvent.getBiome().getRegistryName().func_110624_b().equals("openterraingenerator")) {
            return;
        }
        BiomeConfig biomeConfig = this.lastBiomeConfig;
        if (this.lastBiome == null || this.lastBiomeConfig == null || !waterColorEvent.getBiome().getRegistryName().equals((Object)this.lastBiome)) {
            biomeConfig = this.getBiomeConfig(waterColorEvent.getBiome());
        }
        this.lastBiome = waterColorEvent.getBiome().getRegistryName();
        this.lastBiomeConfig = biomeConfig;
        if (biomeConfig == null) {
            return;
        }
        if (biomeConfig.waterColor == 0xFFFFFF) {
            return;
        }
        waterColorEvent.setNewColor(biomeConfig.waterColor);
    }

    public BiomeConfig getBiomeConfig(Biome input) {
        LocalBiome biome = null;
        try {
            biome = OTG.getBiome(input.func_185359_l(), input.getRegistryName().func_110623_a().split("_")[0]);
            if (biome == null) {
                OTG.log(LogMarker.INFO, "Could not find biome " + input.func_185359_l() + " - " + input.getRegistryName().toString(), new Object[0]);
                return null;
            }
        }
        catch (BiomeNotFoundException e) {
            return null;
        }
        catch (NoSuchMethodError e) {
            return null;
        }
        return biome.getBiomeConfig();
    }

    public void reload() {
        this.lastBiomeConfig = null;
    }
}

