/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.bo4.BO4;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.commands.BaseCommand;
import com.pg85.otg.forge.world.ForgeWorld;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.Rotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class SpawnCommand
extends BaseCommand {
    SpawnCommand() {
        this.name = "spawn";
        this.usage = "spawn <object name> [targetBiome1, targetBiome2, ...]";
        this.description = "Spawn a BO3 or BO4 object. For BO3 CustomObject, spawns the object on the block you are looking at. For BO4 CustomStructure, plots the structure in nearby unpopulated chunks, targetBiomes can be provided, otherwise all biomes are allowed. BO3 CustomStructructures are not supported for this command. If spawning a BO3 object, you can specify rotation with [west] or [east]";
    }

    @Override
    public boolean onCommand(ICommandSender sender, List<String> args) {
        Rotation rot;
        ForgeWorld forgeWorld;
        String objectName;
        Random random = new Random();
        String argsString = StringUtils.join(args, (String)" ").trim();
        ArrayList<String> targetBiomes = new ArrayList<String>();
        if (argsString.contains("[")) {
            String[] nameAndBiomesArr = argsString.split("\\[");
            objectName = nameAndBiomesArr[0].trim();
            String[] biomeNames = nameAndBiomesArr[1].replace("]", "").trim().split(",");
            for (String biomeName : biomeNames) {
                targetBiomes.add(biomeName.trim());
            }
        } else {
            objectName = argsString;
        }
        if ((forgeWorld = ((ForgeEngine)OTG.getEngine()).getWorld(sender.func_130014_f_())) == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(ERROR_COLOR + "/otg spawn is not available for non-OTG dimensions."));
            return true;
        }
        if (args.isEmpty()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(ERROR_COLOR + "You must enter the name of the object."));
            return true;
        }
        CustomObject spawnObject = null;
        if (forgeWorld != null) {
            spawnObject = OTG.getCustomObjectManager().getGlobalObjects().getObjectByName(objectName, forgeWorld.getName(), false);
        }
        if (spawnObject == null) {
            for (LocalWorld localWorld : OTG.getAllWorlds()) {
                if (localWorld != forgeWorld) {
                    spawnObject = OTG.getCustomObjectManager().getGlobalObjects().getObjectByName(objectName, localWorld.getName(), false);
                }
                if (spawnObject == null) continue;
                break;
            }
        }
        if (spawnObject == null) {
            spawnObject = OTG.getCustomObjectManager().getGlobalObjects().getObjectByName(objectName, null, true);
        }
        if (spawnObject == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(ERROR_COLOR + "Object not found."));
            return true;
        }
        if (spawnObject instanceof BO4) {
            if (!forgeWorld.isBo4Enabled()) {
                sender.func_145747_a((ITextComponent)new TextComponentString(ERROR_COLOR + "Cannot spawn a BO4 structure in an isOTGPlus:false world, use a BO3 instead or recreate the world with IsOTGPlus:true in the worldconfig."));
                return true;
            }
            BlockPos pos = sender.func_180425_c();
            int playerX = pos.func_177958_n();
            int playerZ = pos.func_177952_p();
            ChunkCoordinate playerChunk = ChunkCoordinate.fromBlockCoords(playerX, playerZ);
            int maxRadius = 1000;
            for (int cycle = 1; cycle < maxRadius; ++cycle) {
                for (int x1 = playerX - cycle; x1 <= playerX + cycle; ++x1) {
                    for (int z1 = playerZ - cycle; z1 <= playerZ + cycle; ++z1) {
                        ChunkCoordinate chunkCoordSpawned;
                        if (x1 != playerX - cycle && x1 != playerX + cycle && z1 != playerZ - cycle && z1 != playerZ + cycle) continue;
                        ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(playerChunk.getChunkX() + (x1 - playerX), playerChunk.getChunkZ() + (z1 - playerZ));
                        if (sender.func_130014_f_().func_190526_b(chunkCoord.getBlockXCenter(), chunkCoord.getBlockZCenter()) || (chunkCoordSpawned = forgeWorld.getStructureCache().plotBo4Structure((BO4)spawnObject, targetBiomes, chunkCoord)) == null) continue;
                        sender.func_145747_a((ITextComponent)new TextComponentString(BaseCommand.MESSAGE_COLOR + spawnObject.getName() + " was spawned at X " + chunkCoordSpawned.getBlockXCenter() + " Z " + chunkCoordSpawned.getBlockZCenter()));
                        return true;
                    }
                }
            }
            sender.func_145747_a((ITextComponent)new TextComponentString(BaseCommand.MESSAGE_COLOR + spawnObject.getName() + " could not be spawned. This can happen if the world is currently generating chunks, if no biomes with enough space could be found, or if there is an error in the structure's files. Enable SpawnLog:true in OTG.ini and check the logs for more information."));
            return true;
        }
        RayTraceResult trace = this.rayTrace(sender.func_130014_f_(), (EntityPlayer)sender.func_174793_f());
        Rotation rotation = rot = targetBiomes.isEmpty() ? Rotation.NORTH : Rotation.FromString((String)targetBiomes.get(0));
        if (trace != null && trace.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = trace.func_178782_a();
            if (spawnObject.spawnForced(forgeWorld, random, rot, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
                sender.func_145747_a((ITextComponent)new TextComponentString(BaseCommand.MESSAGE_COLOR + spawnObject.getName() + " was spawned."));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(BaseCommand.ERROR_COLOR + "Object can't be spawned over there."));
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(ERROR_COLOR + "No block in sight."));
        }
        return true;
    }

    protected RayTraceResult rayTrace(World worldIn, EntityPlayer playerIn) {
        float f = playerIn.field_70125_A;
        float f1 = playerIn.field_70177_z;
        double d0 = playerIn.field_70165_t;
        double d1 = playerIn.field_70163_u + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70161_v;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = 200.0;
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return worldIn.func_147447_a(vec3d, vec3d1, false, true, false);
    }
}

