/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.ConfigFunction;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.bo4.BO4;
import com.pg85.otg.customobjects.structures.StructuredCustomObject;
import com.pg85.otg.customobjects.structures.bo4.BO4CustomStructure;
import com.pg85.otg.customobjects.structures.bo4.BO4CustomStructureCoordinate;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.forge.commands.BaseCommand;
import com.pg85.otg.generator.resource.CustomStructureGen;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.bo3.Rotation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class ExportDataCommand
extends BaseCommand {
    ExportDataCommand() {
        this.name = "exportBO4Data";
        this.usage = "exportBO4Data";
        this.description = "Exports all BO4 files and BO3 files that have isOTGPlus:true as BO4Data files (if none exist already). BO4Data files can significantly reduce filesize and loading times, and should be used by OTG content creators when packaging presets for players.";
    }

    @Override
    public boolean onCommand(ICommandSender sender, List<String> args) {
        LocalWorld world = this.getWorld(sender, "");
        if (world.getConfigs().getWorldConfig().isOTGPlus) {
            sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "Exporting .BO4Data files for world, this may take a while."));
            OTG.log(LogMarker.INFO, "Initializing and exporting structure starts", new Object[0]);
            DimensionConfig dimConfig = OTG.getDimensionsConfig().getDimensionConfig(world.getName());
            for (LocalBiome biome : world.getAllBiomes()) {
                for (ConfigFunction configFunction : biome.getBiomeConfig().resourceSequence) {
                    if (!(configFunction instanceof CustomStructureGen)) continue;
                    for (StructuredCustomObject structure : ((CustomStructureGen)configFunction).getObjects(dimConfig.PresetName)) {
                        if (structure == null || !(structure instanceof BO4) || OTG.bo4DataExists(((BO4)structure).getConfig())) continue;
                        BO4CustomStructureCoordinate structureCoord = new BO4CustomStructureCoordinate(world, structure, null, Rotation.NORTH, 0, 0, 0, 0, false, false, null);
                        BO4CustomStructure structureStart = new BO4CustomStructure(world, structureCoord);
                        try {
                            structureStart.getMinimumSize(world);
                        }
                        catch (InvalidConfigException e) {
                            ((BO4)structure).isInvalidConfig = true;
                        }
                        OTG.log(LogMarker.INFO, "Exporting .BO4Data for structure start " + ((BO4)structure).getName(), new Object[0]);
                        OTG.generateBO4Data(((BO4)structure).getConfig());
                        OTG.getEngine().getCustomObjectManager().getGlobalObjects().unloadCustomObjectFiles();
                    }
                }
            }
            ArrayList<String> boNames = OTG.getEngine().getCustomObjectManager().getGlobalObjects().getAllBONamesForWorld(dimConfig.PresetName);
            int i = 0;
            for (String string : boNames) {
                ++i;
                CustomObject bo = OTG.getEngine().getCustomObjectManager().getGlobalObjects().getObjectByName(string, dimConfig.PresetName);
                if (bo == null || !(bo instanceof BO4) || OTG.bo4DataExists(((BO4)bo).getConfig())) continue;
                OTG.log(LogMarker.INFO, "Exporting .BO4Data " + i + "/" + boNames.size() + " " + string, new Object[0]);
                OTG.generateBO4Data(((BO4)bo).getConfig());
                OTG.getEngine().getCustomObjectManager().getGlobalObjects().unloadCustomObjectFiles();
            }
            sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + ".BO4Data export complete."));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "The ExportBO4Data command is only available for IsOTGPlus:true worlds."));
        }
        return true;
    }
}

