/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.pg85.otg.OTG;
import com.pg85.otg.forge.commands.BaseCommand;
import com.pg85.otg.forge.util.BO3Creator;
import com.pg85.otg.forge.util.BO4Creator;
import com.pg85.otg.forge.util.BOCreator;
import com.pg85.otg.logging.LogMarker;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.forge.ForgeWorldEdit;
import com.sk89q.worldedit.regions.Region;
import java.io.File;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.Loader;

public class ExportCommand
extends BaseCommand {
    private final boolean hasWorldedit;

    public ExportCommand() {
        this.name = "export";
        this.usage = "export <name> [center_block] [-a include_air] [-t include_tile_entities] [-o override] [-bo4] [-b use branches]";
        this.hasWorldedit = Loader.isModLoaded((String)"worldedit");
    }

    @Override
    public boolean onCommand(ICommandSender sender, List<String> args) {
        String block;
        Region selection;
        if (!this.hasWorldedit) {
            sender.func_145747_a((ITextComponent)new TextComponentString(ERROR_COLOR + "You must have WorldEdit installed to use this command."));
            return true;
        }
        if (args.isEmpty()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(ERROR_COLOR + "You must enter a name for the object."));
            sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + this.usage));
            return true;
        }
        EntityPlayerMP player = (EntityPlayerMP)sender;
        LocalSession session = ForgeWorldEdit.inst.getSession(player);
        try {
            selection = session.getSelection(session.getSelectionWorld());
        }
        catch (Exception e) {
            selection = null;
        }
        if (selection == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(ERROR_COLOR + "No WorldEdit selection found."));
            return true;
        }
        String bo3Name = args.get(0);
        File target = new File(OTG.getEngine().getGlobalObjectsDirectory(), bo3Name + (args.contains("-bo4") ? ".BO4" : ".bo3"));
        if (target.exists() && !args.contains("-o")) {
            sender.func_145747_a((ITextComponent)new TextComponentString(ERROR_COLOR + "A " + (args.contains("-bo4") ? "BO4" : "BO3") + " with that name already exists, use -o to override."));
            return true;
        }
        BOCreator creator = args.contains("-bo4") ? new BO4Creator(bo3Name) : new BO3Creator(bo3Name);
        creator.includeAir(args.contains("-a"));
        creator.includeTiles(args.contains("-t"));
        String string = block = args.size() > 1 && args.get(1).charAt(0) != '-' ? args.get(1) : "";
        boolean branch = args.contains("-bo4") ? args.contains("-b") || selection.getWidth() > 16 || selection.getLength() > 16 : args.contains("-b") || selection.getWidth() > 32 || selection.getLength() > 32;
        creator.author(sender.func_70005_c_());
        creator.create(selection, sender.func_130014_f_(), block, branch);
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format("%sBO%s %s%s (%dx%dx%d) %1$shas been saved to GlobalObjects.", MESSAGE_COLOR, args.contains("-bo4") ? "4" : "3", VALUE_COLOR, bo3Name, selection.getWidth(), selection.getHeight(), selection.getLength())));
        if (branch) {
            if (args.contains("-bo4")) {
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "BO4 is larger than 16x16 so it has been split into branches."));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "BO3 is larger than 32x32 so it has been split into branches."));
            }
        }
        OTG.log(LogMarker.INFO, "Unloading BO2/BO3/BO4 files", new Object[0]);
        OTG.getEngine().getCustomObjectManager().reloadCustomObjectFiles();
        return true;
    }
}

