/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.blocks.portal;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.configuration.dimensions.DimensionsConfig;
import com.pg85.otg.forge.blocks.BlockBreakableBase;
import com.pg85.otg.forge.blocks.portal.OTGBlockPatternHelper;
import com.pg85.otg.forge.blocks.portal.OTGBlockPortalSize;
import com.pg85.otg.forge.blocks.portal.PortalColors;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPortalOTG
extends BlockBreakableBase {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177706_a((String)"axis", EnumFacing.Axis.class, (Enum[])new EnumFacing.Axis[]{EnumFacing.Axis.X, EnumFacing.Axis.Z});
    protected static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    protected static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    protected static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);

    public BlockPortalOTG(String name) {
        super(name, Material.field_151567_E);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X));
        this.func_149675_a(true);
        this.func_149711_c(-1.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149715_a(0.75f);
    }

    public static boolean trySpawnPortal(World worldIn, BlockPos pos) {
        boolean bFound = false;
        for (int i : OTGDimensionManager.GetOTGDimensions()) {
            if (!DimensionManager.isDimensionRegistered((int)i)) continue;
            bFound = true;
            break;
        }
        if (!bFound) {
            return false;
        }
        OTGBlockPortalSize blockportal$size = new OTGBlockPortalSize(worldIn, pos, EnumFacing.Axis.X);
        if (blockportal$size.isValid() && blockportal$size.portalBlockCount == 0) {
            blockportal$size.placePortalBlocks();
            return true;
        }
        OTGBlockPortalSize blockportal$size1 = new OTGBlockPortalSize(worldIn, pos, EnumFacing.Axis.Z);
        if (blockportal$size1.isValid() && blockportal$size1.portalBlockCount == 0) {
            blockportal$size1.placePortalBlocks();
            return true;
        }
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
            case X: {
                return X_AABB;
            }
            default: {
                return Y_AABB;
            }
            case Z: 
        }
        return Z_AABB;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int spawnChance;
        super.func_180650_b(worldIn, pos, state, rand);
        String portalColor = PortalColors.getPortalColorByPortalBlock(this);
        DimensionsConfig dimsConfig = OTG.getDimensionsConfig();
        DimensionConfig dimConfig = null;
        if (dimsConfig.Overworld.Settings.PortalColor.equals(portalColor)) {
            dimConfig = dimsConfig.Overworld;
        } else if (dimsConfig.Dimensions != null) {
            for (DimensionConfig dimConfig2 : dimsConfig.Dimensions) {
                if (!portalColor.equals(dimConfig2.Settings.PortalColor.toLowerCase())) continue;
                dimConfig = dimConfig2;
                break;
            }
        }
        ResourceLocation entityType = dimConfig == null ? new ResourceLocation("zombie_pigman") : new ResourceLocation(dimConfig.Settings.PortalMobType);
        int n = spawnChance = dimConfig == null ? 2000 : dimConfig.Settings.PortalMobSpawnChance;
        if (worldIn.field_73011_w.func_76569_d() && worldIn.func_82736_K().func_82766_b("doMobSpawning") && spawnChance > 0 && rand.nextInt(spawnChance) < worldIn.func_175659_aa().func_151525_a()) {
            Entity entity;
            int i = pos.func_177956_o();
            BlockPos blockpos = pos;
            while (!worldIn.func_180495_p(blockpos).func_185896_q() && blockpos.func_177956_o() > 0) {
                blockpos = blockpos.func_177977_b();
            }
            if (i > 0 && !worldIn.func_180495_p(blockpos.func_177984_a()).func_185915_l() && entityType != null && (entity = ItemMonsterPlacer.func_77840_a((World)worldIn, (ResourceLocation)entityType, (double)((double)blockpos.func_177958_n() + 0.5), (double)((double)blockpos.func_177956_o() + 1.1), (double)((double)blockpos.func_177952_p() + 0.5))) != null) {
                entity.field_71088_bW = entity.func_82147_ab();
            }
        }
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public static int getMetaForAxis(EnumFacing.Axis axis) {
        if (axis == EnumFacing.Axis.X) {
            return 1;
        }
        return axis == EnumFacing.Axis.Z ? 2 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)((meta & 3) == 2 ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        OTGBlockPortalSize blockportal$size1;
        EnumFacing.Axis enumfacing$axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        if (enumfacing$axis == EnumFacing.Axis.X) {
            OTGBlockPortalSize blockportal$size = new OTGBlockPortalSize(worldIn, pos, EnumFacing.Axis.X);
            if (!blockportal$size.isValid() || blockportal$size.portalBlockCount < blockportal$size.width * blockportal$size.height) {
                worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        } else if (!(enumfacing$axis != EnumFacing.Axis.Z || (blockportal$size1 = new OTGBlockPortalSize(worldIn, pos, EnumFacing.Axis.Z)).isValid() && blockportal$size1.portalBlockCount >= blockportal$size1.width * blockportal$size1.height)) {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        boolean flag5;
        pos = pos.func_177972_a(side);
        EnumFacing.Axis enumfacing$axis = null;
        if (blockState.func_177230_c() == this) {
            enumfacing$axis = (EnumFacing.Axis)blockState.func_177229_b(AXIS);
            if (enumfacing$axis == null) {
                return false;
            }
            if (enumfacing$axis == EnumFacing.Axis.Z && side != EnumFacing.EAST && side != EnumFacing.WEST) {
                return false;
            }
            if (enumfacing$axis == EnumFacing.Axis.X && side != EnumFacing.SOUTH && side != EnumFacing.NORTH) {
                return false;
            }
        }
        boolean flag = blockAccess.func_180495_p(pos.func_177976_e()).func_177230_c() == this && blockAccess.func_180495_p(pos.func_177985_f(2)).func_177230_c() != this;
        boolean flag1 = blockAccess.func_180495_p(pos.func_177974_f()).func_177230_c() == this && blockAccess.func_180495_p(pos.func_177965_g(2)).func_177230_c() != this;
        boolean flag2 = blockAccess.func_180495_p(pos.func_177978_c()).func_177230_c() == this && blockAccess.func_180495_p(pos.func_177964_d(2)).func_177230_c() != this;
        boolean flag3 = blockAccess.func_180495_p(pos.func_177968_d()).func_177230_c() == this && blockAccess.func_180495_p(pos.func_177970_e(2)).func_177230_c() != this;
        boolean flag4 = flag || flag1 || enumfacing$axis == EnumFacing.Axis.X;
        boolean bl = flag5 = flag2 || flag3 || enumfacing$axis == EnumFacing.Axis.Z;
        if (flag4 && side == EnumFacing.WEST) {
            return true;
        }
        if (flag4 && side == EnumFacing.EAST) {
            return true;
        }
        if (flag5 && side == EnumFacing.NORTH) {
            return true;
        }
        return flag5 && side == EnumFacing.SOUTH;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!entityIn.func_184207_aI() && entityIn.func_184222_aU()) {
            if (entityIn.func_184218_aH()) {
                Entity entityRiding = entityIn.func_184187_bx();
                this.setPortal(pos, entityRiding);
            }
            this.setPortal(pos, entityIn);
        }
    }

    public void setPortal(BlockPos pos, Entity _this) {
        if (_this.field_71088_bW > 0) {
            _this.field_71088_bW = _this.func_82147_ab();
        } else {
            if (!_this.field_70170_p.field_72995_K && !pos.equals((Object)_this.field_181016_an)) {
                _this.field_181016_an = new BlockPos((Vec3i)pos);
                BlockPattern.PatternHelper blockpattern$patternhelper = OTGBlockPatternHelper.createPatternHelper(_this.field_70170_p, _this.field_181016_an != null ? _this.field_181016_an : _this.func_180425_c());
                double d0 = blockpattern$patternhelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? (double)blockpattern$patternhelper.func_181117_a().func_177952_p() : (double)blockpattern$patternhelper.func_181117_a().func_177958_n();
                double d1 = blockpattern$patternhelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? _this.field_70161_v : _this.field_70165_t;
                d1 = Math.abs(MathHelper.func_181160_c((double)(d1 - (double)(blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? 1 : 0)), (double)d0, (double)(d0 - (double)blockpattern$patternhelper.func_181118_d())));
                double d2 = MathHelper.func_181160_c((double)(_this.field_70163_u - 1.0), (double)blockpattern$patternhelper.func_181117_a().func_177956_o(), (double)(blockpattern$patternhelper.func_181117_a().func_177956_o() - blockpattern$patternhelper.func_181119_e()));
                _this.field_181017_ao = new Vec3d(d1, d2, 0.0);
                _this.field_181018_ap = blockpattern$patternhelper.func_177669_b();
            }
            _this.field_71087_bX = true;
        }
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        EnumParticleTypes particleType;
        if (rand.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        String portalColor = PortalColors.getPortalColorByPortalBlock(this);
        DimensionsConfig dimsConfig = OTG.getDimensionsConfig();
        DimensionConfig dimConfig = null;
        if (dimsConfig.Overworld.Settings.PortalColor.equals(portalColor)) {
            dimConfig = dimsConfig.Overworld;
        } else if (dimsConfig.Dimensions != null) {
            for (DimensionConfig dimConfig2 : dimsConfig.Dimensions) {
                if (!portalColor.equals(dimConfig2.Settings.PortalColor.toLowerCase())) continue;
                dimConfig = dimConfig2;
                break;
            }
        }
        EnumParticleTypes enumParticleTypes = particleType = dimConfig == null ? EnumParticleTypes.PORTAL : EnumParticleTypes.func_186831_a((String)dimConfig.Settings.PortalParticleType);
        if (particleType != null) {
            for (int i = 0; i < 4; ++i) {
                double d0 = (float)pos.func_177958_n() + rand.nextFloat();
                double d1 = (float)pos.func_177956_o() + rand.nextFloat();
                double d2 = (float)pos.func_177952_p() + rand.nextFloat();
                double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
                double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
                double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
                int j = rand.nextInt(2) * 2 - 1;
                if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() != this && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                    d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                    d3 = rand.nextFloat() * 2.0f * (float)j;
                } else {
                    d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                    d5 = rand.nextFloat() * 2.0f * (float)j;
                }
                worldIn.func_175688_a(particleType, d0, d1, d2, d3, d4, d5, new int[0]);
            }
        }
    }

    public int func_176201_c(IBlockState state) {
        return BlockPortalOTG.getMetaForAxis((EnumFacing.Axis)state.func_177229_b(AXIS));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
                    case X: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Z);
                    }
                    case Z: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

