/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.structures.bo3;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.customobjects.bo3.BO3;
import com.pg85.otg.customobjects.structures.CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.StructuredCustomObject;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.BoundingBox;
import com.pg85.otg.util.bo3.Rotation;

public class BO3CustomStructureCoordinate
extends CustomStructureCoordinate {
    public BO3CustomStructureCoordinate(LocalWorld world, StructuredCustomObject object, String customObjectName, Rotation rotation, int x, short y, int z) {
        this.worldName = world.getName();
        this.object = object;
        this.bo3Name = object != null ? object.getName() : (customObjectName != null && customObjectName.length() > 0 ? customObjectName : null);
        this.rotation = rotation;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public ChunkCoordinate getPopulatingChunk() {
        StructuredCustomObject object = this.getObject();
        if (object == null) {
            return null;
        }
        if (!(object instanceof BO3)) {
            if (OTG.getPluginConfig().spawnLog) {
                OTG.log(LogMarker.WARN, "BO3CustomStructure loaded with non-BO3 object " + object.getName(), new Object[0]);
            }
            return null;
        }
        BoundingBox box = ((BO3)object).getBoundingBox(this.rotation);
        int centerX = this.x + box.getMinX() + box.getWidth() / 2;
        int centerZ = this.z + box.getMinZ() + box.getDepth() / 2;
        return ChunkCoordinate.getPopulatingChunk(centerX, centerZ);
    }
}

