/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.structures;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.standard.WorldStandardValues;
import com.pg85.otg.customobjects.bo3.bo3function.BO3ModDataFunction;
import com.pg85.otg.customobjects.bo3.bo3function.BO3ParticleFunction;
import com.pg85.otg.customobjects.bo3.bo3function.BO3SpawnerFunction;
import com.pg85.otg.customobjects.bo4.bo4function.BO4ModDataFunction;
import com.pg85.otg.customobjects.bo4.bo4function.BO4ParticleFunction;
import com.pg85.otg.customobjects.bo4.bo4function.BO4SpawnerFunction;
import com.pg85.otg.customobjects.bofunctions.ModDataFunction;
import com.pg85.otg.customobjects.bofunctions.ParticleFunction;
import com.pg85.otg.customobjects.bofunctions.SpawnerFunction;
import com.pg85.otg.customobjects.structures.CustomStructure;
import com.pg85.otg.customobjects.structures.CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.PlottedChunksRegion;
import com.pg85.otg.customobjects.structures.StructureDataRegion;
import com.pg85.otg.customobjects.structures.bo3.BO3CustomStructure;
import com.pg85.otg.customobjects.structures.bo3.BO3CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.bo4.BO4CustomStructure;
import com.pg85.otg.customobjects.structures.bo4.BO4CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.bo4.CustomStructurePlaceHolder;
import com.pg85.otg.customobjects.structures.bo4.smoothing.SmoothingAreaLine;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.CompressionUtils;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.helpers.StreamHelper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;

public class CustomStructureFileManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePlottedChunksData(LocalWorld world, Map<ChunkCoordinate, PlottedChunksRegion> populatedChunks) {
        int dimensionId = world.getDimensionId();
        int regionsSaved = 0;
        if (populatedChunks.size() > 0) {
            for (Map.Entry<ChunkCoordinate, PlottedChunksRegion> chunkPerRegionEntry : populatedChunks.entrySet()) {
                if (!chunkPerRegionEntry.getValue().requiresSave()) continue;
                chunkPerRegionEntry.getValue().markSaved();
                ++regionsSaved;
                File occupiedChunksFile = new File(world.getWorldSaveDir().getAbsolutePath() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : "") + WorldStandardValues.PlottedChunksDataFolderName + File.separator + chunkPerRegionEntry.getKey().getChunkX() + "_" + chunkPerRegionEntry.getKey().getChunkZ() + WorldStandardValues.StructureDataFileExtension);
                File occupiedChunksBackupFile = new File(world.getWorldSaveDir().getAbsolutePath() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : "") + WorldStandardValues.PlottedChunksDataFolderName + File.separator + chunkPerRegionEntry.getKey().getChunkX() + "_" + chunkPerRegionEntry.getKey().getChunkZ() + WorldStandardValues.StructureDataBackupFileExtension);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(bos);
                boolean[][] entriesByStructureName = chunkPerRegionEntry.getValue().getArray();
                try {
                    int version = 1;
                    dos.writeInt(version);
                    dos.writeInt(100);
                    for (int x = 0; x < 100; ++x) {
                        boolean[] structureArr = entriesByStructureName[x];
                        for (int z = 0; z < 100; ++z) {
                            dos.writeBoolean(structureArr[z]);
                        }
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    return;
                }
                FilterOutputStream dos2 = null;
                FileOutputStream fos = null;
                try {
                    if (!occupiedChunksFile.exists()) {
                        occupiedChunksFile.getParentFile().mkdirs();
                    } else {
                        Files.move(occupiedChunksFile.toPath(), occupiedChunksBackupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    byte[] compressedBytes = CompressionUtils.compress(bos.toByteArray());
                    dos.close();
                    fos = new FileOutputStream(occupiedChunksFile);
                    dos2 = new DataOutputStream(fos);
                    ((DataOutputStream)dos2).write(compressedBytes, 0, compressedBytes.length);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    OTG.log(LogMarker.INFO, "OTG encountered an error writing " + occupiedChunksFile.getAbsolutePath() + ", skipping.", new Object[0]);
                }
                finally {
                    try {
                        if (dos != null) {
                            dos.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (dos2 != null) {
                            dos2.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (fos == null) continue;
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        OTG.log(LogMarker.INFO, regionsSaved + " plotted chunk regions saved.", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<ChunkCoordinate, PlottedChunksRegion> loadPlottedChunksData(LocalWorld world) {
        int dimensionId = world.getDimensionId();
        HashMap<ChunkCoordinate, PlottedChunksRegion> output = new HashMap<ChunkCoordinate, PlottedChunksRegion>();
        File occupiedChunksFolder = new File(world.getWorldSaveDir().getAbsolutePath() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : "") + WorldStandardValues.PlottedChunksDataFolderName + File.separator);
        HashMap<File, File> saveFiles = new HashMap<File, File>();
        ArrayList<Object> mainFiles = new ArrayList<Object>();
        ArrayList<Object> backupFiles = new ArrayList<Object>();
        if (occupiedChunksFolder.exists()) {
            for (File file : occupiedChunksFolder.listFiles()) {
                if (file.getPath().endsWith(WorldStandardValues.StructureDataFileExtension) && file.getName().replace(WorldStandardValues.StructureDataFileExtension, "").split("_").length == 2 && MathHelper.tryParseInt(file.getName().replace(WorldStandardValues.StructureDataFileExtension, "").split("_")[0]) && MathHelper.tryParseInt(file.getName().replace(WorldStandardValues.StructureDataFileExtension, "").split("_")[1])) {
                    mainFiles.add(file);
                    continue;
                }
                if (!file.getPath().endsWith(WorldStandardValues.StructureDataBackupFileExtension) || file.getName().replace(WorldStandardValues.BackupFileSuffix, "").split("_").length != 2 || !MathHelper.tryParseInt(file.getName().replace(WorldStandardValues.BackupFileSuffix, "").split("_")[0]) || !MathHelper.tryParseInt(file.getName().replace(WorldStandardValues.BackupFileSuffix, "").split("_")[1])) continue;
                backupFiles.add(file);
            }
            for (File file : mainFiles) {
                boolean bFound = false;
                for (File file2 : backupFiles) {
                    if (!file.getPath().replace(WorldStandardValues.StructureDataFileExtension, "").equals(file2.getPath().replace(WorldStandardValues.StructureDataBackupFileExtension, ""))) continue;
                    saveFiles.put(file, file2);
                    bFound = true;
                    break;
                }
                if (bFound) continue;
                saveFiles.put(file, null);
            }
        }
        for (Map.Entry entry : saveFiles.entrySet()) {
            byte[] decompressedBytes;
            byte[] compressedBytes;
            ByteBuffer buffer;
            int regionZ;
            int regionX;
            String[] chunkCoords;
            PlottedChunksRegion result;
            FileInputStream fis;
            boolean bSuccess = false;
            File file = (File)entry.getKey();
            File file3 = (File)entry.getValue();
            if (!(file != null && file.exists() || file3 != null && file3.exists())) continue;
            ChunkCoordinate regionCoord = null;
            if (file != null && file.exists()) {
                fis = null;
                result = null;
                try {
                    chunkCoords = file.getName().replace(WorldStandardValues.StructureDataFileExtension, "").split("_");
                    regionX = Integer.parseInt(chunkCoords[0]);
                    regionZ = Integer.parseInt(chunkCoords[1]);
                    regionCoord = ChunkCoordinate.fromChunkCoords(regionX, regionZ);
                    fis = new FileInputStream(file);
                    buffer = fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fis.getChannel().size());
                    compressedBytes = new byte[(int)fis.getChannel().size()];
                    buffer.get(compressedBytes);
                    decompressedBytes = CompressionUtils.decompress(compressedBytes);
                    buffer = ByteBuffer.wrap(decompressedBytes);
                    result = CustomStructureFileManager.parsePlottedChunksFileFromStream(buffer, world);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    OTG.log(LogMarker.INFO, "Failed to load " + file.getAbsolutePath() + ", trying to load backup.", new Object[0]);
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.getChannel().close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        try {
                            fis.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (result != null) {
                    bSuccess = true;
                    output.put(regionCoord, result);
                }
            }
            if (!bSuccess && file3 != null && file3.exists()) {
                fis = null;
                result = null;
                try {
                    chunkCoords = file.getName().replace(WorldStandardValues.StructureDataBackupFileExtension, "").split("_");
                    regionX = Integer.parseInt(chunkCoords[0]);
                    regionZ = Integer.parseInt(chunkCoords[1]);
                    regionCoord = ChunkCoordinate.fromChunkCoords(regionX, regionZ);
                    fis = new FileInputStream(file3);
                    buffer = fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fis.getChannel().size());
                    compressedBytes = new byte[(int)fis.getChannel().size()];
                    buffer.get(compressedBytes);
                    decompressedBytes = CompressionUtils.decompress(compressedBytes);
                    buffer = ByteBuffer.wrap(decompressedBytes);
                    result = CustomStructureFileManager.parsePlottedChunksFileFromStream(buffer, world);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.getChannel().close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        try {
                            fis.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (result != null) {
                    bSuccess = true;
                    output.put(regionCoord, result);
                }
            }
            if (bSuccess) continue;
            if (regionCoord != null) {
                output.put(regionCoord, PlottedChunksRegion.getFilledRegion());
                OTG.log(LogMarker.INFO, "OTG encountered an error loading " + file.getAbsolutePath() + " and could not load a backup, substituting a default filled region. This may result in areas with missing BO4's, smoothing areas, /otg structure info and spawners/particles/moddata.", new Object[0]);
                continue;
            }
            throw new RuntimeException("OTG encountered a critical error loading " + file.getAbsolutePath() + " and could not load a backup, exiting. OTG automatically backs up files before writing and will try to use the backup when loading. If your dimension's structure data files and backups have been corrupted, you can delete them,at the risk of losing data for unspawned structure parts.");
        }
        return output.size() > 0 ? output : null;
    }

    private static PlottedChunksRegion parsePlottedChunksFileFromStream(ByteBuffer buffer, LocalWorld world) throws IOException {
        int version = buffer.getInt();
        int regionSize = buffer.getInt();
        boolean[][] chunksMatrix = new boolean[100][100];
        if (regionSize == 100) {
            for (int x = 0; x < regionSize; ++x) {
                for (int z = 0; z < regionSize; ++z) {
                    chunksMatrix[x][z] = buffer.get() != 0;
                }
            }
        } else {
            OTG.log(LogMarker.INFO, "PlottedChunks region files were corrupted or exported with an incompatible version of OTG, ignoring.", new Object[0]);
            return PlottedChunksRegion.getFilledRegion();
        }
        return new PlottedChunksRegion(chunksMatrix);
    }

    static void saveStructureData(Map<ChunkCoordinate, StructureDataRegion> worldInfoChunks, LocalWorld world) {
        int dimensionId = world.getDimensionId();
        int regionsSaved = 0;
        for (Map.Entry<ChunkCoordinate, StructureDataRegion> cachedRegion : worldInfoChunks.entrySet()) {
            if (!cachedRegion.getValue().requiresSave()) continue;
            cachedRegion.getValue().markSaved();
            ++regionsSaved;
            HashMap<String, HashMap<CustomStructure, ArrayList<ChunkCoordinate>>> structuresPerRegion = new HashMap<String, HashMap<CustomStructure, ArrayList<ChunkCoordinate>>>();
            for (int internalX = 0; internalX < 100; ++internalX) {
                for (int internalZ = 0; internalZ < 100; ++internalZ) {
                    ChunkCoordinate worldChunkCoord = ChunkCoordinate.fromChunkCoords(cachedRegion.getKey().getChunkX() * 100 + internalX, cachedRegion.getKey().getChunkZ() * 100 + internalZ);
                    CustomStructure structureInChunk = cachedRegion.getValue().getStructure(internalX, internalZ);
                    if (structureInChunk == null) continue;
                    String startBoName = "NULL";
                    if (structureInChunk.start != null) {
                        startBoName = structureInChunk.start.bo3Name;
                    }
                    HashMap<CustomStructure, ArrayList<ChunkCoordinate>> entryByStructureName = structuresPerRegion.get(startBoName);
                    ArrayList<Object> structureChunks = new ArrayList();
                    if (entryByStructureName == null) {
                        entryByStructureName = new HashMap();
                        entryByStructureName.put(structureInChunk, structureChunks);
                        structuresPerRegion.put(startBoName, entryByStructureName);
                    } else {
                        structureChunks = entryByStructureName.get(structureInChunk);
                        if (structureChunks == null) {
                            structureChunks = new ArrayList();
                            entryByStructureName.put(structureInChunk, structureChunks);
                        }
                    }
                    structureChunks.add(worldChunkCoord);
                }
            }
            CustomStructureFileManager.saveStructuresRegionFile(world, dimensionId, cachedRegion.getKey(), structuresPerRegion);
        }
        OTG.log(LogMarker.INFO, regionsSaved + " structure data regions saved.", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveStructuresRegionFile(LocalWorld world, int dimensionId, ChunkCoordinate regionCoord, HashMap<String, HashMap<CustomStructure, ArrayList<ChunkCoordinate>>> structuresPerRegion) {
        File structuresRegionFile = new File(world.getWorldSaveDir().getAbsolutePath() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : "") + WorldStandardValues.StructureDataFolderName + File.separator + regionCoord.getChunkX() + "_" + regionCoord.getChunkZ() + WorldStandardValues.StructureDataFileExtension);
        File structuresRegionBackupFile = new File(world.getWorldSaveDir().getAbsolutePath() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : "") + WorldStandardValues.StructureDataFolderName + File.separator + regionCoord.getChunkX() + "_" + regionCoord.getChunkZ() + WorldStandardValues.StructureDataBackupFileExtension);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            int version = 1;
            dos.writeInt(version);
            dos.writeInt(structuresPerRegion.entrySet().size());
            for (Map.Entry<String, HashMap<CustomStructure, ArrayList<ChunkCoordinate>>> entry : structuresPerRegion.entrySet()) {
                StreamHelper.writeStringToStream(dos, entry.getKey());
                dos.writeInt(entry.getValue().entrySet().size());
                for (Map.Entry<CustomStructure, ArrayList<ChunkCoordinate>> entry1 : entry.getValue().entrySet()) {
                    CustomStructure structure = entry1.getKey();
                    if (entry1.getKey().start != null) {
                        dos.writeInt(structure.start.rotation.getRotationId());
                        dos.writeInt(structure.start.getX());
                        dos.writeInt(structure.start.getY());
                        dos.writeInt(structure.start.getZ());
                    }
                    dos.writeInt(entry1.getValue().size());
                    for (ChunkCoordinate chunkCoord : entry1.getValue()) {
                        dos.writeInt(chunkCoord.getChunkX());
                        dos.writeInt(chunkCoord.getChunkZ());
                    }
                    if (structure instanceof BO4CustomStructure && ((BO4CustomStructure)structure).objectsToSpawn.entrySet().size() > 0) {
                        dos.writeBoolean(true);
                        HashMap<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> objectsInRegion = new HashMap<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>>();
                        int size = 0;
                        for (Map.Entry<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> entry2 : ((BO4CustomStructure)structure).objectsToSpawn.entrySet()) {
                            if (!entry2.getKey().toRegionCoord().equals(regionCoord)) continue;
                            objectsInRegion.put(entry2.getKey(), entry2.getValue());
                            ++size;
                        }
                        dos.writeInt(size);
                        for (Map.Entry<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> entry3 : objectsInRegion.entrySet()) {
                            ChunkCoordinate chunkCoordinate = entry3.getKey();
                            dos.writeInt(chunkCoordinate.getChunkX());
                            dos.writeInt(chunkCoordinate.getChunkZ());
                            Stack<BO4CustomStructureCoordinate> coords = entry3.getValue();
                            dos.writeInt(coords.size());
                            for (Object coord : coords) {
                                StreamHelper.writeStringToStream(dos, ((CustomStructureCoordinate)coord).bo3Name);
                                dos.writeInt(((CustomStructureCoordinate)coord).rotation.getRotationId());
                                dos.writeInt(((CustomStructureCoordinate)coord).getX());
                                dos.writeInt(((CustomStructureCoordinate)coord).getY());
                                dos.writeInt(((CustomStructureCoordinate)coord).getZ());
                            }
                        }
                    } else {
                        dos.writeBoolean(false);
                    }
                    if (structure instanceof BO4CustomStructure && ((BO4CustomStructure)structure).smoothingAreaManager.smoothingAreasToSpawn.entrySet().size() > 0) {
                        dos.writeBoolean(true);
                        HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingAreasPerRegion = new HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLine>>();
                        int size = 0;
                        for (Map.Entry<ChunkCoordinate, ArrayList<SmoothingAreaLine>> entry4 : ((BO4CustomStructure)structure).smoothingAreaManager.smoothingAreasToSpawn.entrySet()) {
                            if (!entry4.getKey().toRegionCoord().equals(regionCoord)) continue;
                            smoothingAreasPerRegion.put(entry4.getKey(), entry4.getValue());
                            ++size;
                        }
                        dos.writeInt(size);
                        for (Map.Entry entry5 : smoothingAreasPerRegion.entrySet()) {
                            ChunkCoordinate key = (ChunkCoordinate)entry5.getKey();
                            dos.writeInt(key.getChunkX());
                            dos.writeInt(key.getChunkZ());
                            ArrayList coords2 = (ArrayList)entry5.getValue();
                            dos.writeInt(coords2.size());
                            for (Object coord : coords2) {
                                dos.writeInt(((SmoothingAreaLine)coord).beginPointX);
                                dos.writeInt(((SmoothingAreaLine)coord).beginPointY);
                                dos.writeInt(((SmoothingAreaLine)coord).beginPointZ);
                                dos.writeInt(((SmoothingAreaLine)coord).endPointX);
                                dos.writeInt(((SmoothingAreaLine)coord).endPointY);
                                dos.writeInt(((SmoothingAreaLine)coord).endPointZ);
                                dos.writeInt(((SmoothingAreaLine)coord).originPointX);
                                dos.writeInt(((SmoothingAreaLine)coord).originPointY);
                                dos.writeInt(((SmoothingAreaLine)coord).originPointZ);
                                dos.writeInt(((SmoothingAreaLine)coord).finalDestinationPointX);
                                dos.writeInt(((SmoothingAreaLine)coord).finalDestinationPointY);
                                dos.writeInt(((SmoothingAreaLine)coord).finalDestinationPointZ);
                            }
                        }
                    } else {
                        dos.writeBoolean(false);
                    }
                    if (structure.modDataManager.modData.size() > 0) {
                        dos.writeBoolean(true);
                        HashSet modDataPerRegion = new HashSet();
                        int size = 0;
                        for (ModDataFunction<?> modDataFunction : structure.modDataManager.modData) {
                            if (!ChunkCoordinate.fromBlockCoords(modDataFunction.x, modDataFunction.z).toRegionCoord().equals(regionCoord)) continue;
                            modDataPerRegion.add(modDataFunction);
                            ++size;
                        }
                        dos.writeInt(size);
                        for (ModDataFunction<Object> modDataFunction : modDataPerRegion) {
                            dos.writeInt(modDataFunction.x);
                            dos.writeInt(modDataFunction.y);
                            dos.writeInt(modDataFunction.z);
                            StreamHelper.writeStringToStream(dos, modDataFunction.modId.replace(":", "&#58;").replace(" ", "&nbsp;"));
                            StreamHelper.writeStringToStream(dos, modDataFunction.modData.replace(":", "&#58;").replace(" ", "&nbsp;"));
                        }
                    } else {
                        dos.writeBoolean(false);
                    }
                    if (structure.spawnerManager.spawnerData.size() > 0) {
                        dos.writeBoolean(true);
                        HashSet spawnerDataPerRegion = new HashSet();
                        int size = 0;
                        for (SpawnerFunction<?> spawnerFunction : structure.spawnerManager.spawnerData) {
                            if (!ChunkCoordinate.fromBlockCoords(spawnerFunction.x, spawnerFunction.z).toRegionCoord().equals(regionCoord)) continue;
                            spawnerDataPerRegion.add(spawnerFunction);
                            ++size;
                        }
                        dos.writeInt(size);
                        for (SpawnerFunction<Object> spawnerFunction : spawnerDataPerRegion) {
                            dos.writeInt(spawnerFunction.x);
                            dos.writeInt(spawnerFunction.y);
                            dos.writeInt(spawnerFunction.z);
                            StreamHelper.writeStringToStream(dos, spawnerFunction.mobName.replace(":", "&#58;").replace(" ", "&nbsp;"));
                            StreamHelper.writeStringToStream(dos, spawnerFunction.originalnbtFileName.replace(":", "&#58;").replace(" ", "&nbsp;"));
                            StreamHelper.writeStringToStream(dos, spawnerFunction.nbtFileName.replace(":", "&#58;").replace(" ", "&nbsp;"));
                            dos.writeInt(spawnerFunction.groupSize);
                            dos.writeInt(spawnerFunction.interval);
                            dos.writeInt(spawnerFunction.spawnChance);
                            dos.writeInt(spawnerFunction.maxCount);
                            dos.writeInt(spawnerFunction.despawnTime);
                            dos.writeDouble(spawnerFunction.velocityX);
                            dos.writeDouble(spawnerFunction.velocityY);
                            dos.writeDouble(spawnerFunction.velocityZ);
                            dos.writeBoolean(spawnerFunction.velocityXSet);
                            dos.writeBoolean(spawnerFunction.velocityYSet);
                            dos.writeBoolean(spawnerFunction.velocityZSet);
                            dos.writeFloat(spawnerFunction.yaw);
                            dos.writeFloat(spawnerFunction.pitch);
                        }
                    } else {
                        dos.writeBoolean(false);
                    }
                    if (structure.particlesManager.particleData.size() > 0) {
                        dos.writeBoolean(true);
                        HashSet particleDataPerRegion = new HashSet();
                        int size = 0;
                        for (ParticleFunction<?> particleFunction : structure.particlesManager.particleData) {
                            if (!ChunkCoordinate.fromBlockCoords(particleFunction.x, particleFunction.z).toRegionCoord().equals(regionCoord)) continue;
                            particleDataPerRegion.add(particleFunction);
                            ++size;
                        }
                        dos.writeInt(size);
                        for (ParticleFunction<Object> particleFunction : particleDataPerRegion) {
                            dos.writeInt(particleFunction.x);
                            dos.writeInt(particleFunction.y);
                            dos.writeInt(particleFunction.z);
                            StreamHelper.writeStringToStream(dos, particleFunction.particleName.replace(":", "&#58;").replace(" ", "&nbsp;"));
                            dos.writeDouble(particleFunction.interval);
                            dos.writeDouble(particleFunction.velocityX);
                            dos.writeDouble(particleFunction.velocityY);
                            dos.writeDouble(particleFunction.velocityZ);
                            dos.writeBoolean(particleFunction.velocityXSet);
                            dos.writeBoolean(particleFunction.velocityYSet);
                            dos.writeBoolean(particleFunction.velocityZSet);
                        }
                        continue;
                    }
                    dos.writeBoolean(false);
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        FilterOutputStream dos2 = null;
        FileOutputStream fos = null;
        try {
            if (!structuresRegionFile.exists()) {
                structuresRegionFile.getParentFile().mkdirs();
            } else {
                Files.move(structuresRegionFile.toPath(), structuresRegionBackupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            byte[] compressedBytes = CompressionUtils.compress(bos.toByteArray());
            dos.close();
            fos = new FileOutputStream(structuresRegionFile);
            dos2 = new DataOutputStream(fos);
            ((DataOutputStream)dos2).write(compressedBytes, 0, compressedBytes.length);
        }
        catch (IOException e) {
            e.printStackTrace();
            OTG.log(LogMarker.INFO, "OTG encountered an error writing " + structuresRegionFile.getAbsolutePath() + ", skipping.", new Object[0]);
        }
        finally {
            try {
                if (dos != null) {
                    dos.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (dos2 != null) {
                    dos2.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<CustomStructure, ArrayList<ChunkCoordinate>> loadStructureData(LocalWorld world) {
        int dimensionId = world.getDimensionId();
        HashMap<CustomStructure, ArrayList<ChunkCoordinate>> output = new HashMap<CustomStructure, ArrayList<ChunkCoordinate>>();
        File structureDataFolder = new File(world.getWorldSaveDir().getAbsolutePath() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : "") + WorldStandardValues.StructureDataFolderName + File.separator);
        HashMap<File, File> saveFiles = new HashMap<File, File>();
        ArrayList<Object> mainFiles = new ArrayList<Object>();
        ArrayList<Object> backupFiles = new ArrayList<Object>();
        if (structureDataFolder.exists()) {
            for (File file : structureDataFolder.listFiles()) {
                if (file.getPath().endsWith(WorldStandardValues.StructureDataFileExtension) && file.getName().replace(WorldStandardValues.StructureDataFileExtension, "").split("_").length == 2 && MathHelper.tryParseInt(file.getName().replace(WorldStandardValues.StructureDataFileExtension, "").split("_")[0]) && MathHelper.tryParseInt(file.getName().replace(WorldStandardValues.StructureDataFileExtension, "").split("_")[1])) {
                    mainFiles.add(file);
                    continue;
                }
                if (!file.getPath().endsWith(WorldStandardValues.StructureDataBackupFileExtension) || file.getName().replace(WorldStandardValues.BackupFileSuffix, "").split("_").length != 2 || !MathHelper.tryParseInt(file.getName().replace(WorldStandardValues.BackupFileSuffix, "").split("_")[0]) || !MathHelper.tryParseInt(file.getName().replace(WorldStandardValues.BackupFileSuffix, "").split("_")[1])) continue;
                backupFiles.add(file);
            }
            for (File file : mainFiles) {
                boolean bFound = false;
                for (File file2 : backupFiles) {
                    if (!file.getPath().replace(WorldStandardValues.StructureDataFileExtension, "").equals(file2.getPath().replace(WorldStandardValues.StructureDataBackupFileExtension, ""))) continue;
                    saveFiles.put(file, file2);
                    bFound = true;
                    break;
                }
                if (bFound) continue;
                saveFiles.put(file, null);
            }
        }
        for (Map.Entry entry : saveFiles.entrySet()) {
            byte[] decompressedBytes;
            byte[] compressedBytes;
            ByteBuffer buffer;
            int regionZ;
            int regionX;
            HashMap<CustomStructure, ArrayList<ChunkCoordinate>> result;
            FileInputStream fis;
            ChunkCoordinate regionCoord = null;
            boolean bl = false;
            File file = (File)entry.getKey();
            File structureDataBackupFile = (File)entry.getValue();
            if ((file == null || !file.exists()) && (structureDataBackupFile == null || !structureDataBackupFile.exists())) continue;
            if (file != null && file.exists()) {
                fis = null;
                result = null;
                try {
                    regionX = Integer.parseInt(file.getName().replace(WorldStandardValues.StructureDataFileExtension, "").split("_")[0]);
                    regionZ = Integer.parseInt(file.getName().replace(WorldStandardValues.StructureDataFileExtension, "").split("_")[1]);
                    regionCoord = ChunkCoordinate.fromChunkCoords(regionX, regionZ);
                    fis = new FileInputStream(file);
                    buffer = fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fis.getChannel().size());
                    compressedBytes = new byte[(int)fis.getChannel().size()];
                    buffer.get(compressedBytes);
                    decompressedBytes = CompressionUtils.decompress(compressedBytes);
                    buffer = ByteBuffer.wrap(decompressedBytes);
                    result = CustomStructureFileManager.parseStructuresFileFromStream(buffer, regionCoord, world);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    OTG.log(LogMarker.INFO, "Failed to load " + file.getAbsolutePath() + ", trying to load backup.", new Object[0]);
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.getChannel().close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        try {
                            fis.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (result != null) {
                    bl = true;
                    CustomStructureFileManager.mergeRegionData(world, result, output);
                }
            }
            if (!bl && structureDataBackupFile != null && structureDataBackupFile.exists()) {
                fis = null;
                result = null;
                try {
                    regionX = Integer.parseInt(structureDataBackupFile.getName().replace(WorldStandardValues.BackupFileSuffix, "").split("_")[0]);
                    regionZ = Integer.parseInt(structureDataBackupFile.getName().replace(WorldStandardValues.BackupFileSuffix, "").split("_")[1]);
                    regionCoord = ChunkCoordinate.fromChunkCoords(regionX, regionZ);
                    fis = new FileInputStream(structureDataBackupFile);
                    buffer = fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fis.getChannel().size());
                    compressedBytes = new byte[(int)fis.getChannel().size()];
                    buffer.get(compressedBytes);
                    decompressedBytes = CompressionUtils.decompress(compressedBytes);
                    buffer = ByteBuffer.wrap(decompressedBytes);
                    result = CustomStructureFileManager.parseStructuresFileFromStream(buffer, regionCoord, world);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.getChannel().close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        try {
                            fis.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (result != null) {
                    bl = true;
                    CustomStructureFileManager.mergeRegionData(world, result, output);
                }
            }
            if (bl) continue;
            OTG.log(LogMarker.INFO, "OTG encountered an error loading " + file.getAbsolutePath() + " and could not load a backup, ignoring. This may result in areas with missing BO4's, smoothing areas, /otg structure info and spawners/particles/moddata.", new Object[0]);
        }
        return output.size() > 0 ? output : null;
    }

    private static void mergeRegionData(LocalWorld world, HashMap<CustomStructure, ArrayList<ChunkCoordinate>> result, HashMap<CustomStructure, ArrayList<ChunkCoordinate>> output) {
        block0: for (Map.Entry<CustomStructure, ArrayList<ChunkCoordinate>> entryResult : result.entrySet()) {
            if (output.containsKey(entryResult.getKey())) {
                for (Map.Entry<CustomStructure, ArrayList<ChunkCoordinate>> entryOutput : new HashSet<Map.Entry<CustomStructure, ArrayList<ChunkCoordinate>>>(output.entrySet())) {
                    ArrayList<ChunkCoordinate> coords;
                    if (!entryResult.getKey().equals(entryOutput.getKey())) continue;
                    if (entryResult.getKey() instanceof CustomStructurePlaceHolder) {
                        ((CustomStructurePlaceHolder)entryResult.getKey()).mergeWithCustomStructure(world, (BO4CustomStructure)entryOutput.getKey());
                        coords = entryOutput.getValue();
                        coords.addAll((Collection<ChunkCoordinate>)entryResult.getValue());
                        continue block0;
                    }
                    if (!(entryOutput.getKey() instanceof CustomStructurePlaceHolder)) continue block0;
                    ((CustomStructurePlaceHolder)entryOutput.getKey()).mergeWithCustomStructure(world, (BO4CustomStructure)entryResult.getKey());
                    coords = entryResult.getValue();
                    coords.addAll((Collection<ChunkCoordinate>)entryOutput.getValue());
                    output.remove(entryResult.getKey());
                    output.put(entryResult.getKey(), entryResult.getValue());
                    continue block0;
                }
                continue;
            }
            output.put(entryResult.getKey(), entryResult.getValue());
        }
    }

    private static HashMap<CustomStructure, ArrayList<ChunkCoordinate>> parseStructuresFileFromStream(ByteBuffer buffer, ChunkCoordinate regionCoord, LocalWorld world) throws IOException {
        int version = buffer.getInt();
        HashMap<CustomStructure, ArrayList<ChunkCoordinate>> structuresFile = new HashMap<CustomStructure, ArrayList<ChunkCoordinate>>();
        int structureNamesSize = buffer.getInt();
        for (int i = 0; i < structureNamesSize; ++i) {
            String structureName = StreamHelper.readStringFromBuffer(buffer);
            int structuresSize = buffer.getInt();
            for (int j = 0; j < structuresSize; ++j) {
                CustomStructure structure;
                int coordsSize;
                CustomStructureCoordinate structureStart = null;
                if (!structureName.equals("NULL")) {
                    Rotation startRotationId = Rotation.getRotation(buffer.getInt());
                    int startX = buffer.getInt();
                    int startY = buffer.getInt();
                    int startZ = buffer.getInt();
                    structureStart = world.isBo4Enabled() ? new BO4CustomStructureCoordinate(world, null, structureName, startRotationId, startX, (short)startY, startZ, 0, false, false, null) : new BO3CustomStructureCoordinate(world, null, structureName, startRotationId, startX, (short)startY, startZ);
                }
                int chunksSize = buffer.getInt();
                ArrayList<ChunkCoordinate> chunkCoords = new ArrayList<ChunkCoordinate>();
                for (int k = 0; k < chunksSize; ++k) {
                    int chunkX = buffer.getInt();
                    int chunkZ = buffer.getInt();
                    chunkCoords.add(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ));
                }
                HashMap<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> objectsToSpawn = new HashMap<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>>();
                if (buffer.get() != 0) {
                    int objectsToSpawnSize = buffer.getInt();
                    for (int l = 0; l < objectsToSpawnSize; ++l) {
                        ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(buffer.getInt(), buffer.getInt());
                        Stack<BO4CustomStructureCoordinate> coords = new Stack<BO4CustomStructureCoordinate>();
                        coordsSize = buffer.getInt();
                        for (int m = 0; m < coordsSize; ++m) {
                            String bo3Name = StreamHelper.readStringFromBuffer(buffer);
                            Rotation coordRotation = Rotation.getRotation(buffer.getInt());
                            int coordX = buffer.getInt();
                            int coordY = buffer.getInt();
                            int coordZ = buffer.getInt();
                            coords.add(new BO4CustomStructureCoordinate(world, null, bo3Name, coordRotation, coordX, (short)coordY, coordZ, 0, false, false, null));
                        }
                        objectsToSpawn.put(chunkCoord, coords);
                    }
                }
                HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingAreasToSpawn = new HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLine>>();
                if (buffer.get() != 0) {
                    int smoothingAreasToSpawnSize = buffer.getInt();
                    for (int l = 0; l < smoothingAreasToSpawnSize; ++l) {
                        ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(buffer.getInt(), buffer.getInt());
                        coordsSize = buffer.getInt();
                        ArrayList<SmoothingAreaLine> smoothingAreaLines = new ArrayList<SmoothingAreaLine>();
                        for (int m = 0; m < coordsSize; ++m) {
                            int beginPointX = buffer.getInt();
                            int beginPointY = buffer.getInt();
                            int beginPointZ = buffer.getInt();
                            int endPointX = buffer.getInt();
                            int endPointY = buffer.getInt();
                            int endPointZ = buffer.getInt();
                            int originPointX = buffer.getInt();
                            int originPointY = buffer.getInt();
                            int originPointZ = buffer.getInt();
                            int finalDestinationPointX = buffer.getInt();
                            int finalDestinationPointY = buffer.getInt();
                            int finalDestinationPointZ = buffer.getInt();
                            SmoothingAreaLine smoothingAreaLine = new SmoothingAreaLine(beginPointX, (short)beginPointY, beginPointZ, endPointX, (short)endPointY, endPointZ, originPointX, (short)originPointY, originPointZ, finalDestinationPointX, (short)finalDestinationPointY, finalDestinationPointZ);
                            smoothingAreaLines.add(smoothingAreaLine);
                        }
                        smoothingAreasToSpawn.put(chunkCoord, smoothingAreaLines);
                    }
                }
                HashSet<BO4ModDataFunction> modData = new HashSet<BO4ModDataFunction>();
                if (buffer.get() != 0) {
                    int modDataSize = buffer.getInt();
                    for (int l = 0; l < modDataSize; ++l) {
                        ModDataFunction modDataFunction = world.isBo4Enabled() ? new BO4ModDataFunction() : new BO3ModDataFunction();
                        modDataFunction.x = buffer.getInt();
                        modDataFunction.y = buffer.getInt();
                        modDataFunction.z = buffer.getInt();
                        modDataFunction.modId = StreamHelper.readStringFromBuffer(buffer);
                        modDataFunction.modData = StreamHelper.readStringFromBuffer(buffer);
                        modData.add((BO4ModDataFunction)modDataFunction);
                    }
                }
                HashSet<BO4SpawnerFunction> spawnerData = new HashSet<BO4SpawnerFunction>();
                if (buffer.get() != 0) {
                    int spawnerDataSize = buffer.getInt();
                    for (int l = 0; l < spawnerDataSize; ++l) {
                        SpawnerFunction spawnerFunction = world.isBo4Enabled() ? new BO4SpawnerFunction() : new BO3SpawnerFunction();
                        spawnerFunction.x = buffer.getInt();
                        spawnerFunction.y = buffer.getInt();
                        spawnerFunction.z = buffer.getInt();
                        spawnerFunction.mobName = StreamHelper.readStringFromBuffer(buffer);
                        spawnerFunction.originalnbtFileName = StreamHelper.readStringFromBuffer(buffer);
                        spawnerFunction.nbtFileName = StreamHelper.readStringFromBuffer(buffer);
                        spawnerFunction.groupSize = buffer.getInt();
                        spawnerFunction.interval = buffer.getInt();
                        spawnerFunction.spawnChance = buffer.getInt();
                        spawnerFunction.maxCount = buffer.getInt();
                        spawnerFunction.despawnTime = buffer.getInt();
                        spawnerFunction.velocityX = buffer.getDouble();
                        spawnerFunction.velocityY = buffer.getDouble();
                        spawnerFunction.velocityZ = buffer.getDouble();
                        spawnerFunction.velocityXSet = buffer.get() != 0;
                        spawnerFunction.velocityYSet = buffer.get() != 0;
                        spawnerFunction.velocityZSet = buffer.get() != 0;
                        spawnerFunction.yaw = buffer.getFloat();
                        spawnerFunction.pitch = buffer.getFloat();
                        spawnerData.add((BO4SpawnerFunction)spawnerFunction);
                    }
                }
                HashSet<BO4ParticleFunction> particleData = new HashSet<BO4ParticleFunction>();
                if (buffer.get() != 0) {
                    int particleDataSize = buffer.getInt();
                    for (int l = 0; l < particleDataSize; ++l) {
                        ParticleFunction particleFunction = world.isBo4Enabled() ? new BO4ParticleFunction() : new BO3ParticleFunction();
                        particleFunction.x = buffer.getInt();
                        particleFunction.y = buffer.getInt();
                        particleFunction.z = buffer.getInt();
                        particleFunction.particleName = StreamHelper.readStringFromBuffer(buffer);
                        particleFunction.interval = buffer.getDouble();
                        particleFunction.velocityX = buffer.getDouble();
                        particleFunction.velocityY = buffer.getDouble();
                        particleFunction.velocityZ = buffer.getDouble();
                        particleFunction.velocityXSet = buffer.get() != 0;
                        particleFunction.velocityYSet = buffer.get() != 0;
                        particleFunction.velocityZSet = buffer.get() != 0;
                        particleData.add((BO4ParticleFunction)particleFunction);
                    }
                }
                if (world.isBo4Enabled()) {
                    ChunkCoordinate startChunkCoord = ChunkCoordinate.fromChunkCoords(structureStart.getChunkX(), structureStart.getChunkZ());
                    structure = !startChunkCoord.toRegionCoord().equals(regionCoord) ? new CustomStructurePlaceHolder(world, (BO4CustomStructureCoordinate)structureStart, objectsToSpawn, smoothingAreasToSpawn, 0) : new BO4CustomStructure(world, (BO4CustomStructureCoordinate)structureStart, objectsToSpawn, smoothingAreasToSpawn, 0);
                    ((BO4CustomStructure)structure).startChunkBlockChecksDone = true;
                } else {
                    structure = new BO3CustomStructure((BO3CustomStructureCoordinate)structureStart);
                }
                structure.modDataManager.modData = modData;
                structure.spawnerManager.spawnerData = spawnerData;
                structure.particlesManager.particleData = particleData;
                structuresFile.put(structure, chunkCoords);
            }
        }
        return structuresFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveChunksMapFile(LocalWorld world, HashMap<String, ArrayList<ChunkCoordinate>> spawnedStructuresByName, HashMap<String, HashMap<ChunkCoordinate, Integer>> spawnedStructuresByGroup) {
        int dimensionId = world.getDimensionId();
        File occupiedChunksFile = new File(world.getWorldSaveDir().getAbsolutePath() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : "") + WorldStandardValues.SpawnedStructuresFileName);
        File occupiedChunksBackupFile = new File(world.getWorldSaveDir().getAbsolutePath() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : "") + WorldStandardValues.SpawnedStructuresBackupFileName);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        if (spawnedStructuresByName.size() > 0) {
            try {
                int version = 1;
                dos.writeInt(version);
                dos.writeInt(spawnedStructuresByName.entrySet().size());
                for (Map.Entry<String, ArrayList<ChunkCoordinate>> entry : spawnedStructuresByName.entrySet()) {
                    StreamHelper.writeStringToStream(dos, entry.getKey());
                    dos.writeInt(entry.getValue().size());
                    for (ChunkCoordinate chunkCoordinate : entry.getValue()) {
                        dos.writeInt(chunkCoordinate.getChunkX());
                        dos.writeInt(chunkCoordinate.getChunkZ());
                    }
                }
                dos.writeInt(spawnedStructuresByGroup.entrySet().size());
                for (Map.Entry<String, Cloneable> entry : spawnedStructuresByGroup.entrySet()) {
                    StreamHelper.writeStringToStream(dos, entry.getKey());
                    dos.writeInt(((HashMap)entry.getValue()).entrySet().size());
                    for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                        dos.writeInt(((ChunkCoordinate)entry2.getKey()).getChunkX());
                        dos.writeInt(((ChunkCoordinate)entry2.getKey()).getChunkZ());
                        dos.writeInt((Integer)entry2.getValue());
                    }
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return;
            }
            FilterOutputStream dos2 = null;
            FileOutputStream fos = null;
            try {
                if (!occupiedChunksFile.exists()) {
                    occupiedChunksFile.getParentFile().mkdirs();
                } else {
                    Files.move(occupiedChunksFile.toPath(), occupiedChunksBackupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                byte[] byArray = CompressionUtils.compress(bos.toByteArray());
                fos = new FileOutputStream(occupiedChunksFile);
                dos2 = new DataOutputStream(fos);
                ((DataOutputStream)dos2).write(byArray, 0, byArray.length);
            }
            catch (IOException exception) {
                exception.printStackTrace();
                OTG.log(LogMarker.INFO, "OTG encountered an error writing " + occupiedChunksFile.getAbsolutePath() + ", skipping.", new Object[0]);
            }
            finally {
                try {
                    if (dos != null) {
                        dos.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (dos2 != null) {
                        dos2.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadChunksMapFile(LocalWorld world, HashMap<String, ArrayList<ChunkCoordinate>> spawnedStructuresByName, HashMap<String, HashMap<ChunkCoordinate, Integer>> spawnedStructuresByGroup) {
        FileInputStream fis;
        int dimensionId = world.getDimensionId();
        File occupiedChunksFile = new File(world.getWorldSaveDir().getAbsolutePath() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : "") + WorldStandardValues.SpawnedStructuresFileName);
        File occupiedChunksBackupFile = new File(world.getWorldSaveDir().getAbsolutePath() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : "") + WorldStandardValues.SpawnedStructuresBackupFileName);
        if (!occupiedChunksFile.exists() && !occupiedChunksBackupFile.exists()) {
            return;
        }
        if (occupiedChunksFile.exists()) {
            fis = null;
            try {
                fis = new FileInputStream(occupiedChunksFile);
                ByteBuffer buffer = fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fis.getChannel().size());
                byte[] compressedBytes = new byte[(int)fis.getChannel().size()];
                buffer.get(compressedBytes);
                byte[] decompressedBytes = CompressionUtils.decompress(compressedBytes);
                buffer = ByteBuffer.wrap(decompressedBytes);
                CustomStructureFileManager.parseChunksMapFileFromStream(buffer, world, spawnedStructuresByName, spawnedStructuresByGroup);
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                OTG.log(LogMarker.INFO, "Failed to load " + occupiedChunksFile.getAbsolutePath() + ", trying to load backup.", new Object[0]);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.getChannel().close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (occupiedChunksBackupFile.exists()) {
            fis = null;
            try {
                fis = new FileInputStream(occupiedChunksBackupFile);
                ByteBuffer buffer = fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fis.getChannel().size());
                byte[] compressedBytes = new byte[(int)fis.getChannel().size()];
                buffer.get(compressedBytes);
                byte[] decompressedBytes = CompressionUtils.decompress(compressedBytes);
                buffer = ByteBuffer.wrap(decompressedBytes);
                CustomStructureFileManager.parseChunksMapFileFromStream(buffer, world, spawnedStructuresByName, spawnedStructuresByGroup);
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.getChannel().close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        OTG.log(LogMarker.INFO, "OTG encountered an error loading " + occupiedChunksFile.getAbsolutePath() + " and could not load a backup, skipping. ", new Object[0]);
    }

    private static void parseChunksMapFileFromStream(ByteBuffer buffer, LocalWorld world, HashMap<String, ArrayList<ChunkCoordinate>> spawnedStructuresByName, HashMap<String, HashMap<ChunkCoordinate, Integer>> spawnedStructuresByGroup) throws IOException {
        Cloneable coords;
        HashMap<String, Cloneable> chunksByName = new HashMap<String, Cloneable>();
        HashMap<String, Cloneable> chunksByGroup = new HashMap<String, Cloneable>();
        int version = buffer.getInt();
        int spawnedStructuresByNameSize = buffer.getInt();
        for (int i = 0; i < spawnedStructuresByNameSize; ++i) {
            String name = StreamHelper.readStringFromBuffer(buffer);
            int coordsSize = buffer.getInt();
            coords = new ArrayList();
            for (int j = 0; j < coordsSize; ++j) {
                ((ArrayList)coords).add(ChunkCoordinate.fromChunkCoords(buffer.getInt(), buffer.getInt()));
            }
            chunksByName.put(name, coords);
        }
        int spawnedStructuresByGroupSize = buffer.getInt();
        for (int k = 0; k < spawnedStructuresByGroupSize; ++k) {
            String name = StreamHelper.readStringFromBuffer(buffer);
            coords = new HashMap();
            int coordsSize = buffer.getInt();
            for (int l = 0; l < coordsSize; ++l) {
                ((HashMap)coords).put(ChunkCoordinate.fromChunkCoords(buffer.getInt(), buffer.getInt()), buffer.getInt());
            }
            chunksByGroup.put(name, coords);
        }
        spawnedStructuresByName.clear();
        spawnedStructuresByName.putAll(chunksByName);
        spawnedStructuresByGroup.clear();
        spawnedStructuresByGroup.putAll(chunksByGroup);
    }
}

