/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.structures;

import com.pg85.otg.OTG;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.structures.StructuredCustomObject;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.helpers.MathHelper;

public abstract class CustomStructureCoordinate {
    public String bo3Name;
    public String worldName;
    protected transient StructuredCustomObject object;
    public Rotation rotation;
    public int x;
    public short y;
    public int z;

    protected CustomStructureCoordinate() {
    }

    public int getX() {
        return this.x;
    }

    public short getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public final int getChunkX() {
        return MathHelper.floor((double)this.x / 16.0);
    }

    public final int getChunkZ() {
        return MathHelper.floor((double)this.z / 16.0);
    }

    public StructuredCustomObject getObject() {
        if (this.object == null) {
            CustomObject object = OTG.getCustomObjectManager().getGlobalObjects().getObjectByName(this.bo3Name, this.worldName);
            if (object == null || !(object instanceof StructuredCustomObject)) {
                object = null;
                if (OTG.getPluginConfig().spawnLog) {
                    OTG.log(LogMarker.WARN, "Could not find BO3/BO4 " + this.bo3Name + " in GlobalObjects or WorldObjects directory.", new Object[0]);
                }
            }
            this.bo3Name = object != null ? object.getName() : this.bo3Name;
            this.object = (StructuredCustomObject)object;
            return this.object;
        }
        return this.object;
    }

    public int hashCode() {
        return this.x >> 13 ^ this.y >> 7 ^ this.z ^ this.object.getName().hashCode() ^ this.rotation.toString().hashCode();
    }

    public boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (!(otherObject instanceof CustomStructureCoordinate)) {
            return false;
        }
        CustomStructureCoordinate otherCoord = (CustomStructureCoordinate)otherObject;
        if (otherCoord.x != this.x) {
            return false;
        }
        if (otherCoord.y != this.y) {
            return false;
        }
        if (otherCoord.z != this.z) {
            return false;
        }
        if (!otherCoord.rotation.equals((Object)this.rotation)) {
            return false;
        }
        return otherCoord.object.getName().equals(this.object.getName());
    }
}

