/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.structures;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.customobjects.bo4.BO4;
import com.pg85.otg.customobjects.bofunctions.ModDataFunction;
import com.pg85.otg.customobjects.bofunctions.ParticleFunction;
import com.pg85.otg.customobjects.bofunctions.SpawnerFunction;
import com.pg85.otg.customobjects.structures.CustomStructure;
import com.pg85.otg.customobjects.structures.CustomStructureFileManager;
import com.pg85.otg.customobjects.structures.StructureDataRegion;
import com.pg85.otg.customobjects.structures.bo3.BO3CustomStructure;
import com.pg85.otg.customobjects.structures.bo3.BO3CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.bo4.BO4CustomStructure;
import com.pg85.otg.customobjects.structures.bo4.CustomStructurePlotter;
import com.pg85.otg.generator.resource.CustomStructureGen;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.FifoMap;
import com.pg85.otg.util.helpers.RandomHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class CustomStructureCache {
    public static final int REGION_SIZE = 100;
    private FifoMap<ChunkCoordinate, BO3CustomStructure> bo3StructureCache;
    private CustomStructurePlotter plotter;
    private LocalWorld world;
    private Map<ChunkCoordinate, StructureDataRegion> worldInfoChunks;

    public CustomStructureCache(LocalWorld world) {
        this.world = world;
        this.worldInfoChunks = new HashMap<ChunkCoordinate, StructureDataRegion>();
        this.plotter = new CustomStructurePlotter();
        this.bo3StructureCache = new FifoMap(400);
        this.loadStructureCache();
    }

    private boolean worldInfoChunksContainsKey(ChunkCoordinate chunkCoordinate) {
        ChunkCoordinate regionCoord = chunkCoordinate.toRegionCoord();
        StructureDataRegion chunkRegion = this.worldInfoChunks.get(regionCoord);
        return chunkRegion != null && chunkRegion.getStructure(chunkCoordinate.getRegionInternalX(), chunkCoordinate.getRegionInternalZ()) != null;
    }

    private CustomStructure getFromWorldInfoChunks(ChunkCoordinate chunkCoordinate) {
        ChunkCoordinate regionCoord = chunkCoordinate.toRegionCoord();
        StructureDataRegion chunkRegion = this.worldInfoChunks.get(regionCoord);
        if (chunkRegion != null) {
            return chunkRegion.getStructure(chunkCoordinate.getRegionInternalX(), chunkCoordinate.getRegionInternalZ());
        }
        return null;
    }

    private void addToWorldInfoChunks(CustomStructure structure, ChunkCoordinate chunkCoordinate, boolean requiresSave) {
        ChunkCoordinate regionCoord = chunkCoordinate.toRegionCoord();
        StructureDataRegion chunkRegion = this.worldInfoChunks.get(regionCoord);
        if (chunkRegion == null) {
            chunkRegion = new StructureDataRegion();
            this.worldInfoChunks.put(regionCoord, chunkRegion);
        }
        chunkRegion.setStructure(chunkCoordinate.getRegionInternalX(), chunkCoordinate.getRegionInternalZ(), structure, requiresSave);
    }

    public void markRegionForSaving(ChunkCoordinate regionCoordinate) {
        StructureDataRegion region = this.worldInfoChunks.get(regionCoordinate);
        if (region != null) {
            region.markSaveRequired();
        }
    }

    private void addToWorldInfoChunks(ChunkCoordinate chunkCoord, CustomStructure structure, boolean canOverride) {
        if (this.worldInfoChunksContainsKey(chunkCoord)) {
            CustomStructure existingObject = this.getFromWorldInfoChunks(chunkCoord);
            if (existingObject != structure) {
                if (canOverride) {
                    structure.modDataManager.modData.addAll(existingObject.modDataManager.modData);
                    structure.particlesManager.particleData.addAll(existingObject.particlesManager.particleData);
                    structure.spawnerManager.spawnerData.addAll(existingObject.spawnerManager.spawnerData);
                    this.addToWorldInfoChunks(structure, chunkCoord, true);
                } else {
                    existingObject.modDataManager.modData.addAll(structure.modDataManager.modData);
                    existingObject.particlesManager.particleData.addAll(structure.particlesManager.particleData);
                    existingObject.spawnerManager.spawnerData.addAll(structure.spawnerManager.spawnerData);
                }
            }
        } else {
            this.addToWorldInfoChunks(structure, chunkCoord, true);
        }
    }

    public CustomStructure getChunkData(ChunkCoordinate chunkCoord) {
        return this.getFromWorldInfoChunks(chunkCoord);
    }

    public void reloadBo3StructureCache(LocalWorld world) {
        this.world = world;
        this.bo3StructureCache.clear();
    }

    public BO3CustomStructure getBo3StructureStart(Random worldRandom, int chunkX, int chunkZ) {
        BO3CustomStructureCoordinate customObject;
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
        BO3CustomStructure structureStart = (BO3CustomStructure)this.bo3StructureCache.get(chunkCoord);
        if (structureStart != null) {
            if (structureStart.start == null) {
                return null;
            }
            return structureStart;
        }
        Random random = RandomHelper.getRandomForCoords(chunkX ^ 2, (chunkZ + 1) * 2, this.world.getSeed());
        BiomeConfig biomeConfig = this.world.getBiome(chunkX * 16 + 15, chunkZ * 16 + 15).getBiomeConfig();
        CustomStructureGen structureGen = biomeConfig.structureGen;
        if (structureGen != null && (customObject = structureGen.getRandomObjectCoordinate(this.world, random, chunkX, chunkZ)) != null) {
            structureStart = new BO3CustomStructure(this.world, customObject);
            this.bo3StructureCache.put(chunkCoord, structureStart);
            return structureStart;
        }
        this.bo3StructureCache.put(chunkCoord, new BO3CustomStructure(null));
        return null;
    }

    public void addBo3ToStructureCache(ChunkCoordinate chunkCoord, CustomStructure structure, boolean canOverride) {
        this.addToWorldInfoChunks(chunkCoord, structure, canOverride);
    }

    public boolean isChunkOccupied(LocalWorld world, ChunkCoordinate chunkCoordinate) {
        return this.plotter.isBo4ChunkPlotted(world, chunkCoordinate);
    }

    public void addBo4ToStructureCache(ChunkCoordinate chunkCoord, BO4CustomStructure structure) {
        this.plotter.addBo4ToStructureCache(chunkCoord, structure);
        this.addToWorldInfoChunks(chunkCoord, structure, true);
    }

    public boolean isBo4ChunkOccupied(ChunkCoordinate chunkCoord) {
        if (this.world.isBo4Enabled()) {
            return this.worldInfoChunks.containsKey(chunkCoord);
        }
        return false;
    }

    public void plotBo4Structures(Random rand, ChunkCoordinate chunkCoord) {
        this.plotter.plotStructures(this, this.world, rand, chunkCoord);
    }

    public void spawnBo4Chunk(ChunkCoordinate chunkCoord, ChunkCoordinate chunkBeingPopulated) {
        this.plotter.spawnBO4Chunk(chunkCoord, this.world, chunkBeingPopulated);
    }

    public ChunkCoordinate plotBo4Structure(BO4 structure, ArrayList<String> biomes, ChunkCoordinate chunkCoord) {
        BO4CustomStructure plottedStructure = this.plotter.plotStructures(this, structure, biomes, this.world, new Random(), chunkCoord);
        if (plottedStructure != null) {
            return ChunkCoordinate.fromChunkCoords(plottedStructure.start.getChunkX(), plottedStructure.start.getChunkZ());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToDisk() {
        Object object;
        block9: {
            int interval;
            OTG.log(LogMarker.INFO, "Saving structure and pregenerator data.", new Object[0]);
            boolean firstLog = false;
            long starTime = System.currentTimeMillis();
            do {
                object = this.world.getObjectSpawner().lockingObject;
                synchronized (object) {
                    if (!this.world.getObjectSpawner().populating) {
                        this.world.getObjectSpawner().saving = true;
                        break block9;
                    }
                }
                if (firstLog) {
                    OTG.log(LogMarker.WARN, "SaveToDisk waiting on Populate. Although other mods could be causing this and there may not be any problem, this can potentially cause an endless loop!", new Object[0]);
                    firstLog = false;
                }
                interval = 300;
            } while (System.currentTimeMillis() - starTime <= (long)(interval * 1000));
            OTG.log(LogMarker.FATAL, "SaveToDisk waited on populate longer than " + interval + " seconds, something went wrong!", new Object[0]);
            throw new RuntimeException("SaveToDisk waited on populate longer than " + interval + " seconds, something went wrong!");
        }
        this.saveStructureCache();
        object = this.world.getObjectSpawner().lockingObject;
        synchronized (object) {
            this.world.getObjectSpawner().saveRequired = false;
            this.world.getObjectSpawner().saving = false;
        }
        OTG.log(LogMarker.INFO, "Structure and pregenerator data saved.", new Object[0]);
    }

    private void saveStructureCache() {
        CustomStructureFileManager.saveStructureData(this.worldInfoChunks, this.world);
        if (this.world.isBo4Enabled()) {
            this.plotter.saveStructureCache(this.world);
        }
    }

    private void loadStructureCache() {
        OTG.log(LogMarker.DEBUG, "Loading structures and pre-generator data", new Object[0]);
        this.worldInfoChunks = new HashMap<ChunkCoordinate, StructureDataRegion>();
        HashMap<CustomStructure, ArrayList<ChunkCoordinate>> loadedStructures = CustomStructureFileManager.loadStructureData(this.world);
        if (loadedStructures != null) {
            if (this.world.isBo4Enabled()) {
                this.plotter.loadStructureCache(this.world, loadedStructures);
            }
            for (Map.Entry loadedStructure : loadedStructures.entrySet()) {
                if (loadedStructure == null) {
                    throw new RuntimeException("This shouldn't happen, please ask for help on the OTG Discord and/or file an issue on the OTG github.");
                }
                for (ChunkCoordinate chunkCoordinate : (ArrayList)loadedStructure.getValue()) {
                    this.addToWorldInfoChunks((CustomStructure)loadedStructure.getKey(), chunkCoordinate, false);
                }
                for (ModDataFunction modDataFunction : ((CustomStructure)loadedStructure.getKey()).modDataManager.modData) {
                    this.addToWorldInfoChunks((CustomStructure)loadedStructure.getKey(), ChunkCoordinate.fromBlockCoords(modDataFunction.x, modDataFunction.z), false);
                }
                for (SpawnerFunction spawnerFunction : ((CustomStructure)loadedStructure.getKey()).spawnerManager.spawnerData) {
                    this.addToWorldInfoChunks((CustomStructure)loadedStructure.getKey(), ChunkCoordinate.fromBlockCoords(spawnerFunction.x, spawnerFunction.z), false);
                }
                for (ParticleFunction particleFunction : ((CustomStructure)loadedStructure.getKey()).particlesManager.particleData) {
                    this.addToWorldInfoChunks((CustomStructure)loadedStructure.getKey(), ChunkCoordinate.fromBlockCoords(particleFunction.x, particleFunction.z), false);
                }
            }
        }
        OTG.log(LogMarker.DEBUG, "Loading done", new Object[0]);
    }
}

