/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bofunctions;

import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.customobjects.CustomObjectConfigFile;
import com.pg85.otg.configuration.customobjects.CustomObjectConfigFunction;
import com.pg85.otg.customobjects.bo3.BO3Loader;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.NamedBinaryTag;
import java.util.List;
import java.util.Random;

public abstract class BlockFunction<T extends CustomObjectConfigFile>
extends CustomObjectConfigFunction<T> {
    public LocalMaterialData material;
    public short y;
    public NamedBinaryTag metaDataTag;
    public String metaDataName;

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.assureSize(4, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = (short)this.readInt(args.get(1), -1000, 1000);
        this.z = this.readInt(args.get(2), -100, 100);
        this.material = this.readMaterial(args.get(3));
        if (this.material == null) {
            throw new InvalidConfigException("Material \"" + args.get(3) + "\" could not be read.");
        }
        if (args.size() == 5) {
            this.metaDataTag = BO3Loader.loadMetadata(args.get(4), ((CustomObjectConfigFile)this.getHolder()).getFile());
            if (this.metaDataTag != null) {
                this.metaDataName = args.get(4);
            }
        }
    }

    @Override
    public String makeString() {
        String start = "Block(" + this.x + ',' + this.y + ',' + this.z + ',' + this.material;
        if (this.metaDataTag != null) {
            start = start + ',' + this.metaDataName;
        }
        return start + ')';
    }

    public abstract void spawn(LocalWorld var1, Random var2, int var3, int var4, int var5, ChunkCoordinate var6, boolean var7);

    @Override
    public boolean isAnalogousTo(CustomObjectConfigFunction<T> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        BlockFunction block = (BlockFunction)other;
        return block.x == this.x && block.y == this.y && block.z == this.z;
    }
}

