/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo4;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.configuration.customobjects.CustomObjectConfigFile;
import com.pg85.otg.configuration.customobjects.CustomObjectConfigFunction;
import com.pg85.otg.configuration.customobjects.CustomObjectErroredFunction;
import com.pg85.otg.configuration.io.SettingsReaderOTGPlus;
import com.pg85.otg.configuration.io.SettingsWriterOTGPlus;
import com.pg85.otg.configuration.standard.WorldStandardValues;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.bo3.BO3Settings;
import com.pg85.otg.customobjects.bo4.BO4;
import com.pg85.otg.customobjects.bo4.BO4Settings;
import com.pg85.otg.customobjects.bo4.bo4function.BO4BlockFunction;
import com.pg85.otg.customobjects.bo4.bo4function.BO4BranchFunction;
import com.pg85.otg.customobjects.bo4.bo4function.BO4EntityFunction;
import com.pg85.otg.customobjects.bo4.bo4function.BO4ModDataFunction;
import com.pg85.otg.customobjects.bo4.bo4function.BO4ParticleFunction;
import com.pg85.otg.customobjects.bo4.bo4function.BO4RandomBlockFunction;
import com.pg85.otg.customobjects.bo4.bo4function.BO4SpawnerFunction;
import com.pg85.otg.customobjects.bo4.bo4function.BO4WeightedBranchFunction;
import com.pg85.otg.customobjects.bofunctions.BranchFunction;
import com.pg85.otg.customobjects.structures.bo4.BO4CustomStructureCoordinate;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.CompressionUtils;
import com.pg85.otg.util.bo3.NamedBinaryTag;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.helpers.StreamHelper;
import com.pg85.otg.util.materials.MaterialHelper;
import com.pg85.otg.util.minecraft.defaults.DefaultStructurePart;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.zip.DataFormatException;

public class BO4Config
extends CustomObjectConfigFile {
    public String author;
    public String description;
    public WorldConfig.ConfigMode settingsMode;
    public boolean doReplaceBlocks;
    public int frequency;
    private final int xSize = 16;
    private final int zSize = 16;
    public int minHeight;
    public int maxHeight;
    public BO3Settings.SpawnHeightEnum spawnHeight;
    public boolean useCenterForHighestBlock;
    private BO4BlockFunction[][] heightMap;
    private boolean inheritedBO3Loaded;
    public int minimumSizeTop = -1;
    public int minimumSizeBottom = -1;
    public int minimumSizeLeft = -1;
    public int minimumSizeRight = -1;
    public int timesSpawned = 0;
    public int branchFrequency;
    private String branchFrequencyGroup;
    public HashMap<String, Integer> branchFrequencyGroups;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private int minZ;
    private int maxZ;
    private ArrayList<String> inheritedBO3s;
    public int heightOffset;
    private Rotation inheritBO3Rotation;
    private boolean removeAir;
    public boolean isSpawnPoint;
    public String replaceAbove;
    public String replaceBelow;
    public boolean replaceWithBiomeBlocks;
    public String replaceWithGroundBlock;
    public String replaceWithSurfaceBlock;
    public String replaceWithStoneBlock;
    private String bo3Group;
    public HashMap<String, Integer> bo4Groups;
    public boolean canOverride;
    private String inheritBO3;
    public boolean smoothStartTop;
    public boolean smoothStartWood;
    public int smoothRadius;
    public String smoothingSurfaceBlock;
    public String smoothingGroundBlock;
    public boolean overrideChildSettings;
    public boolean overrideParentHeight;
    public boolean mustBeBelowOther;
    public boolean mustBeInsideWorldBorders;
    private String replacesBO3;
    public ArrayList<String> replacesBO3Branches;
    private String mustBeInside;
    public ArrayList<String> mustBeInsideBranches;
    private String cannotBeInside;
    public ArrayList<String> cannotBeInsideBranches;
    public int smoothHeightOffset;
    public boolean canSpawnOnWater;
    public boolean spawnOnWaterOnly;
    public boolean spawnUnderWater;
    public boolean spawnAtWaterLevel;
    private String worldName;
    private short[][][] blocks;
    private LocalMaterialData[] blocksMaterial;
    private String[] blocksMetaDataName;
    private NamedBinaryTag[] blocksMetaDataTag;
    private LocalMaterialData[][] randomBlocksBlocks;
    private byte[][] randomBlocksBlockChances;
    private String[][] randomBlocksMetaDataNames;
    private NamedBinaryTag[][] randomBlocksMetaDataTags;
    private byte[] randomBlocksBlockCount;
    private BO4BranchFunction[] branchesOTGPlus;
    private BO4ModDataFunction[] modDataOTGPlus;
    private BO4SpawnerFunction[] spawnerDataOTGPlus;
    private BO4ParticleFunction[] particleDataOTGPlus;
    private BO4EntityFunction[] entityDataOTGPlus;
    private boolean isCollidable = false;
    public boolean isBO4Data = false;
    static int BO4BlocksLoadedFromBO4Data = 0;
    static int accumulatedTime = 0;
    static int accumulatedTime2 = 0;
    static int BO4BlocksLoaded = 0;
    int bo4DataVersion = 2;

    public BO4Config(SettingsReaderOTGPlus reader, boolean init) throws InvalidConfigException {
        super(reader);
        if (init) {
            this.init();
        }
    }

    private void init() throws InvalidConfigException {
        this.minX = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.maxY = Integer.MIN_VALUE;
        this.minZ = Integer.MAX_VALUE;
        this.maxZ = Integer.MIN_VALUE;
        if (!this.reader.getFile().getAbsolutePath().toLowerCase().endsWith(".bo4data")) {
            this.readConfigSettings();
        } else {
            this.readFromBO4DataFile(false);
        }
        if (this.settingsMode == WorldConfig.ConfigMode.WriteDisable) {
            this.reader.flushCache();
        }
    }

    public int getXOffset() {
        return this.minX < -8 ? -this.minX : (this.maxX > 7 ? -this.minX : 8);
    }

    public int getZOffset() {
        return this.minZ < -7 ? -this.minZ : (this.maxZ > 8 ? -this.minZ : 7);
    }

    public int getminX() {
        return this.minX + this.getXOffset();
    }

    public int getmaxX() {
        return this.maxX + this.getXOffset();
    }

    public int getminY() {
        return this.minY;
    }

    public int getmaxY() {
        return this.maxY;
    }

    public int getminZ() {
        return this.minZ + this.getZOffset();
    }

    public int getmaxZ() {
        return this.maxZ + this.getZOffset();
    }

    public ArrayList<String> getInheritedBO3s() {
        return this.inheritedBO3s;
    }

    public BO4BlockFunction[][] getSmoothingHeightMap(BO4 start) {
        return this.getSmoothingHeightMap(start, true);
    }

    private BO4BlockFunction[][] getSmoothingHeightMap(BO4 start, boolean fromFile) {
        if (this.heightMap == null) {
            if (this.isBO4Data && fromFile) {
                BO4Config bo4Config = null;
                try {
                    bo4Config = new BO4Config(this.reader, false);
                }
                catch (InvalidConfigException e) {
                    OTG.log(LogMarker.INFO, e.getMessage(), new Object[0]);
                }
                if (bo4Config != null) {
                    try {
                        bo4Config.readFromBO4DataFile(true);
                    }
                    catch (InvalidConfigException e) {
                        OTG.log(LogMarker.INFO, e.getMessage(), new Object[0]);
                        this.heightMap = new BO4BlockFunction[16][16];
                        return this.heightMap;
                    }
                    this.heightMap = bo4Config.getSmoothingHeightMap(start, false);
                    return this.heightMap;
                }
            }
            this.heightMap = new BO4BlockFunction[16][16];
            int blockIndex = 0;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (this.blocks[x][z] == null) continue;
                    for (int i = 0; i < this.blocks[x][z].length; ++i) {
                        boolean isSmoothAreaAnchor = false;
                        boolean isRandomBlock = this.randomBlocksBlocks[blockIndex] != null;
                        short y = this.blocks[x][z][i];
                        if (isRandomBlock) {
                            for (LocalMaterialData randomMaterial : this.randomBlocksBlocks[blockIndex]) {
                                if (randomMaterial == null || !randomMaterial.isSmoothAreaAnchor(start.getConfig().overrideChildSettings && this.overrideChildSettings ? start.getConfig().smoothStartWood : this.smoothStartWood, start.getConfig().spawnUnderWater)) continue;
                                isSmoothAreaAnchor = true;
                                break;
                            }
                        }
                        LocalMaterialData material = this.blocksMaterial[blockIndex];
                        if ((isSmoothAreaAnchor || !isRandomBlock && material.isSmoothAreaAnchor(start.getConfig().overrideChildSettings && this.overrideChildSettings ? start.getConfig().smoothStartWood : this.smoothStartWood, start.getConfig().spawnUnderWater)) && (!(!start.getConfig().overrideChildSettings || !this.overrideChildSettings ? this.smoothStartTop : start.getConfig().smoothStartTop) && y == this.getminY() || (start.getConfig().overrideChildSettings && this.overrideChildSettings ? start.getConfig().smoothStartTop : this.smoothStartTop) && (this.heightMap[x][z] == null || y > this.heightMap[x][z].y))) {
                            BO4BlockFunction blockFunction = null;
                            if (isRandomBlock) {
                                blockFunction = new BO4RandomBlockFunction();
                                blockFunction.blocks = this.randomBlocksBlocks[blockIndex];
                                blockFunction.blockChances = this.randomBlocksBlockChances[blockIndex];
                                blockFunction.metaDataNames = this.randomBlocksMetaDataNames[blockIndex];
                                blockFunction.metaDataTags = this.randomBlocksMetaDataTags[blockIndex];
                                blockFunction.blockCount = this.randomBlocksBlockCount[blockIndex];
                            } else {
                                blockFunction = new BO4BlockFunction();
                            }
                            blockFunction.material = material;
                            blockFunction.x = x;
                            blockFunction.y = y;
                            blockFunction.z = z;
                            blockFunction.metaDataName = this.blocksMetaDataName[blockIndex];
                            blockFunction.metaDataTag = this.blocksMetaDataTag[blockIndex];
                            this.heightMap[x][z] = blockFunction;
                        }
                        ++blockIndex;
                    }
                }
            }
        }
        return this.heightMap;
    }

    public BO4BlockFunction[] getBlocks() {
        return this.getBlocks(true);
    }

    private BO4BlockFunction[] getBlocks(boolean fromFile) {
        if (fromFile && this.isBO4Data) {
            BO4Config bo4Config = null;
            try {
                bo4Config = new BO4Config(this.reader, false);
            }
            catch (InvalidConfigException e) {
                OTG.log(LogMarker.INFO, e.getMessage(), new Object[0]);
            }
            if (bo4Config != null) {
                try {
                    bo4Config.readFromBO4DataFile(true);
                }
                catch (InvalidConfigException e) {
                    OTG.log(LogMarker.INFO, e.getMessage(), new Object[0]);
                    return null;
                }
                return bo4Config.getBlocks(false);
            }
        }
        BO4BlockFunction[] blocksOTGPlus = new BO4BlockFunction[this.blocksMaterial.length];
        int blockIndex = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (this.blocks[x][z] == null) continue;
                for (int i = 0; i < this.blocks[x][z].length; ++i) {
                    BO4BlockFunction block;
                    if (this.randomBlocksBlocks[blockIndex] != null) {
                        block = new BO4RandomBlockFunction(this);
                        block.blocks = this.randomBlocksBlocks[blockIndex];
                        block.blockChances = this.randomBlocksBlockChances[blockIndex];
                        block.metaDataNames = this.randomBlocksMetaDataNames[blockIndex];
                        block.metaDataTags = this.randomBlocksMetaDataTags[blockIndex];
                        block.blockCount = this.randomBlocksBlockCount[blockIndex];
                    } else {
                        block = new BO4BlockFunction(this);
                    }
                    block.x = x;
                    block.y = this.blocks[x][z][i];
                    block.z = z;
                    block.material = this.blocksMaterial[blockIndex];
                    block.metaDataName = this.blocksMetaDataName[blockIndex];
                    block.metaDataTag = this.blocksMetaDataTag[blockIndex];
                    blocksOTGPlus[blockIndex] = block;
                    ++blockIndex;
                }
            }
        }
        return blocksOTGPlus;
    }

    protected BO4BranchFunction[] getbranches() {
        return this.branchesOTGPlus;
    }

    public BO4ModDataFunction[] getModData() {
        return this.modDataOTGPlus;
    }

    public BO4SpawnerFunction[] getSpawnerData() {
        return this.spawnerDataOTGPlus;
    }

    public BO4ParticleFunction[] getParticleData() {
        return this.particleDataOTGPlus;
    }

    public BO4EntityFunction[] getEntityData() {
        return this.entityDataOTGPlus;
    }

    private void loadInheritedBO3() {
        if (this.inheritBO3 != null && this.inheritBO3.trim().length() > 0 && !this.inheritedBO3Loaded) {
            CustomObject parentBO3;
            File currentFile = this.getFile().getParentFile();
            this.worldName = currentFile.getName();
            while (currentFile.getParentFile() != null && !currentFile.getName().toLowerCase().equals("worlds")) {
                this.worldName = currentFile.getName();
                currentFile = currentFile.getParentFile();
                if (!this.worldName.toLowerCase().equals("globalobjects")) continue;
                this.worldName = null;
                break;
            }
            if ((parentBO3 = OTG.getCustomObjectManager().getGlobalObjects().getObjectByName(this.inheritBO3, this.worldName)) != null) {
                int parentMinZ;
                BO4BlockFunction[] blocks = this.getBlocks();
                this.inheritedBO3Loaded = true;
                this.inheritedBO3s.addAll(((BO4)parentBO3).getConfig().getInheritedBO3s());
                this.removeAir = ((BO4)parentBO3).getConfig().removeAir;
                this.replaceAbove = this.replaceAbove == null || this.replaceAbove.length() == 0 ? ((BO4)parentBO3).getConfig().replaceAbove : this.replaceAbove;
                this.replaceBelow = this.replaceBelow == null || this.replaceBelow.length() == 0 ? ((BO4)parentBO3).getConfig().replaceBelow : this.replaceBelow;
                BO4CustomStructureCoordinate rotatedParentMaxCoords = BO4CustomStructureCoordinate.getRotatedBO3Coords(((BO4)parentBO3).getConfig().maxX, ((BO4)parentBO3).getConfig().maxY, ((BO4)parentBO3).getConfig().maxZ, this.inheritBO3Rotation);
                BO4CustomStructureCoordinate rotatedParentMinCoords = BO4CustomStructureCoordinate.getRotatedBO3Coords(((BO4)parentBO3).getConfig().minX, ((BO4)parentBO3).getConfig().minY, ((BO4)parentBO3).getConfig().minZ, this.inheritBO3Rotation);
                int parentMaxX = rotatedParentMaxCoords.getX() > rotatedParentMinCoords.getX() ? rotatedParentMaxCoords.getX() : rotatedParentMinCoords.getX();
                int parentMinX = rotatedParentMaxCoords.getX() < rotatedParentMinCoords.getX() ? rotatedParentMaxCoords.getX() : rotatedParentMinCoords.getX();
                short parentMaxY = rotatedParentMaxCoords.getY() > rotatedParentMinCoords.getY() ? rotatedParentMaxCoords.getY() : rotatedParentMinCoords.getY();
                short parentMinY = rotatedParentMaxCoords.getY() < rotatedParentMinCoords.getY() ? rotatedParentMaxCoords.getY() : rotatedParentMinCoords.getY();
                int parentMaxZ = rotatedParentMaxCoords.getZ() > rotatedParentMinCoords.getZ() ? rotatedParentMaxCoords.getZ() : rotatedParentMinCoords.getZ();
                int n = parentMinZ = rotatedParentMaxCoords.getZ() < rotatedParentMinCoords.getZ() ? rotatedParentMaxCoords.getZ() : rotatedParentMinCoords.getZ();
                if (parentMaxX > this.maxX) {
                    this.maxX = parentMaxX;
                }
                if (parentMinX < this.minX) {
                    this.minX = parentMinX;
                }
                if (parentMaxY > this.maxY) {
                    this.maxY = parentMaxY;
                }
                if (parentMinY < this.minY) {
                    this.minY = parentMinY;
                }
                if (parentMaxZ > this.maxZ) {
                    this.maxZ = parentMaxZ;
                }
                if (parentMinZ < this.minZ) {
                    this.minZ = parentMinZ;
                }
                BO4BlockFunction[] parentBlocks = ((BO4)parentBO3).getConfig().getBlocks();
                ArrayList<BO4BlockFunction> newBlocks = new ArrayList<BO4BlockFunction>();
                newBlocks.addAll(new ArrayList<BO4BlockFunction>(Arrays.asList(parentBlocks)));
                newBlocks.addAll(new ArrayList<BO4BlockFunction>(Arrays.asList(blocks)));
                short[][] columnSizes = new short[16][16];
                for (BO4BlockFunction bO4BlockFunction : newBlocks) {
                    short[] sArray = columnSizes[bO4BlockFunction.x];
                    int n2 = bO4BlockFunction.z;
                    sArray[n2] = (short)(sArray[n2] + 1);
                }
                this.loadBlockArrays(newBlocks, columnSizes);
                this.isCollidable = newBlocks.size() > 0;
                ArrayList<BO4BranchFunction> newBranches = new ArrayList<BO4BranchFunction>();
                if (this.branchesOTGPlus != null) {
                    for (BO4BranchFunction branch : this.branchesOTGPlus) {
                        newBranches.add(branch);
                    }
                }
                for (BO4BranchFunction branch : ((BO4)parentBO3).getConfig().branchesOTGPlus) {
                    newBranches.add(branch.rotate(this.inheritBO3Rotation));
                }
                this.branchesOTGPlus = newBranches.toArray(new BO4BranchFunction[newBranches.size()]);
                ArrayList<BO4ModDataFunction> arrayList = new ArrayList<BO4ModDataFunction>();
                if (this.modDataOTGPlus != null) {
                    for (BO4ModDataFunction modData : this.modDataOTGPlus) {
                        arrayList.add(modData);
                    }
                }
                for (BO4ModDataFunction modData : ((BO4)parentBO3).getConfig().modDataOTGPlus) {
                    arrayList.add(modData.rotate(this.inheritBO3Rotation));
                }
                this.modDataOTGPlus = arrayList.toArray(new BO4ModDataFunction[arrayList.size()]);
                ArrayList<BO4SpawnerFunction> newSpawnerData = new ArrayList<BO4SpawnerFunction>();
                if (this.spawnerDataOTGPlus != null) {
                    for (BO4SpawnerFunction spawnerData : this.spawnerDataOTGPlus) {
                        newSpawnerData.add(spawnerData);
                    }
                }
                for (BO4SpawnerFunction spawnerData : ((BO4)parentBO3).getConfig().spawnerDataOTGPlus) {
                    newSpawnerData.add(spawnerData.rotate(this.inheritBO3Rotation));
                }
                this.spawnerDataOTGPlus = newSpawnerData.toArray(new BO4SpawnerFunction[newSpawnerData.size()]);
                ArrayList<BO4ParticleFunction> newParticleData = new ArrayList<BO4ParticleFunction>();
                if (this.particleDataOTGPlus != null) {
                    for (BO4ParticleFunction particleData : this.particleDataOTGPlus) {
                        newParticleData.add(particleData);
                    }
                }
                for (BO4ParticleFunction particleData : ((BO4)parentBO3).getConfig().particleDataOTGPlus) {
                    newParticleData.add(particleData.rotate(this.inheritBO3Rotation));
                }
                this.particleDataOTGPlus = newParticleData.toArray(new BO4ParticleFunction[newParticleData.size()]);
                ArrayList<BO4EntityFunction> newEntityData = new ArrayList<BO4EntityFunction>();
                if (this.entityDataOTGPlus != null) {
                    for (BO4EntityFunction entityData : this.entityDataOTGPlus) {
                        newEntityData.add(entityData);
                    }
                }
                for (BO4EntityFunction entityData : ((BO4)parentBO3).getConfig().entityDataOTGPlus) {
                    newEntityData.add(entityData.rotate(this.inheritBO3Rotation));
                }
                this.entityDataOTGPlus = newEntityData.toArray(new BO4EntityFunction[newEntityData.size()]);
                this.inheritedBO3s.addAll(((BO4)parentBO3).getConfig().getInheritedBO3s());
            }
            if (!this.inheritedBO3Loaded && OTG.getPluginConfig().spawnLog) {
                OTG.log(LogMarker.WARN, "could not load BO3 parent for InheritBO3: " + this.inheritBO3 + " in BO3 " + this.getName(), new Object[0]);
            }
        }
    }

    private void readResources() throws InvalidConfigException {
        boolean bl;
        boolean bl2;
        ArrayList<BO4BlockFunction> tempBlocksList = new ArrayList<BO4BlockFunction>();
        ArrayList<BO4BranchFunction> tempBranchesList = new ArrayList<BO4BranchFunction>();
        ArrayList<BO4EntityFunction> tempEntitiesList = new ArrayList<BO4EntityFunction>();
        ArrayList<BO4ModDataFunction> tempModDataList = new ArrayList<BO4ModDataFunction>();
        ArrayList<BO4ParticleFunction> tempParticlesList = new ArrayList<BO4ParticleFunction>();
        ArrayList<BO4SpawnerFunction> tempSpawnerList = new ArrayList<BO4SpawnerFunction>();
        short[][] columnSizes = new short[16][16];
        ArrayList<CustomObjectConfigFunction<BO4Config>> resources = new ArrayList<CustomObjectConfigFunction<BO4Config>>();
        int minX = 0;
        int maxX = 0;
        int minZ = 0;
        int maxZ = 0;
        for (CustomObjectConfigFunction<BO4Config> res : this.reader.getConfigFunctions(this, true)) {
            if (!res.isValid()) continue;
            resources.add(res);
            if (res instanceof BranchFunction || res instanceof CustomObjectErroredFunction) continue;
            if (res.x < minX) {
                minX = res.x;
            }
            if (res.x > maxX) {
                maxX = res.x;
            }
            if (res.z < minZ) {
                minZ = res.z;
            }
            if (res.z <= maxZ) continue;
            maxZ = res.z;
        }
        int xSize = Math.abs(minX - maxX);
        int zSize = Math.abs(minZ - maxZ);
        if (xSize > 15 || zSize > 15) {
            if (OTG.getPluginConfig().spawnLog) {
                OTG.log(LogMarker.INFO, "BO4 " + this.getName() + " was too large (" + xSize + "x" + zSize + "), BO4's can be max 16x16 blocks.", new Object[0]);
            }
            throw new InvalidConfigException("BO4 " + this.getName() + " was too large, BO4's can be max 16x16 blocks.");
        }
        int xOffset = 0;
        int zOffset = 0;
        if (minX < -8) {
            xOffset = -minX - 8;
        }
        if (maxX > 7) {
            xOffset = -(maxX - 7);
        }
        if (minZ < -7) {
            zOffset = -minZ - 7;
        }
        if (maxZ > 8) {
            zOffset = -(maxZ - 8);
        }
        for (CustomObjectConfigFunction customObjectConfigFunction : resources) {
            if (!(customObjectConfigFunction instanceof BranchFunction) && !(customObjectConfigFunction instanceof CustomObjectErroredFunction)) {
                customObjectConfigFunction.x += xOffset;
                customObjectConfigFunction.z += zOffset;
            }
            if (customObjectConfigFunction instanceof BO4BlockFunction) {
                this.isCollidable = true;
                if (customObjectConfigFunction instanceof BO4RandomBlockFunction) {
                    tempBlocksList.add((BO4RandomBlockFunction)customObjectConfigFunction);
                    int n = customObjectConfigFunction.x;
                    this.getClass();
                    short[] sArray = columnSizes[n + 16 / 2];
                    int n2 = customObjectConfigFunction.z;
                    this.getClass();
                    int n3 = n2 + 16 / 2 - 1;
                    sArray[n3] = (short)(sArray[n3] + 1);
                } else if (!this.removeAir || !((BO4BlockFunction)customObjectConfigFunction).material.isAir()) {
                    tempBlocksList.add((BO4BlockFunction)customObjectConfigFunction);
                    int n = customObjectConfigFunction.x;
                    this.getClass();
                    short[] sArray = columnSizes[n + 16 / 2];
                    int n4 = customObjectConfigFunction.z;
                    this.getClass();
                    int n5 = n4 + 16 / 2 - 1;
                    sArray[n5] = (short)(sArray[n5] + 1);
                }
                if (customObjectConfigFunction.x < this.minX) {
                    this.minX = customObjectConfigFunction.x;
                }
                if (customObjectConfigFunction.x > this.maxX) {
                    this.maxX = customObjectConfigFunction.x;
                }
                if (((BO4BlockFunction)customObjectConfigFunction).y < this.minY) {
                    this.minY = ((BO4BlockFunction)customObjectConfigFunction).y;
                }
                if (((BO4BlockFunction)customObjectConfigFunction).y > this.maxY) {
                    this.maxY = ((BO4BlockFunction)customObjectConfigFunction).y;
                }
                if (customObjectConfigFunction.z < this.minZ) {
                    this.minZ = customObjectConfigFunction.z;
                }
                if (customObjectConfigFunction.z <= this.maxZ) continue;
                this.maxZ = customObjectConfigFunction.z;
                continue;
            }
            if (customObjectConfigFunction instanceof BO4WeightedBranchFunction) {
                tempBranchesList.add((BO4WeightedBranchFunction)customObjectConfigFunction);
                continue;
            }
            if (customObjectConfigFunction instanceof BO4BranchFunction) {
                tempBranchesList.add((BO4BranchFunction)customObjectConfigFunction);
                continue;
            }
            if (customObjectConfigFunction instanceof BO4ModDataFunction) {
                tempModDataList.add((BO4ModDataFunction)customObjectConfigFunction);
                continue;
            }
            if (customObjectConfigFunction instanceof BO4SpawnerFunction) {
                tempSpawnerList.add((BO4SpawnerFunction)customObjectConfigFunction);
                continue;
            }
            if (customObjectConfigFunction instanceof BO4ParticleFunction) {
                tempParticlesList.add((BO4ParticleFunction)customObjectConfigFunction);
                continue;
            }
            if (!(customObjectConfigFunction instanceof BO4EntityFunction)) continue;
            tempEntitiesList.add((BO4EntityFunction)customObjectConfigFunction);
        }
        if (this.minX == Integer.MAX_VALUE) {
            this.minX = -8;
        }
        if (this.maxX == Integer.MIN_VALUE) {
            this.maxX = -8;
        }
        if (this.minY == Integer.MAX_VALUE) {
            this.minY = 0;
        }
        if (this.maxY == Integer.MIN_VALUE) {
            this.maxY = 0;
        }
        if (this.minZ == Integer.MAX_VALUE) {
            this.minZ = -7;
        }
        if (this.maxZ == Integer.MIN_VALUE) {
            this.maxZ = -7;
        }
        boolean illegalBlock = false;
        for (BO4BlockFunction block1 : tempBlocksList) {
            block1.x += this.getXOffset();
            block1.z += this.getZOffset();
            if (block1.x > 15 || block1.z > 15) {
                illegalBlock = true;
            }
            if (block1.x >= 0 && block1.z >= 0) continue;
            illegalBlock = true;
        }
        this.getClass();
        this.getClass();
        this.blocks = new short[16][16][];
        this.blocksMaterial = new LocalMaterialData[tempBlocksList.size()];
        this.blocksMetaDataName = new String[tempBlocksList.size()];
        this.blocksMetaDataTag = new NamedBinaryTag[tempBlocksList.size()];
        this.randomBlocksBlocks = new LocalMaterialData[tempBlocksList.size()][];
        this.randomBlocksBlockChances = new byte[tempBlocksList.size()][];
        this.randomBlocksMetaDataNames = new String[tempBlocksList.size()][];
        this.randomBlocksMetaDataTags = new NamedBinaryTag[tempBlocksList.size()][];
        this.randomBlocksBlockCount = new byte[tempBlocksList.size()];
        this.getClass();
        this.getClass();
        short[][] sArray = new short[16][16];
        BO4BlockFunction[] blocksSorted = new BO4BlockFunction[tempBlocksList.size()];
        int blocksSortedIndex = 0;
        int x = 0;
        while (true) {
            this.getClass();
            if (x >= 16) break;
            int z = 0;
            while (true) {
                this.getClass();
                if (z >= 16) break;
                for (int h = 0; h < tempBlocksList.size(); ++h) {
                    if (((BO4BlockFunction)tempBlocksList.get((int)h)).x != x || ((BO4BlockFunction)tempBlocksList.get((int)h)).z != z) continue;
                    blocksSorted[blocksSortedIndex] = (BO4BlockFunction)tempBlocksList.get(h);
                    ++blocksSortedIndex;
                }
                ++z;
            }
            ++x;
        }
        for (int blockIndex = 0; blockIndex < blocksSorted.length; ++blockIndex) {
            BO4BlockFunction block = blocksSorted[blockIndex];
            if (this.blocks[block.x][block.z] == null) {
                this.blocks[block.x][block.z] = new short[columnSizes[block.x][block.z]];
            }
            this.blocks[block.x][block.z][sArray[block.x][block.z]] = block.y;
            this.blocksMaterial[blockIndex] = block.material;
            this.blocksMetaDataName[blockIndex] = block.metaDataName;
            this.blocksMetaDataTag[blockIndex] = block.metaDataTag;
            if (block instanceof BO4RandomBlockFunction) {
                this.randomBlocksBlocks[blockIndex] = ((BO4RandomBlockFunction)block).blocks;
                this.randomBlocksBlockChances[blockIndex] = ((BO4RandomBlockFunction)block).blockChances;
                this.randomBlocksMetaDataNames[blockIndex] = ((BO4RandomBlockFunction)block).metaDataNames;
                this.randomBlocksMetaDataTags[blockIndex] = ((BO4RandomBlockFunction)block).metaDataTags;
                this.randomBlocksBlockCount[blockIndex] = ((BO4RandomBlockFunction)block).blockCount;
            }
            short[] sArray2 = sArray[block.x];
            int n = block.z;
            sArray2[n] = (short)(sArray2[n] + 1);
        }
        boolean illegalModData = false;
        for (BO4ModDataFunction bO4ModDataFunction : tempModDataList) {
            bO4ModDataFunction.x += this.getXOffset();
            bO4ModDataFunction.z += this.getZOffset();
            if (bO4ModDataFunction.x > 15 || bO4ModDataFunction.z > 15) {
                illegalModData = true;
            }
            if (bO4ModDataFunction.x >= 0 && bO4ModDataFunction.z >= 0) continue;
            illegalModData = true;
        }
        this.modDataOTGPlus = tempModDataList.toArray(new BO4ModDataFunction[tempModDataList.size()]);
        boolean illegalSpawnerData = false;
        for (BO4SpawnerFunction bO4SpawnerFunction : tempSpawnerList) {
            bO4SpawnerFunction.x += this.getXOffset();
            bO4SpawnerFunction.z += this.getZOffset();
            if (bO4SpawnerFunction.x > 15 || bO4SpawnerFunction.z > 15) {
                illegalSpawnerData = true;
            }
            if (bO4SpawnerFunction.x >= 0 && bO4SpawnerFunction.z >= 0) continue;
            illegalSpawnerData = true;
        }
        this.spawnerDataOTGPlus = tempSpawnerList.toArray(new BO4SpawnerFunction[tempSpawnerList.size()]);
        boolean bl3 = false;
        for (BO4ParticleFunction particleData : tempParticlesList) {
            particleData.x += this.getXOffset();
            particleData.z += this.getZOffset();
            if (particleData.x > 15 || particleData.z > 15) {
                bl2 = true;
            }
            if (particleData.x >= 0 && particleData.z >= 0) continue;
            bl2 = true;
        }
        this.particleDataOTGPlus = tempParticlesList.toArray(new BO4ParticleFunction[tempParticlesList.size()]);
        boolean bl4 = false;
        for (BO4EntityFunction entityData : tempEntitiesList) {
            entityData.x += this.getXOffset();
            entityData.z += this.getZOffset();
            if (entityData.x > 15 || entityData.z > 15) {
                bl = true;
            }
            if (entityData.x >= 0 && entityData.z >= 0) continue;
            bl = true;
        }
        this.entityDataOTGPlus = tempEntitiesList.toArray(new BO4EntityFunction[tempEntitiesList.size()]);
        if (OTG.getPluginConfig().spawnLog) {
            if (illegalBlock) {
                OTG.log(LogMarker.WARN, "Warning: BO4 contains Blocks or RandomBlocks that are placed outside the chunk(s) that the BO3 will be placed in. This can slow down world generation. BO4: " + this.getName(), new Object[0]);
            }
            if (illegalModData) {
                OTG.log(LogMarker.WARN, "Warning: BO4 contains ModData that may be placed outside the chunk(s) that the BO3 will be placed in. This can slow down world generation. BO4: " + this.getName(), new Object[0]);
            }
            if (illegalSpawnerData) {
                OTG.log(LogMarker.WARN, "Warning: BO4 contains a Spawner() that may be placed outside the chunk(s) that the BO3 will be placed in. This can slow down world generation. BO4: " + this.getName(), new Object[0]);
            }
            if (bl2) {
                OTG.log(LogMarker.WARN, "Warning: BO4 contains a Particle() that may be placed outside the chunk(s) that the BO3 will be placed in. This can slow down world generation. BO4: " + this.getName(), new Object[0]);
            }
            if (bl) {
                OTG.log(LogMarker.WARN, "Warning: BO4 contains an Entity() that may be placed outside the chunk(s) that the BO3 will be placed in. This can slow down world generation. BO4: " + this.getName(), new Object[0]);
            }
        }
        this.branchesOTGPlus = tempBranchesList.toArray(new BO4BranchFunction[tempBranchesList.size()]);
    }

    public void setBranches(List<BO4BranchFunction> branches) {
        this.branchesOTGPlus = branches.toArray(new BO4BranchFunction[branches.size()]);
    }

    @Override
    public File getFile() {
        return this.reader.getFile();
    }

    @Override
    protected void writeConfigSettings(SettingsWriterOTGPlus writer) throws IOException {
        this.writeSettings(writer, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeWithData(SettingsWriterOTGPlus writer, List<BO4BlockFunction> blocksList, List<BO4BranchFunction> branchesList) throws IOException {
        writer.setConfigMode(WorldConfig.ConfigMode.WriteAll);
        try {
            writer.open();
            this.writeSettings(writer, blocksList, branchesList);
        }
        finally {
            writer.close();
        }
    }

    private void writeSettings(SettingsWriterOTGPlus writer, List<BO4BlockFunction> blocksList, List<BO4BranchFunction> branchesList) throws IOException {
        writer.bigTitle("BO4 object");
        writer.comment("This is the config file of a custom object.");
        writer.comment("If you add this object correctly to your BiomeConfigs, it will spawn in the world.");
        writer.comment("");
        writer.comment("This is the creator of this BO4 object");
        writer.setting(BO4Settings.AUTHOR, this.author);
        writer.comment("A short description of this BO4 object");
        writer.setting(BO4Settings.DESCRIPTION, this.description);
        if (writer.getFile().getName().toUpperCase().endsWith(".BO3")) {
            writer.comment("Legacy setting, always true for BO4's. Only used if the file has a .BO3 extension.");
            writer.comment("Rename your file to .BO4 and remove this setting.");
            writer.setting(BO4Settings.ISOTGPLUS, true);
        }
        writer.comment("The settings mode, WriteAll, WriteWithoutComments or WriteDisable. See WorldConfig.");
        writer.setting(WorldStandardValues.SETTINGS_MODE_BO3, this.settingsMode);
        writer.bigTitle("Main settings");
        writer.comment("This BO4 can only spawn at least Frequency chunks distance away from any other BO4 with the exact same name.");
        writer.comment("You can use this to make this BO4 spawn in groups or make sure that this BO4 only spawns once every X chunks.");
        writer.setting(BO4Settings.FREQUENCY, this.frequency);
        writer.comment("The spawn height of the BO4: randomY, highestBlock or highestSolidBlock.");
        writer.setting(BO3Settings.SPAWN_HEIGHT, this.spawnHeight);
        writer.comment("When set to true, uses the center of the structure (determined by minimum structure size) when checking the highestBlock to spawn at.");
        writer.setting(BO4Settings.USE_CENTER_FOR_HIGHEST_BLOCK, this.useCenterForHighestBlock);
        writer.smallTitle("Height Limits for the BO4.");
        writer.comment("When in randomY mode used as the minimum Y or in atMinY mode as the actual Y to spawn this BO4 at.");
        writer.setting(BO4Settings.MIN_HEIGHT, this.minHeight);
        writer.comment("When in randomY mode used as the maximum Y to spawn this BO4 at.");
        writer.setting(BO4Settings.MAX_HEIGHT, this.maxHeight);
        writer.comment("Copies the blocks and branches of an existing BO4 into this BO4. You can still add blocks and branches in this BO4, they will be added on top of the inherited blocks and branches.");
        writer.setting(BO4Settings.INHERITBO3, this.inheritBO3);
        writer.comment("Rotates the inheritedBO3's resources (blocks, spawners, checks etc) and branches, defaults to NORTH (no rotation).");
        writer.setting(BO4Settings.INHERITBO3ROTATION, this.inheritBO3Rotation);
        writer.comment("Defaults to true, if true and this is the starting BO4 for this branching structure then this BO4's smoothing and height settings are used for all children (branches).");
        writer.setting(BO4Settings.OVERRIDECHILDSETTINGS, this.overrideChildSettings);
        writer.comment("Defaults to false, if true then this branch uses it's own height settings (SpawnHeight, minHeight, maxHeight, spawnAtWaterLevel) instead of those defined in the starting BO4 for this branching structure.");
        writer.setting(BO4Settings.OVERRIDEPARENTHEIGHT, this.overrideParentHeight);
        writer.comment("If this is set to true then this BO4 can spawn on top of or inside an existing BO4. If this is set to false then this BO4 will use a bounding box to detect collisions with other BO4's, if a collision is detected then this BO4 won't spawn and the current branch is rolled back.");
        writer.setting(BO4Settings.CANOVERRIDE, this.canOverride);
        writer.comment("This branch can only spawn at least branchFrequency chunks (x,z) distance away from any other branch with the exact same name.");
        writer.setting(BO4Settings.BRANCH_FREQUENCY, this.branchFrequency);
        writer.comment("Define groups that this branch belongs to along with a minimum (x,z) range in chunks that this branch must have between it and any other members of this group if it is to be allowed to spawn. Syntax is \"GroupName:Frequency, GoupName2:Frequency2\" etc so for example a branch that belongs to 3 groups: \"BranchFrequencyGroup: Ships:10, Vehicles:5, FloatingThings:3\".");
        writer.setting(BO4Settings.BRANCH_FREQUENCY_GROUP, this.branchFrequencyGroup);
        writer.comment("If this is set to true then this BO4 can only spawn underneath an existing BO4. Used to make sure that dungeons only appear underneath buildings.");
        writer.setting(BO4Settings.MUSTBEBELOWOTHER, this.mustBeBelowOther);
        writer.comment("Used with CanOverride: true. A comma-seperated list of BO4s, this BO4's bounding box must collide with one of the BO4's in the list or this BO4 fails to spawn and the current branch is rolled back. AND/OR is supported, comma is OR, space is AND, f.e: branch1, branch2 branch3, branch 4.");
        writer.setting(BO4Settings.MUSTBEINSIDE, this.mustBeInside);
        writer.comment("Used with CanOverride: true. A comma-seperated list of BO4s, this BO4's bounding box cannot collide with any of the BO4's in the list or this BO4 fails to spawn and the current branch is rolled back.");
        writer.setting(BO4Settings.CANNOTBEINSIDE, this.cannotBeInside);
        writer.comment("Used with CanOverride: true. A comma-seperated list of BO4s, if this BO4's bounding box collides with any of the BO4's in the list then those BO4's won't spawn any blocks. This does not remove or roll back any BO4's.");
        writer.setting(BO4Settings.REPLACESBO3, this.replacesBO3);
        writer.comment("If this is set to true then this BO4 can only spawn inside world borders. Used to make sure that dungeons only appear inside the world borders.");
        writer.setting(BO4Settings.MUSTBEINSIDEWORLDBORDERS, this.mustBeInsideWorldBorders);
        writer.comment("Defaults to true. Set to false if the BO4 is not allowed to spawn on a water block");
        writer.setting(BO4Settings.CANSPAWNONWATER, this.canSpawnOnWater);
        writer.comment("Defaults to false. Set to true if the BO4 is allowed to spawn only on a water block");
        writer.setting(BO4Settings.SPAWNONWATERONLY, this.spawnOnWaterOnly);
        writer.comment("Defaults to false. Set to true if the BO4 and its smoothing area should ignore water when looking for the highest block to spawn on. Defaults to false (things spawn on top of water)");
        writer.setting(BO4Settings.SPAWNUNDERWATER, this.spawnUnderWater);
        writer.comment("Defaults to false. Set to true if the BO4 should spawn at water level");
        writer.setting(BO4Settings.SPAWNATWATERLEVEL, this.spawnAtWaterLevel);
        writer.comment("Spawns the BO4 at a Y offset of this value. Handy when using highestBlock for lowering BO4s into the surrounding terrain when there are layers of ground included in the BO4, also handy when using SpawnAtWaterLevel to lower objects like ships into the water.");
        writer.setting(BO4Settings.HEIGHT_OFFSET, this.heightOffset);
        boolean removeAir = this.readSettings(BO4Settings.REMOVEAIR);
        writer.comment("If set to true removes all AIR blocks from the BO4 so that it can be flooded or buried.");
        writer.setting(BO4Settings.REMOVEAIR, removeAir);
        String replaceAbove = this.readSettings(BO4Settings.REPLACEABOVE);
        writer.comment("Replaces all the non-air blocks that are above this BO4 or its smoothing area with the given block material (should be WATER or AIR or NONE), also applies to smoothing areas although OTG intentionally leaves some of the terrain above them intact. WATER can be used in combination with SpawnUnderWater to fill any air blocks underneath waterlevel with water (and any above waterlevel with air).");
        writer.setting(BO4Settings.REPLACEABOVE, replaceAbove);
        String replaceBelow = this.readSettings(BO4Settings.REPLACEBELOW);
        writer.comment("Replaces all air blocks underneath the BO4 (but not its smoothing area) with the specified material until a solid block is found.");
        writer.setting(BO4Settings.REPLACEBELOW, replaceBelow);
        writer.comment("Defaults to true. If set to true then every block in the BO4 of the materials defined in ReplaceWithGroundBlock or ReplaceWithSurfaceBlock will be replaced by the GroundBlock or SurfaceBlock materials configured for the biome the block is spawned in.");
        writer.setting(BO4Settings.REPLACEWITHBIOMEBLOCKS, this.replaceWithBiomeBlocks);
        writer.comment("Defaults to GRASS, Replaces all the blocks of the given material in the BO4 with the SurfaceBlock configured for the biome it spawns in.");
        writer.setting(BO4Settings.REPLACEWITHSURFACEBLOCK, this.replaceWithSurfaceBlock);
        writer.comment("Defaults to DIRT, Replaces all the blocks of the given material in the BO4 with the GroundBlock configured for the biome it spawns in.");
        writer.setting(BO4Settings.REPLACEWITHGROUNDBLOCK, this.replaceWithGroundBlock);
        writer.comment("Defaults to STONE, Replaces all the blocks of the given material in the BO4 with the StoneBlock configured for the biome it spawns in.");
        writer.setting(BO4Settings.REPLACEWITHSTONEBLOCK, this.replaceWithStoneBlock);
        writer.comment("Makes the terrain around the BO4 slope evenly towards the edges of the BO4. The given value is the distance in blocks around the BO4 from where the slope should start and can be any positive number.");
        writer.setting(BO4Settings.SMOOTHRADIUS, this.smoothRadius);
        writer.comment("Moves the smoothing area up or down relative to the BO4 (at the points where the smoothing area is connected to the BO4). Handy when using SmoothStartTop: false and the BO4 has some layers of ground included, in that case we can set the HeightOffset to a negative value to lower the BO4 into the ground and we can set the SmoothHeightOffset to a positive value to move the smoothing area starting height up.");
        writer.setting(BO4Settings.SMOOTH_HEIGHT_OFFSET, this.smoothHeightOffset);
        writer.comment("Should the smoothing area be attached at the bottom or the top of the edges of the BO4? Defaults to false (bottom). Using this setting can make things slower so try to avoid using it and use SmoothHeightOffset instead if for instance you have a BO4 with some ground layers included. The only reason you should need to use this setting is if you have a BO4 with edges that have an irregular height (like some hills).");
        writer.setting(BO4Settings.SMOOTHSTARTTOP, this.smoothStartTop);
        writer.comment("Should the smoothing area attach itself to \"log\" block or ignore them? Defaults to false (ignore logs).");
        writer.setting(BO4Settings.SMOOTHSTARTWOOD, this.smoothStartWood);
        writer.comment("The block used for smoothing area surface blocks, defaults to biome SurfaceBlock.");
        writer.setting(BO4Settings.SMOOTHINGSURFACEBLOCK, this.smoothingSurfaceBlock);
        writer.comment("The block used for smoothing area ground blocks, defaults to biome GroundBlock.");
        writer.setting(BO4Settings.SMOOTHINGGROUNDBLOCK, this.smoothingGroundBlock);
        writer.comment("Define groups that this BO4 belongs to along with a minimum range in chunks that this BO4 must have between it and any other members of this group if it is to be allowed to spawn. Syntax is \"GroupName:Frequency, GoupName2:Frequency2\" etc so for example a BO4 that belongs to 3 groups: \"BO4Group: Ships:10, Vehicles:5, FloatingThings:3\".");
        writer.setting(BO4Settings.BO3GROUP, this.bo3Group);
        writer.comment("Defaults to false. Set to true if this BO4 should spawn at the player spawn point. When the server starts the spawn point is determined and the BO4's for the biome it is in are loaded, one of these BO4s that has IsSpawnPoint set to true (if any) is selected randomly and is spawned at the spawn point regardless of its rarity (so even Rarity:0, IsSpawnPoint: true BO4's can get spawned as the spawn point!).");
        writer.setting(BO4Settings.ISSPAWNPOINT, this.isSpawnPoint);
        writer.comment("Defaults to true. Set to false to make the BO4 ignore any ReplacedBlocks settings in Biome Configs.");
        writer.setting(BO4Settings.DO_REPLACE_BLOCKS, this.doReplaceBlocks);
        this.writeResources(writer, blocksList, branchesList);
        if (this.reader != null) {
            this.reader.flushCache();
        }
    }

    @Override
    protected void readConfigSettings() throws InvalidConfigException {
        String[] replacesBO3Strings;
        String[] cannotBeInsideStrings;
        String[] mustBeInsideStrings;
        String[] groupString;
        int i;
        String[] groupStrings;
        this.branchFrequency = this.readSettings(BO4Settings.BRANCH_FREQUENCY);
        this.branchFrequencyGroup = this.readSettings(BO4Settings.BRANCH_FREQUENCY_GROUP);
        this.branchFrequencyGroups = new HashMap();
        if (this.branchFrequencyGroup != null && this.branchFrequencyGroup.trim().length() > 0 && (groupStrings = this.branchFrequencyGroup.split(",")) != null && groupStrings.length > 0) {
            for (i = 0; i < groupStrings.length; ++i) {
                String[] stringArray = groupString = groupStrings[i].trim().length() > 0 ? groupStrings[i].split(":") : null;
                if (groupString == null || groupString.length != 2) continue;
                this.branchFrequencyGroups.put(groupString[0].trim(), Integer.parseInt(groupString[1].trim()));
            }
        }
        this.heightOffset = this.readSettings(BO4Settings.HEIGHT_OFFSET);
        this.inheritBO3Rotation = this.readSettings(BO4Settings.INHERITBO3ROTATION);
        this.removeAir = this.readSettings(BO4Settings.REMOVEAIR);
        this.isSpawnPoint = this.readSettings(BO4Settings.ISSPAWNPOINT);
        this.useCenterForHighestBlock = this.readSettings(BO4Settings.USE_CENTER_FOR_HIGHEST_BLOCK);
        this.replaceAbove = this.readSettings(BO4Settings.REPLACEABOVE);
        this.replaceBelow = this.readSettings(BO4Settings.REPLACEBELOW);
        this.replaceWithBiomeBlocks = this.readSettings(BO4Settings.REPLACEWITHBIOMEBLOCKS);
        this.replaceWithGroundBlock = this.readSettings(BO4Settings.REPLACEWITHGROUNDBLOCK);
        this.replaceWithSurfaceBlock = this.readSettings(BO4Settings.REPLACEWITHSURFACEBLOCK);
        this.replaceWithStoneBlock = this.readSettings(BO4Settings.REPLACEWITHSTONEBLOCK);
        this.bo3Group = this.readSettings(BO4Settings.BO3GROUP);
        this.bo4Groups = new HashMap();
        if (this.bo3Group != null && this.bo3Group.trim().length() > 0 && (groupStrings = this.bo3Group.split(",")) != null && groupStrings.length > 0) {
            for (i = 0; i < groupStrings.length; ++i) {
                String[] stringArray = groupString = groupStrings[i].trim().length() > 0 ? groupStrings[i].split(":") : null;
                if (groupString == null || groupString.length != 2) continue;
                this.bo4Groups.put(groupString[0].trim(), Integer.parseInt(groupString[1].trim()));
            }
        }
        this.canOverride = this.readSettings(BO4Settings.CANOVERRIDE);
        this.mustBeBelowOther = this.readSettings(BO4Settings.MUSTBEBELOWOTHER);
        this.mustBeInsideWorldBorders = this.readSettings(BO4Settings.MUSTBEINSIDEWORLDBORDERS);
        this.mustBeInside = this.readSettings(BO4Settings.MUSTBEINSIDE);
        this.mustBeInsideBranches = new ArrayList();
        if (this.mustBeInside != null && this.mustBeInside.trim().length() > 0 && (mustBeInsideStrings = this.mustBeInside.split(",")) != null && mustBeInsideStrings.length > 0) {
            for (i = 0; i < mustBeInsideStrings.length; ++i) {
                String mustBeInsideString = mustBeInsideStrings[i].trim();
                if (mustBeInsideString.length() <= 0) continue;
                this.mustBeInsideBranches.add(mustBeInsideString);
            }
        }
        this.cannotBeInside = this.readSettings(BO4Settings.CANNOTBEINSIDE);
        this.cannotBeInsideBranches = new ArrayList();
        if (this.cannotBeInside != null && this.cannotBeInside.trim().length() > 0 && (cannotBeInsideStrings = this.cannotBeInside.split(",")) != null && cannotBeInsideStrings.length > 0) {
            for (i = 0; i < cannotBeInsideStrings.length; ++i) {
                String cannotBeInsideString = cannotBeInsideStrings[i].trim();
                if (cannotBeInsideString.length() <= 0) continue;
                this.cannotBeInsideBranches.add(cannotBeInsideString);
            }
        }
        this.replacesBO3 = this.readSettings(BO4Settings.REPLACESBO3);
        this.replacesBO3Branches = new ArrayList();
        if (this.replacesBO3 != null && this.replacesBO3.trim().length() > 0 && (replacesBO3Strings = this.replacesBO3.split(",")) != null && replacesBO3Strings.length > 0) {
            for (i = 0; i < replacesBO3Strings.length; ++i) {
                String replacesBO3String = replacesBO3Strings[i].trim();
                if (replacesBO3String.length() <= 0) continue;
                this.replacesBO3Branches.add(replacesBO3String);
            }
        }
        this.smoothHeightOffset = this.readSettings(BO4Settings.SMOOTH_HEIGHT_OFFSET);
        this.canSpawnOnWater = this.readSettings(BO4Settings.CANSPAWNONWATER);
        this.spawnOnWaterOnly = this.readSettings(BO4Settings.SPAWNONWATERONLY);
        this.spawnUnderWater = this.readSettings(BO4Settings.SPAWNUNDERWATER);
        this.spawnAtWaterLevel = this.readSettings(BO4Settings.SPAWNATWATERLEVEL);
        this.inheritBO3 = this.readSettings(BO4Settings.INHERITBO3);
        this.overrideChildSettings = this.readSettings(BO4Settings.OVERRIDECHILDSETTINGS);
        this.overrideParentHeight = this.readSettings(BO4Settings.OVERRIDEPARENTHEIGHT);
        this.smoothRadius = this.readSettings(BO4Settings.SMOOTHRADIUS);
        this.smoothStartTop = this.readSettings(BO4Settings.SMOOTHSTARTTOP);
        this.smoothStartWood = this.readSettings(BO4Settings.SMOOTHSTARTWOOD);
        this.smoothingSurfaceBlock = this.readSettings(BO4Settings.SMOOTHINGSURFACEBLOCK);
        this.smoothingGroundBlock = this.readSettings(BO4Settings.SMOOTHINGGROUNDBLOCK);
        if (this.heightOffset < 0 && this.minHeight < -this.heightOffset) {
            this.minHeight = -this.heightOffset;
        }
        this.inheritedBO3s = new ArrayList();
        this.inheritedBO3s.add(this.getName());
        if (this.inheritBO3 != null && this.inheritBO3.trim().length() > 0) {
            this.inheritedBO3s.add(this.inheritBO3);
        }
        this.author = this.readSettings(BO4Settings.AUTHOR);
        this.description = this.readSettings(BO4Settings.DESCRIPTION);
        this.settingsMode = this.readSettings(WorldStandardValues.SETTINGS_MODE_BO3);
        this.frequency = this.readSettings(BO4Settings.FREQUENCY);
        this.spawnHeight = this.readSettings(BO3Settings.SPAWN_HEIGHT);
        this.minHeight = this.readSettings(BO4Settings.MIN_HEIGHT);
        this.maxHeight = this.readSettings(BO4Settings.MAX_HEIGHT);
        this.maxHeight = this.maxHeight < this.minHeight ? this.minHeight : this.maxHeight;
        this.doReplaceBlocks = this.readSettings(BO4Settings.DO_REPLACE_BLOCKS);
        this.readResources();
        this.loadInheritedBO3();
    }

    private void writeResources(SettingsWriterOTGPlus writer, List<BO4BlockFunction> blocksList, List<BO4BranchFunction> branchesList) throws IOException {
        writer.bigTitle("Blocks");
        writer.comment("All the blocks used in the BO4 are listed here. Possible blocks:");
        writer.comment("Block(x,y,z,id[.data][,nbtfile.nbt)");
        writer.comment("RandomBlock(x,y,z,id[:data][,nbtfile.nbt],chance[,id[:data][,nbtfile.nbt],chance[,...]])");
        writer.comment(" So RandomBlock(0,0,0,CHEST,chest.nbt,50,CHEST,anotherchest.nbt,100) will spawn a chest at");
        writer.comment(" the BO4 origin, and give it a 50% chance to have the contents of chest.nbt, or, if that");
        writer.comment(" fails, a 100% percent chance to have the contents of anotherchest.nbt.");
        writer.comment("MinecraftObject(x,y,z,name) (TODO: This may not work anymore and needs to be tested.");
        writer.comment(" Spawns an object in the Mojang NBT structure format. For example, ");
        writer.comment(" MinecraftObject(0,0,0," + DefaultStructurePart.IGLOO_BOTTOM.getPath() + ")");
        writer.comment(" spawns the bottom part of an igloo.");
        ArrayList<BO4ModDataFunction> modDataList = new ArrayList<BO4ModDataFunction>();
        ArrayList<BO4ParticleFunction> particlesList = new ArrayList<BO4ParticleFunction>();
        ArrayList<BO4SpawnerFunction> spawnerList = new ArrayList<BO4SpawnerFunction>();
        ArrayList<BO4EntityFunction> entitiesList = new ArrayList<BO4EntityFunction>();
        if (blocksList == null || branchesList == null || entitiesList == null) {
            blocksList = new ArrayList<BO4BlockFunction>();
            branchesList = new ArrayList<BO4BranchFunction>();
            for (CustomObjectConfigFunction customObjectConfigFunction : this.reader.getConfigFunctions(this, true)) {
                if (!customObjectConfigFunction.isValid()) continue;
                if (customObjectConfigFunction instanceof BO4RandomBlockFunction) {
                    blocksList.add((BO4RandomBlockFunction)customObjectConfigFunction);
                    continue;
                }
                if (customObjectConfigFunction instanceof BO4BlockFunction) {
                    blocksList.add((BO4BlockFunction)customObjectConfigFunction);
                    continue;
                }
                if (customObjectConfigFunction instanceof BO4WeightedBranchFunction) {
                    branchesList.add((BO4WeightedBranchFunction)customObjectConfigFunction);
                    continue;
                }
                if (customObjectConfigFunction instanceof BO4BranchFunction) {
                    branchesList.add((BO4BranchFunction)customObjectConfigFunction);
                    continue;
                }
                if (customObjectConfigFunction instanceof BO4ModDataFunction) {
                    modDataList.add((BO4ModDataFunction)customObjectConfigFunction);
                    continue;
                }
                if (customObjectConfigFunction instanceof BO4SpawnerFunction) {
                    spawnerList.add((BO4SpawnerFunction)customObjectConfigFunction);
                    continue;
                }
                if (customObjectConfigFunction instanceof BO4ParticleFunction) {
                    particlesList.add((BO4ParticleFunction)customObjectConfigFunction);
                    continue;
                }
                if (!(customObjectConfigFunction instanceof BO4EntityFunction)) continue;
                entitiesList.add((BO4EntityFunction)customObjectConfigFunction);
            }
        }
        for (BO4BlockFunction bO4BlockFunction : blocksList) {
            writer.function(bO4BlockFunction);
        }
        writer.bigTitle("Branches");
        writer.comment("Branches are child-BO4's that spawn if this BO4 is configured to spawn as a");
        writer.comment("CustomStructure resource in a biome config. Branches can have branches,");
        writer.comment("making complex structures possible. See the wiki for more details.");
        writer.comment("");
        writer.comment("Regular Branches spawn each branch with an independent chance of spawning.");
        writer.comment("Branch(x,y,z,isRequiredBranch,branchName,rotation,chance,branchDepth[,anotherBranchName,rotation,chance,branchDepth[,...]][IndividualChance])");
        writer.comment("branchName - name of the object to spawn.");
        writer.comment("rotation - NORTH, SOUTH, EAST or WEST.");
        writer.comment("IndividualChance - The chance each branch has to spawn, assumed to be 100 when left blank");
        writer.comment("isRequiredBranch - If this is set to true then at least one of the branches in this BO4 must spawn at these x,y,z coordinates. If no branch can spawn there then this BO4 fails to spawn and its branch is rolled back.");
        writer.comment("isRequiredBranch:true branches must spawn or the current branch is rolled back entirely. This is useful for grouping BO4's that must spawn together, for instance a single room made of multiple BO4's/branches.");
        writer.comment("If all parts of the room are connected together via isRequiredBranch:true branches then either the entire room will spawns or no part of it will spawn.");
        writer.comment("*Note: When isRequiredBranch:true only one BO4 can be added per Branch() and it will automatically have a rarity of 100.0.");
        writer.comment("isRequiredBranch:false branches are used to make optional parts of structures, for instance the middle section of a tunnel that has a beginning, middle and end BO4/branch and can have a variable length by repeating the middle BO4/branch.");
        writer.comment("By making the start and end branches isRequiredBranch:true and the middle branch isRequiredbranch:false you can make it so that either:");
        writer.comment("A. A tunnel spawns with at least a beginning and end branch");
        writer.comment("B. A tunnel spawns with a beginning and end branch and as many middle branches as will fit in the available space.");
        writer.comment("C. No tunnel spawns at all because there wasn't enough space to spawn at least a beginning and end branch.");
        writer.comment("branchDepth - When creating a chain of branches that contains optional (isRequiredBranch:false) branches branch depth is configured for the first BO4 in the chain to determine the maximum length of the chain.");
        writer.comment("branchDepth - 1 is inherited by each isRequiredBranch:false branch in the chain. When branchDepth is zero isRequiredBranch:false branches cannot spawn and the chain ends. In the case of the tunnel this means the last middle branch would be");
        writer.comment("rolled back and an IsRequiredBranch:true end branch could be spawned in its place to make sure the tunnel has a proper ending.");
        writer.comment("Instead of inheriting branchDepth - 1 from the parent branchDepth can be overridden by child branches if it is set higher than 0 (the default value).");
        writer.comment("isRequiredBranch:true branches do inherit branchDepth and pass it on to their own branches, however they cannot be prevented from spawning by it and also don't subtract 1 from branchDepth when inheriting it.");
        writer.comment("");
        writer.comment("Weighted Branches spawn branches with a dependent chance of spawning.");
        writer.comment("WeightedBranch(x,y,z,isRequiredBranch,branchName,rotation,chance,branchDepth[,anotherBranchName,rotation,chance,branchDepth[,...]][MaxChanceOutOf])");
        writer.comment("*Note: isRequiredBranch must be set to false. It is not possible to use isRequiredBranch:true with WeightedBranch() since isRequired:true branches must spawn and automatically have a rarity of 100.0.");
        writer.comment("MaxChanceOutOf - The chance all branches have to spawn out of, assumed to be 100 when left blank");
        for (BO4BranchFunction bO4BranchFunction : branchesList) {
            writer.function(bO4BranchFunction);
        }
        writer.bigTitle("Entities");
        writer.comment("Forge only (this may have changed, check for updates).");
        writer.comment("An EntityFunction spawns an entity instead of a block. The entity is spawned only once when the BO4 is spawned.");
        writer.comment("Entities are persistent by default so they don't de-spawn when no player is near, they are only unloaded.");
        writer.comment("Usage: Entity(x,y,z,entityName,groupSize,NameTagOrNBTFileName) or Entity(x,y,z,mobName,groupSize)");
        writer.comment("Use /otg entities to get a list of entities that can be used as entityName, this includes entities added by other mods and non-living entities.");
        writer.comment("NameTagOrNBTFileName can be either a nametag for the mob or an .txt file with nbt data (such as myentityinfo.txt).");
        writer.comment("In the text file you can use the same mob spawning parameters used with the /summon command to equip the");
        writer.comment("entity and give it custom attributes etc. You can copy the DATA part of a summon command including surrounding ");
        writer.comment("curly braces to a .txt file, for instance for: \"/summon Skeleton x y z {DATA}\"");
        for (BO4EntityFunction bO4EntityFunction : entitiesList) {
            writer.function(bO4EntityFunction);
        }
        writer.bigTitle("Particles");
        writer.comment("Forge only (this may have changed, check for updates).");
        writer.comment("Creates an invisible particle spawner at the given location that spawns particles every x milliseconds.");
        writer.comment("Usage: Particle(x,y,z,particleName,interval,velocityX,velocityY,velocityZ)");
        writer.comment("velocityX, velocityY and velocityZ are optional.");
        writer.comment("Only vanilla particle names can be used, for 1.11.2 these are;");
        writer.comment("explode, largeexplode, hugeexplosion, fireworksSpark, bubble, splash, wake, suspended");
        writer.comment("depthsuspend, crit, magicCrit, smoke, largesmoke, spell, instantSpell, mobSpell");
        writer.comment("mobSpellAmbient, witchMagic, dripWater, dripLava, angryVillager, happyVillager");
        writer.comment("townaura, note, portal, enchantmenttable, flame, lava, footstep, cloud, reddust");
        writer.comment("snowballpoof,  snowshovel, slime, heart, barrier, iconcrack, blockcrack, blockdust");
        writer.comment("droplet, take, mobappearance, dragonbreath, endRod, damageIndicator, sweepAttack");
        writer.comment("fallingdust, totem, spit.");
        writer.comment("Use /otg particles (forge only) to show a list of particles.");
        writer.comment("velocityX,velocityY,velocityZ - Spawn the enemy with the given velocity. If this is not filled in then a small random velocity is applied.");
        for (BO4ParticleFunction bO4ParticleFunction : particlesList) {
            writer.function(bO4ParticleFunction);
        }
        writer.bigTitle("Spawners");
        writer.comment("Forge only (this may have changed, check for updates).");
        writer.comment("Creates an invisible entity spawner at the given location that spawns entities every x seconds.");
        writer.comment("Entities can only spawn if their spawn requirements are met (zombies/skeletons only spawn in the dark etc). Max entity count for the server is ignored, each spawner has its own maxCount setting.");
        writer.comment("Usage: Spawner(x,y,z,entityName,nbtFileName,groupSize,interval,spawnChance,maxCount,despawnTime,velocityX,velocityY,velocityZ,yaw,pitch)");
        writer.comment("nbtFileName, despawnTime, velocityX, velocityY, velocityZ, yaw and pitch are optional");
        writer.comment("Example Spawner(0, 0, 0, Villager, 1, 5, 100, 5) or Spawner(0, 0, 0, Villager, villager1.txt, 1, 5, 100, 5) or Spawner(0, 0, 0, Villager, 1, 5, 100, 5, 30, 1, 1, 1, 0, 0)");
        writer.comment("entityName - Name of the entity to spawn, use /otg entities to get a list of entities that can be used as entityName, this includes entities added by other mods and non-living entities.");
        writer.comment("nbtFileName - A .txt file with nbt data (such as myentityinfo.txt).");
        writer.comment("In the text file you can use the same mob spawning parameters used with the /summon command to equip the");
        writer.comment("entity and give it custom attributes etc. You can copy the DATA part of a summon command including surrounding ");
        writer.comment("curly braces to a .txt file, for instance for: \"/summon Skeleton x y z {DATA}\"");
        writer.comment("groupSize - Number of entities that should spawn for each successful spawn attempt.");
        writer.comment("interval - Time in seconds between each spawn attempt.");
        writer.comment("spawnChance - For each spawn attempt, the chance between 0-100 that the spawn attempt will succeed.");
        writer.comment("maxCount - The maximum amount of this kind of entity that can exist within 32 blocks. If there are already maxCount or more entities of this type in a 32 radius this spawner will not spawn anything.");
        writer.comment("despawnTime - After despawnTime seconds, if there is no player within 32 blocks of the entity it will despawn..");
        writer.comment("velocityX,velocityY,velocityZ,yaw,pitch - Spawn the enemy with the given velocity and angle, handy for making traps and launchers (shooting arrows and fireballs etc).");
        for (BO4SpawnerFunction bO4SpawnerFunction : spawnerList) {
            writer.function(bO4SpawnerFunction);
        }
        writer.bigTitle("ModData");
        writer.comment("Forge only.");
        writer.comment("Use the ModData() tag to include data that other mods can use");
        writer.comment("Mod makers can use ModData and the /otg GetModData command to test IMC communications between OTG");
        writer.comment("and their mod.");
        writer.comment("Normal users can use it to spawn some mobs and blocks on command.");
        writer.comment("ModData(x,y,z,\"ModName\", \"MyModDataAsText\"");
        writer.comment("Example: ModData(x,y,z,MyCystomNPCMod,SpawnBobHere/WithAPotato/And50Health)");
        writer.comment("Try not to use exotic/reserved characters, like brackets and comma's etc, this stuff isn't fool-proof.");
        writer.comment("Also, use this only to store IDs/object names etc for your mod, DO NOT include things like character dialogue,");
        writer.comment("messages on signs, loot lists etc in this file. As much as possible just store id's/names here and store all the data related to those id's/names in your own mod.");
        writer.comment("OTG has some built in ModData commands for basic mob and block spawning.");
        writer.comment("These are mostly just a demonstration for mod makers to show how ModData.");
        writer.comment("can be used by other mods.");
        writer.comment("For mob spawning in OTG use: ModData(x,y,z,OTG,mob/MobType/Count/Persistent/Name)");
        writer.comment("mob: Makes OTG recognise this as a mob spawning command.");
        writer.comment("MobType: Lower-case, no spaces. Any vanilla mob like dragon, skeleton, wither, villager etc");
        writer.comment("Count: The number of mobs to spawn");
        writer.comment("Persistent (true/false): Should the mobs never de-spawn? If set to true the mob will get a");
        writer.comment("name-tag ingame so you can recognise it.");
        writer.comment("Name: A name-tag for the monster/npc.");
        writer.comment("Example: ModData(0,0,0,OTG,villager/1/true/Bob)");
        writer.comment("To spawn blocks using ModData use: ModData(x,y,z,OTG,block/material)");
        writer.comment("block: Makes OTG recognise this as a block spawning command.");
        writer.comment("material: id or text, custom blocks can be added using ModName:MaterialName.");
        writer.comment("To send all ModData within a radius in chunks around the player to the specified mod");
        writer.comment("use this console command: /otg GetModData ModName Radius");
        writer.comment("ModName: name of the mod, for OTG commands use OTG ");
        writer.comment("Radius (optional): Radius in chunks around the player.");
        for (BO4ModDataFunction bO4ModDataFunction : modDataList) {
            writer.function(bO4ModDataFunction);
        }
    }

    public void writeToStream(DataOutput stream) throws IOException {
        ArrayList<BO4BlockFunction> blocksInColumn;
        int i;
        BO4BlockFunction[] blocks;
        stream.writeInt(this.bo4DataVersion);
        stream.writeInt(this.minimumSizeTop);
        stream.writeInt(this.minimumSizeBottom);
        stream.writeInt(this.minimumSizeLeft);
        stream.writeInt(this.minimumSizeRight);
        stream.writeInt(this.minX);
        stream.writeInt(this.maxX);
        stream.writeInt(this.minY);
        stream.writeInt(this.maxY);
        stream.writeInt(this.minZ);
        stream.writeInt(this.maxZ);
        StreamHelper.writeStringToStream(stream, this.author);
        StreamHelper.writeStringToStream(stream, this.description);
        StreamHelper.writeStringToStream(stream, this.settingsMode.name());
        stream.writeInt(this.frequency);
        StreamHelper.writeStringToStream(stream, this.spawnHeight.name());
        stream.writeInt(this.minHeight);
        stream.writeInt(this.maxHeight);
        stream.writeShort(this.inheritedBO3s.size());
        for (String string : this.inheritedBO3s) {
            StreamHelper.writeStringToStream(stream, string);
        }
        StreamHelper.writeStringToStream(stream, this.inheritBO3);
        StreamHelper.writeStringToStream(stream, this.inheritBO3Rotation.name());
        stream.writeBoolean(this.overrideChildSettings);
        stream.writeBoolean(this.overrideParentHeight);
        stream.writeBoolean(this.canOverride);
        stream.writeInt(this.branchFrequency);
        StreamHelper.writeStringToStream(stream, this.branchFrequencyGroup);
        stream.writeBoolean(this.mustBeBelowOther);
        stream.writeBoolean(this.mustBeInsideWorldBorders);
        StreamHelper.writeStringToStream(stream, this.mustBeInside);
        StreamHelper.writeStringToStream(stream, this.cannotBeInside);
        StreamHelper.writeStringToStream(stream, this.replacesBO3);
        stream.writeBoolean(this.canSpawnOnWater);
        stream.writeBoolean(this.spawnOnWaterOnly);
        stream.writeBoolean(this.spawnUnderWater);
        stream.writeBoolean(this.spawnAtWaterLevel);
        stream.writeBoolean(this.doReplaceBlocks);
        stream.writeInt(this.heightOffset);
        stream.writeBoolean(this.removeAir);
        StreamHelper.writeStringToStream(stream, this.replaceAbove);
        StreamHelper.writeStringToStream(stream, this.replaceBelow);
        stream.writeBoolean(this.replaceWithBiomeBlocks);
        StreamHelper.writeStringToStream(stream, this.replaceWithSurfaceBlock);
        StreamHelper.writeStringToStream(stream, this.replaceWithGroundBlock);
        StreamHelper.writeStringToStream(stream, this.replaceWithStoneBlock);
        stream.writeInt(this.smoothRadius);
        stream.writeInt(this.smoothHeightOffset);
        stream.writeBoolean(this.smoothStartTop);
        stream.writeBoolean(this.smoothStartWood);
        StreamHelper.writeStringToStream(stream, this.smoothingSurfaceBlock);
        StreamHelper.writeStringToStream(stream, this.smoothingGroundBlock);
        StreamHelper.writeStringToStream(stream, this.bo3Group);
        stream.writeBoolean(this.isSpawnPoint);
        stream.writeBoolean(this.isCollidable);
        stream.writeBoolean(this.useCenterForHighestBlock);
        stream.writeInt(this.branchesOTGPlus.length);
        for (BO4BranchFunction bO4BranchFunction : Arrays.asList(this.branchesOTGPlus)) {
            if (bO4BranchFunction instanceof BO4WeightedBranchFunction) {
                stream.writeBoolean(true);
            } else {
                stream.writeBoolean(false);
            }
            bO4BranchFunction.writeToStream(stream);
        }
        stream.writeInt(this.entityDataOTGPlus.length);
        for (BO4EntityFunction bO4EntityFunction : Arrays.asList(this.entityDataOTGPlus)) {
            bO4EntityFunction.writeToStream(stream);
        }
        stream.writeInt(this.particleDataOTGPlus.length);
        for (BO4ParticleFunction bO4ParticleFunction : Arrays.asList(this.particleDataOTGPlus)) {
            bO4ParticleFunction.writeToStream(stream);
        }
        stream.writeInt(this.spawnerDataOTGPlus.length);
        for (BO4SpawnerFunction bO4SpawnerFunction : Arrays.asList(this.spawnerDataOTGPlus)) {
            bO4SpawnerFunction.writeToStream(stream);
        }
        stream.writeInt(this.modDataOTGPlus.length);
        for (BO4ModDataFunction bO4ModDataFunction : Arrays.asList(this.modDataOTGPlus)) {
            bO4ModDataFunction.writeToStream(stream);
        }
        ArrayList<LocalMaterialData> materials = new ArrayList<LocalMaterialData>();
        ArrayList<String> arrayList = new ArrayList<String>();
        int randomBlockCount = 0;
        int nonRandomBlockCount = 0;
        for (BO4BlockFunction block : blocks = this.getBlocks()) {
            if (block instanceof BO4RandomBlockFunction) {
                ++randomBlockCount;
                for (LocalMaterialData material : ((BO4RandomBlockFunction)block).blocks) {
                    if (materials.contains(material)) continue;
                    materials.add(material);
                }
            } else {
                ++nonRandomBlockCount;
            }
            if (block.material != null && !materials.contains(block.material)) {
                materials.add(block.material);
            }
            if (block.metaDataName == null || arrayList.contains(block.metaDataName)) continue;
            arrayList.add(block.metaDataName);
        }
        String[] metaDataNamesArr = arrayList.toArray(new String[arrayList.size()]);
        LocalMaterialData[] blocksArr = materials.toArray(new LocalMaterialData[materials.size()]);
        stream.writeShort(metaDataNamesArr.length);
        for (i = 0; i < metaDataNamesArr.length; ++i) {
            StreamHelper.writeStringToStream(stream, metaDataNamesArr[i]);
        }
        stream.writeShort(blocksArr.length);
        for (i = 0; i < blocksArr.length; ++i) {
            StreamHelper.writeStringToStream(stream, blocksArr[i].getName());
        }
        stream.writeInt(nonRandomBlockCount);
        int nonRandomBlockIndex = 0;
        if (nonRandomBlockCount > 0) {
            for (int x = this.getminX(); x < 16; ++x) {
                for (int z = this.getminZ(); z < 16; ++z) {
                    blocksInColumn = new ArrayList<BO4BlockFunction>();
                    for (BO4BlockFunction blockFunction : blocks) {
                        if (blockFunction instanceof BO4RandomBlockFunction || blockFunction.x != x || blockFunction.z != z) continue;
                        blocksInColumn.add(blockFunction);
                    }
                    stream.writeShort(blocksInColumn.size());
                    if (blocksInColumn.size() > 0) {
                        for (BO4BlockFunction blockFunction : blocksInColumn) {
                            blockFunction.writeToStream(metaDataNamesArr, blocksArr, stream);
                            ++nonRandomBlockIndex;
                        }
                    }
                    if (nonRandomBlockIndex == nonRandomBlockCount) break;
                }
                if (nonRandomBlockIndex == nonRandomBlockCount) break;
            }
        }
        stream.writeInt(randomBlockCount);
        int randomBlockIndex = 0;
        if (randomBlockCount > 0) {
            for (int x = this.getminX(); x < 16; ++x) {
                for (int z = this.getminZ(); z < 16; ++z) {
                    blocksInColumn = new ArrayList();
                    for (BO4BlockFunction blockFunction : blocks) {
                        if (!(blockFunction instanceof BO4RandomBlockFunction) || blockFunction.x != x || blockFunction.z != z) continue;
                        blocksInColumn.add(blockFunction);
                    }
                    stream.writeShort(blocksInColumn.size());
                    if (blocksInColumn.size() > 0) {
                        for (BO4BlockFunction blockFunction : blocksInColumn) {
                            blockFunction.writeToStream(metaDataNamesArr, blocksArr, stream);
                            ++randomBlockIndex;
                        }
                    }
                    if (randomBlockIndex == randomBlockCount) break;
                }
                if (randomBlockIndex == randomBlockCount) break;
            }
        }
    }

    public BO4Config readFromBO4DataFile(boolean getBlocks) throws InvalidConfigException {
        ByteBuffer bufferCompressed = null;
        ByteBuffer bufferDecompressed = null;
        try {
            FileInputStream fis = new FileInputStream(this.reader.getFile());
            try {
                String[] replacesBO3Strings;
                String[] cannotBeInsideStrings;
                String[] mustBeInsideStrings;
                String[] groupStrings;
                String[] groupStrings2;
                bufferCompressed = fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fis.getChannel().size());
                byte[] compressedBytes = new byte[(int)fis.getChannel().size()];
                bufferCompressed.get(compressedBytes);
                try {
                    byte[] decompressedBytes = CompressionUtils.decompress(compressedBytes);
                    bufferDecompressed = ByteBuffer.wrap(decompressedBytes);
                }
                catch (DataFormatException e1) {
                    e1.printStackTrace();
                }
                boolean isBO4Data = true;
                boolean inheritedBO3Loaded = true;
                int bo4DataVersion = bufferDecompressed.getInt();
                if (bo4DataVersion != this.bo4DataVersion) {
                    if (bufferCompressed != null) {
                        bufferCompressed.clear();
                    }
                    if (bufferDecompressed != null) {
                        bufferDecompressed.clear();
                    }
                    try {
                        fis.getChannel().close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw new InvalidConfigException("Could not read BO4Data file " + this.reader.getName() + ", it is outdated. Delete and re-export BO4Data files to fix this, or delete and reinstall your OTG preset.");
                }
                int minimumSizeTop = bufferDecompressed.getInt();
                int minimumSizeBottom = bufferDecompressed.getInt();
                int minimumSizeLeft = bufferDecompressed.getInt();
                int minimumSizeRight = bufferDecompressed.getInt();
                int minX = bufferDecompressed.getInt();
                int maxX = bufferDecompressed.getInt();
                int minY = bufferDecompressed.getInt();
                int maxY = bufferDecompressed.getInt();
                int minZ = bufferDecompressed.getInt();
                int maxZ = bufferDecompressed.getInt();
                String author = StreamHelper.readStringFromBuffer(bufferDecompressed);
                String description = StreamHelper.readStringFromBuffer(bufferDecompressed);
                WorldConfig.ConfigMode settingsMode = WorldConfig.ConfigMode.valueOf(StreamHelper.readStringFromBuffer(bufferDecompressed));
                int frequency = bufferDecompressed.getInt();
                BO3Settings.SpawnHeightEnum spawnHeight = BO3Settings.SpawnHeightEnum.valueOf(StreamHelper.readStringFromBuffer(bufferDecompressed));
                int minHeight = bufferDecompressed.getInt();
                int maxHeight = bufferDecompressed.getInt();
                int inheritedBO3sSize = bufferDecompressed.getShort();
                ArrayList<String> inheritedBO3s = new ArrayList<String>();
                for (int i = 0; i < inheritedBO3sSize; ++i) {
                    inheritedBO3s.add(StreamHelper.readStringFromBuffer(bufferDecompressed));
                }
                String inheritBO3 = StreamHelper.readStringFromBuffer(bufferDecompressed);
                Rotation inheritBO3Rotation = Rotation.valueOf(StreamHelper.readStringFromBuffer(bufferDecompressed));
                boolean overrideChildSettings = bufferDecompressed.get() != 0;
                boolean overrideParentHeight = bufferDecompressed.get() != 0;
                boolean canOverride = bufferDecompressed.get() != 0;
                int branchFrequency = bufferDecompressed.getInt();
                String branchFrequencyGroup = StreamHelper.readStringFromBuffer(bufferDecompressed);
                boolean mustBeBelowOther = bufferDecompressed.get() != 0;
                boolean mustBeInsideWorldBorders = bufferDecompressed.get() != 0;
                String mustBeInside = StreamHelper.readStringFromBuffer(bufferDecompressed);
                String cannotBeInside = StreamHelper.readStringFromBuffer(bufferDecompressed);
                String replacesBO3 = StreamHelper.readStringFromBuffer(bufferDecompressed);
                boolean canSpawnOnWater = bufferDecompressed.get() != 0;
                boolean spawnOnWaterOnly = bufferDecompressed.get() != 0;
                boolean spawnUnderWater = bufferDecompressed.get() != 0;
                boolean spawnAtWaterLevel = bufferDecompressed.get() != 0;
                boolean doReplaceBlocks = bufferDecompressed.get() != 0;
                int heightOffset = bufferDecompressed.getInt();
                boolean removeAir = bufferDecompressed.get() != 0;
                String replaceAbove = StreamHelper.readStringFromBuffer(bufferDecompressed);
                String replaceBelow = StreamHelper.readStringFromBuffer(bufferDecompressed);
                boolean replaceWithBiomeBlocks = bufferDecompressed.get() != 0;
                String replaceWithSurfaceBlock = StreamHelper.readStringFromBuffer(bufferDecompressed);
                String replaceWithGroundBlock = StreamHelper.readStringFromBuffer(bufferDecompressed);
                String replaceWithStoneBlock = StreamHelper.readStringFromBuffer(bufferDecompressed);
                int smoothRadius = bufferDecompressed.getInt();
                int smoothHeightOffset = bufferDecompressed.getInt();
                boolean smoothStartTop = bufferDecompressed.get() != 0;
                boolean smoothStartWood = bufferDecompressed.get() != 0;
                String smoothingSurfaceBlock = StreamHelper.readStringFromBuffer(bufferDecompressed);
                String smoothingGroundBlock = StreamHelper.readStringFromBuffer(bufferDecompressed);
                String bo3Group = StreamHelper.readStringFromBuffer(bufferDecompressed);
                boolean isSpawnPoint = bufferDecompressed.get() != 0;
                boolean isCollidable = bufferDecompressed.get() != 0;
                boolean useCenterForHighestBlock = bufferDecompressed.get() != 0;
                HashMap<String, Integer> branchFrequencyGroups = new HashMap<String, Integer>();
                if (branchFrequencyGroup != null && branchFrequencyGroup.trim().length() > 0 && (groupStrings2 = branchFrequencyGroup.split(",")) != null && groupStrings2.length > 0) {
                    for (int i = 0; i < groupStrings2.length; ++i) {
                        String[] groupString;
                        String[] stringArray = groupString = groupStrings2[i].trim().length() > 0 ? groupStrings2[i].split(":") : null;
                        if (groupString == null || groupString.length != 2) continue;
                        branchFrequencyGroups.put(groupString[0].trim(), Integer.parseInt(groupString[1].trim()));
                    }
                }
                HashMap<String, Integer> bo4Groups = new HashMap<String, Integer>();
                if (bo3Group != null && bo3Group.trim().length() > 0 && (groupStrings = bo3Group.split(",")) != null && groupStrings.length > 0) {
                    for (int i = 0; i < groupStrings.length; ++i) {
                        String[] groupString;
                        String[] stringArray = groupString = groupStrings[i].trim().length() > 0 ? groupStrings[i].split(":") : null;
                        if (groupString == null || groupString.length != 2) continue;
                        bo4Groups.put(groupString[0].trim(), Integer.parseInt(groupString[1].trim()));
                    }
                }
                ArrayList<String> mustBeInsideBranches = new ArrayList<String>();
                if (mustBeInside != null && mustBeInside.trim().length() > 0 && (mustBeInsideStrings = mustBeInside.split(",")) != null && mustBeInsideStrings.length > 0) {
                    for (int i = 0; i < mustBeInsideStrings.length; ++i) {
                        String mustBeInsideString = mustBeInsideStrings[i].trim();
                        if (mustBeInsideString.length() <= 0) continue;
                        mustBeInsideBranches.add(mustBeInsideString);
                    }
                }
                ArrayList<String> cannotBeInsideBranches = new ArrayList<String>();
                if (cannotBeInside != null && cannotBeInside.trim().length() > 0 && (cannotBeInsideStrings = cannotBeInside.split(",")) != null && cannotBeInsideStrings.length > 0) {
                    for (int i = 0; i < cannotBeInsideStrings.length; ++i) {
                        String cannotBeInsideString = cannotBeInsideStrings[i].trim();
                        if (cannotBeInsideString.length() <= 0) continue;
                        cannotBeInsideBranches.add(cannotBeInsideString);
                    }
                }
                ArrayList<String> replacesBO3Branches = new ArrayList<String>();
                if (replacesBO3 != null && replacesBO3.trim().length() > 0 && (replacesBO3Strings = replacesBO3.split(",")) != null && replacesBO3Strings.length > 0) {
                    for (int i = 0; i < replacesBO3Strings.length; ++i) {
                        String replacesBO3String = replacesBO3Strings[i].trim();
                        if (replacesBO3String.length() <= 0) continue;
                        replacesBO3Branches.add(replacesBO3String);
                    }
                }
                int branchesOTGPlusLength = bufferDecompressed.getInt();
                BO4BranchFunction[] branchesOTGPlus = new BO4BranchFunction[branchesOTGPlusLength];
                for (int i = 0; i < branchesOTGPlusLength; ++i) {
                    boolean branchType = bufferDecompressed.get() != 0;
                    BO4BranchFunction branch = branchType ? BO4WeightedBranchFunction.fromStream(this, bufferDecompressed) : BO4BranchFunction.fromStream(this, bufferDecompressed);
                    branchesOTGPlus[i] = branch;
                }
                int entityDataOTGPlusLength = bufferDecompressed.getInt();
                BO4EntityFunction[] entityDataOTGPlus = new BO4EntityFunction[entityDataOTGPlusLength];
                for (int i = 0; i < entityDataOTGPlusLength; ++i) {
                    entityDataOTGPlus[i] = BO4EntityFunction.fromStream(this, bufferDecompressed);
                }
                int particleDataOTGPlusLength = bufferDecompressed.getInt();
                BO4ParticleFunction[] particleDataOTGPlus = new BO4ParticleFunction[particleDataOTGPlusLength];
                for (int i = 0; i < particleDataOTGPlusLength; ++i) {
                    particleDataOTGPlus[i] = BO4ParticleFunction.fromStream(this, bufferDecompressed);
                }
                int spawnerDataOTGPlusLength = bufferDecompressed.getInt();
                BO4SpawnerFunction[] spawnerDataOTGPlus = new BO4SpawnerFunction[spawnerDataOTGPlusLength];
                for (int i = 0; i < spawnerDataOTGPlusLength; ++i) {
                    spawnerDataOTGPlus[i] = BO4SpawnerFunction.fromStream(this, bufferDecompressed);
                }
                int modDataOTGPlusLength = bufferDecompressed.getInt();
                BO4ModDataFunction[] modDataOTGPlus = new BO4ModDataFunction[modDataOTGPlusLength];
                for (int i = 0; i < modDataOTGPlusLength; ++i) {
                    modDataOTGPlus[i] = BO4ModDataFunction.fromStream(this, bufferDecompressed);
                }
                ArrayList<BO4BlockFunction> newBlocks = new ArrayList<BO4BlockFunction>();
                short[][] columnSizes = null;
                this.minX = minX;
                this.maxX = maxX;
                this.minY = minY;
                this.maxY = maxY;
                this.minZ = minZ;
                this.maxZ = maxZ;
                if (getBlocks) {
                    int metaDataNamesArrLength = bufferDecompressed.getShort();
                    String[] metaDataNames = new String[metaDataNamesArrLength];
                    for (int i = 0; i < metaDataNamesArrLength; ++i) {
                        metaDataNames[i] = StreamHelper.readStringFromBuffer(bufferDecompressed);
                    }
                    int blocksArrArrLength = bufferDecompressed.getShort();
                    LocalMaterialData[] blocksArr = new LocalMaterialData[blocksArrArrLength];
                    for (int i = 0; i < blocksArrArrLength; ++i) {
                        String materialName = StreamHelper.readStringFromBuffer(bufferDecompressed);
                        try {
                            blocksArr[i] = MaterialHelper.readMaterial(materialName);
                            continue;
                        }
                        catch (InvalidConfigException e) {
                            if (!OTG.getPluginConfig().spawnLog) continue;
                            OTG.log(LogMarker.WARN, "Could not read material \"" + materialName + "\" for BO4 \"" + this.getName() + "\"", new Object[0]);
                            e.printStackTrace();
                        }
                    }
                    this.getClass();
                    this.getClass();
                    columnSizes = new short[16][16];
                    int nonRandomBlockCount = bufferDecompressed.getInt();
                    int nonRandomBlockIndex = 0;
                    ArrayList<BO4BlockFunction> nonRandomBlocks = new ArrayList<BO4BlockFunction>();
                    if (nonRandomBlockCount > 0) {
                        int x = this.getminX();
                        while (true) {
                            this.getClass();
                            if (x >= 16) break;
                            int z = this.getminZ();
                            while (true) {
                                this.getClass();
                                if (z >= 16) break;
                                int blocksInColumnSize = bufferDecompressed.getShort();
                                for (int j = 0; j < blocksInColumnSize; ++j) {
                                    short[] sArray = columnSizes[x];
                                    int n = z;
                                    sArray[n] = (short)(sArray[n] + 1);
                                    nonRandomBlocks.add(BO4BlockFunction.fromStream(x, z, metaDataNames, blocksArr, this, bufferDecompressed));
                                    if (nonRandomBlockCount == ++nonRandomBlockIndex) break;
                                }
                                if (nonRandomBlockCount == nonRandomBlockIndex) break;
                                ++z;
                            }
                            if (nonRandomBlockCount == nonRandomBlockIndex) break;
                            ++x;
                        }
                    }
                    int randomBlockCount = bufferDecompressed.getInt();
                    int randomBlockIndex = 0;
                    ArrayList<BO4RandomBlockFunction> randomBlocks = new ArrayList<BO4RandomBlockFunction>();
                    if (randomBlockCount > 0) {
                        int x = this.getminX();
                        while (true) {
                            this.getClass();
                            if (x >= 16) break;
                            int z = this.getminZ();
                            while (true) {
                                this.getClass();
                                if (z >= 16) break;
                                int blocksInColumnSize = bufferDecompressed.getShort();
                                for (int j = 0; j < blocksInColumnSize; ++j) {
                                    short[] sArray = columnSizes[x];
                                    int n = z;
                                    sArray[n] = (short)(sArray[n] + 1);
                                    randomBlocks.add(BO4RandomBlockFunction.fromStream(x, z, metaDataNames, blocksArr, this, bufferDecompressed));
                                    if (randomBlockCount == ++randomBlockIndex) break;
                                }
                                if (randomBlockCount == randomBlockIndex) break;
                                ++z;
                            }
                            if (randomBlockCount == randomBlockIndex) break;
                            ++x;
                        }
                    }
                    newBlocks = new ArrayList();
                    newBlocks.addAll(nonRandomBlocks);
                    newBlocks.addAll(randomBlocks);
                }
                this.isBO4Data = isBO4Data;
                this.inheritedBO3Loaded = inheritedBO3Loaded;
                this.minimumSizeTop = minimumSizeTop;
                this.minimumSizeBottom = minimumSizeBottom;
                this.minimumSizeLeft = minimumSizeLeft;
                this.minimumSizeRight = minimumSizeRight;
                this.author = author;
                this.description = description;
                this.settingsMode = settingsMode;
                this.frequency = frequency;
                this.spawnHeight = spawnHeight;
                this.minHeight = minHeight;
                this.maxHeight = maxHeight;
                this.inheritedBO3s = inheritedBO3s;
                this.inheritBO3 = inheritBO3;
                this.inheritBO3Rotation = inheritBO3Rotation;
                this.overrideChildSettings = overrideChildSettings;
                this.overrideParentHeight = overrideParentHeight;
                this.canOverride = canOverride;
                this.branchFrequency = branchFrequency;
                this.branchFrequencyGroup = branchFrequencyGroup;
                this.mustBeBelowOther = mustBeBelowOther;
                this.mustBeInsideWorldBorders = mustBeInsideWorldBorders;
                this.mustBeInside = mustBeInside;
                this.cannotBeInside = cannotBeInside;
                this.replacesBO3 = replacesBO3;
                this.canSpawnOnWater = canSpawnOnWater;
                this.spawnOnWaterOnly = spawnOnWaterOnly;
                this.spawnUnderWater = spawnUnderWater;
                this.spawnAtWaterLevel = spawnAtWaterLevel;
                this.doReplaceBlocks = doReplaceBlocks;
                this.heightOffset = heightOffset;
                this.removeAir = removeAir;
                this.replaceAbove = replaceAbove;
                this.replaceBelow = replaceBelow;
                this.replaceWithBiomeBlocks = replaceWithBiomeBlocks;
                this.replaceWithSurfaceBlock = replaceWithSurfaceBlock;
                this.replaceWithGroundBlock = replaceWithGroundBlock;
                this.replaceWithStoneBlock = replaceWithStoneBlock;
                this.smoothRadius = smoothRadius;
                this.smoothHeightOffset = smoothHeightOffset;
                this.smoothStartTop = smoothStartTop;
                this.smoothStartWood = smoothStartWood;
                this.smoothingSurfaceBlock = smoothingSurfaceBlock;
                this.smoothingGroundBlock = smoothingGroundBlock;
                this.bo3Group = bo3Group;
                this.isSpawnPoint = isSpawnPoint;
                this.isCollidable = isCollidable;
                this.useCenterForHighestBlock = useCenterForHighestBlock;
                this.branchFrequencyGroups = branchFrequencyGroups;
                this.bo4Groups = bo4Groups;
                this.mustBeInsideBranches = mustBeInsideBranches;
                this.cannotBeInsideBranches = cannotBeInsideBranches;
                this.replacesBO3Branches = replacesBO3Branches;
                this.branchesOTGPlus = branchesOTGPlus;
                this.entityDataOTGPlus = entityDataOTGPlus;
                this.particleDataOTGPlus = particleDataOTGPlus;
                this.spawnerDataOTGPlus = spawnerDataOTGPlus;
                this.modDataOTGPlus = modDataOTGPlus;
                if (getBlocks) {
                    this.loadBlockArrays(newBlocks, columnSizes);
                }
            }
            catch (Error | Exception e1) {
                if (bufferCompressed != null) {
                    bufferCompressed.clear();
                }
                if (bufferDecompressed != null) {
                    bufferDecompressed.clear();
                }
                try {
                    fis.getChannel().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                e1.printStackTrace();
                throw new InvalidConfigException("Could not read BO4Data file " + this.reader.getName() + ", it may be outdated or corrupted. Delete and re-export BO4Data files to fix this, or delete and reinstall your OTG preset.");
            }
            if (bufferCompressed != null) {
                bufferCompressed.clear();
            }
            if (bufferDecompressed != null) {
                bufferDecompressed.clear();
            }
            try {
                fis.getChannel().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
            return null;
        }
        return this;
    }

    private void loadBlockArrays(ArrayList<BO4BlockFunction> newBlocks, short[][] columnSizes) {
        this.blocks = new short[16][16][];
        this.blocksMaterial = new LocalMaterialData[newBlocks.size()];
        this.blocksMetaDataName = new String[newBlocks.size()];
        this.blocksMetaDataTag = new NamedBinaryTag[newBlocks.size()];
        this.randomBlocksBlocks = new LocalMaterialData[newBlocks.size()][];
        this.randomBlocksBlockChances = new byte[newBlocks.size()][];
        this.randomBlocksMetaDataNames = new String[newBlocks.size()][];
        this.randomBlocksMetaDataTags = new NamedBinaryTag[newBlocks.size()][];
        this.randomBlocksBlockCount = new byte[newBlocks.size()];
        short[][] columnBlockIndex = new short[16][16];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (this.blocks[x][z] != null) continue;
                this.blocks[x][z] = new short[columnSizes[x][z]];
            }
        }
        for (int i = 0; i < newBlocks.size(); ++i) {
            BO4BlockFunction block = newBlocks.get(i);
            this.blocks[block.x][block.z][columnBlockIndex[block.x][block.z]] = block.y;
            int blockIndex = columnBlockIndex[block.x][block.z] + this.getColumnBlockIndex(columnSizes, block.x, block.z);
            this.blocksMaterial[blockIndex] = block.material;
            this.blocksMetaDataName[blockIndex] = block.metaDataName;
            this.blocksMetaDataTag[blockIndex] = block.metaDataTag;
            if (block instanceof BO4RandomBlockFunction) {
                this.randomBlocksBlocks[blockIndex] = ((BO4RandomBlockFunction)block).blocks;
                this.randomBlocksBlockChances[blockIndex] = ((BO4RandomBlockFunction)block).blockChances;
                this.randomBlocksMetaDataNames[blockIndex] = ((BO4RandomBlockFunction)block).metaDataNames;
                this.randomBlocksMetaDataTags[blockIndex] = ((BO4RandomBlockFunction)block).metaDataTags;
                this.randomBlocksBlockCount[blockIndex] = ((BO4RandomBlockFunction)block).blockCount;
            }
            short[] sArray = columnBlockIndex[block.x];
            int n = block.z;
            sArray[n] = (short)(sArray[n] + 1);
        }
    }

    private int getColumnBlockIndex(short[][] columnSizes, int columnX, int columnZ) {
        int blockIndex = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (columnX == x && columnZ == z) {
                    return blockIndex;
                }
                blockIndex += columnSizes[x][z];
            }
        }
        return blockIndex;
    }

    @Override
    protected void correctSettings() {
    }

    @Override
    protected void renameOldSettings() {
    }

    public boolean isCollidable() {
        return this.isCollidable;
    }
}

