/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo4;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.io.FileSettingsReaderOTGPlus;
import com.pg85.otg.configuration.io.FileSettingsWriterOTGPlus;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.customobjects.bo4.BO4Config;
import com.pg85.otg.customobjects.bo4.bo4function.BO4BlockFunction;
import com.pg85.otg.customobjects.bo4.bo4function.BO4RandomBlockFunction;
import com.pg85.otg.customobjects.structures.Branch;
import com.pg85.otg.customobjects.structures.StructuredCustomObject;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.NamedBinaryTag;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.materials.MaterialHelper;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import java.io.File;
import java.util.ArrayList;
import java.util.Random;

public class BO4
implements StructuredCustomObject {
    public boolean isInvalidConfig;
    private BO4Config config;
    private final String name;
    private final File file;

    public BO4(String name, File file) {
        this.name = name;
        this.file = file;
    }

    public BO4(String name, File file, BO4Config settings) {
        this.name = name;
        this.file = file;
        this.config = settings;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public BO4Config getConfig() {
        return this.config;
    }

    @Override
    public boolean onEnable() {
        if (this.isInvalidConfig) {
            return false;
        }
        if (this.config != null) {
            return true;
        }
        try {
            this.config = new BO4Config(new FileSettingsReaderOTGPlus(this.name, this.file), true);
            if (this.config.settingsMode != WorldConfig.ConfigMode.WriteDisable && !this.config.isBO4Data) {
                FileSettingsWriterOTGPlus.writeToFile(this.config, this.config.settingsMode);
            }
        }
        catch (InvalidConfigException ex) {
            OTG.log(LogMarker.INFO, ex.getMessage(), new Object[0]);
            this.isInvalidConfig = true;
            return false;
        }
        return true;
    }

    @Override
    public boolean canSpawnAsTree() {
        return false;
    }

    @Override
    public boolean canRotateRandomly() {
        return false;
    }

    @Override
    public boolean loadChecks() {
        return true;
    }

    @Override
    public boolean spawnFromSapling(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        return false;
    }

    @Override
    public boolean spawnForced(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        return false;
    }

    @Override
    public boolean spawnAsTree(LocalWorld world, Random random, int x, int z, int minY, int maxY, ChunkCoordinate chunkBeingPopulated) {
        return false;
    }

    @Override
    public boolean process(LocalWorld world, Random random, ChunkCoordinate chunkCoord) {
        return false;
    }

    public Branch[] getBranches() {
        return this.config.getbranches();
    }

    public boolean isCollidable() {
        return this.getConfig().isCollidable();
    }

    public boolean trySpawnAt(LocalWorld world, Random random, Rotation rotation, ChunkCoordinate chunkCoord, int x, int y, int z, String replaceAbove, String replaceBelow, boolean replaceWithBiomeBlocks, String replaceWithSurfaceBlock, String replaceWithGroundBlock, String replaceWithStoneBlock, boolean spawnUnderWater, int waterLevel, boolean isStructureAtSpawn, boolean doReplaceAboveBelowOnly, ChunkCoordinate chunkBeingPopulated, boolean doBiomeConfigReplaceBlocks) {
        LocalMaterialData bo3StoneBlock;
        LocalMaterialData bo3GroundBlock;
        LocalMaterialData bo3SurfaceBlock;
        LocalMaterialData replaceAboveMaterial;
        LocalMaterialData replaceBelowMaterial;
        block81: {
            block80: {
                block79: {
                    block78: {
                        block77: {
                            replaceBelowMaterial = null;
                            replaceAboveMaterial = null;
                            bo3SurfaceBlock = null;
                            bo3GroundBlock = null;
                            bo3StoneBlock = null;
                            if (this.config == null) {
                                OTG.log(LogMarker.FATAL, "Settings was null for BO4 " + this.getName() + ". This should not be happening, please contact the developer.", new Object[0]);
                                throw new RuntimeException("Settings was null for BO4 " + this.getName() + ". This should not be happening, please contact the developer.");
                            }
                            try {
                                bo3SurfaceBlock = replaceWithSurfaceBlock != null && replaceWithSurfaceBlock.length() > 0 ? MaterialHelper.readMaterial(replaceWithSurfaceBlock) : MaterialHelper.GRASS;
                            }
                            catch (InvalidConfigException e1) {
                                bo3SurfaceBlock = MaterialHelper.GRASS;
                                if (!OTG.getPluginConfig().spawnLog) break block77;
                                OTG.log(LogMarker.WARN, "Value " + replaceWithSurfaceBlock + " for replaceWithSurfaceBlock in BO4 " + this.getName() + " was not recognised. Using GRASS instead.", new Object[0]);
                            }
                        }
                        try {
                            bo3GroundBlock = replaceWithGroundBlock != null && replaceWithGroundBlock.length() > 0 ? MaterialHelper.readMaterial(replaceWithGroundBlock) : MaterialHelper.DIRT;
                        }
                        catch (InvalidConfigException e1) {
                            bo3GroundBlock = MaterialHelper.DIRT;
                            if (!OTG.getPluginConfig().spawnLog) break block78;
                            OTG.log(LogMarker.WARN, "Value " + replaceWithGroundBlock + " for replaceWithGroundBlock in BO4 " + this.getName() + " was not recognised. Using DIRT instead.", new Object[0]);
                        }
                    }
                    try {
                        bo3StoneBlock = replaceWithStoneBlock != null && replaceWithStoneBlock.length() > 0 ? MaterialHelper.readMaterial(replaceWithStoneBlock) : MaterialHelper.STONE;
                    }
                    catch (InvalidConfigException e1) {
                        bo3StoneBlock = MaterialHelper.STONE;
                        if (!OTG.getPluginConfig().spawnLog) break block79;
                        OTG.log(LogMarker.WARN, "Value " + replaceWithStoneBlock + " for replaceWithStoneBlock in BO4 " + this.getName() + " was not recognised. Using STONE instead.", new Object[0]);
                    }
                }
                try {
                    replaceBelowMaterial = this.config.replaceBelow != null && this.config.replaceBelow.toLowerCase().equals("none") ? null : (replaceBelow != null && replaceBelow.length() > 0 ? MaterialHelper.readMaterial(replaceBelow) : null);
                }
                catch (InvalidConfigException e1) {
                    replaceBelowMaterial = MaterialHelper.DIRT;
                    if (!OTG.getPluginConfig().spawnLog) break block80;
                    OTG.log(LogMarker.INFO, "Value " + this.config.replaceBelow + " for replaceBelow in BO4 " + this.getName() + " was not recognised. Using DIRT instead.", new Object[0]);
                }
            }
            try {
                replaceAboveMaterial = this.config.replaceAbove != null && this.config.replaceAbove.toLowerCase().equals("none") ? null : (replaceAbove != null && replaceAbove.length() > 0 ? MaterialHelper.readMaterial(replaceAbove) : null);
            }
            catch (InvalidConfigException e1) {
                replaceAboveMaterial = MaterialHelper.AIR;
                if (!OTG.getPluginConfig().spawnLog) break block81;
                OTG.log(LogMarker.INFO, "Value " + this.config.replaceAbove + " for replaceAbove in BO4 " + this.getName() + " was not recognised. Using AIR instead.", new Object[0]);
            }
        }
        boolean isOnBiomeBorder = false;
        LocalBiome biome = null;
        LocalBiome biome2 = null;
        LocalBiome biome3 = null;
        LocalBiome biome4 = null;
        BiomeConfig biomeConfig = null;
        biome = world.getBiomeForPopulation(x, z, chunkBeingPopulated);
        if (replaceWithBiomeBlocks) {
            biome2 = world.getBiomeForPopulation(x + 15, z, chunkBeingPopulated);
            biome3 = world.getBiomeForPopulation(x, z + 15, chunkBeingPopulated);
            biome4 = world.getBiomeForPopulation(x + 15, z + 15, chunkBeingPopulated);
            if (biome != biome2 || biome != biome3 || biome != biome4) {
                isOnBiomeBorder = true;
            }
        }
        biomeConfig = biome.getBiomeConfig();
        boolean followGround = false;
        boolean followStone = false;
        boolean followSurface = false;
        if (replaceBelowMaterial != null) {
            if (replaceBelowMaterial.equals(bo3GroundBlock)) {
                followGround = true;
            } else if (replaceBelowMaterial.equals(bo3StoneBlock)) {
                followStone = true;
            } else if (replaceBelowMaterial.equals(bo3SurfaceBlock)) {
                followSurface = true;
            }
        }
        ArrayList<Object[]> coordsAboveDone = new ArrayList<Object[]>();
        ArrayList<Object[]> coordsBelowDone = new ArrayList<Object[]>();
        BO4BlockFunction blockToQueueForSpawn = new BO4BlockFunction();
        boolean outOfBounds = false;
        long startTime = System.currentTimeMillis();
        BO4BlockFunction[] blocks = this.config.getBlocks();
        if (blocks != null) {
            for (BO4BlockFunction block : this.config.getBlocks()) {
                LocalMaterialData blockAbove;
                LocalMaterialData sourceBlockMaterial;
                ChunkCoordinate destChunk;
                int blockY;
                int highestBlockToReplace;
                boolean bFound;
                if (block instanceof BO4RandomBlockFunction) {
                    BO4RandomBlockFunction randomBlockFunction = (BO4RandomBlockFunction)block;
                    for (int i = 0; i < randomBlockFunction.blockCount; ++i) {
                        if (random.nextInt(100) >= randomBlockFunction.blockChances[i]) continue;
                        block.metaDataName = randomBlockFunction.metaDataNames[i];
                        block.metaDataTag = randomBlockFunction.metaDataTags[i];
                        block.material = randomBlockFunction.blocks[i];
                        break;
                    }
                }
                if (block.material == null) continue;
                if (rotation != Rotation.NORTH) {
                    BO4BlockFunction newBlock = new BO4BlockFunction();
                    int rotations = 0;
                    if (rotation == Rotation.WEST) {
                        rotations = 1;
                    } else if (rotation == Rotation.SOUTH) {
                        rotations = 2;
                    } else if (rotation == Rotation.EAST) {
                        rotations = 3;
                    }
                    if (rotations == 0) {
                        newBlock.x = block.x;
                        newBlock.z = block.z;
                    }
                    if (rotations == 1) {
                        newBlock.x = block.z;
                        newBlock.z = -block.x + 15;
                        newBlock.material = block.material.rotate();
                    }
                    if (rotations == 2) {
                        newBlock.x = -block.x + 15;
                        newBlock.z = -block.z + 15;
                        newBlock.material = block.material.rotate();
                        newBlock.material = newBlock.material.rotate();
                    }
                    if (rotations == 3) {
                        newBlock.x = -block.z + 15;
                        newBlock.z = block.x;
                        newBlock.material = block.material.rotate();
                        newBlock.material = newBlock.material.rotate();
                        newBlock.material = newBlock.material.rotate();
                    }
                    newBlock.y = block.y;
                    newBlock.metaDataName = block.metaDataName;
                    newBlock.metaDataTag = block.metaDataTag;
                    if (isOnBiomeBorder) {
                        biome = world.getBiomeForPopulation(x + newBlock.x, z + newBlock.z, chunkBeingPopulated);
                        biomeConfig = biome.getBiomeConfig();
                    }
                    if (replaceAboveMaterial != null && doReplaceAboveBelowOnly) {
                        bFound = false;
                        for (Object[] coords : coordsAboveDone) {
                            if ((Integer)coords[0] != x + newBlock.x || (Integer)coords[1] != z + newBlock.z) continue;
                            bFound = true;
                            break;
                        }
                        if (!bFound) {
                            coordsAboveDone.add(new Object[]{x + newBlock.x, z + newBlock.z});
                            highestBlockToReplace = world.getHighestBlockYAt(x + newBlock.x, z + newBlock.z, true, true, false, false, true, chunkBeingPopulated);
                            for (blockY = y + newBlock.y + 1; blockY <= highestBlockToReplace && blockY > y + newBlock.y; ++blockY) {
                                blockToQueueForSpawn = new BO4BlockFunction();
                                blockToQueueForSpawn.x = x + newBlock.x;
                                blockToQueueForSpawn.y = (short)blockY;
                                blockToQueueForSpawn.z = z + newBlock.z;
                                blockToQueueForSpawn.metaDataName = newBlock.metaDataName;
                                blockToQueueForSpawn.metaDataTag = newBlock.metaDataTag;
                                destChunk = ChunkCoordinate.fromBlockCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
                                if (chunkCoord.equals(destChunk)) {
                                    blockToQueueForSpawn.material = spawnUnderWater && blockY >= waterLevel ? MaterialHelper.AIR : replaceAboveMaterial;
                                    this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn, chunkBeingPopulated, biomeConfig, false);
                                    continue;
                                }
                                outOfBounds = true;
                            }
                        }
                    }
                    if (replaceBelowMaterial != null && newBlock.y == 0 && !newBlock.material.isEmptyOrAir() && doReplaceAboveBelowOnly) {
                        bFound = false;
                        for (Object[] coords : coordsBelowDone) {
                            if ((Integer)coords[0] != x + newBlock.x || (Integer)coords[1] != z + newBlock.z) continue;
                            bFound = true;
                            break;
                        }
                        if (!bFound) {
                            coordsBelowDone.add(new Object[]{x + newBlock.x, z + newBlock.z});
                            for (blockY = y + newBlock.y - 1; blockY > 0; --blockY) {
                                if (blockY >= 256 || (sourceBlockMaterial = world.getMaterial(x + newBlock.x, blockY, z + newBlock.z, chunkBeingPopulated)) == null) continue;
                                if (!sourceBlockMaterial.isSolid()) {
                                    blockToQueueForSpawn = new BO4BlockFunction();
                                    blockToQueueForSpawn.x = x + newBlock.x;
                                    blockToQueueForSpawn.y = (short)blockY;
                                    blockToQueueForSpawn.z = z + newBlock.z;
                                    blockToQueueForSpawn.material = replaceBelowMaterial;
                                    blockToQueueForSpawn.metaDataName = newBlock.metaDataName;
                                    blockToQueueForSpawn.metaDataTag = newBlock.metaDataTag;
                                    destChunk = ChunkCoordinate.fromBlockCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
                                    if (chunkCoord.equals(destChunk)) {
                                        if (replaceWithBiomeBlocks) {
                                            blockToQueueForSpawn.material = followGround ? biomeConfig.surfaceAndGroundControl.getGroundBlockAtHeight(world, biomeConfig, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z) : (followStone ? biomeConfig.getStoneBlockReplaced(world, y) : (followSurface ? biomeConfig.surfaceAndGroundControl.getSurfaceBlockAtHeight(world, biomeConfig, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z) : (doBiomeConfigReplaceBlocks ? replaceBelowMaterial.parseWithBiomeAndHeight(world, biomeConfig, blockToQueueForSpawn.y) : replaceBelowMaterial)));
                                        } else {
                                            LocalMaterialData localMaterialData = blockToQueueForSpawn.material = doBiomeConfigReplaceBlocks ? replaceBelowMaterial.parseWithBiomeAndHeight(world, biomeConfig, blockToQueueForSpawn.y) : replaceBelowMaterial;
                                            if (blockToQueueForSpawn.material == null) {
                                                blockToQueueForSpawn.material = MaterialHelper.DIRT;
                                            }
                                        }
                                        this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn, chunkBeingPopulated, biomeConfig, false);
                                        continue;
                                    }
                                    outOfBounds = true;
                                    continue;
                                }
                                if (sourceBlockMaterial.isSolid()) break;
                            }
                        }
                    }
                    if (y + newBlock.y <= 0 || y + newBlock.y >= 256 || doReplaceAboveBelowOnly) continue;
                    blockToQueueForSpawn = new BO4BlockFunction();
                    blockToQueueForSpawn.x = x + newBlock.x;
                    blockToQueueForSpawn.y = (short)(y + newBlock.y);
                    blockToQueueForSpawn.z = z + newBlock.z;
                    blockToQueueForSpawn.material = newBlock.material;
                    blockToQueueForSpawn.metaDataName = newBlock.metaDataName;
                    blockToQueueForSpawn.metaDataTag = newBlock.metaDataTag;
                    destChunk = ChunkCoordinate.fromBlockCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
                    if (chunkCoord.equals(destChunk)) {
                        if (replaceWithBiomeBlocks) {
                            if (blockToQueueForSpawn.material.equals(bo3GroundBlock)) {
                                blockToQueueForSpawn.material = biomeConfig.surfaceAndGroundControl.getGroundBlockAtHeight(world, biomeConfig, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z);
                                this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn, chunkBeingPopulated, biomeConfig, false);
                                continue;
                            }
                            if (blockToQueueForSpawn.material.equals(bo3StoneBlock)) {
                                blockToQueueForSpawn.material = biomeConfig.getStoneBlockReplaced(world, blockToQueueForSpawn.y);
                                this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn, chunkBeingPopulated, biomeConfig, false);
                                continue;
                            }
                            if (blockToQueueForSpawn.material.equals(bo3SurfaceBlock)) {
                                blockAbove = world.getMaterial(blockToQueueForSpawn.x, blockToQueueForSpawn.y + 1, blockToQueueForSpawn.z, chunkBeingPopulated);
                                blockToQueueForSpawn.material = blockAbove != null && (blockAbove.isSolid() || blockAbove.isLiquid()) ? biomeConfig.surfaceAndGroundControl.getGroundBlockAtHeight(world, biomeConfig, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z) : biomeConfig.surfaceAndGroundControl.getSurfaceBlockAtHeight(world, biomeConfig, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z);
                                if (blockToQueueForSpawn.material.isAir()) {
                                    blockToQueueForSpawn.material = blockToQueueForSpawn.y < biomeConfig.waterLevelMax ? MaterialHelper.WATER : (doBiomeConfigReplaceBlocks ? newBlock.material.parseWithBiomeAndHeight(world, biomeConfig, blockToQueueForSpawn.y) : newBlock.material);
                                }
                                this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn, chunkBeingPopulated, biomeConfig, false);
                                continue;
                            }
                        }
                        if (spawnUnderWater && blockToQueueForSpawn.material.isMaterial(DefaultMaterial.TORCH) && world.getMaterial(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, chunkBeingPopulated).isLiquid()) continue;
                        this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn, chunkBeingPopulated, biomeConfig, doBiomeConfigReplaceBlocks);
                        continue;
                    }
                    outOfBounds = true;
                    continue;
                }
                if (isOnBiomeBorder) {
                    biome = world.getBiomeForPopulation(x + block.x, z + block.z, chunkBeingPopulated);
                    biomeConfig = biome.getBiomeConfig();
                }
                if (replaceAboveMaterial != null && doReplaceAboveBelowOnly) {
                    bFound = false;
                    for (Object[] coords : coordsAboveDone) {
                        if ((Integer)coords[0] != x + block.x || (Integer)coords[1] != z + block.z) continue;
                        bFound = true;
                        break;
                    }
                    if (!bFound) {
                        coordsAboveDone.add(new Object[]{x + block.x, z + block.z});
                        highestBlockToReplace = world.getHighestBlockYAt(x + block.x, z + block.z, true, true, false, false, true, chunkBeingPopulated);
                        for (blockY = y + block.y + 1; blockY <= highestBlockToReplace && blockY > y + block.y; ++blockY) {
                            blockToQueueForSpawn = new BO4BlockFunction();
                            blockToQueueForSpawn.material = spawnUnderWater && blockY >= waterLevel ? MaterialHelper.AIR : replaceAboveMaterial;
                            blockToQueueForSpawn.x = x + block.x;
                            blockToQueueForSpawn.y = (short)blockY;
                            blockToQueueForSpawn.z = z + block.z;
                            blockToQueueForSpawn.metaDataName = block.metaDataName;
                            blockToQueueForSpawn.metaDataTag = block.metaDataTag;
                            destChunk = ChunkCoordinate.fromBlockCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
                            if (chunkCoord.equals(destChunk)) {
                                this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn, chunkBeingPopulated, biomeConfig, false);
                                continue;
                            }
                            outOfBounds = true;
                        }
                    }
                }
                if (replaceBelowMaterial != null && block.y == 0 && !block.material.isEmptyOrAir() && doReplaceAboveBelowOnly) {
                    bFound = false;
                    for (Object[] coords : coordsBelowDone) {
                        if ((Integer)coords[0] != x + block.x || (Integer)coords[1] != z + block.z) continue;
                        bFound = true;
                        break;
                    }
                    if (!bFound) {
                        coordsBelowDone.add(new Object[]{x + block.x, z + block.z});
                        for (blockY = y + block.y - 1; blockY > 0; --blockY) {
                            if (blockY >= 256 || (sourceBlockMaterial = world.getMaterial(x + block.x, blockY, z + block.z, chunkBeingPopulated)) == null) continue;
                            if (!sourceBlockMaterial.isSolid()) {
                                blockToQueueForSpawn = new BO4BlockFunction();
                                blockToQueueForSpawn.x = x + block.x;
                                blockToQueueForSpawn.y = (short)blockY;
                                blockToQueueForSpawn.z = z + block.z;
                                blockToQueueForSpawn.material = replaceBelowMaterial;
                                blockToQueueForSpawn.metaDataName = block.metaDataName;
                                blockToQueueForSpawn.metaDataTag = block.metaDataTag;
                                destChunk = ChunkCoordinate.fromBlockCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
                                if (chunkCoord.equals(destChunk)) {
                                    if (replaceWithBiomeBlocks) {
                                        blockToQueueForSpawn.material = followGround ? biomeConfig.surfaceAndGroundControl.getGroundBlockAtHeight(world, biomeConfig, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z) : (followStone ? biomeConfig.getStoneBlockReplaced(world, y) : (followSurface ? biomeConfig.surfaceAndGroundControl.getSurfaceBlockAtHeight(world, biomeConfig, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z) : (doBiomeConfigReplaceBlocks ? replaceBelowMaterial.parseWithBiomeAndHeight(world, biomeConfig, blockToQueueForSpawn.y) : replaceBelowMaterial)));
                                    } else {
                                        LocalMaterialData localMaterialData = blockToQueueForSpawn.material = doBiomeConfigReplaceBlocks ? replaceBelowMaterial.parseWithBiomeAndHeight(world, biomeConfig, blockToQueueForSpawn.y) : replaceBelowMaterial;
                                        if (blockToQueueForSpawn.material == null) {
                                            blockToQueueForSpawn.material = MaterialHelper.DIRT;
                                        }
                                    }
                                    this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn, chunkBeingPopulated, biomeConfig, false);
                                    continue;
                                }
                                outOfBounds = true;
                                continue;
                            }
                            if (sourceBlockMaterial.isSolid()) break;
                        }
                    }
                }
                if (y + block.y <= 0 || y + block.y >= 256 || doReplaceAboveBelowOnly) continue;
                blockToQueueForSpawn = new BO4BlockFunction();
                blockToQueueForSpawn.x = x + block.x;
                blockToQueueForSpawn.y = (short)(y + block.y);
                blockToQueueForSpawn.z = z + block.z;
                blockToQueueForSpawn.material = block.material;
                blockToQueueForSpawn.metaDataName = block.metaDataName;
                blockToQueueForSpawn.metaDataTag = block.metaDataTag;
                destChunk = ChunkCoordinate.fromBlockCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
                if (chunkCoord.equals(destChunk)) {
                    if (replaceWithBiomeBlocks) {
                        if (blockToQueueForSpawn.material.equals(bo3GroundBlock)) {
                            blockToQueueForSpawn.material = biomeConfig.surfaceAndGroundControl.getGroundBlockAtHeight(world, biomeConfig, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z);
                            this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn, chunkBeingPopulated, biomeConfig, false);
                            continue;
                        }
                        if (blockToQueueForSpawn.material.equals(bo3StoneBlock)) {
                            blockToQueueForSpawn.material = biomeConfig.getStoneBlockReplaced(world, blockToQueueForSpawn.y);
                            this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn, chunkBeingPopulated, biomeConfig, false);
                            continue;
                        }
                        if (blockToQueueForSpawn.material.equals(bo3SurfaceBlock)) {
                            blockAbove = world.getMaterial(blockToQueueForSpawn.x, blockToQueueForSpawn.y + 1, blockToQueueForSpawn.z, chunkBeingPopulated);
                            blockToQueueForSpawn.material = blockAbove != null && (blockAbove.isSolid() || blockAbove.isLiquid()) ? biomeConfig.surfaceAndGroundControl.getGroundBlockAtHeight(world, biomeConfig, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z) : biomeConfig.surfaceAndGroundControl.getSurfaceBlockAtHeight(world, biomeConfig, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z);
                            if (blockToQueueForSpawn.material.isAir()) {
                                blockToQueueForSpawn.material = blockToQueueForSpawn.y < biomeConfig.waterLevelMax ? MaterialHelper.WATER : (doBiomeConfigReplaceBlocks ? block.material.parseWithBiomeAndHeight(world, biomeConfig, blockToQueueForSpawn.y) : block.material);
                            }
                            this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn, chunkBeingPopulated, biomeConfig, false);
                            continue;
                        }
                    }
                    if (spawnUnderWater && blockToQueueForSpawn.material.isMaterial(DefaultMaterial.TORCH) && world.getMaterial(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, chunkBeingPopulated).isLiquid()) continue;
                    this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn, chunkBeingPopulated, biomeConfig, doBiomeConfigReplaceBlocks);
                    continue;
                }
                outOfBounds = true;
            }
            if (outOfBounds && OTG.getPluginConfig().spawnLog) {
                OTG.log(LogMarker.WARN, "BO4 " + this.getName() + " tried to spawn blocks outside of the chunk being populated, the blocks have been ignored. This can happen if a BO3 is not sliced into 16x16 pieces or has branches positioned in such a way that they cross a chunk border. OTG is more strict than TC in how branching BO4's used as CustomStructures() should be designed, BO4 creators have to design their BO4's and position their branches so that they fit neatly into a 16x16 grid. Hopefully in a future release OTG can be made to automatically slice branching structures instead of forcing the BO4 creator to do it.", new Object[0]);
            }
            if (OTG.getPluginConfig().spawnLog && System.currentTimeMillis() - startTime > 50L) {
                OTG.log(LogMarker.WARN, "Warning: Spawning BO4 " + this.getName() + " took " + (System.currentTimeMillis() - startTime) + " Ms.", new Object[0]);
            }
        }
        return true;
    }

    private void setBlock(LocalWorld world, int x, int y, int z, LocalMaterialData material, NamedBinaryTag metaDataTag, boolean isStructureAtSpawn, ChunkCoordinate chunkBeingPopulated, BiomeConfig biomeConfig, boolean needsReplaceBlock) {
        LocalMaterialData worldMaterial;
        if (OTG.getPluginConfig().developerMode && ((worldMaterial = world.getMaterial(x, y, z, chunkBeingPopulated)).isMaterial(DefaultMaterial.GOLD_BLOCK) || worldMaterial.isMaterial(DefaultMaterial.IRON_BLOCK) || worldMaterial.isMaterial(DefaultMaterial.REDSTONE_BLOCK) || worldMaterial.isMaterial(DefaultMaterial.DIAMOND_BLOCK) || worldMaterial.isMaterial(DefaultMaterial.LAPIS_BLOCK) || worldMaterial.isMaterial(DefaultMaterial.COAL_BLOCK) || worldMaterial.isMaterial(DefaultMaterial.QUARTZ_BLOCK) || worldMaterial.isMaterial(DefaultMaterial.EMERALD_BLOCK)) && (material.isMaterial(DefaultMaterial.GOLD_BLOCK) || material.isMaterial(DefaultMaterial.IRON_BLOCK) || material.isMaterial(DefaultMaterial.REDSTONE_BLOCK) || material.isMaterial(DefaultMaterial.DIAMOND_BLOCK) || material.isMaterial(DefaultMaterial.LAPIS_BLOCK) || material.isMaterial(DefaultMaterial.COAL_BLOCK) || material.isMaterial(DefaultMaterial.QUARTZ_BLOCK) || material.isMaterial(DefaultMaterial.EMERALD_BLOCK))) {
            world.setBlock(x, y, z, MaterialHelper.GLOWSTONE, null, chunkBeingPopulated, false);
            return;
        }
        world.setBlock(x, y, z, material, metaDataTag, chunkBeingPopulated, biomeConfig, needsReplaceBlock);
    }

    @Override
    public boolean doReplaceBlocks() {
        return this.config.doReplaceBlocks;
    }
}

