/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo3.checks;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.customobjects.bo3.BO3Config;
import com.pg85.otg.customobjects.bo3.checks.BO3Check;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.ChunkCoordinate;
import java.util.List;

public class ModCheck
extends BO3Check {
    private String[] mods;

    @Override
    public boolean preventsSpawn(LocalWorld world, int x, int y, int z, ChunkCoordinate chunkBeingPopulated) {
        return false;
    }

    @Override
    public BO3Check rotate() {
        return this;
    }

    @Override
    protected void load(List<String> args) throws InvalidConfigException {
        this.assureSize(1, args);
        this.mods = new String[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            this.mods[i] = args.get(i);
        }
    }

    @Override
    public String makeString() {
        return this.makeString("ModCheck");
    }

    protected String makeString(String name) {
        return name + '(' + String.join((CharSequence)",", this.mods) + ')';
    }

    @Override
    public Class<BO3Config> getHolderType() {
        return BO3Config.class;
    }

    public boolean evaluate() {
        for (String mod : this.mods) {
            if (OTG.getEngine().isModLoaded(mod)) continue;
            return false;
        }
        return true;
    }
}

