/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo3;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.io.FileSettingsReaderOTGPlus;
import com.pg85.otg.configuration.io.FileSettingsWriterOTGPlus;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.customobjects.bo3.BO3Config;
import com.pg85.otg.customobjects.bo3.BO3Settings;
import com.pg85.otg.customobjects.bo3.ObjectExtrusionHelper;
import com.pg85.otg.customobjects.bo3.StructurePartSpawnHeight;
import com.pg85.otg.customobjects.bo3.bo3function.BO3BlockFunction;
import com.pg85.otg.customobjects.bo3.bo3function.BO3EntityFunction;
import com.pg85.otg.customobjects.bo3.bo3function.BO3ModDataFunction;
import com.pg85.otg.customobjects.bo3.bo3function.BO3ParticleFunction;
import com.pg85.otg.customobjects.bo3.bo3function.BO3SpawnerFunction;
import com.pg85.otg.customobjects.bo3.checks.BO3Check;
import com.pg85.otg.customobjects.structures.Branch;
import com.pg85.otg.customobjects.structures.CustomStructure;
import com.pg85.otg.customobjects.structures.CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.StructuredCustomObject;
import com.pg85.otg.customobjects.structures.bo3.BO3CustomStructure;
import com.pg85.otg.customobjects.structures.bo3.BO3CustomStructureCoordinate;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.BoundingBox;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.helpers.RandomHelper;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;

public class BO3
implements StructuredCustomObject {
    private BO3Config settings;
    private final String name;
    private final File file;
    private boolean isInvalidConfig;

    public BO3(String name, File file) {
        this.name = name;
        this.file = file;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public BO3Config getSettings() {
        return this.settings;
    }

    @Override
    public boolean onEnable() {
        if (this.isInvalidConfig) {
            return false;
        }
        if (this.settings != null) {
            return true;
        }
        try {
            this.settings = new BO3Config(new FileSettingsReaderOTGPlus(this.name, this.file));
            if (this.settings.settingsMode != WorldConfig.ConfigMode.WriteDisable) {
                FileSettingsWriterOTGPlus.writeToFile(this.settings, this.settings.settingsMode);
            }
        }
        catch (InvalidConfigException ex) {
            this.isInvalidConfig = true;
            return false;
        }
        return true;
    }

    @Override
    public boolean canSpawnAsTree() {
        return this.settings.tree;
    }

    @Override
    public boolean canRotateRandomly() {
        return this.settings.rotateRandomly;
    }

    @Override
    public boolean loadChecks() {
        return this.settings == null ? false : this.settings.parseModChecks();
    }

    @Override
    public boolean spawnFromSapling(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        BO3BlockFunction[] blocks = this.settings.getBlocks(rotation.getRotationId());
        ArrayList<BO3BlockFunction> blocksToSpawn = new ArrayList<BO3BlockFunction>();
        ObjectExtrusionHelper oeh = new ObjectExtrusionHelper(this.settings.extrudeMode, this.settings.extrudeThroughBlocks);
        HashSet<ChunkCoordinate> chunks = new HashSet<ChunkCoordinate>();
        for (BO3BlockFunction block : blocks) {
            LocalMaterialData localMaterial = world.getMaterial(x + block.x, y + block.y, z + block.z, null);
            if (!(block.y < 0 || localMaterial.isAir() || localMaterial.isMaterial(DefaultMaterial.LOG) || localMaterial.isMaterial(DefaultMaterial.LOG_2) || localMaterial.isMaterial(DefaultMaterial.LEAVES) || localMaterial.isMaterial(DefaultMaterial.LEAVES_2) || localMaterial.isMaterial(DefaultMaterial.SAPLING))) {
                return false;
            }
            if (localMaterial.isAir()) {
                chunks.add(ChunkCoordinate.fromBlockCoords(x + block.x, z + block.z));
                blocksToSpawn.add(block);
            }
            oeh.addBlock(block);
        }
        for (BO3BlockFunction block : blocksToSpawn) {
            block.spawn(world, random, x + block.x, y + block.y, z + block.z, null, false);
        }
        oeh.extrude(world, random, x, y, z, null, false);
        this.handleBO3Functions(null, world, random, rotation, x, y, z, chunks, null);
        return true;
    }

    @Override
    public boolean spawnForced(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        BO3BlockFunction[] blocks = this.settings.getBlocks(rotation.getRotationId());
        ObjectExtrusionHelper oeh = new ObjectExtrusionHelper(this.settings.extrudeMode, this.settings.extrudeThroughBlocks);
        HashSet<ChunkCoordinate> chunks = new HashSet<ChunkCoordinate>();
        for (BO3BlockFunction block : blocks) {
            if (this.settings.outsideSourceBlock != BO3Settings.OutsideSourceBlock.placeAnyway && !this.settings.sourceBlocks.contains(block.material)) continue;
            block.spawn(world, random, x + block.x, y + block.y, z + block.z, null, this.doReplaceBlocks());
            oeh.addBlock(block);
            chunks.add(ChunkCoordinate.fromBlockCoords(x + block.x, z + block.z));
        }
        oeh.extrude(world, random, x, y, z, null, this.doReplaceBlocks());
        this.handleBO3Functions(null, world, random, rotation, x, y, z, chunks, null);
        return true;
    }

    @Override
    public boolean process(LocalWorld world, Random random, ChunkCoordinate chunkCoord) {
        boolean atLeastOneObjectHasSpawned = false;
        int chunkMiddleX = chunkCoord.getBlockXCenter();
        int chunkMiddleZ = chunkCoord.getBlockZCenter();
        for (int i = 0; i < this.settings.frequency; ++i) {
            int z;
            int x;
            if (!(this.settings.rarity > random.nextDouble() * 100.0) || !this.spawn(world, random, x = chunkMiddleX + random.nextInt(16), z = chunkMiddleZ + random.nextInt(16), this.settings.minHeight, this.settings.maxHeight, chunkCoord, this.doReplaceBlocks())) continue;
            atLeastOneObjectHasSpawned = true;
        }
        return atLeastOneObjectHasSpawned;
    }

    @Override
    public boolean spawnAsTree(LocalWorld world, Random random, int x, int z, int minY, int maxY, ChunkCoordinate chunkBeingPopulated) {
        if (minY == -1) {
            minY = this.getSettings().minHeight;
        }
        if (maxY == -1) {
            maxY = this.getSettings().maxHeight;
        }
        return this.spawn(world, random, x, z, minY, maxY, chunkBeingPopulated, false);
    }

    private boolean spawn(LocalWorld world, Random random, int x, int z, int minY, int maxY, ChunkCoordinate chunkBeingPopulated, boolean replaceBlocks) {
        Rotation rotation = this.settings.rotateRandomly ? Rotation.getRandomRotation(random) : Rotation.NORTH;
        int offsetY = 0;
        int baseY = 0;
        if (this.settings.spawnHeight == BO3Settings.SpawnHeightEnum.randomY) {
            int n = baseY = minY == maxY ? minY : RandomHelper.numberInRange(random, minY, maxY);
        }
        if (this.settings.spawnHeight == BO3Settings.SpawnHeightEnum.highestBlock) {
            baseY = world.getHighestBlockAboveYAt(x, z, chunkBeingPopulated);
        }
        if (this.settings.spawnHeight == BO3Settings.SpawnHeightEnum.highestSolidBlock) {
            baseY = world.getBlockAboveSolidHeight(x, z, chunkBeingPopulated);
        }
        offsetY = baseY + this.getOffsetAndVariance(random, this.settings.spawnHeightOffset, this.settings.spawnHeightVariance);
        return this.trySpawnAt(null, world, random, rotation, x, offsetY, z, minY, maxY, baseY, chunkBeingPopulated, replaceBlocks);
    }

    public boolean trySpawnAt(CustomStructure structure, LocalWorld world, Random random, Rotation rotation, int x, int y, int z, int minY, int maxY, int baseY, ChunkCoordinate chunkBeingPopulated, boolean replaceBlocks) {
        BO3Check[] checks;
        if (y < 0 || y >= 256) {
            return false;
        }
        if (y < minY || y > maxY) {
            return false;
        }
        for (BO3Check bO3Check : checks = this.settings.bo3Checks[rotation.getRotationId()]) {
            if (!bO3Check.preventsSpawn(world, x + bO3Check.x, baseY + bO3Check.y, z + bO3Check.z, chunkBeingPopulated)) continue;
            return false;
        }
        BO3BlockFunction[] blocks = this.settings.getBlocks(rotation.getRotationId());
        HashSet<ChunkCoordinate> loadedChunks = new HashSet<ChunkCoordinate>();
        for (BO3BlockFunction block : blocks) {
            if (y + block.y < 0 || y + block.y >= 256) {
                return false;
            }
            ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x + block.x, z + block.z);
            if (loadedChunks.contains(chunkCoord)) continue;
            if (chunkBeingPopulated != null && !OTG.IsInAreaBeingPopulated(x + block.x, z + block.z, chunkBeingPopulated)) {
                return false;
            }
            loadedChunks.add(chunkCoord);
        }
        ArrayList<BO3BlockFunction> arrayList = new ArrayList<BO3BlockFunction>();
        ObjectExtrusionHelper oeh = new ObjectExtrusionHelper(this.settings.extrudeMode, this.settings.extrudeThroughBlocks);
        HashSet<ChunkCoordinate> chunks = new HashSet<ChunkCoordinate>();
        int blocksOutsideSourceBlock = 0;
        int maxBlocksOutsideSourceBlock = (int)Math.ceil((double)blocks.length * ((double)this.settings.maxPercentageOutsideSourceBlock / 100.0));
        for (BO3BlockFunction block : blocks) {
            if ((this.settings.maxPercentageOutsideSourceBlock < 100 && blocksOutsideSourceBlock <= maxBlocksOutsideSourceBlock || this.settings.outsideSourceBlock == BO3Settings.OutsideSourceBlock.dontPlace) && !this.settings.sourceBlocks.contains(world.getMaterial(x + block.x, y + block.y, z + block.z, chunkBeingPopulated))) {
                if (++blocksOutsideSourceBlock > maxBlocksOutsideSourceBlock) {
                    return false;
                }
                if (this.settings.outsideSourceBlock == BO3Settings.OutsideSourceBlock.placeAnyway) {
                    chunks.add(ChunkCoordinate.fromBlockCoords(x + block.x, z + block.z));
                    arrayList.add(block);
                }
            } else {
                chunks.add(ChunkCoordinate.fromBlockCoords(x + block.x, z + block.z));
                arrayList.add(block);
            }
            if (!(block instanceof BO3BlockFunction)) continue;
            oeh.addBlock(block);
        }
        if (!OTG.fireCanCustomObjectSpawnEvent(this, world, x, y, z)) {
            return false;
        }
        for (BO3BlockFunction block : arrayList) {
            block.spawn(world, random, x + block.x, y + block.y, z + block.z, chunkBeingPopulated, replaceBlocks);
        }
        oeh.extrude(world, random, x, y, z, chunkBeingPopulated, replaceBlocks);
        this.handleBO3Functions(structure, world, random, rotation, x, y, z, chunks, chunkBeingPopulated);
        return true;
    }

    public void handleBO3Functions(CustomStructure structure, LocalWorld world, Random random, Rotation rotation, int x, int y, int z, HashSet<ChunkCoordinate> chunks, ChunkCoordinate chunkBeingPopulated) {
        BO3EntityFunction[] entityDataInObject;
        BO3SpawnerFunction[] spawnerDataInObject;
        BO3ModDataFunction[] modDataInObject;
        HashSet<ChunkCoordinate> chunksCustomObject = new HashSet<ChunkCoordinate>();
        HashSet<BO3ModDataFunction> newModDataInObject = new HashSet<BO3ModDataFunction>();
        for (BO3ModDataFunction modData : modDataInObject = this.settings.modDataFunctions[rotation.getRotationId()]) {
            BO3ModDataFunction newModData = new BO3ModDataFunction();
            newModData.y = y + modData.y;
            newModData.x = x + modData.x;
            newModData.z = z + modData.z;
            newModData.modData = modData.modData;
            newModData.modId = modData.modId;
            newModDataInObject.add(newModData);
            chunks.add(ChunkCoordinate.fromBlockCoords(newModData.x, newModData.z));
            chunksCustomObject.add(ChunkCoordinate.fromBlockCoords(newModData.x, newModData.z));
        }
        HashSet<BO3SpawnerFunction> newSpawnerDataInObject = new HashSet<BO3SpawnerFunction>();
        for (BO3SpawnerFunction spawnerData : spawnerDataInObject = this.settings.spawnerFunctions[rotation.getRotationId()]) {
            BO3SpawnerFunction newSpawnerData = new BO3SpawnerFunction();
            newSpawnerData.y = y + spawnerData.y;
            newSpawnerData.x = x + spawnerData.x;
            newSpawnerData.z = z + spawnerData.z;
            newSpawnerData.mobName = spawnerData.mobName;
            newSpawnerData.originalnbtFileName = spawnerData.originalnbtFileName;
            newSpawnerData.nbtFileName = spawnerData.nbtFileName;
            newSpawnerData.groupSize = spawnerData.groupSize;
            newSpawnerData.interval = spawnerData.interval;
            newSpawnerData.spawnChance = spawnerData.spawnChance;
            newSpawnerData.maxCount = spawnerData.maxCount;
            newSpawnerData.despawnTime = spawnerData.despawnTime;
            newSpawnerData.velocityX = spawnerData.velocityX;
            newSpawnerData.velocityY = spawnerData.velocityY;
            newSpawnerData.velocityZ = spawnerData.velocityZ;
            newSpawnerData.velocityXSet = spawnerData.velocityXSet;
            newSpawnerData.velocityYSet = spawnerData.velocityYSet;
            newSpawnerData.velocityZSet = spawnerData.velocityZSet;
            newSpawnerData.yaw = spawnerData.yaw;
            newSpawnerData.pitch = spawnerData.pitch;
            newSpawnerDataInObject.add(newSpawnerData);
            chunks.add(ChunkCoordinate.fromBlockCoords(newSpawnerData.x, newSpawnerData.z));
            chunksCustomObject.add(ChunkCoordinate.fromBlockCoords(newSpawnerData.x, newSpawnerData.z));
        }
        HashSet<BO3ParticleFunction> newParticleDataInObject = new HashSet<BO3ParticleFunction>();
        BO3ParticleFunction[] particleDataInObject = this.settings.particleFunctions[rotation.getRotationId()];
        for (BO3ParticleFunction particleData : particleDataInObject) {
            BO3ParticleFunction newParticleData = new BO3ParticleFunction();
            newParticleData.y = y + particleData.y;
            newParticleData.x = x + particleData.x;
            newParticleData.z = z + particleData.z;
            newParticleData.particleName = particleData.particleName;
            newParticleData.interval = particleData.interval;
            newParticleData.velocityX = particleData.velocityX;
            newParticleData.velocityY = particleData.velocityY;
            newParticleData.velocityZ = particleData.velocityZ;
            newParticleData.velocityXSet = particleData.velocityXSet;
            newParticleData.velocityYSet = particleData.velocityYSet;
            newParticleData.velocityZSet = particleData.velocityZSet;
            newParticleDataInObject.add(newParticleData);
            chunks.add(ChunkCoordinate.fromBlockCoords(newParticleData.x, newParticleData.z));
            chunksCustomObject.add(ChunkCoordinate.fromBlockCoords(newParticleData.x, newParticleData.z));
        }
        if (structure != null) {
            structure.modDataManager.modData.addAll(newModDataInObject);
            structure.particlesManager.particleData.addAll(newParticleDataInObject);
            structure.spawnerManager.spawnerData.addAll(newSpawnerDataInObject);
            for (ChunkCoordinate structureCoord : chunks) {
                world.getStructureCache().addBo3ToStructureCache(structureCoord, structure, true);
            }
        } else {
            BO3CustomStructure placeHolderStructure = new BO3CustomStructure(new BO3CustomStructureCoordinate(world, this, this.getName(), Rotation.NORTH, x, 0, z));
            placeHolderStructure.modDataManager.modData.addAll(newModDataInObject);
            placeHolderStructure.particlesManager.particleData.addAll(newParticleDataInObject);
            placeHolderStructure.spawnerManager.spawnerData.addAll(newSpawnerDataInObject);
            for (ChunkCoordinate structureCoord : chunksCustomObject) {
                world.getStructureCache().addBo3ToStructureCache(structureCoord, placeHolderStructure, false);
            }
        }
        for (BO3EntityFunction entity : entityDataInObject = this.settings.entityFunctions[rotation.getRotationId()]) {
            BO3EntityFunction newEntityData = new BO3EntityFunction();
            newEntityData.y = y + entity.y;
            newEntityData.x = x + entity.x;
            newEntityData.z = z + entity.z;
            newEntityData.name = entity.name;
            newEntityData.resourceLocation = entity.resourceLocation;
            newEntityData.groupSize = entity.groupSize;
            newEntityData.nameTagOrNBTFileName = entity.nameTagOrNBTFileName;
            newEntityData.originalNameTagOrNBTFileName = entity.originalNameTagOrNBTFileName;
            newEntityData.namedBinaryTag = entity.namedBinaryTag;
            newEntityData.rotation = entity.rotation;
            world.spawnEntity(newEntityData, chunkBeingPopulated);
        }
    }

    public Branch[] getBranches(Rotation rotation) {
        return this.settings.branches[rotation.getRotationId()];
    }

    public StructurePartSpawnHeight getStructurePartSpawnHeight() {
        return this.settings.spawnHeight.toStructurePartSpawnHeight();
    }

    public BoundingBox getBoundingBox(Rotation rotation) {
        return this.settings.boundingBoxes[rotation.getRotationId()];
    }

    public int getMaxBranchDepth() {
        return this.settings.maxBranchDepth;
    }

    private int getOffsetAndVariance(Random random, int offset, int variance) {
        if (variance == 0) {
            return offset;
        }
        variance = variance < 0 ? -random.nextInt(MathHelper.abs(variance) + 1) : random.nextInt(variance + 1);
        return MathHelper.clamp(offset + variance, 0, 255);
    }

    public CustomStructureCoordinate makeCustomStructureCoordinate(LocalWorld world, Random random, int chunkX, int chunkZ) {
        Rotation rotation = this.settings.rotateRandomly ? Rotation.getRandomRotation(random) : Rotation.NORTH;
        int height = RandomHelper.numberInRange(random, this.settings.minHeight, this.settings.maxHeight);
        return new BO3CustomStructureCoordinate(world, this, this.getName(), rotation, chunkX * 16 + 8 + random.nextInt(16), (short)height, chunkZ * 16 + 7 + random.nextInt(16));
    }

    @Override
    public boolean doReplaceBlocks() {
        return this.settings.doReplaceBlocks;
    }
}

