/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo2;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.customobjects.CustomObjectConfigFile;
import com.pg85.otg.configuration.io.SettingsReaderOTGPlus;
import com.pg85.otg.configuration.io.SettingsWriterOTGPlus;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.bo2.BO2Settings;
import com.pg85.otg.customobjects.bo2.ObjectCoordinate;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.NamedBinaryTag;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.materials.MaterialSet;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;

public class BO2
extends CustomObjectConfigFile
implements CustomObject {
    private ObjectCoordinate[][] data = new ObjectCoordinate[4][];
    private MaterialSet spawnOnBlockType;
    private MaterialSet collisionBlockType;
    private boolean spawnWater;
    private boolean spawnLava;
    private boolean spawnAboveGround;
    private boolean spawnUnderGround;
    private boolean spawnSunlight;
    private boolean spawnDarkness;
    private boolean randomRotation;
    private boolean dig;
    private boolean tree;
    private boolean branch;
    private boolean needsFoundation;
    private boolean doReplaceBlocks;
    private int rarity;
    private double collisionPercentage;
    private int spawnElevationMin;
    private int spawnElevationMax;
    boolean isEnabled = false;

    BO2(SettingsReaderOTGPlus reader) {
        super(reader);
    }

    @Override
    public boolean canSpawnAsTree() {
        return this.tree;
    }

    @Override
    public boolean doReplaceBlocks() {
        return this.doReplaceBlocks;
    }

    @Override
    public boolean canRotateRandomly() {
        return this.randomRotation;
    }

    @Override
    public boolean spawnFromSapling(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        ObjectCoordinate[] data = this.data[rotation.getRotationId()];
        ArrayList<ObjectCoordinate> blocksToSpawn = new ArrayList<ObjectCoordinate>();
        for (ObjectCoordinate point : data) {
            LocalMaterialData material = world.getMaterial(x + point.x, y + point.y, z + point.z, null);
            if (!(material.isAir() || material.isMaterial(DefaultMaterial.LOG) || material.isMaterial(DefaultMaterial.LOG_2) || material.isMaterial(DefaultMaterial.LEAVES) || material.isMaterial(DefaultMaterial.LEAVES_2))) {
                return false;
            }
            if (!material.isAir()) continue;
            blocksToSpawn.add(point);
        }
        for (ObjectCoordinate point : blocksToSpawn) {
            this.setBlock(world, x + point.x, y + point.y, z + point.z, point.material, null, false, null, false);
        }
        return true;
    }

    @Override
    public boolean spawnForced(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        ObjectCoordinate[] data;
        for (ObjectCoordinate point : data = this.data[rotation.getRotationId()]) {
            LocalMaterialData worldMaterial = world.getMaterial(x + point.x, y + point.y, z + point.z, null);
            if (worldMaterial == null) continue;
            if (worldMaterial.isAir()) {
                this.setBlock(world, x + point.x, y + point.y, z + point.z, point.material, null, false, null, this.doReplaceBlocks());
                continue;
            }
            if (!this.dig) continue;
            this.setBlock(world, x + point.x, y + point.y, z + point.z, point.material, null, false, null, this.doReplaceBlocks());
        }
        return true;
    }

    private boolean canSpawnAt(LocalWorld world, Rotation rotation, int x, int y, int z, ChunkCoordinate chunkBeingPopulated) {
        ObjectCoordinate[] objData;
        int checkLight;
        LocalMaterialData checkBlock;
        if (y < 0 || y >= 256) {
            return false;
        }
        if (y < this.spawnElevationMin || y > this.spawnElevationMax) {
            return false;
        }
        if (!this.spawnOnBlockType.contains(world.getMaterial(x, y - 1, z, chunkBeingPopulated))) {
            return false;
        }
        LocalMaterialData worldMaterial = world.getMaterial(x, y - 5, z, chunkBeingPopulated);
        if (this.needsFoundation && worldMaterial == null || worldMaterial.isAir()) {
            return false;
        }
        LocalMaterialData localMaterialData = checkBlock = !this.spawnWater || !this.spawnLava ? world.getMaterial(x, y + 2, z, chunkBeingPopulated) : null;
        if (checkBlock == null) {
            return false;
        }
        if (!this.spawnWater && (checkBlock.isMaterial(DefaultMaterial.WATER) || checkBlock.isMaterial(DefaultMaterial.STATIONARY_WATER))) {
            return false;
        }
        if (!this.spawnLava && (checkBlock.isMaterial(DefaultMaterial.LAVA) || checkBlock.isMaterial(DefaultMaterial.STATIONARY_LAVA))) {
            return false;
        }
        int n = checkLight = !this.spawnSunlight || !this.spawnDarkness ? world.getLightLevel(x, y + 2, z, chunkBeingPopulated) : 0;
        if (checkLight == -1) {
            return false;
        }
        if (!this.spawnSunlight && checkLight > 8) {
            return false;
        }
        if (!this.spawnDarkness && checkLight < 9) {
            return false;
        }
        HashSet<ChunkCoordinate> loadedChunks = new HashSet<ChunkCoordinate>();
        for (ObjectCoordinate point : objData = this.data[rotation.getRotationId()]) {
            if (y + point.y < 0 || y + point.y >= 256) {
                return false;
            }
            ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x + point.x, z + point.z);
            if (loadedChunks.contains(chunkCoord)) continue;
            if (chunkBeingPopulated != null && !OTG.IsInAreaBeingPopulated(x + point.x, z + point.z, chunkBeingPopulated)) {
                return false;
            }
            loadedChunks.add(chunkCoord);
        }
        if (!this.dig && (int)Math.floor(this.collisionPercentage) < 100) {
            int faultCounter = 0;
            int maxBlocksOutsideSourceBlock = (int)Math.ceil((double)objData.length * (this.collisionPercentage / 100.0));
            for (ObjectCoordinate point : objData) {
                LocalMaterialData material = world.getMaterial(x + point.x, y + point.y, z + point.z, chunkBeingPopulated);
                if (material != null && !this.collisionBlockType.contains(material) || material != null && ++faultCounter <= maxBlocksOutsideSourceBlock) continue;
                return false;
            }
        }
        return OTG.fireCanCustomObjectSpawnEvent(this, world, x, y, z);
    }

    @Override
    public boolean spawnAsTree(LocalWorld world, Random random, int x, int z, int minY, int maxY, ChunkCoordinate chunkBeingPopulated) {
        return this.spawn(world, random, x, z, minY == -1 ? this.spawnElevationMin : minY, maxY == -1 ? this.spawnElevationMax : maxY, chunkBeingPopulated, false);
    }

    private boolean spawn(LocalWorld world, Random random, int x, int z, int minY, int maxY, ChunkCoordinate chunkBeingPopulated, boolean replaceBlocks) {
        ObjectCoordinate[] data;
        Rotation rotation;
        int y;
        if (this.spawnAboveGround) {
            y = world.getBlockAboveSolidHeight(x, z, chunkBeingPopulated);
        } else if (this.spawnUnderGround) {
            int solidHeight = world.getBlockAboveSolidHeight(x, z, chunkBeingPopulated);
            if (solidHeight < 1 || solidHeight <= minY) {
                return false;
            }
            if (solidHeight > maxY) {
                solidHeight = maxY;
            }
            y = random.nextInt(solidHeight - minY) + minY;
        } else {
            y = world.getHighestBlockAboveYAt(x, z, chunkBeingPopulated);
        }
        if (y < 0) {
            return false;
        }
        Rotation rotation2 = rotation = this.randomRotation ? Rotation.getRandomRotation(random) : Rotation.NORTH;
        if (!this.canSpawnAt(world, rotation, x, y, z, chunkBeingPopulated)) {
            return false;
        }
        for (ObjectCoordinate point : data = this.data[rotation.getRotationId()]) {
            LocalMaterialData worldMaterial = world.getMaterial(x + point.x, y + point.y, z + point.z, chunkBeingPopulated);
            if (worldMaterial == null) continue;
            if (worldMaterial.isAir()) {
                this.setBlock(world, x + point.x, y + point.y, z + point.z, point.material, null, false, chunkBeingPopulated, replaceBlocks);
                continue;
            }
            if (!this.dig) continue;
            this.setBlock(world, x + point.x, y + point.y, z + point.z, point.material, null, false, chunkBeingPopulated, replaceBlocks);
        }
        return true;
    }

    @Override
    public boolean process(LocalWorld world, Random rand, ChunkCoordinate chunkCoord) {
        if (this.branch) {
            return false;
        }
        int randomRoll = rand.nextInt(100);
        boolean objectSpawned = false;
        for (int ObjectRarity = this.rarity; randomRoll < ObjectRarity; ObjectRarity -= 100) {
            int x = chunkCoord.getBlockX() + rand.nextInt(16);
            int z = chunkCoord.getBlockZ() + rand.nextInt(16);
            objectSpawned = this.spawn(world, rand, x, z, this.spawnElevationMin, this.spawnElevationMax, chunkCoord, this.doReplaceBlocks());
        }
        return objectSpawned;
    }

    @Override
    protected void writeConfigSettings(SettingsWriterOTGPlus writer) throws IOException {
    }

    @Override
    protected void readConfigSettings() {
        this.spawnOnBlockType = this.readSettings(BO2Settings.SPAWN_ON_BLOCK_TYPE);
        this.collisionBlockType = this.readSettings(BO2Settings.COLLISTION_BLOCK_TYPE);
        this.spawnSunlight = this.readSettings(BO2Settings.SPAWN_SUNLIGHT);
        this.spawnDarkness = this.readSettings(BO2Settings.SPAWN_DARKNESS);
        this.spawnWater = this.readSettings(BO2Settings.SPAWN_WATER);
        this.spawnLava = this.readSettings(BO2Settings.SPAWN_LAVA);
        this.spawnAboveGround = this.readSettings(BO2Settings.SPAWN_ABOVE_GROUND);
        this.spawnUnderGround = this.readSettings(BO2Settings.SPAWN_UNDER_GROUND);
        this.randomRotation = this.readSettings(BO2Settings.RANDON_ROTATION);
        this.dig = this.readSettings(BO2Settings.DIG);
        this.tree = this.readSettings(BO2Settings.TREE);
        this.branch = this.readSettings(BO2Settings.BRANCH);
        this.needsFoundation = this.readSettings(BO2Settings.NEEDS_FOUNDATION);
        this.doReplaceBlocks = this.readSettings(BO2Settings.DO_REPLACE_BLOCKS);
        this.rarity = this.readSettings(BO2Settings.RARITY);
        this.collisionPercentage = this.readSettings(BO2Settings.COLLISION_PERCENTAGE);
        this.spawnElevationMin = this.readSettings(BO2Settings.SPAWN_ELEVATION_MIN);
        this.spawnElevationMax = this.readSettings(BO2Settings.SPAWN_ELEVATION_MAX);
        this.readCoordinates();
    }

    @Override
    protected void correctSettings() {
    }

    @Override
    protected void renameOldSettings() {
    }

    private void readCoordinates() {
        ArrayList<ObjectCoordinate> coordinates = new ArrayList<ObjectCoordinate>();
        for (Map.Entry<String, String> line : this.reader.getRawSettings()) {
            ObjectCoordinate buffer = ObjectCoordinate.getCoordinateFromString(line.getKey(), line.getValue());
            if (buffer == null) continue;
            coordinates.add(buffer);
        }
        this.data[0] = new ObjectCoordinate[coordinates.size()];
        this.data[1] = new ObjectCoordinate[coordinates.size()];
        this.data[2] = new ObjectCoordinate[coordinates.size()];
        this.data[3] = new ObjectCoordinate[coordinates.size()];
        for (int i = 0; i < coordinates.size(); ++i) {
            ObjectCoordinate coordinate;
            this.data[0][i] = coordinate = (ObjectCoordinate)coordinates.get(i);
            this.data[1][i] = coordinate = coordinate.rotate();
            this.data[2][i] = coordinate = coordinate.rotate();
            this.data[3][i] = coordinate = coordinate.rotate();
        }
    }

    private void setBlock(LocalWorld world, int x, int y, int z, LocalMaterialData material, NamedBinaryTag metaDataTag, boolean isStructureAtSpawn, ChunkCoordinate chunkBeingPopulated, boolean replaceBlocks) {
        world.setBlock(x, y, z, material, metaDataTag, chunkBeingPopulated, replaceBlocks);
    }

    @Override
    public boolean onEnable() {
        if (!this.isEnabled) {
            this.isEnabled = true;
            this.enable();
        }
        return true;
    }

    private void enable() {
        this.readConfigSettings();
        this.correctSettings();
    }

    @Override
    public boolean loadChecks() {
        return true;
    }
}

