/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects;

import com.pg85.otg.OTG;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.CustomObjectLoader;
import com.pg85.otg.customobjects.TreeObject;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.minecraft.defaults.TreeType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class CustomObjectCollection {
    private Object indexingFilesLock = new Object();
    private ArrayList<CustomObject> objectsGlobalObjects = new ArrayList();
    private HashMap<String, CustomObject> objectsByNameGlobalObjects = new HashMap();
    private ArrayList<String> objectsNotFoundGlobalObjects = new ArrayList();
    private HashMap<String, ArrayList<CustomObject>> objectsPerWorld = new HashMap();
    private HashMap<String, HashMap<String, CustomObject>> objectsByNamePerWorld = new HashMap();
    private HashMap<String, ArrayList<String>> objectsNotFoundPerWorld = new HashMap();
    private HashMap<String, File> customObjectFilesGlobalObjects = null;
    private HashMap<String, HashMap<String, File>> customObjectFilesPerWorld = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CustomObject loadObject(File file, String worldName) {
        Object object = this.indexingFilesLock;
        synchronized (object) {
            CustomObject object2 = null;
            if (file.isFile()) {
                String fileName = file.getName();
                int index = fileName.lastIndexOf(46);
                if (index != -1) {
                    String objectType = fileName.substring(index + 1, fileName.length());
                    String objectName = fileName.substring(0, index);
                    CustomObjectLoader loader = OTG.getCustomObjectManager().getObjectLoaders().get(objectType.toLowerCase());
                    if (loader != null) {
                        ArrayList<CustomObject> worldObjects;
                        object2 = loader.loadFromFile(objectName, file);
                        if (worldName != null) {
                            worldObjects = this.objectsPerWorld.get(worldName);
                            if (worldObjects == null) {
                                worldObjects = new ArrayList();
                                this.objectsPerWorld.put(worldName, worldObjects);
                            }
                            worldObjects.add(object2);
                        } else {
                            this.objectsGlobalObjects.add(object2);
                        }
                        if (!object2.onEnable() || !object2.loadChecks()) {
                            this.removeLoadedObject(worldName, object2);
                            loader = OTG.getCustomObjectManager().getObjectLoaders().get("bo4");
                            if (loader != null) {
                                object2 = loader.loadFromFile(objectName, file);
                                if (worldName != null) {
                                    worldObjects = this.objectsPerWorld.get(worldName);
                                    if (worldObjects == null) {
                                        worldObjects = new ArrayList();
                                        this.objectsPerWorld.put(worldName, worldObjects);
                                    }
                                    worldObjects.add(object2);
                                } else {
                                    this.objectsGlobalObjects.add(object2);
                                }
                                if (!object2.onEnable() || !object2.loadChecks()) {
                                    this.removeLoadedObject(worldName, object2);
                                    return null;
                                }
                            }
                        }
                    }
                }
            } else {
                OTG.log(LogMarker.FATAL, "Given path does not exist: " + file.getAbsolutePath(), new Object[0]);
                throw new RuntimeException("Given path does not exist: " + file.getAbsolutePath());
            }
            return object2;
        }
    }

    private void removeLoadedObject(String worldName, CustomObject object) {
        if (worldName != null) {
            HashMap<String, CustomObject> worldObjectsByName = this.objectsByNamePerWorld.get(worldName);
            if (worldObjectsByName != null) {
                worldObjectsByName.remove(object.getName().toLowerCase());
                if (worldObjectsByName.size() == 0) {
                    this.objectsByNamePerWorld.remove(worldName, worldObjectsByName);
                }
            }
            ArrayList<CustomObject> worldObjects = this.objectsPerWorld.get(worldName);
            worldObjects.remove(object);
            if (worldObjects.size() == 0) {
                this.objectsPerWorld.remove(worldName, worldObjects);
            }
        } else {
            this.objectsGlobalObjects.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoadedGlobalObject(CustomObject object) {
        Object object2 = this.indexingFilesLock;
        synchronized (object2) {
            String lowerCaseName = object.getName().toLowerCase();
            if (!this.objectsByNameGlobalObjects.containsKey(lowerCaseName)) {
                this.objectsByNameGlobalObjects.put(lowerCaseName, object);
                this.objectsGlobalObjects.add(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadCustomObjectFiles() {
        Object object = this.indexingFilesLock;
        synchronized (object) {
            this.objectsGlobalObjects.clear();
            this.objectsByNameGlobalObjects.clear();
            this.objectsNotFoundGlobalObjects.clear();
            this.objectsPerWorld.clear();
            this.objectsByNamePerWorld.clear();
            this.objectsNotFoundPerWorld.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadCustomObjectFiles() {
        Object object = this.indexingFilesLock;
        synchronized (object) {
            this.objectsGlobalObjects.clear();
            this.objectsByNameGlobalObjects.clear();
            this.objectsNotFoundGlobalObjects.clear();
            this.objectsPerWorld.clear();
            this.objectsByNamePerWorld.clear();
            this.objectsNotFoundPerWorld.clear();
            this.customObjectFilesGlobalObjects = null;
            this.customObjectFilesPerWorld.clear();
        }
    }

    public ArrayList<String> getAllBONamesForWorld(String worldName) {
        HashMap<String, File> files = this.customObjectFilesPerWorld.get(worldName);
        return files == null ? null : new ArrayList<String>(files.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomObject getObjectByName(String name, String worldName) {
        Object object = this.indexingFilesLock;
        synchronized (object) {
            return this.getObjectByName(name, worldName, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexGlobalObjectsFolder() {
        Object object = this.indexingFilesLock;
        synchronized (object) {
            if (this.customObjectFilesGlobalObjects == null) {
                OTG.log(LogMarker.INFO, "Indexing GlobalObjects folder.", new Object[0]);
                this.customObjectFilesGlobalObjects = new HashMap();
                if (new File(OTG.getEngine().getOTGRootFolder() + File.separator + "GlobalObjects").exists()) {
                    this.indexAllCustomObjectFilesInDir(new File(OTG.getEngine().getOTGRootFolder() + File.separator + "GlobalObjects"), this.customObjectFilesGlobalObjects);
                }
                for (TreeType type : TreeType.values()) {
                    this.addLoadedGlobalObject(new TreeObject(type));
                }
                OTG.log(LogMarker.INFO, "GlobalObjects folder indexed.", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexWorldObjectsFolder(String worldName) {
        Object object = this.indexingFilesLock;
        synchronized (object) {
            if (worldName != null && !this.customObjectFilesPerWorld.containsKey(worldName)) {
                OTG.log(LogMarker.INFO, "Indexing WorldObjects folder for world " + worldName, new Object[0]);
                HashMap<String, File> worldCustomObjectFiles = new HashMap<String, File>();
                this.customObjectFilesPerWorld.put(worldName, worldCustomObjectFiles);
                if (worldName != null && new File(OTG.getEngine().getOTGRootFolder() + File.separator + "worlds" + File.separator + worldName + File.separator + "WorldObjects").exists()) {
                    this.indexAllCustomObjectFilesInDir(new File(OTG.getEngine().getOTGRootFolder() + File.separator + "worlds" + File.separator + worldName + File.separator + "WorldObjects"), worldCustomObjectFiles);
                }
                OTG.log(LogMarker.INFO, "WorldObjects folder for world " + worldName + " indexed.", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomObject getObjectByName(String name, String worldName, boolean searchGlobalObjects) {
        Object object = this.indexingFilesLock;
        synchronized (object) {
            ArrayList<String> worldObjectsNotFoundByName;
            worldName = worldName == null ? null : OTG.getEngine().getPresetName(worldName);
            CustomObject object2 = null;
            if (worldName != null) {
                HashMap<String, CustomObject> worldObjectsByName;
                if (worldName.equals("overworld")) {
                    worldName = OTG.getEngine().getPresetName("overworld");
                }
                if ((worldObjectsByName = this.objectsByNamePerWorld.get(worldName)) != null) {
                    object2 = worldObjectsByName.get(name.toLowerCase());
                }
            }
            boolean bSearchedWorldObjects = false;
            if (object2 == null && worldName != null && (worldObjectsNotFoundByName = this.objectsNotFoundPerWorld.get(worldName)) != null && worldObjectsNotFoundByName.contains(name.toLowerCase())) {
                bSearchedWorldObjects = true;
            }
            if (object2 == null && searchGlobalObjects && (worldName == null || bSearchedWorldObjects)) {
                object2 = this.objectsByNameGlobalObjects.get(name.toLowerCase());
            }
            if (object2 != null) {
                return object2;
            }
            if (name.equalsIgnoreCase("UseWorld") || name.equalsIgnoreCase("UseWorldAll")) {
                return null;
            }
            if (name.equalsIgnoreCase("UseBiome") || name.equalsIgnoreCase("UseBiomeAll")) {
                return null;
            }
            boolean bSearchedGlobalObjects = false;
            if (this.objectsNotFoundGlobalObjects != null && this.objectsNotFoundGlobalObjects.contains(name.toLowerCase())) {
                bSearchedGlobalObjects = true;
            }
            if (!(searchGlobalObjects && !bSearchedGlobalObjects || worldName != null && !bSearchedWorldObjects)) {
                return null;
            }
            this.indexGlobalObjectsFolder();
            this.indexWorldObjectsFolder(worldName);
            if (worldName != null && !bSearchedWorldObjects) {
                File searchForFile;
                HashMap<String, File> worldCustomObjectFiles = this.customObjectFilesPerWorld.get(worldName);
                if (worldCustomObjectFiles != null && (searchForFile = worldCustomObjectFiles.get(name.toLowerCase())) != null) {
                    object2 = this.loadObject(searchForFile, worldName);
                    if (object2 != null) {
                        HashMap<String, CustomObject> worldObjectsByName = this.objectsByNamePerWorld.get(worldName);
                        if (worldObjectsByName == null) {
                            worldObjectsByName = new HashMap();
                            this.objectsByNamePerWorld.put(worldName, worldObjectsByName);
                        }
                        worldObjectsByName.put(name.toLowerCase(), object2);
                        return object2;
                    }
                    if (OTG.getPluginConfig().spawnLog) {
                        OTG.log(LogMarker.WARN, "Could not load BO2/BO3, it probably contains errors: " + searchForFile, new Object[0]);
                    }
                    return null;
                }
                ArrayList<String> worldObjectsNotFound = this.objectsNotFoundPerWorld.get(worldName);
                if (worldObjectsNotFound == null) {
                    worldObjectsNotFound = new ArrayList();
                    this.objectsNotFoundPerWorld.put(worldName, worldObjectsNotFound);
                }
                worldObjectsNotFound.add(name.toLowerCase());
            }
            if (searchGlobalObjects && !bSearchedGlobalObjects) {
                object2 = this.objectsByNameGlobalObjects.get(name.toLowerCase());
                if (object2 != null) {
                    return object2;
                }
                File searchForFile = this.customObjectFilesGlobalObjects.get(name.toLowerCase());
                if (searchForFile != null) {
                    object2 = this.loadObject(searchForFile, worldName);
                    if (object2 != null) {
                        this.objectsByNameGlobalObjects.put(name.toLowerCase(), object2);
                        return object2;
                    }
                    if (OTG.getPluginConfig().spawnLog) {
                        OTG.log(LogMarker.WARN, "Could not load BO2/BO3, it probably contains errors: " + searchForFile, new Object[0]);
                    }
                    return null;
                }
                this.objectsNotFoundGlobalObjects.add(name.toLowerCase());
            }
            if (OTG.getPluginConfig().spawnLog) {
                OTG.log(LogMarker.WARN, "Could not find BO2/BO3 " + name + " in GlobalObjects " + (worldName != null ? "and WorldObjects" : "") + " directory " + (worldName != null ? "for world " + worldName : "") + ".", new Object[0]);
            }
            return null;
        }
    }

    private void indexAllCustomObjectFilesInDir(File searchDir, HashMap<String, File> customObjectFiles) {
        if (searchDir.exists()) {
            if (searchDir.isDirectory()) {
                for (File fileInDir : searchDir.listFiles()) {
                    if (fileInDir.isDirectory()) {
                        this.indexAllCustomObjectFilesInDir(fileInDir, customObjectFiles);
                        continue;
                    }
                    if (!fileInDir.getName().toLowerCase().endsWith(".bo4data") && !fileInDir.getName().toLowerCase().endsWith(".bo4") && !fileInDir.getName().toLowerCase().endsWith(".bo3") && !fileInDir.getName().toLowerCase().endsWith(".bo2")) continue;
                    if (fileInDir.getName().toLowerCase().endsWith(".bo4data") || !customObjectFiles.containsKey(fileInDir.getName().toLowerCase().replace(".bo4data", "").replace(".bo4", "").replace(".bo3", "").replace(".bo2", ""))) {
                        customObjectFiles.put(fileInDir.getName().toLowerCase().replace(".bo4data", "").replace(".bo4", "").replace(".bo3", "").replace(".bo2", ""), fileInDir);
                        continue;
                    }
                    if (!OTG.getPluginConfig().spawnLog) continue;
                    OTG.log(LogMarker.WARN, "Duplicate file found: " + fileInDir.getName() + ".", new Object[0]);
                }
            } else if (searchDir.getName().toLowerCase().endsWith(".bo4data") || searchDir.getName().toLowerCase().endsWith(".bo4") || searchDir.getName().toLowerCase().endsWith(".bo3") || searchDir.getName().toLowerCase().endsWith(".bo2")) {
                if (searchDir.getName().toLowerCase().endsWith(".bo4data") || !customObjectFiles.containsKey(searchDir.getName().toLowerCase().replace(".bo4", "").replace(".bo3", "").replace(".bo2", ""))) {
                    customObjectFiles.put(searchDir.getName().toLowerCase().replace(".bo4data", "").replace(".bo4", "").replace(".bo3", "").replace(".bo2", ""), searchDir);
                } else if (OTG.getPluginConfig().spawnLog) {
                    OTG.log(LogMarker.WARN, "Duplicate file found: " + searchDir.getName() + ".", new Object[0]);
                }
            }
        }
    }
}

