/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.standard;

import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.biome.settings.WeightedMobSpawnGroup;
import com.pg85.otg.generator.resource.AboveWaterGen;
import com.pg85.otg.generator.resource.BoulderGen;
import com.pg85.otg.generator.resource.CactusGen;
import com.pg85.otg.generator.resource.CustomObjectGen;
import com.pg85.otg.generator.resource.DungeonGen;
import com.pg85.otg.generator.resource.FossilGen;
import com.pg85.otg.generator.resource.GrassGen;
import com.pg85.otg.generator.resource.IceSpikeGen;
import com.pg85.otg.generator.resource.LiquidGen;
import com.pg85.otg.generator.resource.OreGen;
import com.pg85.otg.generator.resource.PlantGen;
import com.pg85.otg.generator.resource.PlantType;
import com.pg85.otg.generator.resource.ReedGen;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.generator.resource.SmallLakeGen;
import com.pg85.otg.generator.resource.SurfacePatchGen;
import com.pg85.otg.generator.resource.TreeGen;
import com.pg85.otg.generator.resource.UnderWaterOreGen;
import com.pg85.otg.generator.resource.UndergroundLakeGen;
import com.pg85.otg.generator.resource.VinesGen;
import com.pg85.otg.generator.resource.WellGen;
import com.pg85.otg.util.minecraft.defaults.DefaultBiome;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import com.pg85.otg.util.minecraft.defaults.EntityNames;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class StandardBiomeTemplate {
    protected final int worldHeight;
    public String defaultExtends = "";
    public boolean defaultWaterLakes = true;
    public Object[] defaultTree;
    public int defaultDandelions = 2;
    public int defaultPoppies = 0;
    public int defaultBlueOrchids = 0;
    public int defaultTallFlowers = 0;
    public int defaultSunflowers = 0;
    public int defaultTulips = 0;
    public int defaultAzureBluets = 0;
    public int defaultOxeyeDaisies = 0;
    public int defaultAlliums = 0;
    public int defaultGrass = 10;
    public boolean defaultGrassIsGrouped = false;
    public int defaultDoubleGrass = 0;
    public boolean defaultDoubleGrassIsGrouped = false;
    public int defaultFerns = 0;
    public int defaultLargeFerns = 0;
    public int defaultDeadBush = 0;
    public int defaultMushroom = 0;
    public int defaultReed = 0;
    public int defaultCactus = 0;
    public int defaultMelons = 0;
    public int defaultWaterSand = 3;
    public int defaultWaterGravel = 1;
    public int defaultSwampPatches = 0;
    public Object[] defaultWell;
    public float defaultBiomeSurface = 0.1f;
    public float defaultBiomeVolatility = 0.3f;
    public DefaultMaterial defaultSurfaceBlock = DefaultMaterial.GRASS;
    public DefaultMaterial defaultGroundBlock = DefaultMaterial.DIRT;
    public float defaultBiomeTemperature = 0.5f;
    public float defaultBiomeWetness = 0.5f;
    public ArrayList<String> defaultIsle = new ArrayList();
    public ArrayList<String> defaultBorder = new ArrayList();
    public ArrayList<String> defaultNotBorderNear = new ArrayList();
    public String defaultRiverBiome;
    public int defaultSize;
    public int defaultSizeWhenIsle;
    public int defaultSizeWhenBorder;
    public int defaultRarity;
    public int defaultRarityWhenIsle;
    public int defaultColor;
    public int defaultWaterLily;
    public int defaultWaterColorMultiplier;
    public int defaultGrassColor;
    public int defaultFoliageColor;
    public boolean defaultStrongholds;
    public boolean defaultOceanMonuments;
    public boolean defaultWoodlandMansions;
    public boolean defaultNetherFortressEnabled;
    public BiomeConfig.VillageType defaultVillageType;
    public BiomeConfig.RareBuildingType defaultRareBuildingType;
    public BiomeConfig.MineshaftType defaultMineshaftType;
    public int defaultEmeraldOre;
    public boolean defaultHasVines;
    public int defaultBoulder;
    public Object[] defaultSurfaceSurfaceAndGroundControl;
    public boolean defaultIceSpikes;
    public boolean defaultDisableBiomeHeight;
    public double[] defaultCustomHeightControl;
    public double defaultFossilRarity;
    public String defaultBiomeDictId;
    public String defaultInheritMobsBiomeName;
    public String defaultReplaceToBiomeName;
    public boolean inheritSaplingResource;
    public List<WeightedMobSpawnGroup> defaultCreatures;
    public List<WeightedMobSpawnGroup> defaultMonsters;
    public List<WeightedMobSpawnGroup> defaultAmbientCreatures;
    public List<WeightedMobSpawnGroup> defaultWaterCreatures;

    public StandardBiomeTemplate(int worldHeight) {
        this.defaultRiverBiome = DefaultBiome.RIVER.Name;
        this.defaultSize = 4;
        this.defaultSizeWhenIsle = 6;
        this.defaultSizeWhenBorder = 8;
        this.defaultRarity = 100;
        this.defaultRarityWhenIsle = 97;
        this.defaultColor = 0;
        this.defaultWaterLily = 0;
        this.defaultWaterColorMultiplier = 0xFFFFFF;
        this.defaultGrassColor = 0xFFFFFF;
        this.defaultFoliageColor = 0xFFFFFF;
        this.defaultStrongholds = true;
        this.defaultOceanMonuments = false;
        this.defaultWoodlandMansions = false;
        this.defaultNetherFortressEnabled = false;
        this.defaultVillageType = BiomeConfig.VillageType.disabled;
        this.defaultRareBuildingType = BiomeConfig.RareBuildingType.disabled;
        this.defaultMineshaftType = BiomeConfig.MineshaftType.normal;
        this.defaultEmeraldOre = 0;
        this.defaultBoulder = 0;
        this.defaultSurfaceSurfaceAndGroundControl = new Object[0];
        this.defaultCustomHeightControl = new double[33];
        this.defaultFossilRarity = 0.0;
        this.defaultBiomeDictId = "";
        this.defaultInheritMobsBiomeName = "";
        this.defaultReplaceToBiomeName = "";
        this.inheritSaplingResource = false;
        this.defaultCreatures = Arrays.asList(new WeightedMobSpawnGroup(EntityNames.SHEEP, 12, 4, 4), new WeightedMobSpawnGroup(EntityNames.PIG, 10, 4, 4), new WeightedMobSpawnGroup(EntityNames.CHICKEN, 10, 4, 4), new WeightedMobSpawnGroup(EntityNames.COW, 8, 4, 4));
        this.defaultMonsters = Arrays.asList(new WeightedMobSpawnGroup(EntityNames.SPIDER, 100, 4, 4), new WeightedMobSpawnGroup(EntityNames.ZOMBIE, 100, 4, 4), new WeightedMobSpawnGroup(EntityNames.SKELETON, 100, 4, 4), new WeightedMobSpawnGroup(EntityNames.CREEPER, 100, 4, 4), new WeightedMobSpawnGroup(EntityNames.SLIME, 100, 4, 4), new WeightedMobSpawnGroup(EntityNames.ENDERMAN, 10, 1, 4), new WeightedMobSpawnGroup(EntityNames.WITCH, 5, 1, 1));
        this.defaultAmbientCreatures = Collections.singletonList(new WeightedMobSpawnGroup(EntityNames.BAT, 10, 8, 8));
        this.defaultWaterCreatures = Collections.singletonList(new WeightedMobSpawnGroup(EntityNames.SQUID, 10, 4, 4));
        this.worldHeight = worldHeight;
    }

    public List<Resource> createDefaultResources(BiomeConfig config) {
        ArrayList<Resource> resources = new ArrayList<Resource>(32);
        if (this.defaultWaterLakes) {
            resources.add(Resource.createResource(config, SmallLakeGen.class, new Object[]{DefaultMaterial.WATER, 4, 7, 8, 119}));
        }
        resources.add(Resource.createResource(config, SmallLakeGen.class, new Object[]{DefaultMaterial.LAVA, 2, 1, 8, 119}));
        resources.add(Resource.createResource(config, SmallLakeGen.class, new Object[]{DefaultMaterial.LAVA, 2, 8, 6, 50}));
        resources.add(Resource.createResource(config, UndergroundLakeGen.class, 50, 60, 2, 5, 0, 49));
        resources.add(Resource.createResource(config, DungeonGen.class, 8, 100, 0, this.worldHeight));
        if (this.defaultFossilRarity > 0.0) {
            resources.add(Resource.createResource(config, FossilGen.class, this.defaultFossilRarity));
        }
        resources.add(Resource.createResource(config, OreGen.class, new Object[]{DefaultMaterial.DIRT, 33, 10, 100, 0, 255, DefaultMaterial.STONE}));
        resources.add(Resource.createResource(config, OreGen.class, new Object[]{DefaultMaterial.GRAVEL, 33, 8, 100, 0, 255, DefaultMaterial.STONE}));
        resources.add(Resource.createResource(config, OreGen.class, new Object[]{(Object)((Object)DefaultMaterial.STONE) + ":1", 33, 10, 100, 0, 79, DefaultMaterial.STONE}));
        resources.add(Resource.createResource(config, OreGen.class, new Object[]{(Object)((Object)DefaultMaterial.STONE) + ":3", 33, 10, 100, 0, 79, DefaultMaterial.STONE}));
        resources.add(Resource.createResource(config, OreGen.class, new Object[]{(Object)((Object)DefaultMaterial.STONE) + ":5", 33, 10, 100, 0, 79, DefaultMaterial.STONE}));
        resources.add(Resource.createResource(config, OreGen.class, new Object[]{DefaultMaterial.COAL_ORE, 17, 20, 100, 0, 127, DefaultMaterial.STONE}));
        resources.add(Resource.createResource(config, OreGen.class, new Object[]{DefaultMaterial.IRON_ORE, 9, 20, 100, 0, 63, DefaultMaterial.STONE}));
        resources.add(Resource.createResource(config, OreGen.class, new Object[]{DefaultMaterial.GOLD_ORE, 9, 2, 100, 0, 31, DefaultMaterial.STONE}));
        resources.add(Resource.createResource(config, OreGen.class, new Object[]{DefaultMaterial.REDSTONE_ORE, 8, 8, 100, 0, 15, DefaultMaterial.STONE}));
        resources.add(Resource.createResource(config, OreGen.class, new Object[]{DefaultMaterial.DIAMOND_ORE, 8, 1, 100, 0, 15, DefaultMaterial.STONE}));
        resources.add(Resource.createResource(config, OreGen.class, new Object[]{DefaultMaterial.LAPIS_ORE, 7, 1, 100, 0, 15, DefaultMaterial.STONE}));
        if (this.defaultEmeraldOre > 0) {
            resources.add(Resource.createResource(config, OreGen.class, new Object[]{DefaultMaterial.EMERALD_ORE, 5, this.defaultEmeraldOre, 100, 4, 31, DefaultMaterial.STONE}));
        }
        if (this.defaultWaterSand > 0) {
            resources.add(Resource.createResource(config, UnderWaterOreGen.class, new Object[]{DefaultMaterial.SAND, 7, this.defaultWaterSand, 100, DefaultMaterial.DIRT, DefaultMaterial.GRASS}));
        }
        resources.add(Resource.createResource(config, UnderWaterOreGen.class, new Object[]{DefaultMaterial.CLAY, 4, 1, 100, DefaultMaterial.DIRT, DefaultMaterial.CLAY}));
        if (this.defaultWaterGravel > 0) {
            resources.add(Resource.createResource(config, UnderWaterOreGen.class, new Object[]{DefaultMaterial.GRAVEL, 6, this.defaultWaterGravel, 100, DefaultMaterial.DIRT, DefaultMaterial.GRASS}));
        }
        resources.add(Resource.createResource(config, CustomObjectGen.class, "UseWorld"));
        if (this.defaultBoulder != 0) {
            resources.add(Resource.createResource(config, BoulderGen.class, new Object[]{DefaultMaterial.MOSSY_COBBLESTONE, this.defaultBoulder, 30, 0, 256, DefaultMaterial.GRASS, DefaultMaterial.DIRT, DefaultMaterial.STONE}));
        }
        if (this.defaultIceSpikes) {
            resources.add(Resource.createResource(config, IceSpikeGen.class, new Object[]{DefaultMaterial.PACKED_ICE, IceSpikeGen.SpikeType.HugeSpike, 3, 1.66, 60, 128, DefaultMaterial.ICE, DefaultMaterial.DIRT, DefaultMaterial.SNOW_BLOCK}));
            resources.add(Resource.createResource(config, IceSpikeGen.class, new Object[]{DefaultMaterial.PACKED_ICE, IceSpikeGen.SpikeType.SmallSpike, 3, 98.33, 60, 128, DefaultMaterial.ICE, DefaultMaterial.DIRT, DefaultMaterial.SNOW_BLOCK}));
            resources.add(Resource.createResource(config, IceSpikeGen.class, new Object[]{DefaultMaterial.PACKED_ICE, IceSpikeGen.SpikeType.Basement, 2, 100, 60, 128, DefaultMaterial.ICE, DefaultMaterial.DIRT, DefaultMaterial.SNOW_BLOCK}));
        }
        if (this.defaultMelons > 0) {
            resources.add(Resource.createResource(config, PlantGen.class, new Object[]{DefaultMaterial.MELON_BLOCK, this.defaultMelons, 100, 0, this.worldHeight, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
        }
        if (this.defaultSwampPatches > 0) {
            resources.add(Resource.createResource(config, SurfacePatchGen.class, new Object[]{DefaultMaterial.STATIONARY_WATER, DefaultMaterial.WATER_LILY, 62, 62, "Solid"}));
        }
        if (this.defaultTree != null) {
            resources.add(Resource.createResource(config, TreeGen.class, this.defaultTree));
        }
        if (this.defaultWaterLily > 0) {
            resources.add(Resource.createResource(config, AboveWaterGen.class, new Object[]{DefaultMaterial.WATER_LILY, this.defaultWaterLily, 100}));
        }
        if (this.defaultPoppies > 0) {
            resources.add(Resource.createResource(config, PlantGen.class, new Object[]{PlantType.Poppy, this.defaultPoppies, 100, 0, this.worldHeight, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
        }
        if (this.defaultBlueOrchids > 0) {
            resources.add(Resource.createResource(config, PlantGen.class, new Object[]{PlantType.BlueOrchid, this.defaultBlueOrchids, 100, 0, this.worldHeight, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
        }
        if (this.defaultDandelions > 0) {
            resources.add(Resource.createResource(config, PlantGen.class, new Object[]{PlantType.Dandelion, this.defaultDandelions, 100, 0, this.worldHeight, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
        }
        if (this.defaultTallFlowers > 0) {
            resources.add(Resource.createResource(config, PlantGen.class, new Object[]{PlantType.Lilac, this.defaultTallFlowers, 100, 0, this.worldHeight, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
            resources.add(Resource.createResource(config, PlantGen.class, new Object[]{PlantType.RoseBush, this.defaultTallFlowers, 100, 0, this.worldHeight, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
            resources.add(Resource.createResource(config, PlantGen.class, new Object[]{PlantType.Peony, this.defaultTallFlowers, 100, 0, this.worldHeight, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
        }
        if (this.defaultSunflowers > 0) {
            resources.add(Resource.createResource(config, PlantGen.class, new Object[]{PlantType.Sunflower, this.defaultSunflowers, 100, 0, this.worldHeight, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
        }
        if (this.defaultTulips > 0) {
            resources.add(Resource.createResource(config, PlantGen.class, new Object[]{PlantType.OrangeTulip, this.defaultTulips, 25, 0, this.worldHeight, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
            resources.add(Resource.createResource(config, PlantGen.class, new Object[]{PlantType.RedTulip, this.defaultTulips, 25, 0, this.worldHeight, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
            resources.add(Resource.createResource(config, PlantGen.class, new Object[]{PlantType.WhiteTulip, this.defaultTulips, 25, 0, this.worldHeight, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
            resources.add(Resource.createResource(config, PlantGen.class, new Object[]{PlantType.PinkTulip, this.defaultTulips, 25, 0, this.worldHeight, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
        }
        if (this.defaultAzureBluets > 0) {
            resources.add(Resource.createResource(config, PlantGen.class, new Object[]{PlantType.AzureBluet, this.defaultDandelions, 100, 0, this.worldHeight, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
        }
        if (this.defaultAlliums > 0) {
            resources.add(Resource.createResource(config, PlantGen.class, new Object[]{PlantType.Allium, this.defaultDandelions, 100, 0, this.worldHeight, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
        }
        if (this.defaultOxeyeDaisies > 0) {
            resources.add(Resource.createResource(config, PlantGen.class, new Object[]{PlantType.OxeyeDaisy, this.defaultDandelions, 100, 0, this.worldHeight, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
        }
        if (this.defaultMushroom > 0) {
            resources.add(Resource.createResource(config, PlantGen.class, new Object[]{PlantType.RedMushroom, this.defaultMushroom, 12, 0, this.worldHeight, this.defaultSurfaceBlock, DefaultMaterial.DIRT}));
            resources.add(Resource.createResource(config, PlantGen.class, new Object[]{PlantType.BrownMushroom, this.defaultMushroom, 25, 0, this.worldHeight, this.defaultSurfaceBlock, DefaultMaterial.DIRT}));
        }
        if (this.defaultFerns > 0) {
            resources.add(Resource.createResource(config, GrassGen.class, new Object[]{PlantType.Fern, GrassGen.GroupOption.NotGrouped, this.defaultFerns, 100, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
        }
        if (this.defaultDoubleGrass > 0) {
            if (this.defaultDoubleGrassIsGrouped) {
                resources.add(Resource.createResource(config, GrassGen.class, new Object[]{PlantType.DoubleTallgrass, GrassGen.GroupOption.Grouped, this.defaultDoubleGrass, 15, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
            } else {
                resources.add(Resource.createResource(config, GrassGen.class, new Object[]{PlantType.DoubleTallgrass, GrassGen.GroupOption.NotGrouped, this.defaultDoubleGrass, 100, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
            }
        }
        if (this.defaultGrass > 0) {
            if (this.defaultGrassIsGrouped) {
                resources.add(Resource.createResource(config, GrassGen.class, new Object[]{PlantType.Tallgrass, GrassGen.GroupOption.Grouped, this.defaultGrass, 60, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
            } else {
                resources.add(Resource.createResource(config, GrassGen.class, new Object[]{PlantType.Tallgrass, GrassGen.GroupOption.NotGrouped, this.defaultGrass, 100, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
            }
        }
        if (this.defaultLargeFerns > 0) {
            resources.add(Resource.createResource(config, PlantGen.class, new Object[]{PlantType.LargeFern, this.defaultLargeFerns, 90, 30, this.worldHeight, DefaultMaterial.GRASS, DefaultMaterial.DIRT}));
        }
        if (this.defaultDeadBush > 0) {
            resources.add(Resource.createResource(config, GrassGen.class, new Object[]{PlantType.DeadBush, 0, this.defaultDeadBush, 100, DefaultMaterial.SAND, DefaultMaterial.HARD_CLAY, DefaultMaterial.STAINED_CLAY, DefaultMaterial.DIRT}));
        }
        resources.add(Resource.createResource(config, PlantGen.class, new Object[]{DefaultMaterial.PUMPKIN, 1, 3, 0, this.worldHeight, DefaultMaterial.GRASS}));
        if (this.defaultReed > 0) {
            resources.add(Resource.createResource(config, ReedGen.class, new Object[]{DefaultMaterial.SUGAR_CANE_BLOCK, this.defaultReed, 100, 0, this.worldHeight, DefaultMaterial.GRASS, DefaultMaterial.DIRT, DefaultMaterial.SAND}));
        }
        if (this.defaultCactus > 0) {
            resources.add(Resource.createResource(config, CactusGen.class, new Object[]{DefaultMaterial.CACTUS, this.defaultCactus, 100, 0, this.worldHeight, DefaultMaterial.SAND}));
        }
        if (this.defaultHasVines) {
            resources.add(Resource.createResource(config, VinesGen.class, new Object[]{50, 100, 63, this.worldHeight, DefaultMaterial.VINE}));
        }
        resources.add(Resource.createResource(config, LiquidGen.class, new Object[]{DefaultMaterial.WATER, 20, 100, 8, this.worldHeight, DefaultMaterial.STONE}));
        resources.add(Resource.createResource(config, LiquidGen.class, new Object[]{DefaultMaterial.LAVA, 10, 100, 8, this.worldHeight, DefaultMaterial.STONE}));
        if (this.defaultWell != null) {
            resources.add(Resource.createResource(config, WellGen.class, this.defaultWell));
        }
        Collections.sort(resources);
        return resources;
    }
}

