/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.customobjects;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.io.SettingsReaderOTGPlus;
import com.pg85.otg.configuration.io.SettingsWriterOTGPlus;
import com.pg85.otg.configuration.settingType.Setting;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.customobjects.bo4.BO4Config;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.logging.LogMarker;
import java.io.File;
import java.io.IOException;

public abstract class CustomObjectConfigFile {
    public SettingsReaderOTGPlus reader;

    protected CustomObjectConfigFile(SettingsReaderOTGPlus reader) throws IllegalArgumentException {
        this.reader = reader;
    }

    protected <T> T readSettings(Setting<T> setting) {
        return this.readSettings(setting, setting.getDefaultValue());
    }

    private <T> T readSettings(Setting<T> setting, T defaultValue) {
        return this.reader.getSetting(setting, defaultValue);
    }

    public void write(SettingsWriterOTGPlus writer, WorldConfig.ConfigMode configMode) throws IOException {
        if (configMode == WorldConfig.ConfigMode.WriteDisable) {
            throw new IOException("ConfigMode is " + (Object)((Object)WorldConfig.ConfigMode.WriteDisable));
        }
        writer.setConfigMode(configMode);
        try {
            writer.open();
            this.writeConfigSettings(writer);
        }
        finally {
            writer.close();
        }
        if (writer.getFile().getName().toLowerCase().trim().endsWith(".bo3") && this instanceof BO4Config) {
            File newFile = new File(writer.getFile().getParentFile(), this.getName() + ".BO4");
            if (!writer.getFile().renameTo(newFile)) {
                OTG.log(LogMarker.INFO, "Could not rename file " + newFile.getName() + " to BO4, the file may be in use.", new Object[0]);
            }
        }
    }

    protected abstract void writeConfigSettings(SettingsWriterOTGPlus var1) throws IOException;

    protected abstract void readConfigSettings() throws InvalidConfigException;

    protected abstract void correctSettings();

    protected abstract void renameOldSettings();

    public String getName() {
        return this.reader.getName();
    }

    public File getFile() {
        return this.reader.getFile();
    }
}

