/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.world;

import com.pg85.otg.OTG;
import com.pg85.otg.bukkit.biomes.BukkitBiome;
import com.pg85.otg.bukkit.generator.BukkitVanillaBiomeGenerator;
import com.pg85.otg.bukkit.generator.OTGChunkGenerator;
import com.pg85.otg.bukkit.generator.OTGInternalChunkGenerator;
import com.pg85.otg.bukkit.generator.OTGWorldChunkManager;
import com.pg85.otg.bukkit.generator.OTGWorldProvider;
import com.pg85.otg.bukkit.generator.structures.MojangStructurePart;
import com.pg85.otg.bukkit.generator.structures.OTGMansionGen;
import com.pg85.otg.bukkit.generator.structures.OTGMineshaftGen;
import com.pg85.otg.bukkit.generator.structures.OTGNetherFortressGen;
import com.pg85.otg.bukkit.generator.structures.OTGOceanMonumentGen;
import com.pg85.otg.bukkit.generator.structures.OTGRareBuildingGen;
import com.pg85.otg.bukkit.generator.structures.OTGStrongholdGen;
import com.pg85.otg.bukkit.generator.structures.OTGVillageGen;
import com.pg85.otg.bukkit.materials.BukkitMaterialData;
import com.pg85.otg.bukkit.util.JsonToNBT;
import com.pg85.otg.bukkit.util.NBTException;
import com.pg85.otg.bukkit.util.NBTHelper;
import com.pg85.otg.bukkit.world.BukkitWorldSession;
import com.pg85.otg.bukkit.world.WorldHelper;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.common.WorldSession;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.biome.settings.ReplacedBlocksMatrix;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.customobjects.SpawnableObject;
import com.pg85.otg.customobjects.bofunctions.EntityFunction;
import com.pg85.otg.customobjects.structures.CustomStructureCache;
import com.pg85.otg.generator.ChunkBuffer;
import com.pg85.otg.generator.ObjectSpawner;
import com.pg85.otg.generator.biome.BiomeGenerator;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.network.ConfigProvider;
import com.pg85.otg.network.ServerConfigProvider;
import com.pg85.otg.util.BiomeIds;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.NamedBinaryTag;
import com.pg85.otg.util.helpers.ReflectionHelper;
import com.pg85.otg.util.minecraft.defaults.TreeType;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.server.v1_12_R1.BiomeBase;
import net.minecraft.server.v1_12_R1.Block;
import net.minecraft.server.v1_12_R1.BlockLeaves;
import net.minecraft.server.v1_12_R1.BlockLeaves1;
import net.minecraft.server.v1_12_R1.BlockLog1;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.BlockWood;
import net.minecraft.server.v1_12_R1.Blocks;
import net.minecraft.server.v1_12_R1.Chunk;
import net.minecraft.server.v1_12_R1.ChunkCoordIntPair;
import net.minecraft.server.v1_12_R1.ChunkProviderServer;
import net.minecraft.server.v1_12_R1.ChunkRegionLoader;
import net.minecraft.server.v1_12_R1.ChunkSection;
import net.minecraft.server.v1_12_R1.DefinedStructure;
import net.minecraft.server.v1_12_R1.DefinedStructureManager;
import net.minecraft.server.v1_12_R1.DimensionManager;
import net.minecraft.server.v1_12_R1.EntityAreaEffectCloud;
import net.minecraft.server.v1_12_R1.EntityArmorStand;
import net.minecraft.server.v1_12_R1.EntityBat;
import net.minecraft.server.v1_12_R1.EntityBlaze;
import net.minecraft.server.v1_12_R1.EntityBoat;
import net.minecraft.server.v1_12_R1.EntityCaveSpider;
import net.minecraft.server.v1_12_R1.EntityChicken;
import net.minecraft.server.v1_12_R1.EntityCow;
import net.minecraft.server.v1_12_R1.EntityCreeper;
import net.minecraft.server.v1_12_R1.EntityDragonFireball;
import net.minecraft.server.v1_12_R1.EntityEgg;
import net.minecraft.server.v1_12_R1.EntityEnderCrystal;
import net.minecraft.server.v1_12_R1.EntityEnderDragon;
import net.minecraft.server.v1_12_R1.EntityEnderPearl;
import net.minecraft.server.v1_12_R1.EntityEnderSignal;
import net.minecraft.server.v1_12_R1.EntityEnderman;
import net.minecraft.server.v1_12_R1.EntityEndermite;
import net.minecraft.server.v1_12_R1.EntityEvoker;
import net.minecraft.server.v1_12_R1.EntityEvokerFangs;
import net.minecraft.server.v1_12_R1.EntityExperienceOrb;
import net.minecraft.server.v1_12_R1.EntityFallingBlock;
import net.minecraft.server.v1_12_R1.EntityFireworks;
import net.minecraft.server.v1_12_R1.EntityGhast;
import net.minecraft.server.v1_12_R1.EntityGiantZombie;
import net.minecraft.server.v1_12_R1.EntityGuardian;
import net.minecraft.server.v1_12_R1.EntityGuardianElder;
import net.minecraft.server.v1_12_R1.EntityHorse;
import net.minecraft.server.v1_12_R1.EntityHorseDonkey;
import net.minecraft.server.v1_12_R1.EntityHorseMule;
import net.minecraft.server.v1_12_R1.EntityHorseSkeleton;
import net.minecraft.server.v1_12_R1.EntityHorseZombie;
import net.minecraft.server.v1_12_R1.EntityIronGolem;
import net.minecraft.server.v1_12_R1.EntityItemFrame;
import net.minecraft.server.v1_12_R1.EntityLargeFireball;
import net.minecraft.server.v1_12_R1.EntityLeash;
import net.minecraft.server.v1_12_R1.EntityLightning;
import net.minecraft.server.v1_12_R1.EntityLiving;
import net.minecraft.server.v1_12_R1.EntityLlama;
import net.minecraft.server.v1_12_R1.EntityLlamaSpit;
import net.minecraft.server.v1_12_R1.EntityMagmaCube;
import net.minecraft.server.v1_12_R1.EntityMinecartChest;
import net.minecraft.server.v1_12_R1.EntityMinecartCommandBlock;
import net.minecraft.server.v1_12_R1.EntityMinecartFurnace;
import net.minecraft.server.v1_12_R1.EntityMinecartHopper;
import net.minecraft.server.v1_12_R1.EntityMinecartMobSpawner;
import net.minecraft.server.v1_12_R1.EntityMinecartRideable;
import net.minecraft.server.v1_12_R1.EntityMinecartTNT;
import net.minecraft.server.v1_12_R1.EntityMushroomCow;
import net.minecraft.server.v1_12_R1.EntityOcelot;
import net.minecraft.server.v1_12_R1.EntityPainting;
import net.minecraft.server.v1_12_R1.EntityParrot;
import net.minecraft.server.v1_12_R1.EntityPig;
import net.minecraft.server.v1_12_R1.EntityPigZombie;
import net.minecraft.server.v1_12_R1.EntityPolarBear;
import net.minecraft.server.v1_12_R1.EntityPotion;
import net.minecraft.server.v1_12_R1.EntityRabbit;
import net.minecraft.server.v1_12_R1.EntitySheep;
import net.minecraft.server.v1_12_R1.EntityShulker;
import net.minecraft.server.v1_12_R1.EntityShulkerBullet;
import net.minecraft.server.v1_12_R1.EntitySilverfish;
import net.minecraft.server.v1_12_R1.EntitySkeleton;
import net.minecraft.server.v1_12_R1.EntitySkeletonStray;
import net.minecraft.server.v1_12_R1.EntitySkeletonWither;
import net.minecraft.server.v1_12_R1.EntitySlime;
import net.minecraft.server.v1_12_R1.EntitySmallFireball;
import net.minecraft.server.v1_12_R1.EntitySnowball;
import net.minecraft.server.v1_12_R1.EntitySnowman;
import net.minecraft.server.v1_12_R1.EntitySpectralArrow;
import net.minecraft.server.v1_12_R1.EntitySpider;
import net.minecraft.server.v1_12_R1.EntitySquid;
import net.minecraft.server.v1_12_R1.EntityTNTPrimed;
import net.minecraft.server.v1_12_R1.EntityThrownExpBottle;
import net.minecraft.server.v1_12_R1.EntityTippedArrow;
import net.minecraft.server.v1_12_R1.EntityVex;
import net.minecraft.server.v1_12_R1.EntityVillager;
import net.minecraft.server.v1_12_R1.EntityVindicator;
import net.minecraft.server.v1_12_R1.EntityWitch;
import net.minecraft.server.v1_12_R1.EntityWither;
import net.minecraft.server.v1_12_R1.EntityWitherSkull;
import net.minecraft.server.v1_12_R1.EntityWolf;
import net.minecraft.server.v1_12_R1.EntityZombie;
import net.minecraft.server.v1_12_R1.EntityZombieHusk;
import net.minecraft.server.v1_12_R1.EntityZombieVillager;
import net.minecraft.server.v1_12_R1.EnumCreatureType;
import net.minecraft.server.v1_12_R1.EnumDirection;
import net.minecraft.server.v1_12_R1.IBlockData;
import net.minecraft.server.v1_12_R1.IBlockState;
import net.minecraft.server.v1_12_R1.MinecraftKey;
import net.minecraft.server.v1_12_R1.NBTBase;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.NBTTagFloat;
import net.minecraft.server.v1_12_R1.NBTTagList;
import net.minecraft.server.v1_12_R1.SpawnerCreature;
import net.minecraft.server.v1_12_R1.StructureGenerator;
import net.minecraft.server.v1_12_R1.World;
import net.minecraft.server.v1_12_R1.WorldChunkManager;
import net.minecraft.server.v1_12_R1.WorldGenAcaciaTree;
import net.minecraft.server.v1_12_R1.WorldGenBigTree;
import net.minecraft.server.v1_12_R1.WorldGenDungeons;
import net.minecraft.server.v1_12_R1.WorldGenForest;
import net.minecraft.server.v1_12_R1.WorldGenForestTree;
import net.minecraft.server.v1_12_R1.WorldGenFossils;
import net.minecraft.server.v1_12_R1.WorldGenGroundBush;
import net.minecraft.server.v1_12_R1.WorldGenHugeMushroom;
import net.minecraft.server.v1_12_R1.WorldGenJungleTree;
import net.minecraft.server.v1_12_R1.WorldGenMegaTree;
import net.minecraft.server.v1_12_R1.WorldGenSwampTree;
import net.minecraft.server.v1_12_R1.WorldGenTaiga1;
import net.minecraft.server.v1_12_R1.WorldGenTaiga2;
import net.minecraft.server.v1_12_R1.WorldGenTrees;
import net.minecraft.server.v1_12_R1.WorldServer;
import org.apache.commons.lang3.RandomUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftGuardian;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_12_R1.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_12_R1.potion.CraftPotionUtil;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Boat;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.ComplexLivingEntity;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Egg;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Husk;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LeashHitch;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Mule;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Slime;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Stray;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.Weather;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.SpawnerMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public class BukkitWorld
implements LocalWorld {
    private static final int MAX_BIOMES_COUNT = 4096;
    private static final int MAX_SAVED_BIOMES_COUNT = 256;
    public static final int STANDARD_WORLD_HEIGHT = 128;
    private boolean initialized;
    private OTGChunkGenerator generator;
    private WorldServer world;
    private ServerConfigProvider settings;
    private CustomStructureCache structureCache;
    private String name;
    private BiomeGenerator biomeGenerator;
    private final Map<String, LocalBiome> biomeNames = new HashMap<String, LocalBiome>();
    public OTGStrongholdGen strongholdGen;
    public OTGVillageGen villageGen;
    public OTGMineshaftGen mineshaftGen;
    public OTGRareBuildingGen rareBuildingGen;
    public OTGNetherFortressGen netherFortressGen;
    public OTGOceanMonumentGen oceanMonumentGen;
    public OTGMansionGen woodLandMansionGen;
    private WorldGenDungeons dungeon;
    private WorldGenFossils fossil;
    private WorldGenTrees tree;
    private WorldGenAcaciaTree acaciaTree;
    private WorldGenBigTree bigTree;
    private WorldGenForest birchTree;
    private WorldGenTrees cocoaTree;
    private WorldGenForestTree darkOakTree;
    private WorldGenGroundBush groundBush;
    private WorldGenHugeMushroom hugeBrownMushroom;
    private WorldGenHugeMushroom hugeRedMushroom;
    private WorldGenMegaTree hugeTaigaTree1;
    private WorldGenMegaTree hugeTaigaTree2;
    private WorldGenJungleTree jungleTree;
    private WorldGenForest longBirchTree;
    private WorldGenSwampTree swampTree;
    private WorldGenTaiga1 taigaTree1;
    private WorldGenTaiga2 taigaTree2;
    private BukkitWorldSession worldSession;
    private LocalBiome[][] cachedBiomes;
    private boolean cacheIsValid;
    static Method canSpawnStructureAtCoordsMethod;

    public BukkitWorld(String _name) {
        this.name = _name;
        this.worldSession = new BukkitWorldSession(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getSeed() {
        return this.world.getSeed();
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public ConfigProvider getConfigs() {
        return this.settings;
    }

    public void setSettings(ServerConfigProvider newSettings) {
        if (this.settings != null) {
            throw new IllegalStateException("Settings are already set");
        }
        this.settings = newSettings;
    }

    public void reloadSettings() {
        this.biomeNames.clear();
        this.settings.reload();
    }

    public OTGChunkGenerator getChunkGenerator() {
        return this.generator;
    }

    public void setChunkGenerator(OTGChunkGenerator _generator) {
        this.generator = _generator;
    }

    @Override
    public CustomStructureCache getStructureCache() {
        return this.structureCache;
    }

    @Override
    public BiomeGenerator getBiomeGenerator() {
        return this.biomeGenerator;
    }

    @Override
    public ObjectSpawner getObjectSpawner() {
        return this.generator.getObjectSpawner();
    }

    @Override
    public WorldSession getWorldSession() {
        return this.worldSession;
    }

    @Override
    public String getWorldSettingsName() {
        return this.getWorld().getWorldData().getName();
    }

    @Override
    public File getWorldSaveDir() {
        return this.getWorld().getDataManager().getDirectory();
    }

    @Override
    public int getDimensionId() {
        return this.getWorld().worldProvider.getDimensionManager().getDimensionID();
    }

    @Override
    public void deleteWorldSessionData() {
        throw new RuntimeException();
    }

    @Override
    public int getHeightCap() {
        return this.settings.getWorldConfig().worldHeightCap;
    }

    @Override
    public int getHeightScale() {
        return this.settings.getWorldConfig().worldHeightScale;
    }

    public void enable(org.bukkit.World world) {
        WorldServer mcWorld;
        this.world = mcWorld = ((CraftWorld)world).getHandle();
        if (mcWorld.worldProvider.getDimensionManager().equals((Object)DimensionManager.OVERWORLD)) {
            mcWorld.worldProvider = new OTGWorldProvider(this, this.world.worldProvider);
        }
        Class<? extends BiomeGenerator> biomeModeClass = this.settings.getWorldConfig().biomeMode;
        this.biomeGenerator = OTG.getBiomeModeManager().createCached(biomeModeClass, this);
        this.injectWorldChunkManager(this.biomeGenerator);
        mcWorld.b(this.settings.getWorldConfig().waterLevelMax);
        if (!this.initialized) {
            this.structureCache = new CustomStructureCache(this);
            switch (this.settings.getWorldConfig().modeTerrain) {
                case Normal: {
                    this.strongholdGen = new OTGStrongholdGen(this.settings);
                    this.villageGen = new OTGVillageGen(this.settings);
                    this.mineshaftGen = new OTGMineshaftGen();
                    this.rareBuildingGen = new OTGRareBuildingGen(this.settings);
                    this.woodLandMansionGen = new OTGMansionGen(this.settings);
                    this.netherFortressGen = new OTGNetherFortressGen();
                    this.oceanMonumentGen = new OTGOceanMonumentGen(this.settings);
                    this.injectInternalChunkGenerator(new OTGInternalChunkGenerator(this, this.generator));
                }
                case NotGenerate: 
                case TerrainTest: {
                    this.generator.onInitialize(this);
                }
            }
            this.dungeon = new WorldGenDungeons();
            this.fossil = new WorldGenFossils();
            IBlockData jungleLog = Blocks.LOG.getBlockData().set((IBlockState)BlockLog1.VARIANT, (Comparable)BlockWood.EnumLogVariant.JUNGLE);
            IBlockData jungleLeaves = Blocks.LEAVES.getBlockData().set((IBlockState)BlockLeaves1.VARIANT, (Comparable)BlockWood.EnumLogVariant.JUNGLE).set((IBlockState)BlockLeaves.CHECK_DECAY, (Comparable)Boolean.valueOf(false));
            IBlockData oakLeaves = Blocks.LEAVES.getBlockData().set((IBlockState)BlockLeaves1.VARIANT, (Comparable)BlockWood.EnumLogVariant.OAK).set((IBlockState)BlockLeaves.CHECK_DECAY, (Comparable)Boolean.valueOf(false));
            this.tree = new WorldGenTrees(false);
            this.acaciaTree = new WorldGenAcaciaTree(false);
            this.cocoaTree = new WorldGenTrees(false, 5, jungleLog, jungleLeaves, true);
            this.bigTree = new WorldGenBigTree(false);
            this.birchTree = new WorldGenForest(false, false);
            this.darkOakTree = new WorldGenForestTree(false);
            this.longBirchTree = new WorldGenForest(false, true);
            this.swampTree = new WorldGenSwampTree();
            this.taigaTree1 = new WorldGenTaiga1();
            this.taigaTree2 = new WorldGenTaiga2(false);
            this.hugeBrownMushroom = new WorldGenHugeMushroom(Blocks.BROWN_MUSHROOM_BLOCK);
            this.hugeRedMushroom = new WorldGenHugeMushroom(Blocks.RED_MUSHROOM_BLOCK);
            this.hugeTaigaTree1 = new WorldGenMegaTree(false, false);
            this.hugeTaigaTree2 = new WorldGenMegaTree(false, true);
            this.jungleTree = new WorldGenJungleTree(false, 10, 20, jungleLog, jungleLeaves);
            this.groundBush = new WorldGenGroundBush(jungleLog, oakLeaves);
            this.initialized = true;
        } else {
            this.structureCache.reloadBo3StructureCache(this);
        }
    }

    public void disable() {
        if (this.world.worldProvider instanceof OTGWorldProvider) {
            this.world.worldProvider = ((OTGWorldProvider)this.world.worldProvider).getOldWorldProvider();
        }
        this.injectInternalChunkGenerator(new CustomChunkGenerator((World)this.world, this.getSeed(), (ChunkGenerator)this.generator));
    }

    private void injectWorldChunkManager(BiomeGenerator biomeGenerator) {
        if (biomeGenerator instanceof BukkitVanillaBiomeGenerator) {
            ((BukkitVanillaBiomeGenerator)biomeGenerator).setWorldChunkManager(this.world.worldProvider.k());
        } else {
            ReflectionHelper.setValueInFieldOfType(this.world.worldProvider, WorldChunkManager.class, new OTGWorldChunkManager(this, biomeGenerator));
        }
    }

    private void injectInternalChunkGenerator(CustomChunkGenerator chunkGenerator) {
        ChunkProviderServer chunkProvider = this.world.getChunkProviderServer();
        net.minecraft.server.v1_12_R1.ChunkGenerator oldChunkGenerator = chunkProvider.chunkGenerator;
        if (oldChunkGenerator instanceof CustomChunkGenerator) {
            ReflectionHelper.setValueInFieldOfType(chunkProvider, net.minecraft.server.v1_12_R1.ChunkGenerator.class, chunkGenerator);
        }
    }

    @Override
    public LocalBiome createBiomeFor(BiomeConfig biomeConfig, BiomeIds biomeIds, ConfigProvider configProvider, boolean isReload) {
        return this.createBiomeFor(biomeConfig, biomeIds, isReload);
    }

    @Override
    public int getRegisteredBiomeId(String resourceLocationString) {
        if (resourceLocationString != null && !resourceLocationString.trim().isEmpty()) {
            String[] resourceLocationStringArr = resourceLocationString.split(":");
            if (resourceLocationStringArr.length == 1) {
                MinecraftKey resourceLocation = new MinecraftKey("openterraingenerator".toLowerCase(), this.getName() + "_" + resourceLocationStringArr[0].replaceAll(" ", "_"));
                BiomeBase biome = (BiomeBase)BiomeBase.REGISTRY_ID.get((Object)resourceLocation);
                return WorldHelper.getSavedId(biome);
            }
            if (resourceLocationStringArr.length == 2) {
                MinecraftKey resourceLocation = new MinecraftKey(resourceLocationStringArr[0], resourceLocationStringArr[1]);
                BiomeBase biome = (BiomeBase)BiomeBase.REGISTRY_ID.get((Object)resourceLocation);
                return WorldHelper.getSavedId(biome);
            }
        }
        return -1;
    }

    @Override
    public BukkitBiome getCalculatedBiome(int x, int z) {
        return (BukkitBiome)this.getBiomeByOTGIdOrNull(this.biomeGenerator.getBiome(x, z));
    }

    @Override
    public LocalBiome getBiome(int x, int z) {
        return this.getCalculatedBiome(x, z);
    }

    @Override
    public LocalBiome getBiomeForPopulation(int worldX, int worldZ, ChunkCoordinate chunkBeingPopulated) {
        return !this.cacheIsValid ? this.getBiome(worldZ, worldX) : this.cachedBiomes[worldX - chunkBeingPopulated.getBlockX()][worldZ - chunkBeingPopulated.getBlockZ()];
    }

    @Override
    public void cacheBiomesForPopulation(ChunkCoordinate chunkCoord) {
        this.cachedBiomes = new LocalBiome[32][32];
        int areaSize = 32;
        for (int x = 0; x < areaSize; ++x) {
            for (int z = 0; z < areaSize; ++z) {
                this.cachedBiomes[x][z] = this.getBiome(chunkCoord.getBlockX() + x, chunkCoord.getBlockZ() + z);
            }
        }
        this.cacheIsValid = true;
    }

    @Override
    public void invalidatePopulationBiomeCache() {
        this.cacheIsValid = false;
    }

    @Override
    public String getSavedBiomeName(int x, int z) {
        BiomeConfig biomeConfig = this.getBiome(x, z).getBiomeConfig();
        if (biomeConfig.replaceToBiomeName == null || biomeConfig.replaceToBiomeName.trim().length() == 0) {
            return biomeConfig.getName();
        }
        return biomeConfig.replaceToBiomeName;
    }

    private LocalBiome createBiomeFor(BiomeConfig biomeConfig, BiomeIds biomeIds, boolean isReload) {
        BukkitBiome biome = BukkitBiome.forCustomBiome(biomeConfig, biomeIds, this.getName(), isReload);
        this.biomeNames.put(biome.getName(), biome);
        return biome;
    }

    @Override
    public int getMaxBiomesCount() {
        return 4096;
    }

    @Override
    public int getMaxSavedBiomesCount() {
        return 256;
    }

    @Override
    public ArrayList<LocalBiome> getAllBiomes() {
        ArrayList<LocalBiome> biomes = new ArrayList<LocalBiome>();
        for (LocalBiome biome : this.settings.getBiomeArrayByOTGId()) {
            biomes.add(biome);
        }
        return biomes;
    }

    @Override
    public LocalBiome getBiomeByOTGIdOrNull(int id) {
        return this.settings.getBiomeByOTGIdOrNull(id);
    }

    @Override
    public LocalBiome getFirstBiomeOrNull() {
        return this.biomeNames.size() > 0 ? (LocalBiome)this.biomeNames.values().toArray()[0] : null;
    }

    @Override
    public LocalBiome getBiomeByNameOrNull(String name) {
        return this.biomeNames.get(name);
    }

    @Override
    public void prepareDefaultStructures(int chunkX, int chunkZ, boolean dry) {
        WorldConfig worldConfig = this.settings.getWorldConfig();
        if (worldConfig.strongholdsEnabled) {
            this.strongholdGen.a((World)this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.mineshaftsEnabled) {
            this.mineshaftGen.a((World)this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.villagesEnabled && dry) {
            this.villageGen.a((World)this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.rareBuildingsEnabled) {
            this.rareBuildingGen.a((World)this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.netherFortressesEnabled) {
            this.netherFortressGen.a((World)this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.oceanMonumentsEnabled) {
            this.oceanMonumentGen.a((World)this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.woodLandMansionsEnabled) {
            this.woodLandMansionGen.a((World)this.world, chunkX, chunkZ, null);
        }
    }

    @Override
    public boolean placeDungeon(Random rand, int x, int y, int z) {
        if (y < 0 || y >= 256) {
            return false;
        }
        return this.dungeon.generate((World)this.world, rand, new BlockPosition(x, y, z));
    }

    @Override
    public boolean placeFossil(Random rand, ChunkCoordinate chunkCoord) {
        return this.fossil.generate((World)this.world, rand, new BlockPosition(chunkCoord.getBlockX(), 0, chunkCoord.getBlockZ()));
    }

    @Override
    public boolean placeTree(TreeType type, Random rand, int x, int y, int z) {
        if (y < 0 || y >= 256) {
            return false;
        }
        BlockPosition blockPos = new BlockPosition(x, y, z);
        switch (type) {
            case Tree: {
                return this.tree.generate((World)this.world, rand, blockPos);
            }
            case BigTree: {
                return this.bigTree.generate((World)this.world, rand, blockPos);
            }
            case Forest: 
            case Birch: {
                return this.birchTree.generate((World)this.world, rand, blockPos);
            }
            case TallBirch: {
                return this.longBirchTree.generate((World)this.world, rand, blockPos);
            }
            case HugeMushroom: {
                if (rand.nextBoolean()) {
                    return this.hugeBrownMushroom.generate((World)this.world, rand, blockPos);
                }
                return this.hugeRedMushroom.generate((World)this.world, rand, blockPos);
            }
            case HugeRedMushroom: {
                return this.hugeRedMushroom.generate((World)this.world, rand, blockPos);
            }
            case HugeBrownMushroom: {
                return this.hugeBrownMushroom.generate((World)this.world, rand, blockPos);
            }
            case SwampTree: {
                return this.swampTree.generate((World)this.world, rand, blockPos);
            }
            case Taiga1: {
                return this.taigaTree1.generate((World)this.world, rand, blockPos);
            }
            case Taiga2: {
                return this.taigaTree2.generate((World)this.world, rand, blockPos);
            }
            case JungleTree: {
                return this.jungleTree.generate((World)this.world, rand, blockPos);
            }
            case GroundBush: {
                return this.groundBush.generate((World)this.world, rand, blockPos);
            }
            case CocoaTree: {
                return this.cocoaTree.generate((World)this.world, rand, blockPos);
            }
            case Acacia: {
                return this.acaciaTree.generate((World)this.world, rand, blockPos);
            }
            case DarkOak: {
                return this.darkOakTree.generate((World)this.world, rand, blockPos);
            }
            case HugeTaiga1: {
                return this.hugeTaigaTree1.generate((World)this.world, rand, blockPos);
            }
            case HugeTaiga2: {
                return this.hugeTaigaTree2.generate((World)this.world, rand, blockPos);
            }
        }
        throw new RuntimeException("Failed to handle tree of type " + type.toString());
    }

    @Override
    public boolean chunkHasDefaultStructure(Random rand, ChunkCoordinate chunkCoord) {
        WorldConfig worldConfig = this.settings.getWorldConfig();
        return worldConfig.villagesEnabled && this.isStructureInRadius(chunkCoord, this.villageGen, 4) || worldConfig.rareBuildingsEnabled && this.isStructureInRadius(chunkCoord, this.rareBuildingGen, 4) || worldConfig.netherFortressesEnabled && this.isStructureInRadius(chunkCoord, this.netherFortressGen, 4) || worldConfig.oceanMonumentsEnabled && this.isStructureInRadius(chunkCoord, this.oceanMonumentGen, 4) || worldConfig.woodLandMansionsEnabled && this.isStructureInRadius(chunkCoord, this.woodLandMansionGen, 4);
    }

    public boolean isStructureInRadius(ChunkCoordinate startChunk, StructureGenerator structure, int radiusInChunks) {
        if (canSpawnStructureAtCoordsMethod == null) {
            try {
                canSpawnStructureAtCoordsMethod = StructureGenerator.class.getDeclaredMethod("a", Integer.TYPE, Integer.TYPE);
                canSpawnStructureAtCoordsMethod.setAccessible(true);
            }
            catch (NoSuchMethodException | SecurityException e) {
                OTG.log(LogMarker.ERROR, "Error, could not reflect canSpawnStructureAtCoords, BO4's may not be able to detect default/modded structures. OTG may not fully support your Spigot/Bukkit version.", new Object[0]);
                e.printStackTrace();
            }
        }
        int chunkX = startChunk.getChunkX();
        int chunkZ = startChunk.getChunkZ();
        for (int cycle = 0; cycle <= radiusInChunks; ++cycle) {
            for (int xRadius = -cycle; xRadius <= cycle; ++xRadius) {
                for (int zRadius = -cycle; zRadius <= cycle; ++zRadius) {
                    int distance = (int)Math.floor(Math.sqrt(Math.pow(chunkX - chunkX + xRadius, 2.0) + Math.pow(chunkZ - chunkZ + zRadius, 2.0)));
                    if (distance != cycle) continue;
                    boolean canSpawnStructureAtCoords = false;
                    try {
                        canSpawnStructureAtCoords = (Boolean)canSpawnStructureAtCoordsMethod.invoke((Object)structure, chunkX + xRadius, chunkZ + zRadius);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        OTG.log(LogMarker.ERROR, "Error, could not reflect canSpawnStructureAtCoords, BO4's may not be able to detect default/modded structures. OTG may not fully support your Spigot/Bukkit version.", new Object[0]);
                        e.printStackTrace();
                    }
                    if (!canSpawnStructureAtCoords) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean placeDefaultStructures(Random random, ChunkCoordinate chunkCoord) {
        ChunkCoordIntPair chunkIntPair = new ChunkCoordIntPair(chunkCoord.getChunkX(), chunkCoord.getChunkZ());
        WorldConfig worldConfig = this.settings.getWorldConfig();
        boolean villageGenerated = false;
        if (worldConfig.strongholdsEnabled) {
            this.strongholdGen.a((World)this.world, random, chunkIntPair);
        }
        if (worldConfig.mineshaftsEnabled) {
            this.mineshaftGen.a((World)this.world, random, chunkIntPair);
        }
        if (worldConfig.villagesEnabled) {
            villageGenerated = this.villageGen.a((World)this.world, random, chunkIntPair);
        }
        if (worldConfig.rareBuildingsEnabled) {
            this.rareBuildingGen.a((World)this.world, random, chunkIntPair);
        }
        if (worldConfig.netherFortressesEnabled) {
            this.netherFortressGen.a((World)this.world, random, chunkIntPair);
        }
        if (worldConfig.oceanMonumentsEnabled) {
            this.oceanMonumentGen.a((World)this.world, random, chunkIntPair);
        }
        if (worldConfig.woodLandMansionsEnabled) {
            this.woodLandMansionGen.a((World)this.world, random, chunkIntPair);
        }
        return villageGenerated;
    }

    @Override
    public SpawnableObject getMojangStructurePart(String name) {
        MinecraftKey minecraftKey = new MinecraftKey(name);
        DefinedStructureManager mojangStructureParts = this.world.getDataManager().h();
        DefinedStructure mojangStructurePart = mojangStructureParts.a(this.world.getMinecraftServer(), minecraftKey);
        if (mojangStructurePart == null) {
            return null;
        }
        return new MojangStructurePart(name, mojangStructurePart);
    }

    @Override
    public double getBiomeBlocksNoiseValue(int xInWorld, int zInWorld) {
        return this.getChunkGenerator().getBiomeBlocksNoiseValue(xInWorld, zInWorld);
    }

    @Override
    public void replaceBlocks(ChunkCoordinate chunkCoord) {
    }

    private void replaceBlocks(Chunk rawChunk) {
        int worldStartX = rawChunk.locX * 16;
        int worldStartZ = rawChunk.locZ * 16;
        ChunkSection[] sectionsArray = rawChunk.getSections();
        int blockId = 0;
        ReplacedBlocksMatrix.ReplacedBlocksInstruction[][][] replaceInstructionsCache = new ReplacedBlocksMatrix.ReplacedBlocksInstruction[16][16][];
        for (ChunkSection section : sectionsArray) {
            if (section == null) continue;
            for (int sectionX = 0; sectionX < 16; ++sectionX) {
                for (int sectionZ = 0; sectionZ < 16; ++sectionZ) {
                    ReplacedBlocksMatrix.ReplacedBlocksInstruction[] replaceArray = replaceInstructionsCache[sectionX][sectionZ];
                    if (replaceArray == null) {
                        LocalBiome biome = this.getBiome(worldStartX + sectionX, worldStartZ + sectionZ);
                        if (biome == null || !biome.getBiomeConfig().replacedBlocks.hasReplaceSettings()) {
                            replaceArray = new ReplacedBlocksMatrix.ReplacedBlocksInstruction[]{};
                        } else {
                            biome.getBiomeConfig().replacedBlocks.parseForWorld(this);
                            replaceArray = new ReplacedBlocksMatrix.ReplacedBlocksInstruction[biome.getBiomeConfig().replacedBlocks.getInstructions().size()];
                            replaceArray = biome.getBiomeConfig().replacedBlocks.getInstructions().toArray(replaceArray);
                        }
                        replaceInstructionsCache[sectionX][sectionZ] = replaceArray;
                    }
                    if (replaceArray == null || replaceArray.length <= 0) continue;
                    int minHeight = 256;
                    int maxHeight = 0;
                    for (ReplacedBlocksMatrix.ReplacedBlocksInstruction instruction : replaceArray) {
                        if (instruction.getFrom() == null || instruction.getTo() == null) continue;
                        if (instruction.getMinHeight() < minHeight) {
                            minHeight = instruction.getMinHeight();
                        }
                        if (instruction.getMaxHeight() <= maxHeight) continue;
                        maxHeight = instruction.getMaxHeight();
                    }
                    for (int sectionY = 0; sectionY < 16; ++sectionY) {
                        IBlockData block = null;
                        int y = section.getYPosition() + sectionY;
                        if (y < minHeight || y > maxHeight) continue;
                        for (ReplacedBlocksMatrix.ReplacedBlocksInstruction instruction : replaceArray) {
                            if (instruction.getFrom() == null || instruction.getTo() == null || y < instruction.getMinHeight() || y > instruction.getMaxHeight()) continue;
                            if (block == null) {
                                block = section.getType(sectionX, sectionY, sectionZ);
                                blockId = Block.getId((Block)block.getBlock());
                            }
                            if (instruction.getFrom().getBlockId() != blockId) continue;
                            section.setType(sectionX, sectionY, sectionZ, ((BukkitMaterialData)instruction.getTo()).internalBlock());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void placePopulationMobs(LocalBiome biome, Random random, ChunkCoordinate chunkCoord) {
        SpawnerCreature.a((World)this.world, (BiomeBase)((BukkitBiome)biome).getHandle(), (int)(chunkCoord.getChunkX() * 16 + 8), (int)(chunkCoord.getChunkZ() * 16 + 8), (int)16, (int)16, (Random)random);
    }

    private net.minecraft.server.v1_12_R1.Entity getEntity(Class<? extends Entity> clazz, EnumDirection direction) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (Boat.class.isAssignableFrom(clazz)) {
            return new EntityBoat((World)this.world, x, y, z);
        }
        if (FallingBlock.class.isAssignableFrom(clazz)) {
            return new EntityFallingBlock((World)this.world, x, y, z, this.world.getType(new BlockPosition(x, y, z)));
        }
        if (Projectile.class.isAssignableFrom(clazz)) {
            if (Snowball.class.isAssignableFrom(clazz)) {
                return new EntitySnowball((World)this.world, x, y, z);
            }
            if (Egg.class.isAssignableFrom(clazz)) {
                return new EntityEgg((World)this.world, x, y, z);
            }
            if (Arrow.class.isAssignableFrom(clazz)) {
                if (TippedArrow.class.isAssignableFrom(clazz)) {
                    EntityTippedArrow entity = new EntityTippedArrow((World)this.world);
                    entity.setType(CraftPotionUtil.fromBukkit((PotionData)new PotionData(PotionType.WATER, false, false)));
                    return entity;
                }
                if (SpectralArrow.class.isAssignableFrom(clazz)) {
                    return new EntitySpectralArrow((World)this.world);
                }
                return new EntityTippedArrow((World)this.world);
            }
            if (ThrownExpBottle.class.isAssignableFrom(clazz)) {
                return new EntityThrownExpBottle((World)this.world);
            }
            if (EnderPearl.class.isAssignableFrom(clazz)) {
                return new EntityEnderPearl((World)this.world);
            }
            if (ThrownPotion.class.isAssignableFrom(clazz)) {
                if (LingeringPotion.class.isAssignableFrom(clazz)) {
                    return new EntityPotion((World)this.world, x, y, z, CraftItemStack.asNMSCopy((ItemStack)new ItemStack(Material.LINGERING_POTION, 1)));
                }
                return new EntityPotion((World)this.world, x, y, z, CraftItemStack.asNMSCopy((ItemStack)new ItemStack(Material.SPLASH_POTION, 1)));
            }
            if (Fireball.class.isAssignableFrom(clazz)) {
                if (SmallFireball.class.isAssignableFrom(clazz)) {
                    return new EntitySmallFireball((World)this.world);
                }
                if (WitherSkull.class.isAssignableFrom(clazz)) {
                    return new EntityWitherSkull((World)this.world);
                }
                if (DragonFireball.class.isAssignableFrom(clazz)) {
                    return new EntityDragonFireball((World)this.world);
                }
                return new EntityLargeFireball((World)this.world);
            }
            if (ShulkerBullet.class.isAssignableFrom(clazz)) {
                return new EntityShulkerBullet((World)this.world);
            }
        } else {
            if (Minecart.class.isAssignableFrom(clazz)) {
                if (PoweredMinecart.class.isAssignableFrom(clazz)) {
                    return new EntityMinecartFurnace((World)this.world, x, y, z);
                }
                if (StorageMinecart.class.isAssignableFrom(clazz)) {
                    return new EntityMinecartChest((World)this.world, x, y, z);
                }
                if (ExplosiveMinecart.class.isAssignableFrom(clazz)) {
                    return new EntityMinecartTNT((World)this.world, x, y, z);
                }
                if (HopperMinecart.class.isAssignableFrom(clazz)) {
                    return new EntityMinecartHopper((World)this.world, x, y, z);
                }
                if (SpawnerMinecart.class.isAssignableFrom(clazz)) {
                    return new EntityMinecartMobSpawner((World)this.world, x, y, z);
                }
                if (CommandMinecart.class.isAssignableFrom(clazz)) {
                    return new EntityMinecartCommandBlock((World)this.world, x, y, z);
                }
                return new EntityMinecartRideable((World)this.world, x, y, z);
            }
            if (EnderSignal.class.isAssignableFrom(clazz)) {
                return new EntityEnderSignal((World)this.world, x, y, z);
            }
            if (EnderCrystal.class.isAssignableFrom(clazz)) {
                return new EntityEnderCrystal((World)this.world);
            }
            if (LivingEntity.class.isAssignableFrom(clazz)) {
                if (Chicken.class.isAssignableFrom(clazz)) {
                    return new EntityChicken((World)this.world);
                }
                if (Cow.class.isAssignableFrom(clazz)) {
                    if (MushroomCow.class.isAssignableFrom(clazz)) {
                        return new EntityMushroomCow((World)this.world);
                    }
                    return new EntityCow((World)this.world);
                }
                if (Golem.class.isAssignableFrom(clazz)) {
                    if (Snowman.class.isAssignableFrom(clazz)) {
                        return new EntitySnowman((World)this.world);
                    }
                    if (IronGolem.class.isAssignableFrom(clazz)) {
                        return new EntityIronGolem((World)this.world);
                    }
                    if (Shulker.class.isAssignableFrom(clazz)) {
                        return new EntityShulker((World)this.world);
                    }
                } else {
                    if (Creeper.class.isAssignableFrom(clazz)) {
                        return new EntityCreeper((World)this.world);
                    }
                    if (Ghast.class.isAssignableFrom(clazz)) {
                        return new EntityGhast((World)this.world);
                    }
                    if (Pig.class.isAssignableFrom(clazz)) {
                        return new EntityPig((World)this.world);
                    }
                    if (!Player.class.isAssignableFrom(clazz)) {
                        if (Sheep.class.isAssignableFrom(clazz)) {
                            return new EntitySheep((World)this.world);
                        }
                        if (Horse.class.isAssignableFrom(clazz)) {
                            return new EntityHorse((World)this.world);
                        }
                        if (Skeleton.class.isAssignableFrom(clazz)) {
                            return new EntitySkeleton((World)this.world);
                        }
                        if (Slime.class.isAssignableFrom(clazz)) {
                            if (MagmaCube.class.isAssignableFrom(clazz)) {
                                return new EntityMagmaCube((World)this.world);
                            }
                            return new EntitySlime((World)this.world);
                        }
                        if (Spider.class.isAssignableFrom(clazz)) {
                            if (CaveSpider.class.isAssignableFrom(clazz)) {
                                return new EntityCaveSpider((World)this.world);
                            }
                            return new EntitySpider((World)this.world);
                        }
                        if (Squid.class.isAssignableFrom(clazz)) {
                            return new EntitySquid((World)this.world);
                        }
                        if (Tameable.class.isAssignableFrom(clazz)) {
                            if (Wolf.class.isAssignableFrom(clazz)) {
                                return new EntityWolf((World)this.world);
                            }
                            if (Ocelot.class.isAssignableFrom(clazz)) {
                                return new EntityOcelot((World)this.world);
                            }
                        } else {
                            if (PigZombie.class.isAssignableFrom(clazz)) {
                                return new EntityPigZombie((World)this.world);
                            }
                            if (Zombie.class.isAssignableFrom(clazz)) {
                                return new EntityZombie((World)this.world);
                            }
                            if (Giant.class.isAssignableFrom(clazz)) {
                                return new EntityGiantZombie((World)this.world);
                            }
                            if (Silverfish.class.isAssignableFrom(clazz)) {
                                return new EntitySilverfish((World)this.world);
                            }
                            if (Enderman.class.isAssignableFrom(clazz)) {
                                return new EntityEnderman((World)this.world);
                            }
                            if (Blaze.class.isAssignableFrom(clazz)) {
                                return new EntityBlaze((World)this.world);
                            }
                            if (Villager.class.isAssignableFrom(clazz)) {
                                return new EntityVillager((World)this.world);
                            }
                            if (Witch.class.isAssignableFrom(clazz)) {
                                return new EntityWitch((World)this.world);
                            }
                            if (Wither.class.isAssignableFrom(clazz)) {
                                return new EntityWither((World)this.world);
                            }
                            if (ComplexLivingEntity.class.isAssignableFrom(clazz)) {
                                if (EnderDragon.class.isAssignableFrom(clazz)) {
                                    return new EntityEnderDragon((World)this.world);
                                }
                            } else if (Ambient.class.isAssignableFrom(clazz)) {
                                if (Bat.class.isAssignableFrom(clazz)) {
                                    return new EntityBat((World)this.world);
                                }
                            } else {
                                if (Rabbit.class.isAssignableFrom(clazz)) {
                                    return new EntityRabbit((World)this.world);
                                }
                                if (Endermite.class.isAssignableFrom(clazz)) {
                                    return new EntityEndermite((World)this.world);
                                }
                                if (Guardian.class.isAssignableFrom(clazz)) {
                                    return new EntityGuardian((World)this.world);
                                }
                                if (ArmorStand.class.isAssignableFrom(clazz)) {
                                    return new EntityArmorStand((World)this.world, x, y, z);
                                }
                                if (PolarBear.class.isAssignableFrom(clazz)) {
                                    return new EntityPolarBear((World)this.world);
                                }
                                if (Parrot.class.isAssignableFrom(clazz)) {
                                    return new EntityParrot((World)this.world);
                                }
                            }
                        }
                    }
                }
            } else if (Hanging.class.isAssignableFrom(clazz)) {
                if (LeashHitch.class.isAssignableFrom(clazz)) {
                    return new EntityLeash((World)this.world, new BlockPosition((int)x, (int)y, (int)z));
                }
                if (Painting.class.isAssignableFrom(clazz)) {
                    return new EntityPainting((World)this.world, new BlockPosition((int)x, (int)y, (int)z), direction);
                }
                if (ItemFrame.class.isAssignableFrom(clazz)) {
                    return new EntityItemFrame((World)this.world, new BlockPosition((int)x, (int)y, (int)z), direction);
                }
            } else {
                if (TNTPrimed.class.isAssignableFrom(clazz)) {
                    return new EntityTNTPrimed((World)this.world, x, y, z, null);
                }
                if (ExperienceOrb.class.isAssignableFrom(clazz)) {
                    return new EntityExperienceOrb((World)this.world, x, y, z, 0);
                }
                if (Weather.class.isAssignableFrom(clazz)) {
                    if (LightningStrike.class.isAssignableFrom(clazz)) {
                        return new EntityLightning((World)this.world, x, y, z, false);
                    }
                } else {
                    if (Firework.class.isAssignableFrom(clazz)) {
                        return new EntityFireworks((World)this.world, x, y, z, null);
                    }
                    if (AreaEffectCloud.class.isAssignableFrom(clazz)) {
                        return new EntityAreaEffectCloud((World)this.world, x, y, z);
                    }
                }
            }
        }
        if (Donkey.class.isAssignableFrom(clazz)) {
            return new EntityHorseDonkey((World)this.world);
        }
        if (ElderGuardian.class.isAssignableFrom(clazz)) {
            return new EntityGuardianElder((World)this.world);
        }
        if (Evoker.class.isAssignableFrom(clazz)) {
            return new EntityEvoker((World)this.world);
        }
        if (EvokerFangs.class.isAssignableFrom(clazz)) {
            return new EntityEvokerFangs((World)this.world);
        }
        if (Husk.class.isAssignableFrom(clazz)) {
            return new EntityZombieHusk((World)this.world);
        }
        if (Llama.class.isAssignableFrom(clazz)) {
            return new EntityLlama((World)this.world);
        }
        if (LlamaSpit.class.isAssignableFrom(clazz)) {
            return new EntityLlamaSpit((World)this.world);
        }
        if (Mule.class.isAssignableFrom(clazz)) {
            return new EntityHorseMule((World)this.world);
        }
        if (SkeletonHorse.class.isAssignableFrom(clazz)) {
            return new EntityHorseSkeleton((World)this.world);
        }
        if (Stray.class.isAssignableFrom(clazz)) {
            return new EntitySkeletonStray((World)this.world);
        }
        if (Vex.class.isAssignableFrom(clazz)) {
            return new EntityVex((World)this.world);
        }
        if (Vindicator.class.isAssignableFrom(clazz)) {
            return new EntityVindicator((World)this.world);
        }
        if (WitherSkeleton.class.isAssignableFrom(clazz)) {
            return new EntitySkeletonWither((World)this.world);
        }
        if (ZombieHorse.class.isAssignableFrom(clazz)) {
            return new EntityHorseZombie((World)this.world);
        }
        if (ZombieVillager.class.isAssignableFrom(clazz)) {
            return new EntityZombieVillager((World)this.world);
        }
        return null;
    }

    @Override
    public void spawnEntity(EntityFunction<?> entityData, ChunkCoordinate chunkBeingPopulated) {
        if (OTG.getPluginConfig().spawnLog) {
            OTG.log(LogMarker.DEBUG, "Attempting to spawn BO3 Entity() " + entityData.groupSize + " x " + entityData.name + " at " + entityData.x + " " + entityData.y + " " + entityData.z, new Object[0]);
        }
        if (chunkBeingPopulated != null && !OTG.IsInAreaBeingPopulated((int)Math.floor(entityData.x), (int)Math.floor(entityData.z), chunkBeingPopulated)) {
            if (OTG.getPluginConfig().spawnLog) {
                OTG.log(LogMarker.DEBUG, "Tried to spawn entity " + entityData.resourceLocation + "outside population bounds, aborting", new Object[0]);
            }
            return;
        }
        if (entityData.y < 0 || entityData.y >= 256) {
            if (OTG.getPluginConfig().spawnLog) {
                OTG.log(LogMarker.ERROR, "Failed to spawn mob " + entityData.name + ", spawn position out of bounds", new Object[0]);
            }
            return;
        }
        String nameTag = entityData.nameTagOrNBTFileName;
        net.minecraft.server.v1_12_R1.Entity entity = this.createEntityFromData(entityData);
        if (entity == null) {
            return;
        }
        Material material = this.world.getWorld().getBlockAt(new Location((org.bukkit.World)this.world.getWorld(), (double)entityData.x, (double)entityData.y, (double)entityData.z)).getType();
        if (!material.isTransparent() || material.isSolid() || entity.getBukkitEntity() instanceof CraftGuardian || EnumCreatureType.WATER_CREATURE.a().isAssignableFrom(entity.getClass()) && material != Material.WATER && material != Material.STATIONARY_WATER) {
            this.world.removeEntity(entity);
            return;
        }
        if (entity instanceof EntityLiving) {
            for (int r = 0; r < entityData.groupSize; ++r) {
                if (r != 0 && (entity = this.createEntityFromData(entityData)) == null) {
                    return;
                }
                if (nameTag != null && !nameTag.toLowerCase().trim().endsWith(".txt") && !nameTag.toLowerCase().trim().endsWith(".nbt")) {
                    entity.setCustomName(nameTag);
                }
                ((CraftLivingEntity)CraftLivingEntity.getEntity((CraftServer)this.world.getServer(), (net.minecraft.server.v1_12_R1.Entity)entity)).setRemoveWhenFarAway(false);
            }
        } else {
            for (int r = 0; r < entityData.groupSize; ++r) {
                if (r != 0 && (entity = this.createEntityFromData(entityData)) == null || !(entity instanceof EntityItemFrame) || ((EntityItemFrame)entity).direction != null) continue;
                ((EntityItemFrame)entity).direction = EnumDirection.SOUTH;
            }
        }
    }

    private net.minecraft.server.v1_12_R1.Entity createEntityFromData(EntityFunction<?> entityData) {
        net.minecraft.server.v1_12_R1.Entity entity = null;
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (entityData.getMetaData() != null && entityData.getMetaData().trim().length() > 0) {
            try {
                if (entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".txt")) {
                    nbttagcompound = JsonToNBT.getTagFromJson(entityData.getMetaData());
                    nbttagcompound.setString("id", entityData.resourceLocation);
                } else if (entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".nbt")) {
                    nbttagcompound = NBTHelper.getNMSFromNBTTagCompound(entityData.namedBinaryTag);
                }
            }
            catch (NBTException nbtexception) {
                if (OTG.getPluginConfig().spawnLog) {
                    OTG.log(LogMarker.WARN, "Invalid NBT tag for mob in EntityFunction: " + entityData.getMetaData() + ". Skipping mob.", new Object[0]);
                }
                return null;
            }
            if (nbttagcompound.hasKey("Facing")) {
                byte face = nbttagcompound.getByte("Facing");
                nbttagcompound.setByte("Facing", (byte)((face + (6 - entityData.rotation)) % 4));
            }
            if (nbttagcompound.hasKey("Rotation")) {
                NBTTagList list = nbttagcompound.getList("Rotation", 5);
                float f = list.g(0);
                if (f == 1.0f) {
                    f += (float)RandomUtils.nextInt((int)0, (int)350);
                }
                list.a(0, (NBTBase)new NBTTagFloat((f + (float)((2 - entityData.rotation) % 4 * 90)) % 360.0f));
            }
            if ((entity = ChunkRegionLoader.spawnEntity((NBTTagCompound)nbttagcompound, (World)this.world, (double)((double)entityData.x + 0.5), (double)entityData.y, (double)((double)entityData.z + 0.5), (boolean)true, (CreatureSpawnEvent.SpawnReason)CreatureSpawnEvent.SpawnReason.CUSTOM)) == null) {
                return null;
            }
        } else {
            try {
                Entity e = this.world.getWorld().spawn(new Location((org.bukkit.World)this.world.getWorld(), (double)entityData.x + 0.5, (double)entityData.y + 0.0, (double)entityData.z + 0.5), EntityType.fromName((String)entityData.name).getEntityClass());
                entity = this.world.getEntity(e.getUniqueId());
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (OTG.getPluginConfig().spawnLog) {
            OTG.log(LogMarker.DEBUG, "Spawned OK", new Object[0]);
        }
        return entity;
    }

    @Override
    public ChunkCoordinate getSpawnChunk() {
        BlockPosition spawnPos = this.world.getSpawn();
        return ChunkCoordinate.fromBlockCoords(spawnPos.getX(), spawnPos.getZ());
    }

    @Override
    public boolean isInsidePregeneratedRegion(ChunkCoordinate chunk) {
        return false;
    }

    @Override
    public LocalMaterialData getMaterial(int x, int y, int z, ChunkCoordinate chunkBeingPopulated) {
        if (y >= 256 || y < 0) {
            return null;
        }
        Chunk chunk = null;
        if (chunkBeingPopulated != null && OTG.IsInAreaBeingPopulated(x, z, chunkBeingPopulated)) {
            chunk = this.getChunkGenerator().getChunk(x, z);
        }
        if (chunk == null && chunkBeingPopulated == null) {
            ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
            if (this.world.getChunkProviderServer().isLoaded(chunkCoord.getChunkX(), chunkCoord.getChunkZ())) {
                chunk = this.getChunkGenerator().getChunk(x, z);
            } else {
                return this.getChunkGenerator().getMaterialInUnloadedChunk(x, y, z);
            }
        }
        if (chunk == null) {
            return null;
        }
        int internalX = x & 0xF;
        int internalZ = z & 0xF;
        return BukkitMaterialData.ofMinecraftBlockData(chunk.a(internalX, y, internalZ));
    }

    @Override
    public int getBlockAboveLiquidHeight(int x, int z, ChunkCoordinate chunkBeingPopulated) {
        int highestY = this.getHighestBlockYAt(x, z, false, true, false, false, false, chunkBeingPopulated);
        highestY = highestY > 0 ? ++highestY : -1;
        return highestY;
    }

    @Override
    public int getBlockAboveSolidHeight(int x, int z, ChunkCoordinate chunkBeingPopulated) {
        int highestY = this.getHighestBlockYAt(x, z, true, false, true, true, false, chunkBeingPopulated);
        highestY = highestY > 0 ? ++highestY : -1;
        return highestY;
    }

    @Override
    public int getHighestBlockAboveYAt(int x, int z, ChunkCoordinate chunkBeingPopulated) {
        return this.getHighestBlockYAt(x, z, true, true, false, true, false, chunkBeingPopulated) + 1;
    }

    @Override
    public int getHighestBlockYAt(int x, int z, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow, boolean ignoreLeaves, ChunkCoordinate chunkBeingPopulated) {
        int heightMapy;
        Chunk chunk = null;
        if (chunkBeingPopulated != null && OTG.IsInAreaBeingPopulated(x, z, chunkBeingPopulated)) {
            chunk = this.getChunkGenerator().getChunk(x, z);
        }
        if (chunk == null && chunkBeingPopulated == null) {
            ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
            if (this.world.getChunkProviderServer().isLoaded(chunkCoord.getChunkX(), chunkCoord.getChunkZ())) {
                chunk = this.getChunkGenerator().getChunk(x, z);
            } else {
                return this.getChunkGenerator().getHighestBlockYInUnloadedChunk(x, z, findSolid, findLiquid, ignoreLiquid, ignoreSnow);
            }
        }
        if (chunk == null) {
            return -1;
        }
        int internalX = x & 0xF;
        int internalZ = z & 0xF;
        boolean incorrectHeightMap = false;
        for (heightMapy = chunk.b(internalX, internalZ); heightMapy < this.getHeightCap() && chunk.a(internalX, heightMapy, internalZ).getMaterial().blocksLight(); ++heightMapy) {
            incorrectHeightMap = true;
        }
        if (incorrectHeightMap) {
            this.world.w(new BlockPosition(x, heightMapy, z));
        }
        for (int i = heightMapy; i >= 0; --i) {
            boolean isSolid;
            IBlockData blockData = chunk.getBlockData(new BlockPosition(internalX, i, internalZ));
            Block block = blockData.getBlock();
            BukkitMaterialData material = BukkitMaterialData.ofMinecraftBlockData(blockData);
            boolean isLiquid = material.isLiquid();
            boolean bl = isSolid = material.isSolid() || !ignoreLeaves && (block == Blocks.LEAVES || block == Blocks.LEAVES2) || !ignoreSnow && block == Blocks.SNOW_LAYER;
            if (ignoreLiquid && isLiquid) continue;
            if (findSolid && isSolid || findLiquid && isLiquid) {
                return i;
            }
            if ((!findSolid || !isLiquid) && (!findLiquid || !isSolid)) continue;
            return -1;
        }
        return -1;
    }

    @Override
    public int getHeightMapHeight(int x, int z, ChunkCoordinate chunkBeingPopulated) {
        int heightMapy;
        Chunk chunk = null;
        if (chunkBeingPopulated != null && OTG.IsInAreaBeingPopulated(x, z, chunkBeingPopulated)) {
            chunk = this.getChunkGenerator().getChunk(x, z);
        }
        if (chunk == null && chunkBeingPopulated == null) {
            ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
            if (this.world.getChunkProviderServer().isLoaded(chunkCoord.getChunkX(), chunkCoord.getChunkZ())) {
                chunk = this.getChunkGenerator().getChunk(x, z);
            }
        }
        if (chunk == null) {
            return -1;
        }
        int internalX = x & 0xF;
        int internalZ = z & 0xF;
        boolean incorrectHeightMap = false;
        for (heightMapy = chunk.b(internalX, internalZ); heightMapy < this.getHeightCap() && chunk.a(internalX, heightMapy, internalZ).getMaterial().blocksLight(); ++heightMapy) {
            incorrectHeightMap = true;
        }
        if (incorrectHeightMap) {
            this.world.w(new BlockPosition(x, heightMapy, z));
        }
        return heightMapy;
    }

    @Override
    public int getLightLevel(int x, int y, int z, ChunkCoordinate chunkBeingPopulated) {
        if (y < 0 || y >= 256) {
            return -1;
        }
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        if (chunkBeingPopulated != null && OTG.IsInAreaBeingPopulated(x, z, chunkBeingPopulated) || chunkBeingPopulated == null && this.world.getChunkProviderServer().isLoaded(chunkCoord.getChunkX(), chunkCoord.getChunkZ())) {
            return this.world.j(new BlockPosition(x, y, z));
        }
        return -1;
    }

    @Override
    public LocalMaterialData[] getBlockColumnInUnloadedChunk(int x, int z) {
        return this.generator.getBlockColumnInUnloadedChunk(x, z);
    }

    @Override
    public void setBlock(int x, int y, int z, LocalMaterialData material, NamedBinaryTag metaDataTag, ChunkCoordinate chunkBeingPopulated, boolean replaceBlocks) {
        this.setBlock(x, y, z, material, metaDataTag, chunkBeingPopulated, null, replaceBlocks);
    }

    @Override
    public void setBlock(int x, int y, int z, LocalMaterialData material, NamedBinaryTag metaDataTag, ChunkCoordinate chunkBeingPopulated, BiomeConfig biomeConfig, boolean replaceBlocks) {
        if (y < 0 || y >= 256) {
            return;
        }
        if (material.isEmpty()) {
            return;
        }
        if (chunkBeingPopulated == null || OTG.IsInAreaBeingPopulated(x, z, chunkBeingPopulated)) {
            if (replaceBlocks) {
                if (biomeConfig == null) {
                    biomeConfig = chunkBeingPopulated == null ? this.getBiome(x, z).getBiomeConfig() : this.getBiomeForPopulation(x, z, chunkBeingPopulated).getBiomeConfig();
                }
                material = material.parseWithBiomeAndHeight(this, biomeConfig, y);
            }
            this.getChunkGenerator().setBlock(x, y, z, material, metaDataTag, biomeConfig);
        }
    }

    @Override
    public boolean generateModdedCaveGen(int x, int z, ChunkBuffer chunkBuffer) {
        return false;
    }

    @Override
    public boolean isInsideWorldBorder(ChunkCoordinate chunkCoordinate) {
        return true;
    }

    @Override
    public boolean isBo4Enabled() {
        return this.getConfigs().getWorldConfig().isOTGPlus;
    }

    @Override
    public void updateSpawnPointY() {
    }
}

