/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.util;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.biome.settings.WeightedMobSpawnGroup;
import com.pg85.otg.configuration.standard.MojangSettings;
import com.pg85.otg.logging.LogMarker;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.server.v1_12_R1.BiomeBase;
import net.minecraft.server.v1_12_R1.Entity;
import net.minecraft.server.v1_12_R1.EntityInsentient;
import net.minecraft.server.v1_12_R1.EntityTypes;
import net.minecraft.server.v1_12_R1.EnumCreatureType;
import net.minecraft.server.v1_12_R1.MinecraftKey;
import net.minecraft.server.v1_12_R1.WeightedRandom;

public final class MobSpawnGroupHelper {
    private static final Field WEIGHT_FIELD;

    private static EnumCreatureType toEnumCreatureType(MojangSettings.EntityCategory type) {
        switch (type) {
            case MONSTER: {
                return EnumCreatureType.MONSTER;
            }
            case CREATURE: {
                return EnumCreatureType.CREATURE;
            }
            case AMBIENT_CREATURE: {
                return EnumCreatureType.AMBIENT;
            }
            case WATER_CREATURE: {
                return EnumCreatureType.WATER_CREATURE;
            }
        }
        throw new AssertionError((Object)("Unknown mob type: " + (Object)((Object)type)));
    }

    private static WeightedMobSpawnGroup fromMinecraftGroup(BiomeBase.BiomeMeta biomeMeta) {
        return new WeightedMobSpawnGroup(MobSpawnGroupHelper.fromMinecraftClass(biomeMeta.b), MobSpawnGroupHelper.getWeight(biomeMeta), biomeMeta.c, biomeMeta.d);
    }

    public static int getWeight(BiomeBase.BiomeMeta biomeMeta) {
        try {
            return WEIGHT_FIELD.getInt(biomeMeta);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<WeightedMobSpawnGroup> getListFromMinecraftBiome(BiomeBase biome, MojangSettings.EntityCategory type) {
        List mobList = biome.getMobs(MobSpawnGroupHelper.toEnumCreatureType(type));
        return MobSpawnGroupHelper.fromMinecraftList(mobList);
    }

    private static List<WeightedMobSpawnGroup> fromMinecraftList(Collection<BiomeBase.BiomeMeta> biomeMetas) {
        ArrayList<WeightedMobSpawnGroup> result = new ArrayList<WeightedMobSpawnGroup>();
        for (BiomeBase.BiomeMeta meta : biomeMetas) {
            result.add(MobSpawnGroupHelper.fromMinecraftGroup(meta));
        }
        return result;
    }

    public static List<BiomeBase.BiomeMeta> toMinecraftlist(Collection<WeightedMobSpawnGroup> weightedMobSpawnGroups) {
        ArrayList<BiomeBase.BiomeMeta> biomeList = new ArrayList<BiomeBase.BiomeMeta>();
        for (WeightedMobSpawnGroup mobGroup : weightedMobSpawnGroups) {
            Class<? extends EntityInsentient> entityClass = MobSpawnGroupHelper.toMinecraftClass(mobGroup.getInternalName());
            if (entityClass != null) {
                biomeList.add(new BiomeBase.BiomeMeta(entityClass, mobGroup.getWeight(), mobGroup.getMin(), mobGroup.getMax()));
                continue;
            }
            if (!OTG.getPluginConfig().spawnLog) continue;
            OTG.log(LogMarker.WARN, "Mob type {} not found", mobGroup.getInternalName());
        }
        return biomeList;
    }

    private static Class<? extends EntityInsentient> toMinecraftClass(String mobName) {
        Class clazz = (Class)EntityTypes.b.get((Object)new MinecraftKey(mobName));
        if (clazz == null) {
            return null;
        }
        if (EntityInsentient.class.isAssignableFrom(clazz)) {
            return clazz.asSubclass(EntityInsentient.class);
        }
        return null;
    }

    private static String fromMinecraftClass(Class<? extends Entity> entityClass) {
        return ((MinecraftKey)EntityTypes.b.b(entityClass)).toString();
    }

    static {
        try {
            WEIGHT_FIELD = WeightedRandom.WeightedRandomChoice.class.getDeclaredField("a");
            WEIGHT_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Reflection error", e);
        }
    }
}

