/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.generator.structures;

import com.pg85.otg.bukkit.biomes.BukkitBiome;
import com.pg85.otg.bukkit.generator.structures.VillageStart;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.network.ServerConfigProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.server.v1_12_R1.BiomeBase;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.StructureGenerator;
import net.minecraft.server.v1_12_R1.StructureStart;
import net.minecraft.server.v1_12_R1.World;

public class OTGVillageGen
extends StructureGenerator {
    public List<BiomeBase> villageSpawnBiomes;
    private int size;
    private int distance;
    private int minimumDistance;

    public OTGVillageGen(ServerConfigProvider configs) {
        this.size = configs.getWorldConfig().villageSize;
        this.distance = configs.getWorldConfig().villageDistance;
        this.minimumDistance = 8;
        this.villageSpawnBiomes = new ArrayList<BiomeBase>();
        for (LocalBiome biome : configs.getBiomeArrayByOTGId()) {
            if (biome == null || biome.getBiomeConfig().villageType == BiomeConfig.VillageType.disabled) continue;
            this.villageSpawnBiomes.add(((BukkitBiome)biome).getHandle());
        }
    }

    public BlockPosition getNearestGeneratedFeature(World world, BlockPosition blockposition, boolean flag) {
        this.g = world;
        return OTGVillageGen.a((World)world, (StructureGenerator)this, (BlockPosition)blockposition, (int)this.distance, (int)this.minimumDistance, (int)10387312, (boolean)false, (int)100, (boolean)flag);
    }

    protected boolean a(int chunkX, int chunkZ) {
        boolean flag;
        int k = chunkX;
        int l = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.distance - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.distance - 1;
        }
        int i1 = chunkX / this.distance;
        int j1 = chunkZ / this.distance;
        Random random = this.g.a(i1, j1, 10387312);
        i1 *= this.distance;
        j1 *= this.distance;
        return k == (i1 += random.nextInt(this.distance - this.minimumDistance)) && l == (j1 += random.nextInt(this.distance - this.minimumDistance)) && (flag = this.g.getWorldChunkManager().a(k * 16 + 8, l * 16 + 8, 0, this.villageSpawnBiomes));
    }

    protected StructureStart b(int chunkX, int chunkZ) {
        return new VillageStart(this.g, this.f, chunkX, chunkZ, this.size);
    }

    public String a() {
        return "OTGVillage";
    }
}

