/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.events;

import com.pg85.otg.bukkit.materials.BukkitMaterialData;
import com.pg85.otg.bukkit.world.BukkitWorld;
import com.pg85.otg.bukkit.world.WorldHelper;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.generator.resource.SaplingGen;
import com.pg85.otg.generator.resource.SaplingType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.IBlockData;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.block.BlockState;
import org.bukkit.event.world.StructureGrowEvent;

class SaplingListener {
    SaplingListener() {
    }

    void onStructureGrow(StructureGrowEvent event) {
        BukkitWorld world = (BukkitWorld)WorldHelper.toLocalWorld(event.getWorld());
        if (world == null) {
            return;
        }
        Location location = event.getLocation();
        IBlockData blockData = world.getWorld().getType(new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()));
        BukkitMaterialData material = BukkitMaterialData.ofMinecraftBlockData(blockData);
        SaplingType saplingType = this.toSaplingType(event.getSpecies());
        boolean wideTrunk = saplingType.requiresFourSaplings();
        if (wideTrunk || saplingType == SaplingType.Custom) {
            Location bigSaplingBlock = this.findFourSaplings(location, material, world);
            if (bigSaplingBlock == null) {
                wideTrunk = false;
            } else {
                wideTrunk = true;
                location = bigSaplingBlock;
            }
        }
        ArrayList<BlockState> saplingBlockStates = new ArrayList<BlockState>();
        byte data = 0;
        for (BlockState block : event.getBlocks()) {
            if ((double)block.getY() != location.getY()) continue;
            if ((double)block.getX() == location.getX() && (double)block.getZ() == location.getZ()) {
                saplingBlockStates.add(block);
                data = block.getBlock().getData();
                continue;
            }
            if (!wideTrunk || (double)block.getX() != location.getX() + 1.0 && (double)block.getZ() != location.getZ() + 1.0) continue;
            saplingBlockStates.add(block);
        }
        LocalBiome biome = world.getBiome(location.getBlockX(), location.getBlockZ());
        if (biome == null) {
            return;
        }
        BiomeConfig biomeConfig = biome.getBiomeConfig();
        SaplingGen sapling = saplingType == SaplingType.Custom ? biomeConfig.getCustomSaplingGen(material, wideTrunk) : biomeConfig.getSaplingGen(saplingType);
        if (sapling == null && biomeConfig.inheritSaplingResource && biomeConfig.replaceToBiomeName != null && biomeConfig.replaceToBiomeName.trim().length() > 0) {
            biome = world.getBiomeByNameOrNull(biomeConfig.replaceToBiomeName);
            if (biome == null) {
                return;
            }
            biomeConfig = biome.getBiomeConfig();
            sapling = saplingType == SaplingType.Custom ? biomeConfig.getCustomSaplingGen(material, wideTrunk) : biomeConfig.getSaplingGen(saplingType);
        }
        if (sapling == null) {
            return;
        }
        for (BlockState b : saplingBlockStates) {
            b.setType(Material.AIR);
            b.update(true);
        }
        boolean success = false;
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            if (!sapling.growSapling(world, random, wideTrunk, location.getBlockX(), location.getBlockY(), location.getBlockZ())) continue;
            success = true;
            break;
        }
        if (success) {
            event.getBlocks().clear();
        } else {
            event.setCancelled(true);
            for (BlockState b : saplingBlockStates) {
                b.getBlock().setTypeIdAndData(material.getBlockId(), data, false);
            }
        }
    }

    private boolean isSameSapling(LocalMaterialData sapling1, LocalMaterialData sapling2) {
        if (sapling1 == null || sapling2 == null) {
            return false;
        }
        return sapling1.getBlockData() % 8 == sapling2.getBlockData() % 8 && sapling1.getBlockId() == sapling2.getBlockId();
    }

    private Location findFourSaplings(Location loc, LocalMaterialData material, LocalWorld world) {
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        for (int treeOffsetX = 0; treeOffsetX >= -1; --treeOffsetX) {
            for (int treeOffsetZ = 0; treeOffsetZ >= -1; --treeOffsetZ) {
                if (!this.isSameSapling(material, world.getMaterial(x + treeOffsetX, y, z + treeOffsetZ, null)) || !this.isSameSapling(material, world.getMaterial(x + treeOffsetX + 1, y, z + treeOffsetZ, null)) || !this.isSameSapling(material, world.getMaterial(x + treeOffsetX, y, z + treeOffsetZ + 1, null)) || !this.isSameSapling(material, world.getMaterial(x + treeOffsetX + 1, y, z + treeOffsetZ + 1, null))) continue;
                return loc.add((double)treeOffsetX, 0.0, (double)treeOffsetZ);
            }
        }
        return null;
    }

    private Location searchLowestXZLocation(int y, List<BlockState> blocks) {
        BlockState lowestXZ = null;
        for (BlockState blockState : blocks) {
            if (blockState.getY() != y || blockState.getType() != Material.LOG && blockState.getType() != Material.LOG_2) continue;
            if (lowestXZ == null) {
                lowestXZ = blockState;
                continue;
            }
            if (blockState.getX() > lowestXZ.getX() || blockState.getZ() > lowestXZ.getZ()) continue;
            lowestXZ = blockState;
        }
        if (lowestXZ == null) {
            return null;
        }
        return lowestXZ.getLocation();
    }

    private SaplingType toSaplingType(TreeType treeType) {
        switch (treeType) {
            case REDWOOD: 
            case TALL_REDWOOD: {
                return SaplingType.Redwood;
            }
            case BIRCH: 
            case TALL_BIRCH: {
                return SaplingType.Birch;
            }
            case JUNGLE: {
                return SaplingType.BigJungle;
            }
            case SMALL_JUNGLE: {
                return SaplingType.SmallJungle;
            }
            case TREE: 
            case BIG_TREE: {
                return SaplingType.Oak;
            }
            case RED_MUSHROOM: {
                return SaplingType.RedMushroom;
            }
            case BROWN_MUSHROOM: {
                return SaplingType.BrownMushroom;
            }
            case ACACIA: {
                return SaplingType.Acacia;
            }
            case DARK_OAK: {
                return SaplingType.DarkOak;
            }
            case MEGA_REDWOOD: {
                return SaplingType.HugeRedwood;
            }
        }
        return SaplingType.Custom;
    }
}

