/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.commands;

import com.pg85.otg.bukkit.OTGPlugin;
import com.pg85.otg.bukkit.commands.BaseCommand;
import com.pg85.otg.bukkit.commands.BiomeCommand;
import com.pg85.otg.bukkit.commands.CheckCommand;
import com.pg85.otg.bukkit.commands.ExportCommand;
import com.pg85.otg.bukkit.commands.HelpCommand;
import com.pg85.otg.bukkit.commands.LookupCommand;
import com.pg85.otg.bukkit.commands.MapCommand;
import com.pg85.otg.bukkit.commands.ReloadCommand;
import com.pg85.otg.bukkit.commands.SpawnCommand;
import com.pg85.otg.bukkit.commands.StructureCommand;
import com.pg85.otg.bukkit.commands.TPCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class OTGCommandExecutor
implements CommandExecutor {
    private final OTGPlugin plugin;
    protected HashMap<String, BaseCommand> commandHashMap = new HashMap();
    private HelpCommand helpCommand;

    public OTGCommandExecutor(OTGPlugin plugin) {
        this.plugin = plugin;
        this.helpCommand = new HelpCommand(plugin);
        this.registerCommands();
    }

    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        ArrayList<String> arg = new ArrayList<String>(Arrays.asList(strings));
        BaseCommand cmd = this.helpCommand;
        if (!arg.isEmpty() && this.commandHashMap.containsKey(arg.get(0))) {
            cmd = this.commandHashMap.get(arg.get(0));
            arg.remove(0);
        }
        if (!commandSender.hasPermission(cmd.perm)) {
            commandSender.sendMessage(ChatColor.RED.toString() + "You don't have permission to " + cmd.getHelp() + "!");
            return true;
        }
        return cmd.onCommand(commandSender, arg);
    }

    private void registerCommands() {
        this.addCommand(new ReloadCommand(this.plugin));
        this.addCommand(new CheckCommand(this.plugin));
        this.addCommand(new TPCommand(this.plugin));
        this.addCommand(new BiomeCommand(this.plugin));
        this.addCommand(new SpawnCommand(this.plugin));
        this.addCommand(new LookupCommand(this.plugin));
        this.addCommand(new ExportCommand(this.plugin));
        this.addCommand(new MapCommand(this.plugin));
        this.addCommand(new StructureCommand(this.plugin));
        this.addCommand(this.helpCommand);
    }

    private void addCommand(BaseCommand command) {
        this.commandHashMap.put(command.name, command);
    }
}

