/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.commands;

import com.pg85.otg.OTG;
import com.pg85.otg.bukkit.OTGPlugin;
import com.pg85.otg.bukkit.world.WorldHelper;
import com.pg85.otg.common.LocalWorld;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;

public abstract class BaseCommand {
    public static final String ERROR_COLOR = ChatColor.RED.toString();
    public static final String MESSAGE_COLOR = ChatColor.GREEN.toString();
    static final String VALUE_COLOR = ChatColor.DARK_GREEN.toString();
    String name;
    String perm;
    String usage;
    protected OTGPlugin plugin;

    BaseCommand(OTGPlugin _plugin) {
        this.plugin = _plugin;
    }

    public abstract boolean onCommand(CommandSender var1, List<String> var2);

    protected LocalWorld getWorld(CommandSender sender, String worldName) {
        LocalWorld world;
        Location location;
        if (worldName.isEmpty() && (location = this.getLocation(sender)) != null && (world = WorldHelper.toLocalWorld(location.getWorld())) != null) {
            return world;
        }
        return OTG.getWorld(worldName);
    }

    protected Location getLocation(CommandSender sender) {
        if (sender instanceof Player) {
            return ((Player)sender).getLocation();
        }
        if (sender instanceof BlockCommandSender) {
            return ((BlockCommandSender)sender).getBlock().getLocation();
        }
        return null;
    }

    protected void listMessage(CommandSender sender, List<String> lines, int page, String ... headers) {
        int pageCount = (lines.size() >> 3) + 1;
        if (page > pageCount) {
            page = pageCount;
        }
        sender.sendMessage(ChatColor.AQUA.toString() + headers[0] + " - page " + page + "/" + pageCount);
        for (int headerId = 1; headerId < headers.length; ++headerId) {
            sender.sendMessage(ChatColor.AQUA + headers[headerId]);
        }
        for (int i = --page * 8; i < lines.size() && i < page * 8 + 8; ++i) {
            sender.sendMessage(lines.get(i));
        }
    }

    public String getHelp() {
        String desc;
        String ret = "do that";
        Permission permission = Bukkit.getPluginManager().getPermission(this.perm);
        if (permission != null && (desc = permission.getDescription()) != null && desc.trim().length() > 0) {
            ret = desc.trim();
        }
        return ret;
    }
}

