/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg;

import com.pg85.otg.OTGEngine;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.PluginConfig;
import com.pg85.otg.configuration.biome.settings.BiomeResourcesManager;
import com.pg85.otg.configuration.customobjects.CustomObjectResourcesManager;
import com.pg85.otg.configuration.dimensions.DimensionsConfig;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.CustomObjectManager;
import com.pg85.otg.customobjects.bo4.BO4Config;
import com.pg85.otg.events.EventHandler;
import com.pg85.otg.events.EventPriority;
import com.pg85.otg.generator.ChunkBuffer;
import com.pg85.otg.generator.biome.BiomeModeManager;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.CompressionUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class OTG {
    public static boolean IsNewWorldBeingCreated = false;
    private static OTGEngine Engine;

    private OTG() {
    }

    public static OTGEngine getEngine() {
        return Engine;
    }

    public static void setEngine(OTGEngine engine) {
        if (Engine != null) {
            throw new IllegalStateException("Engine is already set.");
        }
        Engine = engine;
        engine.onStart();
    }

    public static void stopEngine() {
        Engine.onShutdown();
        Engine = null;
    }

    public static BiomeModeManager getBiomeModeManager() {
        return Engine.getBiomeModeManager();
    }

    public static BiomeResourcesManager getBiomeResourcesManager() {
        return Engine.getBiomeResourceManager();
    }

    public static CustomObjectResourcesManager getCustomObjectResourcesManager() {
        return Engine.getCustomObjectResourcesManager();
    }

    public static CustomObjectManager getCustomObjectManager() {
        return Engine.getCustomObjectManager();
    }

    public static PluginConfig getPluginConfig() {
        return Engine.getPluginConfig();
    }

    public static DimensionsConfig getDimensionsConfig() {
        return Engine.getDimensionsConfig();
    }

    public static void setDimensionsConfig(DimensionsConfig dimensionsConfig) {
        Engine.setDimensionsConfig(dimensionsConfig);
    }

    public static String getBiomeName(String worldName, int x, int z) {
        LocalWorld world = OTG.getWorld(worldName);
        if (world == null) {
            return null;
        }
        return world.getSavedBiomeName(x, z);
    }

    public static LocalBiome getBiomeByOTGId(int id) {
        ArrayList<LocalWorld> worlds = OTG.getAllWorlds();
        if (worlds != null) {
            for (LocalWorld world : worlds) {
                LocalBiome biome = world.getBiomeByOTGIdOrNull(id);
                if (biome == null) continue;
                return biome;
            }
        }
        return null;
    }

    public static LocalBiome getBiome(String name, String worldName) {
        ArrayList<LocalWorld> worlds = OTG.getAllWorlds();
        if (worlds != null) {
            for (LocalWorld world : worlds) {
                LocalBiome biome;
                if (!world.getName().toLowerCase().equals(worldName.toLowerCase()) || (biome = world.getBiomeByNameOrNull(name)) == null) continue;
                return biome;
            }
        }
        return null;
    }

    public static LocalWorld getWorld(String name) {
        return Engine.getWorld(name);
    }

    public static LocalWorld getUnloadedWorld(String name) {
        return Engine.getUnloadedWorld(name);
    }

    public static ArrayList<LocalWorld> getAllWorlds() {
        return Engine.getAllWorlds();
    }

    public static void registerEventHandler(EventHandler handler) {
        Engine.registerEventHandler(handler);
    }

    public static void registerEventHandler(EventHandler handler, EventPriority priority) {
        Engine.registerEventHandler(handler, priority);
    }

    public static boolean fireReplaceBiomeBlocksEvent(int x, int z, ChunkBuffer chunkBuffer, LocalWorld localWorld) {
        return Engine.fireReplaceBiomeBlocksEvent(x, z, chunkBuffer, localWorld);
    }

    public static boolean fireCanCustomObjectSpawnEvent(CustomObject object, LocalWorld world, int x, int y, int z) {
        return Engine.fireCanCustomObjectSpawnEvent(object, world, x, y, z);
    }

    public static void firePopulationEndEvent(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        Engine.firePopulationEndEvent(world, random, villageInChunk, chunkCoord);
    }

    public static void firePopulationStartEvent(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        Engine.firePopulationStartEvent(world, random, villageInChunk, chunkCoord);
    }

    public static boolean fireResourceProcessEvent(Resource resource, LocalWorld world, Random random, boolean villageInChunk, int chunkX, int chunkZ) {
        return Engine.fireResourceProcessEvent(resource, world, random, villageInChunk, chunkX, chunkZ);
    }

    public static void log(LogMarker level, List<String> messages) {
        Engine.getLogger().log(level, messages);
    }

    public static void log(LogMarker level, String message, Object ... params) {
        Engine.getLogger().log(level, message, params);
    }

    public static void printStackTrace(LogMarker level, Throwable e) {
        OTG.printStackTrace(level, e, Integer.MAX_VALUE);
    }

    public static void printStackTrace(LogMarker level, Throwable e, int maxDepth) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        Engine.getLogger().log(level, stringWriter.toString(), new Object[0]);
    }

    public static String correctOldBiomeConfigFolder(File settingsDir) {
        String biomeFolderName = "WorldBiomes";
        File oldBiomeConfigs = new File(settingsDir, "BiomeConfigs");
        if (oldBiomeConfigs.exists() && !oldBiomeConfigs.renameTo(new File(settingsDir, biomeFolderName))) {
            OTG.log(LogMarker.WARN, "========================", new Object[0]);
            OTG.log(LogMarker.WARN, "Found old `BiomeConfigs` folder, but it could not be renamed to `", biomeFolderName, "`!");
            OTG.log(LogMarker.WARN, "Please rename the folder manually.", new Object[0]);
            OTG.log(LogMarker.WARN, "========================", new Object[0]);
            biomeFolderName = "BiomeConfigs";
        }
        return biomeFolderName;
    }

    public static boolean IsInAreaBeingPopulated(int blockX, int blockZ, ChunkCoordinate chunkBeingPopulated) {
        int chunkX = blockX >> 4;
        int chunkZ = blockZ >> 4;
        return !(chunkX != chunkBeingPopulated.getChunkX() && chunkX != chunkBeingPopulated.getChunkX() + 1 || chunkZ != chunkBeingPopulated.getChunkZ() && chunkZ != chunkBeingPopulated.getChunkZ() + 1);
    }

    public static boolean bo4DataExists(BO4Config config) {
        String filePath = config.getFile().getAbsolutePath().endsWith(".BO4") ? config.getFile().getAbsolutePath().replace(".BO4", ".BO4Data") : (config.getFile().getAbsolutePath().endsWith(".bo4") ? config.getFile().getAbsolutePath().replace(".bo4", ".BO4Data") : (config.getFile().getAbsolutePath().endsWith(".BO3") ? config.getFile().getAbsolutePath().replace(".BO3", ".BO4Data") : (config.getFile().getAbsolutePath().endsWith(".bo3") ? config.getFile().getAbsolutePath().replace(".bo3", ".BO4Data") : config.getFile().getAbsolutePath())));
        File file = new File(filePath);
        return file.exists();
    }

    public static void generateBO4Data(BO4Config config) {
        String filePath = config.getFile().getAbsolutePath().endsWith(".BO4") ? config.getFile().getAbsolutePath().replace(".BO4", ".BO4Data") : (config.getFile().getAbsolutePath().endsWith(".bo4") ? config.getFile().getAbsolutePath().replace(".bo4", ".BO4Data") : (config.getFile().getAbsolutePath().endsWith(".BO3") ? config.getFile().getAbsolutePath().replace(".BO3", ".BO4Data") : (config.getFile().getAbsolutePath().endsWith(".bo3") ? config.getFile().getAbsolutePath().replace(".bo3", ".BO4Data") : config.getFile().getAbsolutePath())));
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(bos);
                config.writeToStream(dos);
                byte[] compressedBytes = CompressionUtils.compress(bos.toByteArray());
                dos.close();
                FileOutputStream fos = new FileOutputStream(file);
                DataOutputStream dos2 = new DataOutputStream(fos);
                dos2.write(compressedBytes, 0, compressedBytes.length);
                dos2.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

